/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import java.nio.ByteBuffer;

public class DataUpdateMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected byte[] hexdata;
    protected String password;
    protected static final int PASSWORDSIZE = 4;
    protected MFAddress address = MFAddress.ZERO_ADDR;
    protected int dataLength = 0;

    protected void buildMessage() throws Exception {
        this.buffer.put(HexUtil.spaceFill(this.password, 4).getBytes("IBM1047"));
        this.buffer.put(this.address.toByteArray());
        this.buffer.putInt(this.hexdata.length);
        this.buffer.put(this.hexdata);
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        byte[] buf = new byte[4];
        this.buffer.get(buf);
        this.password = HexUtil.rightTrim(new String(buf, "IBM1047"));
        this.address = new MFAddress(this.buffer);
        this.dataLength = this.buffer.getInt();
        this.hexdata = new byte[this.dataLength];
        this.buffer.get(this.hexdata);
    }

    public void setHexdata(byte[] hex) {
        this.hexdata = hex;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void setAlet(long aletvalue) {
        this.address.setAlet(aletvalue);
    }

    protected short _defaultID() {
        return 7;
    }

    public String getPassword() {
        return this.password;
    }

    public MFAddress getAddress() {
        return this.address;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    protected int _getMessageSize() {
        return this.hexdata.length + 50;
    }

    protected String _toString() {
        String msg = String.format("Addr:%1$s Length:%2$d Data:%3$s", this.address.getAddrString(), this.dataLength, HexUtil.toHex(this.hexdata, 4));
        return msg;
    }

    public void setAddress(MFAddress address) {
        this.address = address;
    }
}

