/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;

public class CompositeErrorMessage
extends DebugMessage {
    public static final short INVALID_MONNAME = 2;
    public static final short MISSING_SYMBOLIC = 1;
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected String CSECT;
    protected int date = 0;
    protected String programname;
    protected String monitoredname;
    protected int time = 0;

    public CompositeErrorMessage() {
    }

    public CompositeErrorMessage(ByteBuffer buffer) throws Exception {
        super(buffer);
    }

    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 1: 
            case 2: {
                super.setSubmessageID(submessageID);
                break;
            }
            default: {
                throw new ITException(String.format("Invalid submessage %d", submessageID));
            }
        }
    }

    protected short _defaultID() {
        return 42;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        byte[] buf = new byte[8];
        this.buffer.get(buf);
        this.programname = new String(buf, "IBM1047").trim();
        buf = new byte[8];
        this.buffer.get(buf);
        this.CSECT = new String(buf, "IBM1047").trim();
        buf = new byte[8];
        this.buffer.get(buf);
        this.monitoredname = new String(buf, "IBM1047").trim();
        buf = new byte[3];
        this.buffer.get(buf);
        if (buf[2] != 0) {
            this.date = Numbers.unpack(buf).intValue();
        }
        buf = new byte[4];
        this.buffer.get(buf);
        if (buf[3] != 0) {
            this.time = Numbers.unpack(buf).intValue();
        }
    }

    protected int _getMessageSize() {
        int result = 31;
        return result;
    }

    protected String _toString() {
        return null;
    }

    protected void buildMessage() throws Exception {
        try {
            this.buffer.put(HexUtil.spaceFill(this.programname, 8).getBytes("IBM1047"));
            this.buffer.put(HexUtil.spaceFill(this.CSECT, 8).getBytes("IBM1047"));
            this.buffer.put(HexUtil.spaceFill(this.monitoredname, 8).getBytes("IBM1047"));
            this.buffer.put(Numbers.pack(this.date, 3));
            this.buffer.put(Numbers.pack(this.time, 4));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMonitoredname() {
        return this.monitoredname;
    }

    public void setMonitoredname(String monitoredname) {
        this.monitoredname = monitoredname;
    }

    public String getCSECT() {
        return this.CSECT;
    }

    public void setCSECT(String csect) {
        this.CSECT = csect;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public String getProgramname() {
        return this.programname;
    }

    public void setProgramname(String programname) {
        this.programname = programname;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }
}

