/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.Numbers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CallTraceListMessage
extends DebugMessage {
    private static final int CALL_LOG_RECORD_SIZE = 20;
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected ArrayList<CallLogRecord> log = null;

    protected short _defaultID() {
        return 47;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        int count = Numbers.getUShort(newbuffer.getShort());
        this.log = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            byte[] buf = new byte[8];
            byte[] buf4 = new byte[4];
            CallLogRecord record = new CallLogRecord();
            newbuffer.get(buf);
            record.program = HexUtil.rightTrim(new String(buf, "IBM1047"));
            newbuffer.get(buf);
            record.csect = HexUtil.rightTrim(new String(buf, "IBM1047"));
            newbuffer.get();
            newbuffer.get(buf4);
            CallLogRecord.access$202(record, buf4);
            buf[0] = newbuffer.get();
            String lang = new String(buf, "IBM1047");
            char language = lang.charAt(0);
            switch (language) {
                case 'C': {
                    record.lang = "COBOL";
                    break;
                }
                case 'A': {
                    record.lang = "ASM";
                    break;
                }
                case 'P': {
                    record.lang = "PL/I";
                    break;
                }
                default: {
                    record.lang = "Unknown Language";
                }
            }
            buf[0] = newbuffer.get();
            switch (buf[0]) {
                case 0: {
                    record.type = "Current Program";
                    break;
                }
                case 1: {
                    record.type = "Static Call";
                    break;
                }
                case 2: {
                    record.type = "Dynamic Call";
                    break;
                }
                case 3: {
                    record.type = "EXEC CICS Link";
                    break;
                }
                default: {
                    record.type = "Unknown Call";
                }
            }
            record.number = i;
            if (record.csect.length() != 0 && !record.csect.equals(record.program)) {
                record.program = record.program + "_" + record.csect;
            }
            ((Buffer)newbuffer).position(newbuffer.position() + 20);
            this.log.add(record);
        }
    }

    protected int _getMessageSize() {
        return 0;
    }

    protected String _toString() {
        return null;
    }

    public CallLogRecord[] getLogRecords() {
        if (this.log == null) {
            return new CallLogRecord[0];
        }
        return this.log.toArray(new CallLogRecord[this.log.size()]);
    }

    protected void buildMessage() throws Exception {
    }

    public class CallLogRecord {
        private String program;
        private String csect;
        private byte[] offset;
        private int statement;
        private String lang;
        private String type;
        private int number;
        private int linenumber;
        private String text;

        public String getProgram() {
            return this.program;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setStatement(int statement) {
            this.statement = statement;
        }

        public void setLinenumber(int linenumber) {
            this.linenumber = linenumber;
        }

        public byte[] getOffset() {
            return this.offset;
        }

        public int getStatement() {
            return this.statement;
        }

        public String getLang() {
            return this.lang;
        }

        public String getType() {
            return this.type;
        }

        public int getNumber() {
            return this.number;
        }

        public int getLinenumber() {
            return this.linenumber;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        static /* synthetic */ byte[] access$202(CallLogRecord x0, byte[] x1) {
            x0.offset = x1;
            return x1;
        }
    }
}

