/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.IParseSource;
import com.ca.intertest.tools.StatementType;
import com.ca.intertest.tools.XMLFile;
import com.ca.intertest.tools.XMLRequest;
import com.ca.intertest.tools.parseSource;
import com.ca.intertest.tools.scanASM;
import java.util.Comparator;
import org.w3c.dom.Element;

public class parseASM
extends parseSource
implements IParseSource {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected String lastCSECT = "";
    private static final String[] unusedAttrs = new String[]{"gt_picl", "gt_name", "gt_datst", "lablstmt", "lablname"};

    public parseASM(XMLFile xml, Element member) {
        super(xml, member);
        this.scansource = new scanASM(member.getAttribute("gt_m_aty"));
        this.lang = 16;
    }

    void parseVariableElement(Element variable) {
        String name = variable.getAttribute("gt_name");
        String stmt = variable.getAttribute("gt_datst");
        String structureoffset = variable.getAttribute("gt_disp");
        String level = variable.getAttribute("gt_evel");
        variable.setAttribute("name", name);
        variable.setAttribute("level", level);
        variable.setAttribute("offset", "0");
        variable.setAttribute("structureoffset", structureoffset);
        variable.setAttribute("statementnumber", stmt);
        this.removeUnusedAttrs(variable, unusedAttrs);
        if (!this.altVarnames.isEmpty() && this.altVarnames.containsKey(name)) {
            this.altVarnames.remove(name);
        }
    }

    void parseLabelElement(Element label) {
        String stmt = label.getAttribute("lablstmt");
        String disp = label.getAttribute("labldisp");
        label.setAttribute("statementnumber", stmt);
        label.setAttribute("level", "0");
        label.setAttribute("offset", disp);
        label.setAttribute("name", label.getAttribute("lablname"));
        this.removeUnusedAttrs(label, unusedAttrs);
    }

    protected Element getParent(Element oldParent, Element item) {
        if (oldParent.getTagName().equals("symbols")) {
            return oldParent;
        }
        int parentLevel = XMLRequest.getInt("level", oldParent);
        int itemLevel = XMLRequest.getInt("level", item);
        if (itemLevel <= parentLevel) {
            return this.getParent((Element)oldParent.getParentNode(), item);
        }
        return oldParent;
    }

    Comparator getComparator() {
        return null;
    }

    void parseLine(String line, int statementnumber, int linenumber) {
        String newCSECT;
        String source = this.scansource.getSourceSegment(line);
        if (source.length() < 7) {
            return;
        }
        char first_char = source.charAt(0);
        if (first_char == ' ' || first_char == '*') {
            return;
        }
        String[] tokens = source.split("[ ]+");
        if (tokens.length > 1 && (tokens[1].equals("CSECT") || tokens[1].equals("DSECT")) && !(newCSECT = tokens[1] + tokens[0]).equals(this.lastCSECT) && tokens[1].equals("CSECT")) {
            Element label = this.xml.createElement("pgmstructure");
            label.setAttribute("statementnumber", Integer.toString(statementnumber));
            label.setAttribute("level", "0");
            label.setAttribute("offset", "0");
            label.setAttribute("name", tokens[0]);
            label.setAttribute("linenumber", Integer.toString(linenumber));
            this.elements.put(label, null);
            this.addVerb(StatementType.NOOP.name(), null, statementnumber, 0, linenumber, 0);
        }
    }

    protected boolean checkExcludeVariable(Element variable) {
        return true;
    }

    protected int checkLevel1() {
        return 0;
    }

    protected void loadLevel1(Element item, int structCnt) {
    }
}

