/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IBreakpointMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.IUnconditionalBreakpointMessage;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Numbers;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class UnconditionalBreakpointMessage
extends BreakpointMessage
implements IBreakpointMessage,
IUnconditionalBreakpointMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected String paragraph = "";

    public UnconditionalBreakpointMessage() {
        super(true);
        this.submessageID = (short)2;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        try {
            this.getProgram(this.buffer);
            this.getAvailable(this.buffer);
            this.breakpointID = this.buffer.getLong();
            this.skipcount = Numbers.getUShort(this.buffer.getShort());
            switch (this.getSubmessageID()) {
                case 1: {
                    break;
                }
                case 3: {
                    int len = Numbers.getUShort(this.buffer.getShort());
                    byte[] buf = new byte[len];
                    this.buffer.get(buf);
                    this.paragraph = HexUtil.rightTrim(new String(buf, "IBM1047"));
                    break;
                }
                case 2: {
                    this.statement = this.buffer.getInt();
                }
            }
        }
        catch (BufferUnderflowException e) {
            Logger.loggit(e);
            throw new ITException("Invalid message for BreakPoint message", e.getCause());
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
            throw new ITException(e.getCause());
        }
    }

    protected short _defaultID() {
        return 1;
    }

    protected void buildSubBPMessage() throws ITException, UnsupportedEncodingException {
        this.buffer.putShort(Numbers.putUShort(this.skipcount));
        switch (this.submessageID) {
            case 1: 
            case 11: {
                break;
            }
            case 2: 
            case 12: {
                this.buffer.putInt(this.statement);
                this.buffer.put(new byte[7]);
                break;
            }
            case 3: 
            case 13: {
                this.buffer.putShort((short)this.paragraph.length());
                this.buffer.put(this.paragraph.getBytes("IBM1047"));
            }
        }
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public void setParagraph(String paragraph) {
        this.paragraph = paragraph;
    }

    public void setParagraph(Object paragraph) {
        if (paragraph != null) {
            this.setParagraph(paragraph.toString());
        }
    }

    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 1: 
            case 2: 
            case 3: {
                super.setSubmessageID(submessageID);
                break;
            }
            default: {
                throw new ITException("Invalid Unconditional Breakpoint");
            }
        }
    }

    protected String _toString() {
        return super._toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.paragraph == null ? 0 : this.paragraph.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IUnconditionalBreakpointMessage)) {
            return false;
        }
        IUnconditionalBreakpointMessage other = (IUnconditionalBreakpointMessage)obj;
        if (this.paragraph == null ? other.getParagraph() != null : !this.paragraph.equals(other.getParagraph())) {
            return false;
        }
        return super.equals(obj);
    }
}

