/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.FileType;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Numbers;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class RequestBreakpointMessage
extends BreakpointMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected short[] rbp_codes = new short[0];
    protected int rbp_type = 0;
    public static final int BATCH = 8;
    public static final int UEXIT = 128;
    public static final int TERM = 64;
    public static final int TRAN = 32;
    public static final int REMOVE_RBP = 16;
    public static final short DBCALL = 1;
    public static final short ENTRY = 128;
    public static final short EXIT = 64;
    public static final short LABEL = 4;
    public static final short[] BATCH_FLAG_BITS = new short[]{1, 128, 64, 4};

    public void setRbp_type(int rbp_type) {
        if ((rbp_type & 0x40) != 0) {
            this.setFiletype(FileType.TERMID);
        } else if ((rbp_type & 0x20) != 0) {
            this.setFiletype(FileType.TRANID);
        } else {
            this.setFiletype(FileType.PROGID);
        }
        this.rbp_type = rbp_type;
    }

    public RequestBreakpointMessage() {
        super(true);
    }

    public RequestBreakpointMessage(long ID) {
        this();
        BigInteger big = BigInteger.valueOf(ID);
        byte[] buff = big.toByteArray();
        buff = HexUtil.sizeBytes(buff, 3);
        this.rbp_type = buff[0];
        buff = HexUtil.sizeBytes(buff, 2);
        big = new BigInteger(buff);
        this.rbp_codes = new short[]{big.shortValue()};
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        try {
            int count;
            this.getProgram(this.buffer);
            this.getAvailable(this.buffer);
            this.breakpointID = this.buffer.getLong();
            this.skipcount = Numbers.getUShort(this.buffer.getShort());
            this.rbp_type = this.buffer.get();
            if ((this.rbp_type & 0x10) == 16) {
                this.enabled = false;
                this.rbp_type &= 0xFFFFFFEF;
            }
            if ((count = Numbers.getUShort(this.buffer.getShort())) == 0) {
                count = (short)(this.buffer.remaining() / 2);
            }
            this.rbp_codes = new short[count];
            for (int i = 0; i < count; ++i) {
                this.rbp_codes[i] = this.buffer.getShort();
            }
        }
        catch (BufferUnderflowException e) {
            Logger.loggit(e);
            throw new ITException("Invalid message for BreakPoint message", e.getCause());
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
            throw new ITException(e.getCause());
        }
    }

    public boolean isProgramID() {
        if (super.isProgram()) {
            return this.getProgram().length() != 0;
        }
        return false;
    }

    protected void setRBP_Type() {
        switch (this.filetype) {
            case TRANID: {
                this.rbp_type = this.stripType() | 0x20;
                break;
            }
            case TERMID: {
                this.rbp_type = this.stripType() | 0x40;
            }
        }
    }

    private int stripType() {
        int mask = -137;
        return this.rbp_type & 0xFFFFFF77;
    }

    public short[] getRbp_codes() {
        return this.rbp_codes;
    }

    public void setRbp_codes(short[] rbp_codes) {
        this.rbp_codes = rbp_codes;
    }

    public int getRbp_type() {
        return this.rbp_type;
    }

    protected short _defaultID() {
        return 4;
    }

    protected void buildSubBPMessage() throws ITException, UnsupportedEncodingException {
        this.setRBP_Type();
        this.buffer.putShort(Numbers.putUShort(this.skipcount));
        this.buffer.put((byte)(this.rbp_type | (this.enabled ? 0 : 16)));
        this.buffer.putShort((short)this.rbp_codes.length);
        for (short item : this.rbp_codes) {
            this.buffer.putShort(item);
        }
    }

    protected String _toString() {
        return super._toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RequestBreakpointMessage)) {
            return false;
        }
        RequestBreakpointMessage other = (RequestBreakpointMessage)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (!this.getProgram().equals(other.getProgram())) {
            return false;
        }
        if (this.skipcount != other.getSkipcount()) {
            return false;
        }
        if (this.rbp_type != other.rbp_type) {
            return false;
        }
        return super.equals(obj);
    }

    public long getBreakpointID() {
        short code = this.rbp_codes.length > 0 ? this.rbp_codes[0] : (short)0;
        BigInteger big = BigInteger.valueOf(code);
        byte[] buff = big.toByteArray();
        buff = HexUtil.sizeBytes(buff, 3);
        buff[0] = (byte)this.rbp_type;
        big = new BigInteger(buff);
        return big.longValue();
    }
}

