/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFAddress
implements Cloneable,
Comparable<MFAddress> {
    public static final BigInteger MAX_UINT = new BigInteger("ffffffff", 16);
    public static final BigInteger MAX_ULONG = new BigInteger("ffffffffffffffff", 16);
    public static final MFAddress ZERO_ADDR = new MFAddress();
    protected static final BigInteger UINT_PLUS_ONE = MAX_UINT.add(BigInteger.ONE);
    protected static final BigInteger ULONG_PLUS_ONE = MAX_ULONG.add(BigInteger.ONE);
    static final String cacopyright = "Copyright (c) 2017 CA";
    private static final long serialVersionUID = -5801480737622998628L;
    protected BigInteger address = BigInteger.ZERO;
    protected BigInteger alet = BigInteger.ZERO;
    protected Amode amode = Amode.UNDEFINED;

    public MFAddress(byte[] address) throws Exception {
        this();
        if (address == null) {
            throw new NullPointerException("null String");
        }
        if (address.length == 0) {
            address = new byte[8];
        }
        switch (address.length) {
            case 4: {
                this.setAddress(address);
                this.amode = Amode.AMODE31;
                break;
            }
            case 8: {
                this.setAddress(address);
                this.amode = Amode.AMODE64;
                break;
            }
            case 12: 
            case 13: {
                byte[] buff = new byte[8];
                System.arraycopy(address, 0, buff, 0, 8);
                this.setAddress(buff);
                buff = new byte[4];
                System.arraycopy(address, 8, buff, 0, 4);
                this.setAlet(buff);
                break;
            }
            default: {
                if (address.length < 8) {
                    this.setAddress(address);
                    break;
                }
                throw new ITAddressFormatException("Invalid byte array size");
            }
        }
    }

    public MFAddress(byte[] address, byte[] alet) throws Exception {
        this();
        this.setAddress(address);
        this.setAlet(alet);
    }

    public MFAddress(ByteBuffer buffer) throws Exception {
        this();
        byte[] addr = new byte[8];
        byte[] alet = new byte[4];
        buffer.get(addr);
        buffer.get(alet);
        byte amode = buffer.get();
        this.setAddress(addr);
        this.setAlet(alet);
        this.setAmode(Amode.values()[amode]);
    }

    public MFAddress(long high, long low) throws Exception {
        this();
        if (high < 0L || low < 0L) {
            String highstr = Long.toHexString(high);
            String lowstr = Long.toHexString(low);
            this.setAddress(new BigInteger(highstr, 16), new BigInteger(lowstr, 16));
        } else {
            this.setAddress(BigInteger.valueOf(high), BigInteger.valueOf(low));
        }
    }

    public MFAddress(String address) throws Exception {
        this();
        if (address == null) {
            throw new NullPointerException("Null address String");
        }
        StringTokenizer tokens = new StringTokenizer(address, "_:-", true);
        int count = tokens.countTokens();
        if (count < 1) {
            return;
        }
        String[] item = new String[count];
        int ix = 0;
        int limit = count - 1;
        while (tokens.hasMoreTokens()) {
            item[ix++] = tokens.nextToken();
        }
        String high = null;
        String low = null;
        String alet = null;
        String amode = null;
        if (item[1].equals("_")) {
            if (count < 3) {
                throw new ITAddressFormatException(String.format("%s is invalid", address));
            }
            high = item[0];
            ix = 2;
        } else {
            high = "0";
            ix = 0;
        }
        low = item[ix++];
        if ((count - ix) % 2 != 0) {
            throw new ITAddressFormatException(String.format("%s is invalid", address));
        }
        if (ix < limit && item[ix].equals(":")) {
            int n = ++ix;
            ++ix;
            alet = item[n];
        }
        if (ix < limit && item[ix].equals("-")) {
            int n = ++ix;
            ++ix;
            amode = item[n];
        }
        this.setAddress(new BigInteger(high, 16), new BigInteger(low, 16));
        if (alet != null) {
            this.setAlet(alet);
        }
        if (amode != null) {
            this.setAmode(Amode.valueOf(amode));
        }
    }

    private MFAddress() {
    }

    public MFAddress add(long offset) {
        if (offset == 0L) {
            return this;
        }
        BigInteger result = this.address.add(BigInteger.valueOf(offset));
        result = this.setULong(result);
        try {
            MFAddress newaddr = this.clone();
            newaddr.address = result;
            return newaddr;
        }
        catch (CloneNotSupportedException e) {
            Logger.loggit(e);
            return ZERO_ADDR;
        }
    }

    public MFAddress clone() throws CloneNotSupportedException {
        MFAddress result = (MFAddress)super.clone();
        result.address = new BigInteger(this.address.toByteArray());
        result.alet = new BigInteger(this.alet.toByteArray());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MFAddress)) {
            return super.equals(obj);
        }
        MFAddress other = (MFAddress)obj;
        if (other.address.equals(this.address)) {
            return other.alet.equals(this.alet);
        }
        return false;
    }

    public String getAddrString() {
        return HexUtil.toRegisterHex(this.address.toByteArray());
    }

    public long getAlet() {
        return this.alet.longValue();
    }

    public String getAletString() {
        return HexUtil.toHex(HexUtil.sizeBytes(this.alet.toByteArray(), 4));
    }

    public Amode getAmode() {
        return this.amode;
    }

    public long getHigh() {
        return this.address.divide(MAX_UINT).longValue();
    }

    public String getHighString() {
        return HexUtil.toHex(HexUtil.sizeBytes(this.address.divide(MAX_UINT).toByteArray(), 4));
    }

    public long getLow() {
        return this.address.mod(MAX_UINT).longValue();
    }

    public String getLowString() {
        return HexUtil.toHex(HexUtil.sizeBytes(this.address.mod(MAX_UINT).toByteArray(), 4));
    }

    public long getOffset(MFAddress address) {
        return this.address.subtract(address.address).longValue();
    }

    public void setAlet(byte[] alet) {
        if (alet == null || alet.length == 0) {
            this.setAlet(BigInteger.ZERO);
        } else {
            this.setAlet(new BigInteger(HexUtil.sizeBytes(alet, 4)));
        }
    }

    public void setAlet(long alet) {
        if (alet < 0L) {
            this.setAlet(BigInteger.valueOf(alet).add(UINT_PLUS_ONE));
        } else {
            this.setAlet(BigInteger.valueOf(alet));
        }
    }

    public void setAlet(String alet) {
        this.alet = new BigInteger(alet, 16);
    }

    public void setAmode(Amode amode) {
        this.amode = amode;
    }

    public MFAddress subtract(long offset) {
        return this.add(0L - offset);
    }

    public long subtract(MFAddress addr) {
        return this.address.subtract(addr.address).longValue();
    }

    public long add(MFAddress addr) {
        return this.address.add(addr.address).longValue();
    }

    public byte[] toByteArray() {
        byte[] result = new byte[13];
        byte[] add = HexUtil.sizeBytes(this.address.toByteArray(), 8);
        System.arraycopy(add, 0, result, 0, 8);
        add = HexUtil.sizeBytes(this.alet.toByteArray(), 4);
        System.arraycopy(add, 0, result, 8, 4);
        result[12] = (byte)this.amode.ordinal();
        return result;
    }

    public String toString() {
        StringBuilder value = new StringBuilder(24);
        byte[] buff = this.address.toByteArray();
        switch (this.amode) {
            case UNDEFINED: 
            case AMODE64: {
                value.append(HexUtil.toRegisterHex(buff));
                break;
            }
            default: {
                buff = HexUtil.sizeBytes(buff, 4);
                value.append(HexUtil.toHex(buff));
            }
        }
        if (!this.alet.equals(BigInteger.ZERO)) {
            value.append(':');
            value.append(HexUtil.toHex(HexUtil.sizeBytes(this.alet.toByteArray(), 4)));
        }
        if (this.amode != Amode.UNDEFINED) {
            value.append('-');
            value.append(this.amode.name());
        }
        return value.toString();
    }

    private void setAddress(BigInteger high, BigInteger low) {
        this.address = this.setUint(high).shiftLeft(32).add(this.setUint(low));
    }

    private void setAddress(byte[] addr) {
        if (addr == null) {
            throw new NullPointerException("Null byte array");
        }
        if (addr.length == 0) {
            addr = new byte[8];
        }
        this.address = new BigInteger(addr);
    }

    private void setAlet(BigInteger alet) {
        this.alet = this.setUint(alet);
    }

    private BigInteger setUint(BigInteger value) {
        BigInteger result = value;
        if (value.signum() == -1) {
            result = UINT_PLUS_ONE.add(value);
        }
        while (result.bitLength() > 32) {
            result = result.clearBit(result.bitLength() - 1);
        }
        return value;
    }

    private BigInteger setULong(BigInteger value) {
        BigInteger result = value;
        if (value.signum() == -1) {
            result = ULONG_PLUS_ONE.add(value);
        }
        while (result.bitLength() > 64) {
            result = result.clearBit(result.bitLength() - 1);
        }
        return result;
    }

    @Override
    public int compareTo(MFAddress o) {
        return this.address.compareTo(o.address);
    }

    public class ITAddressFormatException
    extends ITException {
        private static final long serialVersionUID = 6963953559383197903L;

        public ITAddressFormatException() {
        }

        public ITAddressFormatException(String message) {
            super(message);
        }

        public ITAddressFormatException(String string, Throwable cause) {
            super(string, cause);
        }

        public ITAddressFormatException(Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Amode {
        UNDEFINED,
        AMODE24,
        AMODE31,
        AMODE64;

    }
}

