/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.ITHexUtilException;
import com.ca.intertest.tools.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class HexUtil {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private static final DateFormat df;
    private static final DateFormat dflocaltime;
    public static final String EMPTY = "";
    public static final String LF;
    public static final char PLAINDOT = '.';
    public static final char FANCYDOT = '\u25aa';
    public static char dot;
    private static final String matchescharacters;
    private static final String matchesallcharacters;
    private static final Pattern patternAllCharacters;
    private static final StringBuilder nulls;
    private static final String timeformat = "%s:%s";

    private HexUtil() {
    }

    public static String addTime(String string) {
        if (string != null) {
            return String.format(timeformat, dflocaltime.format(new Date()), string);
        }
        return dflocaltime.format(new Date());
    }

    public static String decryptPassword(String userid, String password) {
        try {
            BigInteger clearpassword = new BigInteger(password, 16);
            BigInteger user = new BigInteger(userid.getBytes("IBM1047"));
            clearpassword = clearpassword.subtract(user);
            return new String(clearpassword.toByteArray(), "IBM1047");
        }
        catch (NumberFormatException e) {
            return password;
        }
        catch (UnsupportedEncodingException e) {
            return password;
        }
    }

    public static String encryptPassword(String userid, String clearpassword) {
        try {
            BigInteger password = new BigInteger(clearpassword.getBytes("IBM1047"));
            BigInteger user = new BigInteger(userid.getBytes("IBM1047"));
            password = password.add(user);
            return password.toString(16);
        }
        catch (Exception e) {
            return clearpassword;
        }
    }

    public static void FloatingtoBytes(String number, byte[] bytes) throws ITHexUtilException {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        try {
            if (bytes.length > 4) {
                Double value = new Double(number);
                buf.putDouble(value);
            } else {
                Float value = new Float(number);
                buf.putFloat(value.floatValue());
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            throw new ITHexUtilException("Invalid floating point conversion", e.getCause());
        }
    }

    public static String getErrorText(Throwable e) {
        if (e == null) {
            return "Unknown Event";
        }
        String text = e.getMessage();
        if (text == null || text.length() == 0) {
            Throwable cause = e.getCause();
            if (cause != null) {
                text = cause.getMessage();
            }
            if (text == null || text.length() == 0) {
                text = e.getClass().getSimpleName();
            }
        }
        return text;
    }

    public static byte[] getPasswordKey(String userid, String clearpassword) {
        int len = 8;
        try {
            String fullsize = HexUtil.spaceFill(clearpassword, 8);
            BigInteger password = new BigInteger(fullsize.getBytes("IBM1047"));
            fullsize = HexUtil.spaceFill(userid, 8);
            BigInteger user = new BigInteger(fullsize.getBytes("IBM1047"));
            password = password.add(user);
            byte[] bytes = password.toByteArray();
            if (bytes.length > 8) {
                throw new ITException("Key too big for target");
            }
            if (bytes.length < 8) {
                byte[] newbytes = new byte[8];
                int ix = bytes.length;
                System.arraycopy(bytes, 0, newbytes, 8 - ix, ix);
                bytes = newbytes;
            }
            return bytes;
        }
        catch (Exception e) {
            return new byte[8];
        }
    }

    public static byte[] HextoBytes(String string) {
        int length = (string = HexUtil.stripSpaces(string.replace('_', ' '))).length();
        if (length % 2 == 0 && string.matches("[0-9A-Fa-f]+")) {
            byte[] bytes = new byte[length / 2];
            int j = 0;
            for (int i = 0; i < length; i += 2) {
                bytes[j] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
                ++j;
            }
            return bytes;
        }
        return null;
    }

    public static boolean HextoBytes(String string, byte[] bytes) {
        boolean result = false;
        int length = (string = HexUtil.stripSpaces(string.replace('_', ' '))).length();
        if (length / 2 != bytes.length) {
            return result;
        }
        if (string.matches("[0-9A-Fa-f]+")) {
            int j = 0;
            for (int i = 0; i < length; i += 2) {
                byte item = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
                if (item != bytes[j]) {
                    result = true;
                    bytes[j] = item;
                }
                ++j;
            }
        }
        return result;
    }

    public static String null2hex(int length) {
        int ix = length * 2;
        while (nulls.length() < ix) {
            nulls.append("00");
        }
        return nulls.substring(0, ix);
    }

    public static void NumbertoByte(String number, byte[] bytes) throws ITHexUtilException {
        try {
            BigInteger value = new BigInteger(number);
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            switch (bytes.length) {
                case 1: {
                    buf.put(value.byteValue());
                    break;
                }
                case 2: {
                    buf.putShort(value.shortValue());
                    break;
                }
                case 4: {
                    buf.putInt(value.intValue());
                    break;
                }
                case 8: {
                    buf.putLong(value.longValue());
                    break;
                }
                default: {
                    byte[] result = value.toByteArray();
                    int i = 0;
                    for (i = 0; i < result.length && i < bytes.length; ++i) {
                        bytes[i] = result[i];
                    }
                    while (i < bytes.length) {
                        bytes[i++] = 0;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            throw new ITHexUtilException("Invalid conversion of number", e.getCause());
        }
    }

    public static String rightTrim(String string) {
        int i;
        if (string == null) {
            return EMPTY;
        }
        for (i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
        }
        return ++i == string.length() ? string : string.substring(0, i);
    }

    public static byte[] sizeBytes(byte[] bytes, int size) {
        if (bytes == null) {
            return new byte[size];
        }
        if (bytes.length == size) {
            return bytes;
        }
        byte[] result = new byte[size];
        if (bytes.length == 0) {
            return result;
        }
        if (bytes.length < size) {
            System.arraycopy(bytes, 0, result, size - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, bytes.length - size, result, 0, size);
        }
        return result;
    }

    public static String spaceFill(String string, int length) {
        if (string == null) {
            string = EMPTY;
        } else {
            if (string.length() == length) {
                return string;
            }
            if (string.length() > length) {
                return string.substring(0, length);
            }
        }
        String formatstr = String.format("%%-%ds", length);
        return String.format(formatstr, string).substring(0, length);
    }

    public static String Squeeze(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        StringTokenizer tokens = new StringTokenizer(string);
        if (tokens.countTokens() == 1) {
            return tokens.nextToken();
        }
        StringBuilder buffer = new StringBuilder(string.length());
        while (tokens.hasMoreTokens()) {
            buffer.append(tokens.nextToken());
            buffer.append(' ');
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public static boolean StringtoBytes(String string, byte[] bytes) throws ITHexUtilException {
        boolean changed = false;
        try {
            byte[] ebcdic = string.getBytes("IBM1047");
            for (int i = 0; i < ebcdic.length && i < bytes.length; ++i) {
                boolean chkdot;
                boolean bl = chkdot = string.charAt(i) == dot;
                if (chkdot) {
                    ebcdic[i] = bytes[i];
                    continue;
                }
                if (ebcdic[i] == bytes[i]) continue;
                changed = true;
                bytes[i] = ebcdic[i];
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
            throw new ITHexUtilException(e);
        }
        return changed;
    }

    public static String stripSpaces(String string) {
        if (string == null) {
            return EMPTY;
        }
        StringTokenizer tokens = new StringTokenizer(string);
        if (tokens.countTokens() == 1) {
            return tokens.nextToken();
        }
        StringBuilder buffer = new StringBuilder(string.length());
        while (tokens.hasMoreTokens()) {
            buffer.append(tokens.nextToken());
        }
        return buffer.toString();
    }

    public static Calendar TimeStamp(int date, int time) {
        int year;
        if (date == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int thisyear = calendar.get(1) - 2000;
        year += (year = date / 1000) > thisyear && year > 60 ? 1900 : 2000;
        int day = date % 1000;
        int hour = time / 10000;
        int minute = time % 10000 / 100;
        int sec = time % 100;
        calendar.clear();
        calendar.set(1, year);
        calendar.set(6, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, sec);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar TimeStamp(String timestr) {
        Calendar time = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            time.setTime(df.parse(timestr));
        }
        catch (ParseException e) {
            time = null;
        }
        return time;
    }

    public static String TimeStampString(Calendar timestamp) {
        return timestamp == null ? "Unknown Date" : df.format(timestamp.getTime());
    }

    public static String TimeStampString(int date, int time) {
        return HexUtil.TimeStampString(HexUtil.TimeStamp(date, time));
    }

    public static String toFloating(byte[] bytes) throws ITHexUtilException {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        if (bytes.length == 8) {
            return Double.toString(buf.getDouble());
        }
        if (bytes.length == 4) {
            return Float.toString(buf.getFloat());
        }
        throw new ITHexUtilException("<<No Data>>");
    }

    public static String toHex(byte value) {
        return HexUtil.toHex(new Byte(value), 1);
    }

    public static String toHex(byte[] bytes) {
        return HexUtil.toHex(bytes, 4, ' ');
    }

    public static String toHex(byte[] bytes, int span) {
        return HexUtil.toHex(bytes, span, ' ');
    }

    public static String toHex(byte[] bytes, int span, char delim) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY;
        }
        if (span == 0) {
            span = bytes.length;
        }
        Formatter fmt = new Formatter();
        int offset = 0;
        int size = bytes.length;
        if (span < size) {
            offset = 0;
            while (offset < size) {
                HexUtil.formatHex(fmt, bytes, offset, span);
                if ((offset += span) >= size) continue;
                try {
                    fmt.out().append(delim);
                }
                catch (IOException e) {
                    Logger.loggit(e);
                }
            }
        }
        HexUtil.formatHex(fmt, bytes, offset, span);
        return fmt.toString();
    }

    public static String toHex(int value) {
        return HexUtil.toHex(new Integer(value), 4);
    }

    public static String toHex(long value) {
        return HexUtil.toHex(new Long(value), 8);
    }

    public static String toHex(Number value, int length) {
        String formatstr = String.format("%%0%dX", length * 2);
        return String.format(formatstr, value);
    }

    public static String toHex(short value) {
        return HexUtil.toHex(new Short(value), 2);
    }

    public static String toRegisterHex(byte[] register) {
        register = HexUtil.sizeBytes(register, 8);
        return HexUtil.toHex(register, 4, '_');
    }

    public static String toSigned(byte[] bytes) throws ITHexUtilException {
        try {
            BigInteger value = new BigInteger(bytes);
            return value.toString();
        }
        catch (NumberFormatException e) {
            Logger.loggit(e);
            throw new ITHexUtilException("Invalid conversion to signed integer");
        }
    }

    public static String toString(byte[] bytes) {
        return HexUtil.toString(bytes, false);
    }

    public static String toString(byte[] bytes, boolean fill) {
        try {
            boolean hasDots;
            String ascii = new String(bytes, "IBM1047");
            if (!fill) {
                ascii = HexUtil.rightTrim(ascii);
            }
            boolean bl = hasDots = !patternAllCharacters.matcher(ascii).matches();
            if (hasDots) {
                StringBuilder array = new StringBuilder(ascii);
                for (int i = 0; i < array.length(); ++i) {
                    if (bytes[i] <= -1 || bytes[i] >= 64) continue;
                    array.setCharAt(i, dot);
                }
                return array.toString();
            }
            return ascii;
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
            return HexUtil.getErrorText(e);
        }
    }

    public static String toUnSigned(byte[] bytes) throws ITHexUtilException {
        try {
            BigInteger value = new BigInteger(1, bytes);
            return value.toString();
        }
        catch (NumberFormatException e) {
            Logger.loggit(e);
            throw new ITHexUtilException("Invalid conversion to unsigned integer");
        }
    }

    private static void formatHex(Formatter fmt, byte[] bytes, int offset, int length) {
        int end = offset + length;
        if (end > bytes.length) {
            end = bytes.length;
        }
        for (int i = offset; i < end; ++i) {
            fmt.format("%0$02X", bytes[i]);
        }
    }

    public static String getMatchesCharacters() {
        return matchescharacters;
    }

    public static String getMatchesAllCharacters() {
        return matchesallcharacters;
    }

    public static char setDot(boolean fancy) {
        dot = (char)(fancy ? 9642 : 46);
        return dot;
    }

    public static char getDot() {
        return dot;
    }

    public static String toHexDump(byte[] bytes, String title) {
        return HexUtil.toHexDump(bytes, title, 32, 0);
    }

    public static String toHexDump(byte[] bytes, String title, int span, int maxmsg) {
        StringBuilder chars;
        int header = title == null ? 0 : title.length() + LF.length();
        int length = bytes.length;
        boolean truncated = false;
        span = (span + 3) / 4 * 4;
        String format = String.format("+%%04X %%-%ds|%%-%ds|", span / 4 * 9, span);
        try {
            chars = new StringBuilder(new String(bytes, 0, length, "IBM1047"));
            for (int i = 0; i < chars.length(); ++i) {
                char charAt = chars.charAt(i);
                if (charAt >= ' ' && charAt <= '~') continue;
                chars.setCharAt(i, '.');
            }
        }
        catch (UnsupportedEncodingException e) {
            return "Bad EBCDIC Translation";
        }
        StringBuilder string = new StringBuilder(header + (60 + LF.length()) * (bytes.length / span + 1));
        if (header > LF.length()) {
            string.append(title);
            string.append(LF);
        }
        for (int index = 0; index < length; index += span) {
            int remaining = length - index;
            int stride = Math.min(span, remaining);
            byte[] set = new byte[stride];
            int offset = index;
            for (int ix = 0; ix < stride; ++ix) {
                set[ix] = bytes[offset++];
            }
            String hex = HexUtil.toHex(set, 4, ' ');
            String line = String.format(format, index, hex, chars.substring(index, index + stride));
            string.append(line);
            string.append(LF);
        }
        if (truncated) {
            string.append(String.format("Text truncated to %d characters%s", maxmsg, LF));
        }
        if (string.length() >= LF.length()) {
            string.setLength(string.length() - LF.length());
        }
        return string.toString();
    }

    static {
        char[] displaycharacters;
        df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        dflocaltime = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
        LF = System.getProperty("line.separator");
        dot = (char)9642;
        StringBuilder string = new StringBuilder(1152);
        byte[] ebcdiccharacters = new byte[192];
        for (int i = 0; i < 192; ++i) {
            ebcdiccharacters[i] = (byte)(i + 64);
        }
        try {
            String tempstring = new String(ebcdiccharacters, "IBM1047");
            displaycharacters = tempstring.toCharArray();
        }
        catch (UnsupportedEncodingException e) {
            displaycharacters = new char[]{};
        }
        for (int i = 0; i < displaycharacters.length; ++i) {
            string.append(String.format("\\u%04X", displaycharacters[i]));
        }
        String displayString = string.toString();
        matchescharacters = String.format("[%s]+", displayString);
        matchesallcharacters = String.format("[%s%c]+", displayString, Character.valueOf(dot));
        patternAllCharacters = Pattern.compile(matchescharacters);
        nulls = new StringBuilder(8);
    }
}

