/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelReturnMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected MFAddress address = MFAddress.ZERO_ADDR;
    protected String channel = "";
    protected String container = "";
    protected String codepage = "";
    protected byte currflag = 0;
    protected int segmentcount = 1;
    protected ArrayList<String> segchars = new ArrayList();
    protected ArrayList<MFAddress> segaddrs = new ArrayList();
    protected ArrayList<Integer> seglengths = new ArrayList();

    @Override
    protected void buildMessage() throws Exception {
        this.channel = String.format("%-16s", this.channel);
        this.buffer.put(this.channel.getBytes("IBM1047"));
        this.container = String.format("%-16s", this.container);
        this.buffer.put(this.container.getBytes("IBM1047"));
        this.buffer.put(this.address.toByteArray());
        this.buffer.put(this.currflag);
        this.buffer.putInt(Integer.valueOf(this.codepage));
        this.buffer.putShort(Numbers.putUShort(this.segmentcount));
        for (int i = 0; i < this.segmentcount; ++i) {
            MFAddress addr = this.segaddrs.get(i);
            String saddr = addr.getLowString();
            byte[] baddr = new byte[4];
            baddr = HexUtil.HextoBytes(saddr);
            this.buffer.put(baddr);
            this.buffer.putInt(this.seglengths.get(i));
            String str = this.segchars.get(i);
            str = String.format("%-32", str);
            this.buffer.put(str.getBytes("IBM1047"));
        }
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        try {
            byte[] buf16 = new byte[16];
            this.buffer.get(buf16);
            this.channel = HexUtil.rightTrim(new String(buf16, "IBM1047"));
            this.buffer.get(buf16);
            this.container = HexUtil.rightTrim(new String(buf16, "IBM1047"));
            this.address = new MFAddress(this.buffer);
            this.currflag = this.buffer.get();
            this.codepage = String.valueOf(this.buffer.getInt());
            this.segmentcount = Numbers.getUShort(this.buffer.getShort());
            byte[] buf32 = new byte[32];
            byte[] buf4 = new byte[4];
            for (int i = 0; i < this.segmentcount; ++i) {
                this.buffer.get(buf4);
                this.segaddrs.add(i, new MFAddress(buf4));
                this.seglengths.add(i, this.buffer.getInt());
                this.buffer.get(buf32);
                this.segchars.add(i, HexUtil.rightTrim(new String(buf32, "IBM1047")));
            }
        }
        catch (Exception e) {
            throw new ITException(e);
        }
    }

    public String getChannel() {
        return this.channel;
    }

    public String getContainer() {
        return this.container;
    }

    public String getCodePage() {
        return this.codepage;
    }

    public byte getCurrFlag() {
        return this.currflag;
    }

    public MFAddress getAddress() {
        return this.address;
    }

    public long getAlet() {
        return this.address.getAlet();
    }

    public int getsegmentCount() {
        return this.segmentcount;
    }

    public ArrayList<String> getSegChars() {
        return this.segchars;
    }

    public ArrayList<MFAddress> getSegAddrs() {
        return this.segaddrs;
    }

    public ArrayList<Integer> getSegLengths() {
        return this.seglengths;
    }

    @Override
    protected short _defaultID() {
        return 40;
    }

    @Override
    protected int _getMessageSize() {
        return 2000;
    }

    @Override
    protected String _toString() {
        return null;
    }
}

