/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.XMLFile;
import com.ca.intertest.tools.parseASM;
import com.ca.intertest.tools.parseCOBOL;
import com.ca.intertest.tools.parsePLI;
import com.ca.intertest.tools.parseSource;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Element;

public class BuildListing {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private InputStream listing;
    private InputStream verbs;
    private InputStream labels;
    private InputStream variables;
    private File zipfile;
    private int errorLevel = 0;
    private String errorText = "";
    private int fixedLength = 0;
    private XMLFile source;
    private static final int zipMethod = 0;

    public BuildListing(XMLFile requestXML, InputStream listing, InputStream verbs, InputStream labels, InputStream variables) {
        this.source = requestXML;
        this.listing = listing;
        this.verbs = verbs;
        this.labels = labels;
        this.variables = variables;
    }

    public int build() throws Exception {
        parseSource parser;
        Element member = this.source.getFirstMember();
        String value = member.getAttribute("gt_m_lang");
        int language = Integer.parseInt(value, 16);
        switch (language) {
            case 32: {
                parser = new parseCOBOL(this.source, member);
                break;
            }
            case 16: {
                parser = new parseASM(this.source, member);
                break;
            }
            case 128: {
                parser = new parsePLI(this.source, member);
                break;
            }
            default: {
                throw new ITException("Unknown language");
            }
        }
        parser.setVersion(1);
        this.zipfile = File.createTempFile("CAIT", ".zip");
        this.zipfile.deleteOnExit();
        FileOutputStream dest = new FileOutputStream(this.zipfile);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
        out.setMethod(0);
        out = new ZipOutputStream(new BufferedOutputStream(dest));
        String userid = System.getenv("USERNAME");
        userid = userid == null ? "" : userid.toUpperCase();
        out.setComment("Created By:" + userid);
        int records = this.source.getRecordCount(this.source.getFirstMember());
        ZipEntry entry = new ZipEntry("listing");
        out.putNextEntry(entry);
        InputStreamReader reader = new InputStreamReader(this.listing);
        parser.parseListing(records, reader, out, this.fixedLength);
        out.closeEntry();
        reader = new InputStreamReader(this.variables);
        parser.parseVariables(reader);
        reader = new InputStreamReader(this.labels);
        parser.parseLabels(reader);
        parser.parseVerbs(this.verbs);
        member.setAttribute("com.ca.intertest", "true");
        parser.populateXML();
        ZipEntry zipentry = new ZipEntry("metadata");
        out.putNextEntry(zipentry);
        this.source.toFile(new BufferedWriter(new OutputStreamWriter(out)));
        out.closeEntry();
        out.close();
        dest.close();
        return 0;
    }

    public File getZipfile() {
        return this.zipfile;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public int getFixedLength() {
        return this.fixedLength;
    }

    public void setFixedLength(int fixedLength) {
        this.fixedLength = fixedLength;
    }
}

