/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;

public class BackStepMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    public static final short CVMI_PREV = 4;
    public static final short CVMI_ADV = 8;
    protected static final short CVMI_PARAGRAPH = 16;
    public static final short CVMI_POINT = 32;
    public static final short CVMI_PREVPARA = 20;
    public static final short CVMI_ADVPARA = 24;
    public static final short CVMI_POINTPARA = 48;
    private static final String EMPTY = "";
    protected int count = 0;
    protected String name = "";

    public BackStepMessage() {
    }

    public BackStepMessage(ByteBuffer buffer) throws Exception {
        super(buffer);
    }

    protected short _defaultID() {
        return 15;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        switch (this.submessageID) {
            case 4: 
            case 8: 
            case 20: 
            case 24: 
            case 32: {
                this.count = Numbers.getUShort(this.buffer.getShort());
                break;
            }
            case 48: {
                byte[] bytes = new byte[Numbers.getUShort(this.buffer.getShort())];
                this.buffer.get(bytes);
                this.name = new String(bytes, "IBM1047").trim();
                break;
            }
            default: {
                throw new ITException(String.format("Invalid subMessage for %s", this.getClass().getSimpleName()));
            }
        }
    }

    protected int _getMessageSize() {
        return 4 + (this.name == null ? 0 : this.name.length());
    }

    protected String _toString() {
        return String.format("%1$d", this.count == 0 ? 1 : this.count);
    }

    protected void buildMessage() throws Exception {
        switch (this.submessageID) {
            case 4: 
            case 8: 
            case 20: 
            case 24: 
            case 32: {
                this.buffer.putShort((short)(this.count == 0 ? 1 : this.count));
                break;
            }
            case 48: {
                this.buffer.putShort((short)this.name.length());
                this.buffer.put(this.name.getBytes("IBM1047"));
                break;
            }
            default: {
                throw new ITException(String.format("Invalid subMessage for %s", this.getClass().getSimpleName()));
            }
        }
    }

    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 4: 
            case 8: 
            case 20: 
            case 24: 
            case 32: 
            case 48: {
                super.setSubmessageID(submessageID);
                break;
            }
            default: {
                throw new ITException(String.format("Invalid subMessage for %s", this.getClass().getSimpleName()));
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? EMPTY : name.toUpperCase();
    }
}

