/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFAddress
implements Cloneable,
Comparable<MFAddress> {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private static final int FLAG_BIT = Integer.MIN_VALUE;
    private static final int HIGH_BYTE = -16777216;
    public static final BigInteger MAX_UINT = new BigInteger("ffffffff", 16);
    public static final BigInteger MAX_ULONG = new BigInteger("ffffffffffffffff", 16);
    protected static final BigInteger UINT_PLUS_ONE = MAX_UINT.add(BigInteger.ONE);
    protected static final BigInteger ULONG_PLUS_ONE = MAX_ULONG.add(BigInteger.ONE);
    private static final String sourceClass = MFAddress.class.getName();
    private Logger log = Logger.getLogger(sourceClass);
    public static final MFAddress ZERO_ADDR = new MFAddress();
    private static final long serialVersionUID = -5801480737622998628L;
    protected BigInteger address = BigInteger.ZERO;
    protected BigInteger alet = BigInteger.ZERO;
    protected Amode amode = Amode.UNDEFINED;

    public MFAddress(byte[] address) throws Exception {
        this();
        if (address == null) {
            throw new NullPointerException("null Address bytes");
        }
        if (address.length == 0) {
            address = new byte[4];
        }
        switch (address.length) {
            case 4: {
                this.setAddress(address);
                this.amode = Amode.AMODE31;
                break;
            }
            case 8: {
                this.setAddress(address);
                if (this.getHigh() != 0L) {
                    this.amode = Amode.AMODE64;
                    break;
                }
                this.amode = Amode.UNDEFINED;
                break;
            }
            case 12: 
            case 13: {
                byte[] buff = new byte[8];
                System.arraycopy(address, 0, buff, 0, 8);
                this.setAddress(buff);
                buff = new byte[4];
                System.arraycopy(address, 8, buff, 0, 4);
                this.setAlet(buff);
                break;
            }
            default: {
                if (address.length < 8) {
                    this.setAddress(address);
                    break;
                }
                throw new TTAddressFormatException("Invalid byte array size");
            }
        }
    }

    public MFAddress(byte[] address, byte[] alet) throws Exception {
        this();
        this.setAddress(address);
        this.setAlet(alet);
    }

    public MFAddress(ByteBuffer buffer) throws Exception {
        this();
        byte[] addr = new byte[8];
        byte[] alet = new byte[4];
        buffer.get(addr);
        buffer.get(alet);
        byte amode = buffer.get();
        this.setAddress(addr);
        this.setAlet(alet);
        this.setAmode(Amode.values()[amode]);
    }

    public MFAddress(long high, long low) throws Exception {
        this();
        if (high < 0L || low < 0L) {
            String highstr = Long.toHexString(high);
            String lowstr = Long.toHexString(low);
            this.setAddress(new BigInteger(highstr, 16), new BigInteger(lowstr, 16));
        } else {
            this.setAddress(BigInteger.valueOf(high), BigInteger.valueOf(low));
        }
    }

    public MFAddress(String value) throws Exception {
        this();
        int startlow;
        int endlow;
        int endalet;
        if (this.address == null) {
            throw new NullPointerException("Null address String");
        }
        String address = value.trim().replaceFirst(" ", "_");
        String high = null;
        String low = null;
        String alet = null;
        String amode = null;
        int amodestart = address.indexOf(45);
        if (amodestart == -1) {
            endalet = address.length();
            amodestart = address.length();
        } else {
            endalet = amodestart;
            amode = address.substring(amodestart + 1);
        }
        int aletstart = address.indexOf(58);
        if (aletstart == -1) {
            endlow = endalet;
            aletstart = endalet;
        } else {
            endlow = aletstart;
            alet = address.substring(aletstart + 1, amodestart);
        }
        int endhigh = address.indexOf(95);
        if (endhigh == -1) {
            startlow = 0;
        } else {
            startlow = endhigh + 1;
            high = address.substring(0, endhigh);
        }
        low = address.substring(startlow, endlow);
        try {
            this.setAddress(new BigInteger(high == null ? "0" : high, 16), new BigInteger(low, 16));
            if (alet != null) {
                this.setAlet(alet);
            }
            if (amode != null) {
                this.setAmode(Amode.valueOf(amode));
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, e.getClass().getSimpleName(), e);
            throw e;
        }
    }

    private MFAddress() {
    }

    public MFAddress add(long offset) {
        if (offset == 0L) {
            return this;
        }
        BigInteger result = this.address.add(BigInteger.valueOf(offset));
        result = this.setULong(result);
        try {
            MFAddress newaddr = this.clone();
            newaddr.address = result;
            return newaddr;
        }
        catch (CloneNotSupportedException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            return ZERO_ADDR;
        }
    }

    public MFAddress clone() throws CloneNotSupportedException {
        MFAddress result = (MFAddress)super.clone();
        result.address = new BigInteger(this.address.toByteArray());
        result.alet = new BigInteger(this.alet.toByteArray());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MFAddress)) {
            return false;
        }
        MFAddress other = (MFAddress)obj;
        if (other.address.equals(this.address)) {
            return other.alet.equals(this.alet);
        }
        return false;
    }

    public String getAddrString() {
        return HexUtil.toRegisterHex(this.address.toByteArray());
    }

    public long getAlet() {
        return this.alet.longValue();
    }

    public String getAletString() {
        return HexUtil.toHex(HexUtil.sizeBytes(this.alet.toByteArray(), 4));
    }

    public Amode getAmode() {
        if (this.amode == Amode.UNDEFINED) {
            this.amode = this.getHigh() == 0L ? Amode.AMODE31 : Amode.AMODE64;
        }
        return this.amode;
    }

    public long getHigh() {
        return this.address.divide(MAX_UINT).longValue();
    }

    public String getHighString() {
        return HexUtil.toHex(HexUtil.sizeBytes(this.address.divide(MAX_UINT).toByteArray(), 4));
    }

    public long getLow() {
        return this.address.mod(MAX_UINT).longValue();
    }

    public String getLowString() {
        return HexUtil.toHex(HexUtil.sizeBytes(this.address.mod(MAX_UINT).toByteArray(), 4));
    }

    public long getOffset(MFAddress address) {
        return this.address.subtract(address.address).longValue();
    }

    public void setAlet(byte[] alet) {
        if (alet == null || alet.length == 0) {
            this.setAlet(BigInteger.ZERO);
        } else {
            this.setAlet(new BigInteger(HexUtil.sizeBytes(alet, 4)));
        }
    }

    public void setAlet(long alet) {
        if (alet < 0L) {
            this.setAlet(BigInteger.valueOf(alet).add(UINT_PLUS_ONE));
        } else {
            this.setAlet(BigInteger.valueOf(alet));
        }
    }

    public void setAlet(String alet) {
        this.alet = new BigInteger(alet, 16);
    }

    public MFAddress setAmode(Amode amode) {
        this.amode = amode;
        if (this.getHigh() == 0L && this.amode == Amode.AMODE64) {
            this.amode = Amode.UNDEFINED;
        }
        return this;
    }

    public MFAddress subtract(long offset) {
        return this.add(0L - offset);
    }

    public long subtract(MFAddress addr) {
        return this.address.subtract(addr.address).longValue();
    }

    public long add(MFAddress addr) {
        return this.address.add(addr.address).longValue();
    }

    public byte[] toByteArray() {
        byte[] result = new byte[13];
        byte[] add = HexUtil.sizeBytes(this.address.toByteArray(), 8);
        System.arraycopy(add, 0, result, 0, 8);
        add = HexUtil.sizeBytes(this.alet.toByteArray(), 4);
        System.arraycopy(add, 0, result, 8, 4);
        result[12] = (byte)this.amode.ordinal();
        return result;
    }

    public String getText(boolean fullDescription) {
        if (fullDescription) {
            return this.toString();
        }
        byte[] buff = this.address.toByteArray();
        switch (this.amode) {
            case UNDEFINED: 
            case AMODE64: {
                if (this.getHigh() == 0L) break;
                return HexUtil.toRegisterHex(buff);
            }
        }
        buff = HexUtil.sizeBytes(buff, 4);
        return HexUtil.toHex(buff);
    }

    public String toString() {
        StringBuilder value = new StringBuilder(24);
        byte[] buff = this.address.toByteArray();
        switch (this.amode) {
            case UNDEFINED: 
            case AMODE64: {
                if (this.getHigh() != 0L) {
                    value.append(HexUtil.toRegisterHex(buff));
                    break;
                }
            }
            default: {
                buff = HexUtil.sizeBytes(buff, 4);
                value.append(HexUtil.toHex(buff));
            }
        }
        if (!this.alet.equals(BigInteger.ZERO)) {
            value.append(':');
            value.append(HexUtil.toHex(HexUtil.sizeBytes(this.alet.toByteArray(), 4)));
        }
        if (this.amode != Amode.UNDEFINED) {
            value.append('-');
            value.append(this.amode.name());
        }
        return value.toString();
    }

    private void setAddress(BigInteger high, BigInteger low) throws TTAddressFormatException {
        if (high.compareTo(MAX_UINT) > 0) {
            throw new TTAddressFormatException("High Order address exceeds expected value");
        }
        if (low.compareTo(MAX_UINT) > 0) {
            throw new TTAddressFormatException("Low Order address exceeds expected value");
        }
        this.address = this.setUint(high).shiftLeft(32).add(this.setUint(low));
    }

    private void setAddress(byte[] addr) {
        if (addr == null) {
            throw new NullPointerException("Null byte array");
        }
        if (addr.length == 0) {
            addr = new byte[8];
        }
        this.address = new BigInteger(addr);
    }

    private void setAlet(BigInteger alet) {
        this.alet = this.setUint(alet);
    }

    private BigInteger setUint(BigInteger value) {
        BigInteger result = value;
        if (value.signum() == -1) {
            result = UINT_PLUS_ONE.add(value);
        }
        while (result.bitLength() > 32) {
            result = result.clearBit(result.bitLength() - 1);
        }
        return value;
    }

    private BigInteger setULong(BigInteger value) {
        BigInteger result = value;
        if (value.signum() == -1) {
            result = ULONG_PLUS_ONE.add(value);
        }
        while (result.bitLength() > 64) {
            result = result.clearBit(result.bitLength() - 1);
        }
        return result;
    }

    @Override
    public int compareTo(MFAddress o) {
        return this.address.compareTo(o.address);
    }

    public boolean hasFlagBit() {
        switch (this.getAmode()) {
            case AMODE64: {
                return false;
            }
            case AMODE31: {
                long low = this.getLow();
                long flag = low & Integer.MIN_VALUE;
                return flag != 0L;
            }
            case AMODE24: {
                long low = this.getLow();
                long flag = low & 0xFFFFFFFFFF000000L;
                return flag != 0L;
            }
        }
        return false;
    }

    public MFAddress stripFlagBit() {
        if (this.hasFlagBit()) {
            try {
                switch (this.getAmode()) {
                    case AMODE31: {
                        long low = this.getLow() & Integer.MAX_VALUE;
                        return new MFAddress(this.getHigh(), low);
                    }
                    case AMODE24: {
                        long low = this.getLow() & 0xFFFFFFL;
                        return new MFAddress(this.getHigh(), low);
                    }
                }
            }
            catch (Exception e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
        }
        return this;
    }

    public class TTAddressFormatException
    extends TTException {
        private static final long serialVersionUID = 6963953559383197903L;

        public TTAddressFormatException() {
        }

        public TTAddressFormatException(String message) {
            super(message);
        }

        public TTAddressFormatException(String string, Throwable cause) {
            super(string, cause);
        }

        public TTAddressFormatException(Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Amode {
        UNDEFINED,
        AMODE24,
        AMODE31,
        AMODE64;

    }
}

