/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.AsmVerAttribute;
import com.ca.testingtools.common.BooleanAttribute;
import com.ca.testingtools.common.CalendarAttribute;
import com.ca.testingtools.common.CobVerAttribute;
import com.ca.testingtools.common.DecimalAttribute;
import com.ca.testingtools.common.DptypAttribute;
import com.ca.testingtools.common.DstypAttribute;
import com.ca.testingtools.common.Fl2Attribute;
import com.ca.testingtools.common.FlAttribute;
import com.ca.testingtools.common.HexAttribute;
import com.ca.testingtools.common.HexBooleanAttribute;
import com.ca.testingtools.common.IAttribute;
import com.ca.testingtools.common.IntAttribute;
import com.ca.testingtools.common.LanguageAttribute;
import com.ca.testingtools.common.NflgAttribute;
import com.ca.testingtools.common.OptVerAttribute;
import com.ca.testingtools.common.PvdtpAttribute;
import com.ca.testingtools.common.SignAttribute;
import com.ca.testingtools.common.StringAttribute;
import com.ca.testingtools.common.UsagAttribute;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute {
    static final String cacopyright = "Copyright (c) 2017 CA";
    public static final String EMPTY = "";
    public static final Hashtable<String, IAttribute> attributes = new Hashtable();

    public static synchronized IAttribute getInstance(String name, String value) {
        IAttribute attr = attributes.get(name);
        if (attr == null) {
            return new StringAttribute(name, name, value);
        }
        switch (attr.getType()) {
            case 1: {
                return new StringAttribute(name, attr.getTitle(), value);
            }
            case 2: {
                return new AsmVerAttribute(name, attr.getTitle(), value);
            }
            case 3: {
                return new BooleanAttribute(name, attr.getTitle(), value);
            }
            case 4: {
                return new CalendarAttribute(name, attr.getTitle(), value);
            }
            case 5: {
                return new DecimalAttribute(name, attr.getTitle(), value);
            }
            case 6: {
                return new HexAttribute(name, attr.getTitle(), value);
            }
            case 7: {
                return new HexBooleanAttribute(name, attr.getTitle(), value);
            }
            case 8: {
                return new IntAttribute(name, attr.getTitle(), value);
            }
            case 9: {
                return new LanguageAttribute(name, attr.getTitle(), value);
            }
            case 10: {
                return new OptVerAttribute(name, attr.getTitle(), value);
            }
            case 11: {
                return new DptypAttribute(name, attr.getTitle(), value);
            }
            case 18: {
                return new PvdtpAttribute(name, attr.getTitle(), value);
            }
            case 12: {
                return new DstypAttribute(name, attr.getTitle(), value);
            }
            case 13: {
                return new SignAttribute(name, attr.getTitle(), value);
            }
            case 16: {
                return new NflgAttribute(name, attr.getTitle(), value);
            }
            case 14: {
                return new FlAttribute(name, attr.getTitle(), value);
            }
            case 15: {
                return new Fl2Attribute(name, attr.getTitle(), value);
            }
            case 17: {
                return new CobVerAttribute(name, attr.getTitle(), value);
            }
            case 19: {
                return new UsagAttribute(name, attr.getTitle(), value);
            }
        }
        return attr;
    }

    public static synchronized String toString(String name, String value) {
        IAttribute attr = attributes.get(name);
        if (attr == null) {
            return value;
        }
        return attr.toString(value);
    }

    public static synchronized String toString(String name, Element element) {
        return Attribute.toString(name, element.getAttribute(name));
    }

    public static synchronized Object toString(String name, Properties properties) {
        return Attribute.toString(name, properties.getProperty(name));
    }

    public static synchronized Object toString(String name, Map<String, String> map) {
        return Attribute.toString(name, map.get(name));
    }

    public static synchronized Object getValue(String name, String value) {
        IAttribute attr = attributes.get(name);
        if (attr == null) {
            return value;
        }
        return attr.setValue(value);
    }

    public static synchronized Object getValue(String name, Element element) {
        return Attribute.getValue(name, element.getAttribute(name));
    }

    public static synchronized Object getValue(String name, Map<String, String> map) {
        return Attribute.getValue(name, map.get(name));
    }

    public static synchronized Object getValue(String name, Properties properties) {
        return Attribute.getValue(name, properties.getProperty(name));
    }

    static {
        attributes.put("gt_abslv", new IntAttribute("gt_abslv", "Absolute Level", EMPTY));
        attributes.put("gt_datst", new IntAttribute("gt_datst", "Variable Statement", EMPTY));
        attributes.put("gt_disp", new IntAttribute("gt_disp", "COBOL/ASM Displacement", EMPTY));
        attributes.put("gt_dmapd", new IntAttribute("gt_dmapd", "DMAPD Value", EMPTY));
        attributes.put("gt_dmaps", new IntAttribute("gt_dmaps", "DMAPS Value", EMPTY));
        attributes.put("gt_dmax1", new IntAttribute("gt_dmax1", "Dimension Size 1", EMPTY));
        attributes.put("gt_dmax2", new IntAttribute("gt_dmax2", "Dimension Size 2", EMPTY));
        attributes.put("gt_dmax3", new IntAttribute("gt_dmax3", "Dimension Size 3", EMPTY));
        attributes.put("gt_dmax4", new IntAttribute("gt_dmax4", "Dimension Size 4", EMPTY));
        attributes.put("gt_dmax5", new IntAttribute("gt_dmax5", "Dimension Size 5", EMPTY));
        attributes.put("gt_dmax6", new IntAttribute("gt_dmax6", "Dimension Size 6", EMPTY));
        attributes.put("gt_dmax7", new IntAttribute("gt_dmax7", "Dimension Size 7", EMPTY));
        attributes.put("gt_dptyp", new DptypAttribute("gt_dptyp", "Usage Data Type", EMPTY));
        attributes.put("gt_dstyp", new DstypAttribute("gt_dstyp", "Location Data Type", EMPTY));
        attributes.put("gt_evel", new IntAttribute("gt_evel", "Level", EMPTY));
        attributes.put("gt_fl", new FlAttribute("gt_fl", "Cell Flag", EMPTY));
        attributes.put("gt_fl2", new Fl2Attribute("gt_fl2", "Dependency Flag", EMPTY));
        attributes.put("gt_fsiz", new IntAttribute("gt_fsiz", "Datafield Size -1", EMPTY));
        attributes.put("pl1arlb1", new IntAttribute("pl1arlb1", "PL/I Array Increment 1", EMPTY));
        attributes.put("pl1arlb2", new IntAttribute("pl1arlb2", "PL/I Array Increment 2", EMPTY));
        attributes.put("pl1arlb3", new IntAttribute("pl1arlb3", "PL/I Array Increment 3", EMPTY));
        attributes.put("pl1arlb4", new IntAttribute("pl1arlb4", "PL/I Array Increment 4", EMPTY));
        attributes.put("pl1arlb5", new IntAttribute("pl1arlb5", "PL/I Array Increment 5", EMPTY));
        attributes.put("pl1arlb6", new IntAttribute("pl1arlb6", "PL/I Array Increment 6", EMPTY));
        attributes.put("pl1arlb7", new IntAttribute("pl1arlb7", "PL/I Array Increment 7", EMPTY));
        attributes.put("gt_incr1", new IntAttribute("gt_incr1", "Array Increment 1", EMPTY));
        attributes.put("gt_incr2", new IntAttribute("gt_incr2", "Array Increment 2", EMPTY));
        attributes.put("gt_incr3", new IntAttribute("gt_incr3", "Array Increment 3", EMPTY));
        attributes.put("gt_incr4", new IntAttribute("gt_incr4", "Array Increment 4", EMPTY));
        attributes.put("gt_incr5", new IntAttribute("gt_incr5", "Array Increment 5", EMPTY));
        attributes.put("gt_incr6", new IntAttribute("gt_incr6", "Array Increment 6", EMPTY));
        attributes.put("gt_incr7", new IntAttribute("gt_incr7", "Array Increment 7", EMPTY));
        attributes.put("gt_m_aty", new AsmVerAttribute("gt_m_aty", "Type", EMPTY));
        attributes.put("gt_m_avr", new StringAttribute("gt_m_avr", "ASM Version", EMPTY));
        attributes.put("gt_m_cty", new CobVerAttribute("gt_m_cty", "COBOL Version", EMPTY));
        attributes.put("gt_m_flg", new HexAttribute("gt_m_flg", "Flag", EMPTY));
        attributes.put("gt_base", new HexAttribute("gt_base", "BL Type", EMPTY));
        attributes.put("gt_m_nam", new StringAttribute("gt_m_nam", "Name", EMPTY));
        attributes.put("gt_m_opt", new OptVerAttribute("gt_m_opt", "Optimizer", EMPTY));
        attributes.put("gt_m_plc", new DecimalAttribute("gt_m_plc", "PL/I Version", EMPTY));
        attributes.put("gt_m_re_", new IntAttribute("gt_m_re_", "Internal Records", EMPTY));
        attributes.put("gt_m_xa", new HexBooleanAttribute("gt_m_xa", "XA", EMPTY));
        attributes.put("gt_name", new StringAttribute("gt_name", "Variable Name", EMPTY));
        attributes.put("gt_namel", new IntAttribute("gt_namel", "Name Length -1", EMPTY));
        attributes.put("gt_nflg", new NflgAttribute("gt_nflg", "Data Label Flag", EMPTY));
        attributes.put("gt_pic", new StringAttribute("gt_pic", "Picture", EMPTY));
        attributes.put("gt_prec", new HexAttribute("gt_prec", "PLI Precision", EMPTY));
        attributes.put("gt_pvbds", new IntAttribute("gt_pvbds", "PLI base handle part I", EMPTY));
        attributes.put("gt_pvbsq", new IntAttribute("gt_pvdsq", "PLI base handle part II", EMPTY));
        attributes.put("gt_pvdcl", new IntAttribute("gt_pvdcl", "DCL Statement Number", EMPTY));
        attributes.put("gt_pvdes", new HexAttribute("gt_pvdes", "PLI Structure Desc", EMPTY));
        attributes.put("gt_pvdtp", new PvdtpAttribute("gt_pvdtp", "PL/I Data Type", EMPTY));
        attributes.put("gt_pvltp", new HexAttribute("gt_pvltp", "PLI ITEM TYPE", EMPTY));
        attributes.put("gt_pvptr", new HexAttribute("gt_pvptr", "PLI Pointer", EMPTY));
        attributes.put("gt_pvsln", new IntAttribute("gt_pvsln", "PLI Structure Level", EMPTY));
        attributes.put("gt_pvsof", new IntAttribute("gt_pvsof", "PLI Structure Offset", EMPTY));
        attributes.put("gt_scale", new HexAttribute("gt_scale", "Scaling Positions", EMPTY));
        attributes.put("gt_sigfl", new IntAttribute("gt_sigfl", "Left Significant Figures", EMPTY));
        attributes.put("gt_sigfr", new IntAttribute("gt_sigfr", "Right Significant Figures", EMPTY));
        attributes.put("gt_sign", new SignAttribute("gt_sign", "Sign Indicator", EMPTY));
        attributes.put("gt_usag", new UsagAttribute("gt_usag", "COBOL Data Type", EMPTY));
        attributes.put("lablstmt", new IntAttribute("lablstmt", "Label", EMPTY));
        attributes.put("pl1estmt", new IntAttribute("pl1estmt", "PL/I Entry Label", EMPTY));
        attributes.put("gt_m_jul", new IntAttribute("gt_m_jul", "Julian Date", EMPTY));
        attributes.put("gt_m_lang", new LanguageAttribute("gt_m_lang", "Language", EMPTY));
        attributes.put("length", new IntAttribute("length", "Length", EMPTY));
        attributes.put("level", new IntAttribute("level", "Level", EMPTY));
        attributes.put("linenumber", new IntAttribute("linenumber", "Line", EMPTY));
        attributes.put("lastlinenumber", new IntAttribute("lastlinenumber", "Last Line", EMPTY));
        attributes.put("offset", new IntAttribute("offset", "Offset", EMPTY));
        attributes.put("records", new IntAttribute("records", "Records", EMPTY));
        attributes.put("laststatement", new IntAttribute("laststatement", "Statement", EMPTY));
        attributes.put("statementnumber", new IntAttribute("statementnumber", "Statement", EMPTY));
        attributes.put("statement_sub_number", new IntAttribute("statement_sub_number", "Statement sub number", EMPTY));
        attributes.put("subindex", new IntAttribute("subindex", "Statement subindex", EMPTY));
        attributes.put("statement_type", new HexAttribute("statement_type", "Statement subindex", EMPTY));
        attributes.put("structureoffset", new IntAttribute("structureoffset", "StructureOffset", EMPTY));
        attributes.put("time", new CalendarAttribute("time", "Date/Time", EMPTY));
        attributes.put("gt_m_tim", new IntAttribute("gt_m_tim", "Time of day", EMPTY));
        attributes.put("verb_data", new IntAttribute("verb_data", "Verb Data", EMPTY));
        attributes.put("version", new StringAttribute("version", "Version", EMPTY));
    }
}

