/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import com.ca.fmp.ims.view.wizardpages.SelFieldNameWizard;
import com.ca.fmp.ims.view.wizardpages.CRLClass;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.view.wizardpages.GenericSelectionBox;
import com.ca.fmp.ims.view.wizardpages.GenericUpdate2Page;
import com.ca.fmp.ims.view.wizardpages.CRLClass.LayoutField;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class SelWithLayoutPage extends GenericUpdate2Page implements
SelectionListener {

	static final String cacopyright = "Copyright  2016 CA";
	protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.selCritRules"; //$NON-NLS-1$
	private String layoutInfo = "";
	private String[] SelConds;
	private static String newCondition = "";
	public static Button saveSelCrit;
	private GenericSelectionBox genericSelCrit;
	private int[] map;
	private FileMasterServer server;

	public SelWithLayoutPage(String pageName, String title, CRLClass crl,
			int selectedIndex, FileMasterServer server, String layoutInfo,
			String[] SelConds, GenericSelectionBox genericSelCrit) {
		super(pageName, title, crl, selectedIndex, server, false);
		this.layoutInfo = layoutInfo;
		this.SelConds = SelConds;
		this.genericSelCrit = genericSelCrit;
		this.map = new int[SelConds.length];
		for(int i = 0; i < map.length; i++){
			map[i] = -1;
		}
		this.server =server;
		setTitle("Create Selection Conditions");
		setDescription("Specify selection conditions for fields");
	}

	@Override
	public void createControl(Composite parent) {

		super.createControl(parent);
		/*PlatformUI.getWorkbench().getHelpSystem()
		.setHelp(parent, CONTEXT_HELP_ID);*/
		txtRecLayout.setText(layoutInfo);
		tableUpdateFromSel();
		saveSelCrit = new Button(parent, SWT.NONE);
		saveSelCrit.setEnabled(false);
	}

	private void tableUpdateFromSel() {
		CRLClass crl = new CRLClass();
		crl.addLayout("toBeDel", "toBeDel");
		int indexOfField = -1;
		Object[] treeItems = getTreeItems(treeViewer.getTree().getItems());
		for (int count = 0; count < treeItems.length; count++) {
			String fieldName = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getField();
			int level = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getLevel();
			boolean isTop = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).isTop();
			boolean selected = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).isSelected();
			int position = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getPosition();
			String formatType = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getFormatType();
			int formatNum = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getFormatNum();
			int formatDec = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getFormatDec();
			int length = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getLength();
			int logOperator = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getLogOperator();
			int operator = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getOperator();
			String value = ((CRLClass.LayoutField) ((TreeItem)
					treeItems[count]).getData()).getValue();
			crl.getLayout(0).addField(fieldName, level, isTop, selected,
					position, formatType,formatNum,formatDec,length,
					logOperator, operator, value);
		}
		for (int count = 0; count < SelConds.length; count++) {
			String selCondLine = SelConds[count];

			String[] splitByOperator = selCondLine.split(
					  " GT | gt | Gt | gT | > |"
					+ " GE | ge | Ge | gE | >= |"
					+ " EQ | eq | Eq | eQ | = |"
					+ " NE | ne | Ne | nE | <> |"
					+ " LT | lt | Lt | lT | < |"
					+ " LE | le | Le | lE | <= |"
					+ " CO | co | Co | cO ", 2);
			
			if (splitByOperator.length > 1){
				String namePart = splitByOperator[0].trim();
				String valuePart = splitByOperator[1].trim();
				
				String parsedLogOperator = "";
				String[] namePartSplitBySpace = namePart.split("\\s+");
				if (isLogicalOperator(namePartSplitBySpace[0])){
					//line starts with AND/OR
					parsedLogOperator = namePartSplitBySpace[0];
					//remove log operator from field name
					namePart = namePart.substring(namePartSplitBySpace[0].length()).trim();
				} else if (count > 0){
					//get AND/OR from previous line
					String[] previousLine = SelConds[count - 1].split("\\s+");
					parsedLogOperator = previousLine[previousLine.length - 1];
				}
				
				indexOfField = isLayoutField(namePart);
				
				if (indexOfField > -1){
					//remove value part from line
					selCondLine = selCondLine.substring(0, selCondLine.length() - valuePart.length() - 1);
					String[] splitBySpace = selCondLine.split("\\s+");
					int operator = getOperator(splitBySpace[splitBySpace.length - 1]);
					
					int logOperator;
					if (parsedLogOperator.equalsIgnoreCase("AND") || parsedLogOperator.equalsIgnoreCase("&")){
						logOperator = CRLClass.AND;
					} else if (parsedLogOperator.equalsIgnoreCase("OR") || parsedLogOperator.equalsIgnoreCase("|")){
						logOperator = CRLClass.OR;
					} else { //default value
						logOperator = CRLClass.AND;
					}
					
					//get value (remove log operator)
					String[] valuePartSplitBySpace = valuePart.split("\\s+");
					String lastPart = valuePartSplitBySpace[valuePartSplitBySpace.length - 1];
					if (isLogicalOperator(lastPart)){
						valuePart = valuePart.substring(0, valuePart.length() - lastPart.length() - 1).trim();
					}
					
					if (operator != CRLClass.NONE && valuePart.length() > 0){
						mapCondition(count, indexOfField);
						crl.getLayout(0).getLayoutField(indexOfField).setOperator(operator);
						crl.getLayout(0).getLayoutField(indexOfField).setValue(valuePart);
						if(count > 0){ //first condition without AND/OR
							crl.getLayout(0).getLayoutField(indexOfField).setLogOperator(logOperator);
						}
					}
				}
			}
		}
		
		fields = crl.getLayout(0).getLayoutFields();        

		treeViewer.setInput(fields.toArray(new Object[fields.size()]));
		treeViewer.refresh();
		treeViewer.expandToLevel(AbstractTreeViewer.ALL_LEVELS);
	}

	private int isLayoutField(String layoutField) {
		Object[] treeItems = getTreeItems(treeViewer.getTree().getItems());
		for (int count = 0; count < treeItems.length; count++) {
			if (((CRLClass.LayoutField) ((TreeItem)treeItems[count]).getData())
					.getField().equalsIgnoreCase(layoutField)) {
				return count;
			}
		}
		return -1;
	}

	@Override
	public void createMenuItem(Menu menu, String text) {
		final MenuItem menuItem = new MenuItem(menu, SWT.PUSH);
		menuItem.setText(text);
		menuItem.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				String value = fields.get(lineNumber).getValue();
				if (((MenuItem) event.widget).getText().equals(FIELD_NAME)) {
					LayoutField selectedLayoutField = ((LayoutField)(treeViewer.getTree().getSelection()[0]).getData());					
					
					dialog = new TestingToolsWizardDialog(getShell(),
							new SelFieldNameWizard(crl.getLayout(selectedIndex)
									.getLayoutDataset(), crl.getLayout(
											selectedIndex).getLayoutMember(), true, server, selectedLayoutField));
					
					dialog.create();
					dialog.open();
				} else if (!value
						.matches("([CTXPBN]*\\d*['\"]?[0-9A-Za-z]*['\"]?\\s*)*")) {
					value = "";
				}
				if (((MenuItem) event.widget).getText().equals(CHARACTER)) {
					fields.get(lineNumber).setValue(value + " C'' ");
				} else if (((MenuItem) event.widget).getText().equals(TEXT)) {
					fields.get(lineNumber).setValue(value + " T'' ");
				} else if (((MenuItem) event.widget).getText().equals(
						HEXADECIMAL)) {
					fields.get(lineNumber).setValue(value + " X'' ");
				} else if (((MenuItem) event.widget).getText().equals(PACKED)) {
					fields.get(lineNumber).setValue(value + " P'' ");
				} else if (((MenuItem) event.widget).getText().equals(BINARY)) {
					fields.get(lineNumber).setValue(value + " B'' ");
				} else if (((MenuItem) event.widget).getText().equals(NUMERIC)) {
					fields.get(lineNumber).setValue(value + " N'' ");
				}
				treeViewer.refresh();
			}
		});
	}

	@Override
	public boolean doFinish() {
		newCondition = "";
		String logicalOperator = "";

		Object[] treeItems = getTreeItems(treeViewer.getTree().getItems());

		//update existing selection conditions
		for(int i = 0; i < map.length; i++){
			if(map[i] > -1&& ((TreeItem)treeItems[map[i]]).getData()!=null){
				if (!((CRLClass.LayoutField) ((TreeItem)treeItems[map[i]]).getData()).getValue().trim().isEmpty()) {
					//@parra12: commented out the i>0 due to defect 3211
					if(/*i > 0 || */!newCondition.isEmpty()){
						newCondition += " " + getLogOperator(((CRLClass.LayoutField) ((TreeItem)treeItems[map[i]]).getData()).getLogOperator()) + " \r\n";
					}
					logicalOperator = SelConds[i].split("\\s+")[SelConds[i].split("\\s+").length - 1].toUpperCase();
					if(!isLogicalOperator(logicalOperator)){
						logicalOperator = "AND";
					}
					
					String type = ((CRLClass.LayoutField) ((TreeItem)treeItems[map[i]]).getData()).getFormatType();
					String value = ((CRLClass.LayoutField) ((TreeItem)treeItems[map[i]]).getData()).getValue();

					newCondition += ((CRLClass.LayoutField) ((TreeItem)treeItems[map[i]]).getData()).getField() + " " +
					getUpdatedOperator(SelConds[i],
							getOperator(((CRLClass.LayoutField) ((TreeItem)treeItems[map[i]]).getData()).getOperator()))
							+ " " + checkQualifier(value, type);
				}
			} else {
				if(i > 0){
					newCondition += " " + logicalOperator + "\r\n";
				}
				logicalOperator = SelConds[i].split("\\s+")[SelConds[i].split("\\s+").length - 1].toUpperCase();

				if(isLogicalOperator(logicalOperator)){
					newCondition += SelConds[i].substring(0, SelConds[i].length() - logicalOperator.length()).trim();
				} else {
					newCondition += SelConds[i].trim();	
				}
			}
		}
		
		//add new selection conditions
				for (int i = 0; i < treeItems.length; i++) {
					if(((TreeItem)treeItems[i]).getData()!=null){
					if (!((CRLClass.LayoutField) ((TreeItem)treeItems[i]).getData()).getValue().trim().isEmpty()
							&& !isMappedCondition(i)) {

						if(!newCondition.isEmpty()){
							newCondition += " " + getLogOperator(((CRLClass.LayoutField) ((TreeItem) treeItems[i]).getData()).getLogOperator()) + " \r\n";
						}
						
						String value = ((CRLClass.LayoutField) ((TreeItem)treeItems[i]).getData()).getValue();
						String type = ((CRLClass.LayoutField) ((TreeItem)treeItems[i]).getData()).getFormatType();
						
						newCondition += ((CRLClass.LayoutField) ((TreeItem) treeItems[i]).getData()).getField()
						+ " " + getOperator(((CRLClass.LayoutField) ((TreeItem)treeItems[i]).getData()).getOperator())
						+ " " + checkQualifier(value, type);
					}
				}
				}
	//	genericSelCrit.setText(newCondition);
		saveSelCrit.notifyListeners(SWT.Selection, new Event());
		return true;
	}
	
	private String checkQualifier(String value, String type) {
		/* Method to help fix defect 2200 
			1)	If an alpha-numeric value is enclosed only in either quotes or apostrophes on the Rules/Layout window, 
			then it should be qualified with a T on the Selection Condition Update panel.
			2)	If a numeric value is not enclosed in quotes or apostrophes on the Rules/Layout window, then they 
			should be enclosed in quotes and qualified on the Selection Condition Update panel.  For a packed field 
			the value should be qualified with a P.  For a zoned numeric or binary field then the value should be 
			qualified with an N.
		 */
		value = value.trim();
		if(value.matches("['\"][+-]?[0-9]*\\.?[0-9]*['\"]")) {
			if(type.matches("PS?")) {
				return "P" + value;
			} else if(type.matches("[BN]S?")) {
				return "N" + value;
			}
		} else if(value.matches("[+-]?[0-9]*\\.?[0-9]*")) {
			if(type.matches("PS?")) {
				return "P'" + value + "'";
			} else if(type.matches("[BN]S?")) {
				return "N'" + value + "'";
			}
		} else if(value.matches("['\"][\\x20-\\x7E]*['\"]")) {
			return "T" + value;
		}
		return value;
	}

	private boolean isMappedCondition(int index){
		for(int i = 0; i < map.length; i++){
			if(map[i] == index){
				return true;
			}
		}
		return false;
	}

	private void mapCondition(int indexInConditions, int indexInTree){
		//duplicated commands - take the last one 
		for(int i = 0; i < indexInConditions; i++){
			if(map[i] == indexInTree){
				map[i] = -1;
			}
		}
		map[indexInConditions] = indexInTree;
	}

	private boolean isLogicalOperator(String string) {
		if (string.equalsIgnoreCase("AND")
				|| string.equalsIgnoreCase("OR")
				|| string.equalsIgnoreCase("&")
				|| string.equalsIgnoreCase("|")){
			return true;
		}
		return false;
	}

	private String getUpdatedOperator(String string, String operator) {
		String oldOperator = string.split("\\s+")[1].trim();
		if (oldOperator.equals("=") || oldOperator.equals("<>")
				|| oldOperator.equals("<") || oldOperator.equals(">")
				|| oldOperator.equals("<=") || oldOperator.equals(">=")) {
			return getUpdatedOperator(operator);
		} else {
			return operator;
		}
	}

	private String getUpdatedOperator(String operator) {
		if (operator.equals("GT"))
			return ">";
		if (operator.equals("GE"))
			return ">=";
		if (operator.equals("EQ"))
			return "=";
		if (operator.equals("NE"))
			return "<>";
		if (operator.equals("LT"))
			return "<";
		if (operator.equals("LE"))
			return "<=";
		if (operator.equals("CO"))
			return "CO";
		return null;
	}

	private String getOperator(int operator){
		switch (operator) {
		case CRLClass.GT:
			return "GT";
		case CRLClass.GE:
			return "GE";
		case CRLClass.EQ:
			return "EQ";
		case CRLClass.NE:
			return "NE";
		case CRLClass.LT:
			return "LT";
		case CRLClass.LE:
			return "LE";
		case CRLClass.CO:
			return "CO";
		default:
			return "";
		}
	}
	
	private int getOperator(String operator){
		operator = operator.trim().toUpperCase();
		
		if (operator.equalsIgnoreCase("EQ")	|| operator.equalsIgnoreCase("=")) {
			return CRLClass.EQ;
		}
		if (operator.equalsIgnoreCase("NE")	|| operator.equalsIgnoreCase("<>")) {
			return CRLClass.NE;
		}
		if (operator.equalsIgnoreCase("LE")	|| operator.equalsIgnoreCase("<=")) {
			return CRLClass.LE;
		}
		if (operator.equalsIgnoreCase("GE") || operator.equalsIgnoreCase(">=")) {
			return CRLClass.GE;
		}
		if (operator.equalsIgnoreCase("LT") || operator.equalsIgnoreCase("<")) {
			return CRLClass.LT;
		}
		if (operator.equalsIgnoreCase("GT")	|| operator.equalsIgnoreCase(">")) {
			return CRLClass.GT;
		}
		if (operator.equalsIgnoreCase("CO")) {
			return CRLClass.CO;
		}
		return CRLClass.NONE;
	}

	private String getLogOperator(int logOperator){
		switch (logOperator) {
		case CRLClass.AND:
			return "AND"; 
		case CRLClass.OR:
			return "OR"; 
		default:
			return "AND"; 
		}
	}

	public static String getNewCondition() {
		return newCondition;
	}
}
