/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

import com.ca.fmp.ims.common.FMHistory;
import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.common.FileMasterMember;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.VPATSortDialog;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.fmp.ims.model.GetMemberRequestType;
import com.ca.fmp.ims.model.WCMemberRequestType;
import com.ca.fmp.ims.model.WCdsnRequestType;
import com.ca.fmp.ims.model.generated.FilterMemberInfoListType;
import com.ca.fmp.ims.model.generated.FilterMemberInfoType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.GetMemberResponseType;
import com.ca.fmp.ims.model.generated.GetMemberType;
import com.ca.fmp.ims.model.generated.MemberTypeType;
import com.ca.fmp.ims.model.generated.WCMemberTypeType;
import com.ca.fmp.ims.model.generated.WildCardMemberType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.operation.SendRequestToMainframeJob;
import com.ca.fmp.ims.view.wizards.DatasetWizard;
import com.ca.fmp.ims.view.wizards.FileMasterWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class ImportSelCritWizardPage extends FileMasterWizard implements
		ModifyListener, SelectionListener, Listener, ICheckStateListener {

	protected FileMasterServer server;
	private FMServerTreeModel model = FMServerTreeModel.getInstance();
	//private FMSelectionTreeModel fmstModel = FMSelectionTreeModel.getInstance();
	private FileMasterMember member;
	protected Label labelServer;
	private Label selectMemberLabel;
	protected Combo servername;
	Combo selectViewCombo;
	Combo selectdsnCombo;
	Combo selectMemberCombo;
	private Button selectAll;
	private Button btnMemberSelect;
	protected Label seldsnBtn;
	protected Button selView;

	String newServer;
	String oldServer;
	boolean pendingMessage = false;
	boolean msgDisplayed;
	private String newDatasetName;
	private String oldDatasetName;
	private Text numberOfMem;
	private IPreferenceStore store = new ScopedPreferenceStore(
			new InstanceScope(), "com.ca.fmp.ims.common");
	private Boolean ShowDialog = false;
	private static String[] SelConds;
	private static ArrayList<String> contentSelRec = new ArrayList<String>();

	protected CheckboxTableViewer viewer;
	private static final int NAME = 0;
	private static final int DBDName=1;
	private static final int DESCRIPTION = 2;
	private static final int DateChanged = 3;
	private static final int TimeChanged = 4;
	private static final int UserID = 5;
	private Listener sortListener;
	public static Button saveSelCrit;
	public static String layoutDsn;
	public static String description;
	private final String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.importSelCrit"; //$NON-NLS-1$
	protected String missingDSandMem;
	//private FileMasterMember selMember;
	private ArrayList<FileMasterMember> memberList = new ArrayList<FileMasterMember>();
	private String selDataSetName;
	private String selMemberName;
	public static String conditions = "";
	private static String layDsname;
	private static String LayMem;
	private GUIResponseType response;
	private ArrayList<String> TempmembersList = new ArrayList<String>();
	
	private Listener sortListenerVPAT;  //grake02 26/OCT/2016

	public ImportSelCritWizardPage(String pageName, FileMasterServer server,
			String[] SelConds) {
		super(pageName);
		setTitle(pageName);
		this.server = server;
		ImportSelCritWizardPage.SelConds = SelConds;
		missingDSandMem = "Please select a Selection data set and member\n ";

	}

	@Override
	public void createControl(Composite parent) {
		super.createControl(parent);
		PlatformUI.getWorkbench().getHelpSystem()
				.setHelp(parent, CONTEXT_HELP_ID);
		saveSelCrit = new Button(parent, SWT.NONE);
		saveSelCrit.setEnabled(false);
		/* Server Label */
		labelServer = new Label(dataSetComposite, SWT.BOLD | SWT.LEFT);
		labelServer.setText("Se&rver:"); //$NON-NLS-1$
		GridData gd_labelServer = new GridData(SWT.LEFT, SWT.CENTER, false,
				false, 1, 1);
		gd_labelServer.horizontalIndent = 16;
		labelServer.setLayoutData(gd_labelServer);
		/* Server ComboBox */
		servername = new Combo(dataSetComposite, SWT.BORDER | SWT.READ_ONLY);

		servername.setItems(getServers());
		servername.setText(server.getText());
		TextUtil.setWidth(servername, 37);
		servername.addListener(SWT.Selection, this);

		if (servername.getItemCount() > 0) {
			boolean lastServerExists = false;
			String lastServerUsed = FMHistory
					.getServer("ServerAddSelcritWizardPage");
			for (int count = 0; count < servername.getItemCount(); count++) {
				if (servername.getItem(count).toString()
						.equalsIgnoreCase(lastServerUsed)) {
					lastServerExists = true;
					servername.setText(servername.getItem(count).toString());

					break;
				}
			}
			if (!lastServerExists)
				servername.setText(servername.getItem(0));
		}

		servername.addFocusListener(new FocusListener() {

			@Override
			public void focusLost(FocusEvent e) {
			}

			@Override
			public void focusGained(FocusEvent e) {
				if (!msgDisplayed) {
					oldServer = servername.getText();

				}
				msgDisplayed = false;
			}
		});

		servername.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				newServer = servername.getText().trim();
				server = FMServerTreeModel.getInstance().getServer(newServer.split("\\(")[0]);
				pendingMessage = true;
				if (oldServer != null)
					displayServerChangedMsg();
				changeServer();
				setPageComplete(canFlipToNextPage());
			}

		});

		new Label(dataSetComposite, SWT.NONE);
		new Label(dataSetComposite, SWT.NONE);
		
		/* Record Layout Data set */
		seldsnBtn = new Label(dataSetComposite, SWT.NONE);
		seldsnBtn.setText("Select &data set:");
		GridData gd_selectDSNLabel = new GridData(SWT.LEFT, SWT.CENTER,
				false, false, 1, 1);
		gd_selectDSNLabel.horizontalIndent = 16;
		seldsnBtn.setLayoutData(gd_selectDSNLabel);

		/* Data set combo box */
		selectdsnCombo = new Combo(dataSetComposite, SWT.BORDER);
		selectdsnCombo.addFocusListener(new FocusListener() {

			@Override
			public void focusLost(FocusEvent e) {
			}

			@Override
			public void focusGained(FocusEvent e) {
				if (!msgDisplayed) {
					oldDatasetName = selectdsnCombo.getText();

				}
				msgDisplayed = false;
			}
		});
		selectdsnCombo.addKeyListener(new KeyListener() {

			@Override
			public void keyReleased(KeyEvent e) {
				newDatasetName = selectdsnCombo.getText().trim();
				ShowDialog = !store.getBoolean("CLOSE_VALUE");
				boolean datasetError = (Validator.dataset(
						selectdsnCombo.getText(), true) == Validator.NO_ERROR
						|| Validator.dataset(selectdsnCombo.getText(), true) == Validator.DS_WILDCARD || Validator
						.dataset(selectdsnCombo.getText(), true) == Validator.DS_MISSING) ? false
						: true;
				if (ShowDialog
						&& !datasetError
						&& (viewer.getTable().getItemCount() > 1 || !selectMemberCombo
								.getText().isEmpty())
						&& !oldDatasetName.equalsIgnoreCase(newDatasetName)) {
					pendingMessage = true;
				} else {
					pendingMessage = false;
					if (!oldDatasetName.equalsIgnoreCase(newDatasetName)) {
						oldDatasetName = newDatasetName;
						viewer.getTable().removeAll();
						viewer.setInput(null);
						selectMemberCombo.setText("");
					}
				}
				displayDatasetChangedMsg();

			}

			@Override
			public void keyPressed(KeyEvent e) {
			}
		});
		selectdsnCombo.addMouseListener(new MouseListener() {
			
			@Override
			public void mouseUp(MouseEvent e) {
				// TODO Auto-generated method stub
				newDatasetName = selectdsnCombo.getText().trim();
				ShowDialog = !store.getBoolean("CLOSE_VALUE");
				boolean datasetError = (Validator.dataset(
						selectdsnCombo.getText(), true) == Validator.NO_ERROR
						|| Validator.dataset(selectdsnCombo.getText(), true) == Validator.DS_WILDCARD || Validator
						.dataset(selectdsnCombo.getText(), true) == Validator.DS_MISSING) ? false
						: true;
				if (ShowDialog
						&& !datasetError
						&& (viewer.getTable().getItemCount() > 1 || !selectMemberCombo
								.getText().isEmpty())
						&& !oldDatasetName.equalsIgnoreCase(newDatasetName)) {
					pendingMessage = true;
				} else {
					pendingMessage = false;
					if (!oldDatasetName.equalsIgnoreCase(newDatasetName)) {
						oldDatasetName = newDatasetName;
						viewer.getTable().removeAll();
						viewer.setInput(null);
						selectMemberCombo.setText("");
					}
				}
				displayDatasetChangedMsg();
			}
			
			@Override
			public void mouseDown(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void mouseDoubleClick(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		selectdsnCombo.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				newDatasetName = selectdsnCombo.getText().trim();
				ShowDialog = !store.getBoolean("CLOSE_VALUE");
				boolean datasetError = (Validator.dataset(
						selectdsnCombo.getText(), true) == Validator.NO_ERROR
						|| Validator.dataset(selectdsnCombo.getText(), true) == Validator.DS_WILDCARD || Validator
						.dataset(selectdsnCombo.getText(), true) == Validator.DS_MISSING) ? false
						: true;
				if (ShowDialog
						&& !datasetError
						&& (viewer.getTable().getItemCount() > 1 || !selectMemberCombo
								.getText().isEmpty())
						&& !oldDatasetName.equalsIgnoreCase(newDatasetName)) {
					pendingMessage = true;
				} else {
					pendingMessage = false;
					if (!oldDatasetName.equalsIgnoreCase(newDatasetName)) {
						oldDatasetName = newDatasetName;
						viewer.getTable().removeAll();
						viewer.setInput(null);
						selectMemberCombo.setText("");
					}
				}
				displayDatasetChangedMsg();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		});
		selectdsnCombo.addModifyListener(this);
		selectdsnCombo.addVerifyListener(new verifytoUpperCase());
		selectdsnCombo.setLayoutData(new GridData(SWT.FILL, SWT.NONE, true,
				true, 1, 1));
		TextUtil.setWidth(selectdsnCombo, 35);
		selectdsnCombo.setTextLimit(44);
		FMHistory.intializeComboBoxes(selectdsnCombo, "ImportSelCritSelectDSN");
		selectdsnCombo.setEnabled(true);
		/* Button for Data set Select */
		dataSetSelectBtn = new Button(dataSetComposite, SWT.NONE);
		dataSetSelectBtn.setEnabled(false);
		dataSetSelectBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				FMWWidgetSelected(e);
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		});
		dataSetSelectBtn.setText("&Select...");

		/* Button for Data set DSN List */
		dataSetDSNListBtn = new Button(dataSetComposite, SWT.NONE);
		dataSetDSNListBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				FMWWidgetSelected(e);
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		});
		dataSetDSNListBtn.setText("DSN &List...");
		dataSetDSNListBtn.setEnabled(false);
		dataSetDSNListBtn.setVisible(false);
		selectMemberLabel = new Label(dataSetComposite, SWT.NONE);
		GridData gd_selectMemberLabel = new GridData(SWT.LEFT, SWT.CENTER,
				false, false, 1, 1);
		gd_selectMemberLabel.horizontalIndent = 16;
		selectMemberLabel.setLayoutData(gd_selectMemberLabel);
		selectMemberLabel.setText("&Member name:");

		// Member combo
		selectMemberCombo = new Combo(dataSetComposite, SWT.NONE);
		selectMemberCombo.setLayoutData(new GridData(SWT.FILL, SWT.NONE, true,
				true, 1, 1));
		selectMemberCombo.setTextLimit(8);
		GridData gd_layoutMemberCombo = new GridData(SWT.FILL, SWT.FILL, false,
				false, 1, 1);
		gd_layoutMemberCombo.widthHint = 107;
		selectMemberCombo.addModifyListener(this);
		selectMemberCombo.addVerifyListener(new verifytoUpperCase());
		// toMember Preferences
		FMHistory.intializeComboBoxes(selectMemberCombo,
				"ImportSelCritSelectMember");
		selectMemberCombo.setEnabled(true);
		btnMemberSelect = new Button(dataSetComposite, SWT.NONE);
		btnMemberSelect.setText("S&elect");
		btnMemberSelect.setLayoutData(new GridData(SWT.FILL, SWT.CENTER,
				true, false, 1, 1));
		btnMemberSelect.setEnabled(false);
		new Label(dataSetComposite, SWT.NONE);
		
		btnMemberSelect.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				member = new FileMasterMember();
				member.setName(selectMemberCombo.getText());
				doSelect();
				
			}
		});
		
		dataSetComposite.setTabList(new Control[]{servername,selectdsnCombo, dataSetSelectBtn, dataSetDSNListBtn,
				selectMemberCombo, btnMemberSelect});

		Composite memberTbl = new Composite(container, SWT.NONE);
		memberTbl.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		GridLayout memberTbl_layout = new GridLayout(2, false);
		memberTbl.setLayout(memberTbl_layout);
		createViewer(memberTbl);
		/* Select All Button */
		selectAll = new Button(memberTbl, SWT.PUSH);
		selectAll.setText("Select &All");
		GridData gd_selectAll = new GridData(SWT.LEFT, SWT.CENTER, false,
				false, 1, 1);
		gd_selectAll.widthHint = 120;
		selectAll.setLayoutData(gd_selectAll);
		selectAll.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (viewer.getTable().getItems().length > 0) {
					if (selectAll.getText().toString()
							.equalsIgnoreCase("Select &All")) {
						for (int i = 0; i < viewer.getTable().getItems().length; i++) {
							viewer.getTable().getItem(i).setChecked(true);
						}
						selectAll.setText("&Clear Selections");
					} else {
						selectAll.setText("Select &All");
						for (int i = 0; i < viewer.getTable().getItems().length; i++) {
							viewer.getTable().getItem(i).setChecked(false);
						}
					}
				}
				setPageComplete(isPageComplete());
			}
		});
		numberOfMem = new Text(memberTbl, SWT.READ_ONLY);
		numberOfMem.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true,
				false, 1, 1));
		TextUtil.setWidth(numberOfMem, 12);
		numberOfMem.setEnabled(false);

		getShell().getDefaultButton().setText("OK");
		setControl(container);
		viewer.addCheckStateListener(this);
		setPageComplete(isPageComplete());
		
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
	}

	private void createViewer(Composite parent) {

		viewer = CheckboxTableViewer.newCheckList(parent, SWT.BORDER
				| SWT.FULL_SELECTION | SWT.H_SCROLL | SWT.V_SCROLL | SWT.MULTI);

		viewer.getTable().setLinesVisible(true);
		viewer.getTable().setHeaderVisible(true);
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 2,
				1);
		gd_table.heightHint = 130;
		gd_table.widthHint = 534;
		viewer.getTable().setLayoutData(gd_table);
		setupColumnListener();
		createColumns(parent, viewer);
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setInput(null);
		
		setupVPATColumnSorter();  //grake02 27/OCT/2016

	}

	private void changeServer() {
		String TestServer = "";
		for (int servers = 0; servers < model.getServers().length; servers++) {
			TestServer = model.getServers()[servers].getText();
			if (TestServer.equalsIgnoreCase(servername.getText())) {
				this.server = (FileMasterServer) model.getServers()[servers]
						.getAdapter(FileMasterServer.class);
				serverChanged(server);
				break;
			}
		}
	}

	private int displayServerChangedMsg() {
		msgDisplayed = true;
		int returncode = -1;
		boolean remove = false;
		if (pendingMessage) {
			pendingMessage = false;
			if (newServer != null && !newServer.equals(oldServer)) {
				final String title = "Confirm Server Change";
				String toggleMessage = "Do not ask me again";
				String question = "Are you sure you want to change the server? Clicking yes will reset all fields on this dialog. ";

				MessageDialogWithToggle result = MessageDialogWithToggle
						.openYesNoQuestion(null, title, question,
								toggleMessage, false, store, "CLOSE_VALUE");
				returncode = result.getReturnCode();
				if (returncode == 2)
					remove = true;
				if (remove) {
					oldServer = newServer;
					store.setValue("CLOSE_VALUE", result.getToggleState());

					if (result.getToggleState())
						ShowDialog = false;

					viewer.getTable().removeAll();
					viewer.setInput(null);
					selectMemberCombo.setText("");
					selectdsnCombo.setText("");
					numberOfMem.setText("");
				} else {
					if (result.getToggleState()) {
						ShowDialog = false;
					}
					servername.setText(oldServer);
					newServer = oldServer;
				}
			}
		}
		return returncode;
	}

	private int displayDatasetChangedMsg() {
		msgDisplayed = true;
		int returncode = -1;
		boolean remove = false;
		if (pendingMessage) {
			pendingMessage = false;
			if (newDatasetName != null
					&& !newDatasetName.equals(oldDatasetName)) {
				final String title = "Confirm Change Data Set";
				String toggleMessage = "Do not ask me again";
				String question = "Are you sure you want to change the data set? Clicking yes will reset all fields on this dialog. ";

				MessageDialogWithToggle result = MessageDialogWithToggle
						.openYesNoQuestion(null, title, question,
								toggleMessage, false, store, "CLOSE_VALUE");
				returncode = result.getReturnCode();
				if (returncode == 2)
					remove = true;
				if (remove) {

					oldDatasetName = newDatasetName;
					store.setValue("CLOSE_VALUE", result.getToggleState());

					if (result.getToggleState())
						ShowDialog = false;

					viewer.getTable().removeAll();
					viewer.setInput(null);
					selectMemberCombo.setText("");
				} else {
					if (result.getToggleState()) {
						ShowDialog = false;
					}
					selectdsnCombo.setText(oldDatasetName);
					newDatasetName = oldDatasetName;
				}
			}

		}
		return returncode;
	}

	public TableViewer getViewer() {
		return viewer;
	}

	private void createColumns(final Composite parent, final TableViewer viewer) {
		String[] titles = { "Name", "DBD Name","Description", "Date Changed","Time Changed","User ID" };
		int[] bounds = { 100,100,300,120,120,100 };
		Table table = viewer.getTable();
		for (int i = 0; i < titles.length; i++) {
			TableViewerColumn tableColumn = new TableViewerColumn(viewer,
					bounds[i]);
			switch (i) {
			case NAME:
				tableColumn.setLabelProvider(new NameLabelProvider());
				break;
			case DBDName:
				tableColumn.setLabelProvider(new DBDNameLabelProvider());
				break;
			case DESCRIPTION:
				tableColumn.setLabelProvider(new DescriptionLabelProvider());
				break;
			
			case DateChanged:
				tableColumn.setLabelProvider(new DateChangedLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case TimeChanged:
				tableColumn.setLabelProvider(new TimeChangednLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case UserID:
				tableColumn.setLabelProvider(new UserIDLabelProvider());
				break;
			}

			tableColumn.getColumn().setText(titles[i]);
			tableColumn.getColumn().setWidth(bounds[i]);
			tableColumn.getColumn().addListener(SWT.Selection, sortListener);
		}

		viewer.setSorter(new ImportSelCritWizardPageSorter());
		table.setSortColumn(table.getColumn(0));
		table.setSortDirection(SWT.UP);
	}

	/**
	 * 
	 */
	private void setupColumnListener() {
		sortListener = new Listener() {

			public void handleEvent(final Event event) {
				HashMap<String,String> items = new HashMap<String, String>();
				for(int i =0; i < viewer.getTable().getItemCount(); i++){
					items.put(((FileMasterMember)viewer.getTable().getItem(i).getData()).getName(),viewer.getTable().getItem(i).getChecked()== true? "true" : "false" );
				}
				final TableColumn column = (TableColumn) event.widget;
				final Table table = viewer.getTable();
				if (column.equals(table.getSortColumn())) {
					final int direction = table.getSortDirection();
					switch (direction) {
					case SWT.DOWN:
						table.setSortDirection(SWT.UP);
						break;
					case SWT.None:
					case SWT.UP:
					default:
						table.setSortDirection(SWT.DOWN);
						break;
					}
				} else {
					table.setSortColumn(column);
					table.setSortDirection(SWT.UP);
				}
				viewer.refresh();
				String memberName;
				for(int i=0; i < items.size(); i++){
					memberName = ((FileMasterMember)viewer.getTable().getItem(i).getData()).getName();
					viewer.getTable().getItem(i).setChecked(items.get(memberName).equalsIgnoreCase("true") ? true : false);
				}
			}
		};

	}

	@Override
	public void handleEvent(Event event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		Widget source = e.widget;
		if (((Button) source).getText().equals("&Select...")) {
			DatasetWizard wizard = new DatasetWizard(selectdsnCombo.getText(), "", server);
			dialog = new TestingToolsWizardDialog(getShell(), wizard);
			dialog.open();
		}
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub

	}

	private String[] getServers() {
		String[] listOfServers = new String[model.getServers().length];
		for (int serverCount = 0; serverCount < model.getServers().length; serverCount++) {
			listOfServers[serverCount] = model.getServers()[serverCount]
					.getServer().getText();
		}
		return listOfServers;
	}

	public boolean isPageComplete() {

		if (viewer != null && selectAll != null) {
			if (viewer.getTable().getItemCount() == 0)
				selectAll.setEnabled(false);
			else
				selectAll.setEnabled(true);
		}

		// Selection Data set validation
		if (selectMemberCombo != null && dataSetSelectBtn != null
				&& btnMemberSelect != null) {

			
				// Selection Data set validation
				switch (Validator.dataset(selectdsnCombo.getText(), true)) {
				case Validator.DS_WILDCARD:
					error = error + Validator.errorMsg[Validator.DS_WILDCARD]
							+ "\n";
					dataSetSelectBtn.setEnabled(true);
					dataSetDSNListBtn.setEnabled(true);
					btnMemberSelect.setEnabled(false);
					break;
				case Validator.DS_INVALID:
				case Validator.DS_LONG:
					error = error
							+ Validator.errorMsg[Validator.dataset(
									selectdsnCombo.getText(), true)] + "\n ";
					dataSetSelectBtn.setEnabled(false);
					dataSetDSNListBtn.setEnabled(false);
					btnMemberSelect.setEnabled(false);
					break;
				case Validator.DS_MISSING:
					error = error + Validator.errorMsg[Validator.DS_MISSING]
							+ "\n";
					dataSetSelectBtn.setEnabled(false);
					btnMemberSelect.setEnabled(false);
					break;
				case Validator.NO_ERROR:
					dataSetSelectBtn.setEnabled(false);
					btnMemberSelect.setEnabled(false);
					break;
				}

			
			if(error.length()==0){
				// Selection member validation
				switch (Validator.member(selectMemberCombo.getText(), false)) {
				case Validator.MEM_WILDCARD:
					if (Validator.dataset(selectdsnCombo.getText(), true) != Validator.DS_MISSING) {
						btnMemberSelect.setEnabled(true);
						if (viewer.getCheckedElements().length == 0) {
							error = error
									+ Validator.errorMsg[Validator.member(
											selectMemberCombo.getText(), true)]
									+ "\n ";
						}
					} else {
						error = error
								+ Validator.errorMsg[Validator.dataset(
										selectdsnCombo.getText(), true)]
								+ "\n ";
						btnMemberSelect.setEnabled(false);
					}
					break;
				case Validator.MEM_INVALID:
					if (Validator.dataset(selectdsnCombo.getText(), true) != Validator.DS_MISSING) {
						if (viewer.getCheckedElements().length == 0) {
							error = error
									+ Validator.errorMsg[Validator.member(
											selectMemberCombo.getText(), false)]
									+ "\n ";
						}
					} else {
						error = error
								+ Validator.errorMsg[Validator.dataset(
										selectdsnCombo.getText(), true)]
								+ "\n ";

					}
					btnMemberSelect.setEnabled(false);
					break;
				case Validator.NO_ERROR:
					if (Validator.member(selectMemberCombo.getText(), true) != Validator.MEM_MISSING) {
						if (Validator.dataset(selectdsnCombo.getText(), true) != Validator.DS_MISSING) {

						} else {
							error = error
									+ Validator.errorMsg[Validator.dataset(
											selectdsnCombo.getText(), true)]
									+ "\n ";
						}
						btnMemberSelect.setEnabled(false);
					} else {
						if (Validator.dataset(selectdsnCombo.getText(), true) != Validator.DS_MISSING) {
							if (viewer.getCheckedElements().length == 0) {
								error = error
										+ Validator.errorMsg[Validator.member(
												selectMemberCombo.getText(),
												true)] + "\n ";
							}
						}
					}
					break;
				}

				if (selectMemberCombo.getText().trim().length() == 0
						&& (Validator.dataset(selectdsnCombo.getText(), true) == Validator.NO_ERROR))
					btnMemberSelect.setEnabled(true);

			}

		}
		if (error.length() > 0) {
			if (getErrorMessage() != null) {
				if (!getErrorMessage().equalsIgnoreCase(error)) {
					setErrorMessage(error);
					error = new String();
					return false;
				} else {
					error = new String();
				}
			} else {
				setErrorMessage(error);
				error = new String();
				return false;
			}
		} else {
			setErrorMessage(null);
			return true;
		}
		return false;
	}

	@Override
	public void checkStateChanged(CheckStateChangedEvent event) {
		// TODO Auto-generated method stub
		if (viewer.getCheckedElements().length >= 1) {
			if(viewer.getCheckedElements().length == 1)
			selectAll.setText("&Clear Selection");
			else
				selectAll.setText("&Clear Selections");
		} else {
			selectAll.setText("Select &All");
		}
		if (viewer.getCheckedElements().length == 0) {
			selectAll.setText("Select &All");
		}
		setPageComplete(canFlipToNextPage());
	}

	protected boolean ValidateMember() {

		if (selectMemberCombo != null && btnMemberSelect != null) {
			if (Validator.member(selectMemberCombo.getText(), true) == Validator.NO_ERROR) {
				btnMemberSelect.setEnabled(false);
				return true;
			} else

			if (btnMemberSelect != null && viewer != null) {
				switch (Validator.member(selectMemberCombo.getText(), true)) {
				case Validator.NO_ERROR:
				case Validator.MEM_WILDCARD:
					btnMemberSelect.setEnabled(true);
					break;
				case Validator.MEM_INVALID:
					error = error
							+ Validator.errorMsg[Validator.member(
									selectMemberCombo.getText(), true)] + "\n";
					btnMemberSelect.setEnabled(false);
					break;
				case Validator.MEM_MISSING:
					error = error
							+ Validator.errorMsg[Validator.member(
									selectMemberCombo.getText(), true)] + "\n";
					if (viewer.getCheckedElements().length > 0) {
						error = new String();
					}
					break;
				}

				if (error.length() > 0) {
					setErrorMessage(error);
					if (viewer.getCheckedElements().length > 0) {
						return true;
					}
					return false;
				} else {
					setErrorMessage(null);
					if (viewer.getCheckedElements().length > 0) {
						return true;
					}
					return false;
				}
			}
		}
		return false;
	}

	private void doSelect() {
		WildCardMemberType wildcardmemType= new WildCardMemberType();
		wildcardmemType.setDsname(selectdsnCombo.getText().trim());
		wildcardmemType.setWCMemberType(WCMemberTypeType.FILTER);
		if(selectMemberCombo.getText().equals("")){
			wildcardmemType.setWCMemberName("*");
		}
		else
		wildcardmemType.setWCMemberName(selectMemberCombo.getText().trim());
		
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new WCMemberRequestType(server,wildcardmemType).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
    		if(uuid.equalsIgnoreCase("\""))
    			throw new TTException();
		} catch (TTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			//return false;
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);
		//Temporary fix to wait for the response before trying to parse it.
		if(req.getResult()!=Status.CANCEL_STATUS){
		do{
			System.out.println("Waiting on the response.");
		}while(req.getResult() != Status.OK_STATUS);
		
		response = req.getGuiResponseType();
		
		int oldSelectedMember = viewer.getCheckedElements().length;
		boolean isMemberExist = false;
		memberList.clear();
		for (int i = 0; i < oldSelectedMember; i++) {
			memberList.add((FileMasterMember) viewer.getCheckedElements()[i]);

		}

		if (response == null) {
			System.out.println("resposne is null");
		}
		if(response.getFunctionRC()!=0 || response.getReturnCode()!=0){
			for(int i=0;i<response.getMessages().getMessage().size();i++){
				String shortText = response.getMessages().getMessage().get(i).getShortText();
				String messageID = response.getMessages().getMessage().get(i).getMessageId();
				List<String> messageText = response.getMessages().getMessage().get(i).getMessageText();
				TT_ErrorDialog.openError(null, "Error", messageID+": "+shortText, new Throwable(messageText.get(i)));

			}
		}
		 else {
				
			 FilterMemberInfoListType memberRespond = response.getWildCardMemberResponse().getFilterInfoList();
				List<FilterMemberInfoType> loadmemberLib = memberRespond.getFilterMemberInfo();
				

				for (FilterMemberInfoType m : loadmemberLib) {
					FileMasterMember fileMasterMember = new FileMasterMember();
					fileMasterMember.setName(m.getName());
					fileMasterMember.setDescription(m.getDescription());
					fileMasterMember.setUserID(m.getUserID());
					fileMasterMember.setTimeChanged(m.getTimeChanged());
					fileMasterMember.setDateChanged(m.getDateChanged());
					fileMasterMember.setDBDName(m.getDBDname());
					
					memberList.add(fileMasterMember);
				
							if (!memberList.contains(fileMasterMember)) {

								memberList.add(fileMasterMember);
							}
				}
						viewer.setInput(memberList.toArray(new FileMasterMember[memberList.size()]));
						viewer.refresh();
						if (memberList.size() == 1) {
							numberOfMem.setText(memberList.size()
									+ " member returned.");
						} else {
							numberOfMem.setText(memberList.size()
									+ " members returned.");
						}
						numberOfMem.setEnabled(true);
		 

				if (memberList.size() > 0)
					selectAll.setEnabled(true);
				else
					selectAll.setEnabled(false);
			}
		}
		}

	@Override
	public void FMWWidgetSelected(SelectionEvent e) {
		Widget source = e.widget;
		String datasetName = oldDatasetName;
		String DSLength = Integer.toHexString(oldDatasetName.length());
		fmdataset = new FileMasterDataset(null);
		fmdataset.setName(datasetName);
		fmdataset.setDSLength(DSLength);
		if (source instanceof Button) {
			if (((Button) source).getText().equals("&Select...")) {
				if(getWCResponse(fmdataset)){
				DatasetWizard wizard = new DatasetWizard(response,server);
				dialog = new TestingToolsWizardDialog(getShell(), wizard);
				dialog.create();
				DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener() {

							@Override
							public void widgetSelected(SelectionEvent e) {
								// TODO Auto-generated method stub
								selectdsnCombo.setText(DatasetWizardPage.getSelectedDSN().toString());
								fmdataset = DatasetWizardPage.getSelectedDSN();
							}

							@Override
							public void widgetDefaultSelected(SelectionEvent e) {
								// TODO Auto-generated method stub

							}
						});
				dialog.open();
				}
			} 
		}
	}
	private boolean getWCResponse(FileMasterDataset dataset) {
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new WCdsnRequestType(server,dataset.getName().trim()).createXml());
		} catch (TTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);
		if(req.getResult()==Status.CANCEL_STATUS){
			return false;
		}
		response = req.getGuiResponseType();
		if(response==null)
			return false;
		//No error therefore proceed with further processing.
		if(response.getFunctionRC()==0 && response.getReturnCode() ==0){
			int numOfDsnReturned = response.getWildCardDataSetResponse().getDataSetInfoList().getDataSetInfo().size();
	}
		else{
			for(int i=0;i<response.getMessages().getMessage().size();i++){
			String shortText = response.getMessages().getMessage().get(i).getShortText();
			String messageID = response.getMessages().getMessage().get(i).getMessageId();
			List<String> messageText = response.getMessages().getMessage().get(i).getMessageText();
			TT_ErrorDialog.openError(null, "Error", messageID+": "+shortText, new Throwable(messageText.get(i)));

		}
			return false;
		}
		return true;
	}
	public void insertMembersToTable(final List<FileMasterMember> members) {
		ArrayList<FileMasterMember> oldMembers = new ArrayList<FileMasterMember>();
		for (int i = 0; i < viewer.getTable().getItemCount(); i++) {
			if (viewer.getTable().getItem(i).getChecked())
				oldMembers.add((FileMasterMember) viewer.getElementAt(i));
		}
		for (int i = 0; i < members.size(); i++) {
			oldMembers.add(members.get(i));
		}
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setInput(oldMembers.toArray());

		viewer.setAllChecked(true);

		if (viewer.getTable().getItemCount() == 0)
			selectAll.setEnabled(false);

		if (viewer.getCheckedElements().length == viewer.getTable()
				.getItemCount()) {
			selectAll.setText("&Clear Selections");

		} else {
			selectAll.setText("Select &All"); // ----------------------------
		}

		if (members.size() > 0) {
			for (int i = 0; i < viewer.getTable().getItemCount(); i++) {
				((FileMasterMember) viewer.getTable().getItems()[i].getData()).setChecked(true);
			}
			setPageComplete(isPageComplete());

			selectAll.setEnabled(true);
		}
	}

	public boolean doFinish() {
		FMHistory.insertHistory(selectdsnCombo, "ImportSelCritSelectDSN");
		FMHistory.insertHistory(selectMemberCombo, "ImportSelCritSelectMember");

		TempmembersList = new ArrayList<String>();

		// if(viewer.getCheckedElements().length == 0){
		
			selDataSetName = selectdsnCombo.getText().trim();
			int numCheckedMembers = viewer.getCheckedElements().length;
			if (numCheckedMembers > 0) {
				for (int i = 0; i < numCheckedMembers; i++) {
					TempmembersList.add(((FileMasterMember) viewer
							.getCheckedElements()[i]).getName());

				}
			} else {
				selMemberName = selectMemberCombo.getText().trim();
				TempmembersList.add(selMemberName);
			}

		
		// selMember = CommonMFCalls.getFQMEM(selDataSetName, selMemberName,
		// server, "L");

		/*
		 * if(CommonMFCalls.RETURN_CODE.equals("0")){ if(!((FileMasterMember)
		 * selMember).getType().equalsIgnoreCase("S")){
		 * TT_ErrorDialog.openError(null,"Error","Return Code: 4",new
		 * Throwable("The specified member is not a valid selection member."));
		 * return false; }
		 * 
		 * } else{ return false; }
		 */
		// }
		//the doSelect will handle sending request and response if user enters member name and clicks Finish instead of a wildcard search.
		for (int i = 0; i < TempmembersList.size(); i++) {
			selMemberName = TempmembersList.get(i);
			doGetMember(selMemberName);
		}

		saveSelCrit.notifyListeners(SWT.Selection, new Event());

		return true;
	}

	

	private boolean doGetMember(String member) {
		GetMemberType getMemType= new GetMemberType();
		getMemType.setDsname(selectdsnCombo.getText().trim());
		getMemType.setMemberType(MemberTypeType.FILTER);
		getMemType.setMemberName(member.trim());
		
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new GetMemberRequestType(server,getMemType).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
    		if(uuid.equalsIgnoreCase("\""))
    			throw new TTException();
		} catch (TTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			//return false;
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);
		//Temporary fix to wait for the response before trying to parse it.
		
		if(req.getResult() == Status.CANCEL_STATUS){
			numberOfMem.setText("No members returned.");
			numberOfMem.setEnabled(true);
			return false;
			//return null;
		}
		do{
			System.out.println("Waiting on the response.");
		}while(req.getResult() != Status.OK_STATUS);
		response = req.getGuiResponseType();
		if(response.getReturnCode()!=0|| response.getFunctionRC()!=0){
			for(int i=0;i<response.getMessages().getMessage().size(); i++){
				String shortText = response.getMessages().getMessage().get(i).getShortText();
				String messageID = response.getMessages().getMessage().get(i).getMessageId();
				List<String> messageText = response.getMessages().getMessage().get(i).getMessageText();
				TT_ErrorDialog.openError(null, "Error", messageID+": "+shortText, new Throwable(messageText.get(i)));
				
		}
			return false;
		}
		 else {
			
			 String line = new String();
			 GetMemberResponseType getmemberResponse = response.getGetMemberResponse();
			 
			 //added the null check when member is returned with no selection criteria pass back control to the sel crit box in options page
			 if(getmemberResponse.getSelectionMember()==null){
				 line="";
			 }
			 else if(getmemberResponse.getSelectionMember().getSelectionMbrRecords()==null){
				 line="";
			 }
			 else{
				 description = getmemberResponse.getSelectionMember().getSelectionMbrHdrInfo().getFMProcessingParmDescription();
				 if(getmemberResponse.getSelectionMember()!=null)
				 layoutDsn = getmemberResponse.getSelectionMember().getSelectionMbrLayout().getDsname();
			 for(int i=0;i<getmemberResponse.getSelectionMember().getSelectionMbrRecords().getFMProcessingParmMbrRecord().size();i++){
				 line= getmemberResponse.getSelectionMember().getSelectionMbrRecords().getFMProcessingParmMbrRecord().get(i);
			 contentSelRec.add(line);
			 }
			 }
		 }
		return true;
	}

	public static String getLayDsname() {
		return layDsname;
	}

	public void setLayDsname(String layDsname) {
		this.layDsname = layDsname;
	}

	public static String getLayMem() {
		return LayMem;
	}

	public void setLayMem(String layMem) {
		LayMem = layMem;
	}

	public static String getNewCondition() {
		// TODO read from selMember
		//initialize the conditions variable to avoid duplicates
		conditions="";
		// retain the old values from the selection criteria box.
		if(SelConds!=null){
		for(int i = 0; i < SelConds.length; i++){
			if(!SelConds[i].trim().isEmpty())
			conditions+= SelConds[i] + "\r\n";
		}
		}
		//append the new conditions to existing conditions.
		for (int i = 0; i < contentSelRec.size(); i++) {
			if (!contentSelRec.isEmpty())
				conditions += contentSelRec.get(i) + "\r\n";
		}
		contentSelRec.clear();

		return conditions;
	}

	public static void setConditions(String conditions) {
		ImportSelCritWizardPage.conditions = "";
	}

	public void setDSNCombo(String selDSNString) {
		selectdsnCombo.setText(selDSNString);
	}

	@Override
	public void modifyText(ModifyEvent e) {
		// TODO Auto-generated method stub
		setPageComplete(isPageComplete());
	}
	
	//grake02 26/OCT/2016 - create filter filter for 508 compliant problem.
	private void setupVPATColumnSorter()
	{
        //grake02 26/OCT/2016 - invoke sort dialog so that application is 508 compliant
		sortListenerVPAT = new Listener() 
        {
        	public void handleEvent(Event event) 
        	{
	            if (event.keyCode == SWT.F12)
	            {
	            	VPATSortDialog VPATdialog = new VPATSortDialog(getShell(), viewer);
	            	VPATdialog.create();
	            	if (VPATdialog.open() == Window.OK)
	            	{
	            		viewer.refresh();
	            	}
	            }
	        }
	    };
	    
	    getShell().getDisplay().addFilter(SWT.KeyDown, sortListenerVPAT);      				
	}	
	
	public void dispose()
	{
		getShell().getDisplay().removeFilter(SWT.KeyDown, sortListenerVPAT);  //grake02 26/OCT/2016
		super.dispose();
	}	
}
