/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.dialogs;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;

import com.ca.fmp.ims.model.generated.IMSENVInfoType;

public class IMSENVInfoTypeComparator extends ViewerComparator {

	  private int propertyIndex;
	  private static final int ASCENDING = 0;
	  private static final int DESCENDING = 1;
	  private int direction = ASCENDING;

	  public IMSENVInfoTypeComparator() {
	    this.propertyIndex = 0;
	    direction = ASCENDING;
	  }

	  public int getDirection() {
	    return direction == 1 ? SWT.DOWN : SWT.UP;
	  }

	  public void setColumn(int column) {
	    if (column == this.propertyIndex) {
	      // Same column as last sort; toggle the direction
	      direction = 1 - direction;
	    } else {
	      // New column; do an ascending sort
	      this.propertyIndex = column;
	      direction = DESCENDING;
	    }
	  }

	  @Override
	  public int compare(Viewer viewer, Object e1, Object e2) {
		  IMSENVInfoType p1 = (IMSENVInfoType) e1;
		  IMSENVInfoType p2 = (IMSENVInfoType) e2;
		  int rc = 0;
		  switch (propertyIndex) {
		  case 0:
			  String name1 = "";
			  if(p1.getName() != null) {
				  name1 = p1.getName();
			  }
			  String name2 = "";
			  if(p2.getName() != null) {
				  name2 = p2.getName();
			  }
			  rc = name1.compareTo(name2);
			  break;
		  case 1:
			  // Have to account for null;
			  String typeString1 = "";
              if(p1.getType() != null) {
            	  typeString1 = p1.getType().toString(); 
              }
              String typeString2 = "";              
              if(p2.getType() != null) {
            	  typeString2 = p2.getType().toString(); 
              }
			  rc = typeString1.compareTo(typeString2);
			  break;
		  case 2:
			  // Have to account for items that don't have a description
			  String description1 = p1.getDescription();
			  if(description1 == null) {
				  description1 = "";
			  }
			  
			  String description2 = p2.getDescription();
			  if(description2 == null) {
				  description2 = "";
			  }
			  rc = description1.compareTo(description2);
			  break;
		  default:
			  rc = 0;
		  }
		  // If descending order, flip the direction
		  if (direction == DESCENDING) {
			  rc = -rc;
		  }
		  return rc;
	  }
}
