/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.databaselist;

import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.part.ViewPart;

import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.testingtools.core.ServerStatusJob;
import com.ca.testingtools.core.TT_TreeItem;


/**
 * This sample class demonstrates how to plug-in a new
 * workbench view. The view shows data obtained from the
 * model. The sample creates a dummy model on the fly,
 * but a real implementation would connect to the model
 * available either in this or another plug-in (e.g. the workspace).
 * The view is connected to the model using a content provider.
 * <p>
 * The view uses a label provider to define how model
 * objects should be presented in the view. Each
 * view can present the same model objects using
 * different labels and icons, if needed. Alternatively,
 * a single label provider can be shared between views
 * in order to ensure that objects of the same type are
 * presented in the same way everywhere.
 * <p>
 */

public class DatabaseListView extends ViewPart implements
IPropertyChangeListener {

	/**
	 * The ID of the view as specified by the extension.
	 */
	public static final String ID = "com.ca.fmp.ims.view.databaselist";
	public static final String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.databaselistview";

	private TreeViewer viewer;
	private MenuManager menuMgr;
	private boolean show=true;
	private FMServerTreeModel model = FMServerTreeModel.getInstance();
	//public static final String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.databaselistview";
	private static final boolean sortview = true;
	/**
	 * The constructor.
	 */
	public DatabaseListView() {
	}

	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(Composite parent) {
		DatabaseListViewPatternFilter filter = new DatabaseListViewPatternFilter();				
		FilteredTree tree = new FilteredTree(parent, SWT.BORDER | SWT.MULTI | SWT.H_SCROLL 
				| SWT.V_SCROLL | SWT.FULL_SELECTION, filter, false);
		viewer = tree.getViewer();			
		DatabaseListViewContentProvider contentprovider = new DatabaseListViewContentProvider(this);
		DatabaseListViewLabelProvider labelProvider = new DatabaseListViewLabelProvider(tree);
		DatabaseListDoubleClickListener doubleClickListener = new DatabaseListDoubleClickListener();
		PlatformUI.getWorkbench().getHelpSystem().setHelp(viewer.getControl(), CONTEXT_HELP_ID);		
		viewer.setContentProvider((ITreeContentProvider)contentprovider);	
		if (sortview)
		    viewer.setComparator(new DatabaseListViewComparator());
		viewer.setLabelProvider(labelProvider);
		viewer.addDoubleClickListener(doubleClickListener);
		getSite().setSelectionProvider(viewer);
		menuMgr = new MenuManager();
		menuMgr.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		// This is a bad way to remove duplicate menu items in popup menu.
		//i have added this code to work around eclipse bug id= 366528 
		if (show) {
			menuMgr.addMenuListener(new IMenuListener() {

				@Override
				public void menuAboutToShow(IMenuManager manager) {
					// TODO Auto-generated method stub
					// menuMgr.remove( (IContributionItem)
					// menuMgr.getMenu().getItem(1));
					show = false;
					menuMgr.removeAll();

				}
			});
		}
		getSite().registerContextMenu(menuMgr, viewer);
		Control control = viewer.getControl();
		Menu menu = menuMgr.createContextMenu(control);
		

		
		control.setMenu(menu);

		TT_TreeItem[] servers = model.getServers();
		viewer.setInput(servers);
		viewer.collapseAll();
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
		}
		for (TT_TreeItem item : servers) {
			ServerStatusJob job = new ServerStatusJob(item);
			job.schedule();
		}
		//hookDoubleClickCommand();
		
		getSite().setSelectionProvider(viewer);
		
		IContextService contextService = (IContextService)getSite().getService(IContextService.class);
		contextService.activateContext("com.ca.filemaster.ims");
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		viewer.getControl().setFocus();
	}

	public TreeViewer getViewer() {
		// TODO Auto-generated method stub
		return viewer;
	}
	@Override
	public void propertyChange(PropertyChangeEvent event) {
		Object source = event.getSource();
		final TT_TreeItem item = model.findObject(source);

		Object newValue = event.getNewValue();
		for (TT_TreeItem itemRefresh : model.getServers()) {
			ServerStatusJob job = new ServerStatusJob(itemRefresh);
			job.schedule();
		}

		
		if (item != null && newValue != null) { // don't refresh deletes
			Display display = Display.getDefault();
			if (display != null && !viewer.getControl().isDisposed()) {
				display.asyncExec(new Runnable() {

					@Override
					public void run() {
						viewer.refresh(item, true);
					}
				});
			}
		}
	}
	@Override
	public void dispose() {
		super.dispose();
		for (TT_TreeItem server : model.getServers()) {
			server.removeListener(this);
		}
	}
}