/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.FMHistory;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.IMSDatabase;
import com.ca.fmp.ims.model.OpenDatabaseRequestType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.EditModeType;
import com.ca.fmp.ims.model.generated.IMSENVTypeType;
import com.ca.fmp.ims.model.generated.OpenDBActionType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Messages;
import com.ca.fmp.ims.view.ckey.ConcatenatedKeyView;
import com.ca.fmp.ims.view.editor.EditorView;
import com.ca.fmp.ims.view.wizardpages.OpenDatabaseWizardPageDBD;
import com.ca.fmp.ims.view.wizardpages.OpenDatabaseWizardPageDBDDSN;
import com.ca.fmp.ims.view.wizardpages.OpenDatabaseWizardPageServer;
import com.ca.fmp.ims.view.wizardpages.OptionsWizardPage;
import com.ca.fmp.ims.view.wizardpages.OpenDatabaseWizardPagePCB;
import com.ca.fmp.ims.view.wizardpages.OpenDatabaseWizardPageSIX;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;

/**
 * 
 * @author carel06
 */
public class OpenDatabaseWizard extends Wizard implements INewWizard {

	public final static String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.openWizardPage";
	private static final int GUISESSIONLEN = 36;
    protected OpenDatabaseWizardPageServer openDatabaseWizardPageServer;
//    protected OpenDatabaseWizardPageDBD openDatabaseWizardPageDBD;
//    protected OpenDatabaseWizardPageDBDDSN openDatabaseWizardPageDBDDSN;
    protected OptionsWizardPage optionsWizardPage;
    private Logger log = Logger.getLogger(OpenDatabaseWizard.class.getName());
    private FileMasterServer fileMasterServer;
    
	ArrayList<String> shortText = new ArrayList<String>();
	ArrayList<String> messageID = new ArrayList<String>();
	List<String> messageText = new ArrayList<String>();
	String messageIDFinal="";
	String messageTextFinal= "";
	String title = "";
	
	public IMSENVTypeType imsEnvType;
    
	public OpenDatabaseWizard() {
		super();
		setWindowTitle(Messages.OpenDatabaseWizard_0);
	}
	
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		if(selection.getFirstElement()!=null){
			TT_TreeItem treeItem= ((TT_TreeItem)(((IStructuredSelection)selection).getFirstElement()));
			if (treeItem.getParent() == null) {
				fileMasterServer = (FileMasterServer) treeItem.getValue();
			}
		}
		this.setForcePreviousAndNextButtons(true);
		
		//mainframe preferences moved to OpenDatabase handler
	}
	
	@Override
	public void addPages() {
		openDatabaseWizardPageServer = new OpenDatabaseWizardPageServer(fileMasterServer);
		addPage(openDatabaseWizardPageServer);
	}

	@Override
	public boolean performFinish() {
//		log.log(Level.INFO, "fileMasterServer: " + openDatabaseWizardPageServer.getServer());
//		log.log(Level.INFO, "dbd dsn: " + openDatabaseWizardPageDBDDSN.getDbdDsn1());
		return doFinish();
	}

	public FileMasterServer getFileMasterServer() {
		return fileMasterServer;
	}

	public OpenDatabaseWizardPageServer getOpenDatabaseWizardPageServer() {
		return openDatabaseWizardPageServer;
	}

	@Override
	public boolean canFinish() {

		if(imsEnvType == null){
			return false;
		}
							
		if(imsEnvType == IMSENVTypeType.BMP &&
				openDatabaseWizardPageServer.pageContentValidated
				&& ((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isPageComplete()){
			
			if (((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isPSBPageRequired == true
					&& getPage(Messages.OpenDatabaseWizard_Page_PCB) != null
					&& (!((OpenDatabaseWizardPagePCB) getPage(Messages.OpenDatabaseWizard_Page_PCB)).isPageComplete())){
				return false;	
			}
					
		    if (((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isSIXPageRequired == true
		    		&& getPage(Messages.OpenDatabaseWizard_Page_SIX) != null
		    		&& (!((OpenDatabaseWizardPageSIX) getPage(Messages.OpenDatabaseWizard_Page_SIX)).isPageComplete())){
		    	return false;
		    }	
			
			if(getPage(Messages.OpenDatabaseWizard_Page_Options) != null
					&& ((OptionsWizardPage) getPage(Messages.OpenDatabaseWizard_Page_Options)).isPageComplete() == true){
				return true;
			} else {
				return false;
			}
		}

		if(imsEnvType == IMSENVTypeType.DLI &&
				openDatabaseWizardPageServer.pageContentValidated
				&& ((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).pageContentValidated){
			
			if (((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isPSBPageRequired == true
					&& getPage(Messages.OpenDatabaseWizard_Page_PCB) != null
					&& (!((OpenDatabaseWizardPagePCB) getPage(Messages.OpenDatabaseWizard_Page_PCB)).isPageComplete())){
				return false;	
			}
					
		    if (((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isSIXPageRequired == true
		    		&& getPage(Messages.OpenDatabaseWizard_Page_SIX) != null
		    		&& (!((OpenDatabaseWizardPageSIX) getPage(Messages.OpenDatabaseWizard_Page_SIX)).isPageComplete())){
		    	return false;
		    }		

			if(((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isDBDDSNPageRequired == true
					&& getPage(Messages.OpenDatabaseWizard_Page_DBDDSN) != null
					&& ((OpenDatabaseWizardPageDBDDSN) getPage(Messages.OpenDatabaseWizard_Page_DBDDSN)).isPageComplete()){
				if(getPage(Messages.OpenDatabaseWizard_Page_Options) != null
						&& ((OptionsWizardPage) getPage(Messages.OpenDatabaseWizard_Page_Options)).isPageComplete() == true){
					return true;
				} else {
					return false;
				}
			}
			
			if(((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isDBDDSNPageRequired == false){
				if(getPage(Messages.OpenDatabaseWizard_Page_Options) != null
						&& ((OptionsWizardPage) getPage(Messages.OpenDatabaseWizard_Page_Options)).isPageComplete() == true){
					return true;
				} else {
					return false;
				}
			}
			
			return false;
		}

		return false;
	}
	
	public boolean doFinish(){
		XMLDocument xmlDocument = null;
		String uuid = "";
		String description = "";
		ArrayList<String> selConds = new ArrayList<String>();
		IMSDatabase imsDb = new IMSDatabase();
		
		try {
			//PAGE_SERVER
			OpenDatabaseWizardPageServer oDBWizardPageServer = (OpenDatabaseWizardPageServer) getPage(Messages.OpenDatabaseWizard_Page_Server);
			FMHistory.insertHistory(oDBWizardPageServer.getEnvNameCombo(),"envNameCombo");
			imsDb.setIMSEmvironmentPDS(oDBWizardPageServer.getImsEnvDSN().trim());
			imsDb.setIMSEnvironment(oDBWizardPageServer.getImsEnvironment().trim());
			
			//PAGE_DBD
			OpenDatabaseWizardPageDBD oDBWizardPageDBD = (OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD);
			FMHistory.insertHistory(oDBWizardPageDBD.getDBDCombo(),"DBDCombo");
			imsDb.setDBDName(oDBWizardPageDBD.getDbd().trim());
			imsDb.setEditMode(oDBWizardPageDBD.getEditMode());
			if(oDBWizardPageDBD.getEditMode() == EditModeType.B){
				FMHistory.insertBoolean(Messages.OpenWizardHistoryEditMode, false);				
			} else {
				FMHistory.insertBoolean(Messages.OpenWizardHistoryEditMode, true);
			}
			imsDb.setSecondaryIndex(oDBWizardPageDBD.getUseSecondaryIndex());
			imsDb.setPSBName(oDBWizardPageDBD.getPSBorACB());			
            if (!oDBWizardPageDBD.getUseSecondaryIndex()){
            	FMHistory.insertHistory(oDBWizardPageDBD.getPSBorACBCombo(),"PSBorACBCombo");            	
            }
										
			//PAGE_PCB
			if (((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isPSBPageRequired == true
			    && getPage(Messages.OpenDatabaseWizard_Page_PCB) != null
			    && (((OpenDatabaseWizardPagePCB) getPage(Messages.OpenDatabaseWizard_Page_PCB)).isPageComplete())){
				imsDb.setPCBnum(((OpenDatabaseWizardPagePCB) getPage(Messages.OpenDatabaseWizard_Page_PCB)).getSelectedPCBNum());
	        }			
						
			//PAGE_SIX
            if (((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isSIXPageRequired == true
            	&& getPage(Messages.OpenDatabaseWizard_Page_SIX) != null
            	&& (((OpenDatabaseWizardPageSIX) getPage(Messages.OpenDatabaseWizard_Page_SIX)).isPageComplete())){
            	imsDb.setSecondaryIndexDBD(((OpenDatabaseWizardPageSIX) getPage(Messages.OpenDatabaseWizard_Page_SIX)).getSelectedSIXdbdname());            	
            }				

        	//PAGE_OPTIONS
			OptionsWizardPage optionsWizardPage = getPage(Messages.OpenDatabaseWizard_Page_Options) != null ?
					(OptionsWizardPage) getPage(Messages.OpenDatabaseWizard_Page_Options) : null;
			if(optionsWizardPage != null){
				imsDb.setDisplayMode(optionsWizardPage.getDisplayMode());
				imsDb.setLayoutDataset(optionsWizardPage.getlayoutDSN());
				imsDb.setCRLDataset(optionsWizardPage.getcustomLayDSN());
				description = optionsWizardPage.getDescription();
				selConds = optionsWizardPage.getSelConds();
				if(optionsWizardPage.getlayoutDSNCombo() != null && !optionsWizardPage.getlayoutDSN().isEmpty()){
					if(!optionsWizardPage.checkifDSNisArchived(optionsWizardPage.getlayoutDSN())){
						return false;
					}
				}
				if(optionsWizardPage.getCustomLayoutDSNCombo() != null&& !optionsWizardPage.getcustomLayDSN().isEmpty()){
					if(!optionsWizardPage.checkifDSNisArchived(optionsWizardPage.getcustomLayDSN())){
						return false;
					}
				}
				
				FMHistory.insertString(Messages.OpenWizardHistoryDisplayMode, optionsWizardPage.getDisplayMode().toString());
				
				if(optionsWizardPage.getlayoutDSNCombo().getText().length() != 0){
					FMHistory.insertHistory(optionsWizardPage.getlayoutDSNCombo(), "layoutDataSetComboGenericOptions");
					FMHistory.insertBoolean(Messages.OpenWizardHistoryLayoutUsed, true);
				} else {
					FMHistory.insertBoolean(Messages.OpenWizardHistoryLayoutUsed, false);
				}
				
				if(optionsWizardPage.getCustomLayoutDSNCombo().getText().length() != 0){
					FMHistory.insertHistory(optionsWizardPage.getCustomLayoutDSNCombo(), "crlComboGenericOptions");
					FMHistory.insertBoolean(Messages.OpenWizardHistoryCustomLayoutUsed, true);
				} else {
					FMHistory.insertBoolean(Messages.OpenWizardHistoryCustomLayoutUsed, false);
				}
				
				FMHistory.insertString(Messages.OpenWizardHistorySelectionCriteria, optionsWizardPage.genSelCriteriaBox.selConditionText.getText());
			}
			
		       
			if(oDBWizardPageDBD.isDBDDSNPageRequired == true || 
				(oDBWizardPageDBD.isPSBPageRequired == true && ((OpenDatabaseWizardPagePCB) getPage(Messages.OpenDatabaseWizard_Page_PCB)).isDBDDSNPageRequired) ||
				(oDBWizardPageDBD.isSIXPageRequired == true && ((OpenDatabaseWizardPageSIX) getPage(Messages.OpenDatabaseWizard_Page_SIX)).isDBDDSNPageRequired)){
				OpenDatabaseWizardPageDBDDSN openDatabaseWizardPageDBDDSN = (OpenDatabaseWizardPageDBDDSN) getPage(Messages.OpenDatabaseWizard_Page_DBDDSN);
				imsDb.setDbdDatasets(openDatabaseWizardPageDBDDSN.getDbdDatasets());
			}
			
			OpenDatabaseRequestType oDRT = new OpenDatabaseRequestType(getFileMasterServer(),imsDb,description,selConds,OpenDBActionType.FINISH);
			xmlDocument = new XMLDocument(oDRT.createXml());
			if(oDRT.getUUID()==null || oDRT.getUUID().isEmpty()){
				throw new TTException();
			}
			uuid = oDRT.getUUID();
		} catch (TTException e) {
			e.printStackTrace();
			return false;
		}
		
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(getFileMasterServer(), map, "opendb", true, xmlDocument);	
		if(req.getResult()==Status.CANCEL_STATUS)
			return true;

		//check for error condition upon clicking finish- navri01
		if((req.getGuiResponseType().getReturnCode()!=0 && (!req.getGuiResponseType().getMessages().getMessage()
				.get(0).getMessageId().equals("CAWL108E"))) || req.getGuiResponseType().getFunctionRC()!=0){
			showError(req);
			return false;
		}
		else{
			IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
			IWorkbenchPage page = window.getActivePage();
			try {
				String secondaryID = uuid;
				IViewPart editorView = page.showView(EditorView.ID, secondaryID , IWorkbenchPage.VIEW_ACTIVATE);		

				((EditorView)editorView).setServer(getFileMasterServer());		
				((EditorView)editorView).setSegmentInfo(req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getSegmentInfoList());
				((EditorView)editorView).setFindLimit(req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getFindlim());

				IViewPart cKeyView = editorView.getSite().getWorkbenchWindow().getActivePage().findView("com.ca.fmp.ims.view.ckey");
				if(cKeyView != null){
					((ConcatenatedKeyView)cKeyView).wakeUpView(imsDb.getDisplayMode());
				}
				
				if(imsDb.getDisplayMode() == DisplayModeType.C){
					((EditorView)editorView).createCharFormatMode((int)req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getMaxSegLen());
					((EditorView)editorView).getFormatMode().setCKeyDisplay(DisplayModeType.C);
					if(imsDb.getEditMode() == EditModeType.B){
						((EditorView)editorView).setPartName(req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getDBDname() + 
								                             (req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getSIXProcessing()==YorNType.Y? " (secondary)" : "") + " [Read-only]");
						((EditorView)editorView).setEditMode(EditModeType.B);
					} else {
						((EditorView)editorView).setPartName(req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getDBDname() + 
								                             (req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getSIXProcessing()==YorNType.Y? " (secondary)" : ""));
						((EditorView)editorView).setEditMode(EditModeType.E);
						((StatusLineContributionItem) ((EditorView)editorView).getViewSite().getActionBars().getStatusLineManager().find("insertOrOvertype")).setText("Overtype");
					}
					if(req.getGuiResponseType().getMessages()!=null && req.getGuiResponseType().getMessages().getMessage().get(0).getMessageId().equals("CAWL108E")){
						showError(req);
					}
				}
				else if(imsDb.getDisplayMode() == DisplayModeType.S){ 					
					((EditorView)editorView).createSingleRecordFormatMode((int)req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getMaxSegLen());
					((EditorView)editorView).getFormatMode().setCKeyDisplay(DisplayModeType.S);
					if(imsDb.getEditMode() == EditModeType.B){
						((EditorView)editorView).setPartName(req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getDBDname() + 
								                             (req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getSIXProcessing()==YorNType.Y? " (secondary)" : "") + " [Read-only]");
						((EditorView)editorView).setEditMode(EditModeType.B);
					} else {
						((EditorView)editorView).setPartName(req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getDBDname() + 
								                             (req.getGuiResponseType().getEditResponse().getOpenDatabaseResponse().getOpenDBComplete().getSIXProcessing()==YorNType.Y? " (secondary)" : ""));
						((EditorView)editorView).setEditMode(EditModeType.E);
						((StatusLineContributionItem) ((EditorView)editorView).getViewSite().getActionBars().getStatusLineManager().find("insertOrOvertype")).setText("Overtype");
					}
					if(req.getGuiResponseType().getMessages()!=null &&req.getGuiResponseType().getMessages().getMessage().get(0).getMessageId().equals("CAWL108E")){
						showError(req);
					}								
				}
			} catch (PartInitException e) {
				e.printStackTrace();
			}
		}
		
		if(((OpenDatabaseWizardPageDBD) getPage(Messages.OpenDatabaseWizard_Page_DBD)).isDBDDSNPageRequired == true){
			OpenDatabaseWizardPageDBDDSN openDatabaseWizardPageDBDDSN = (OpenDatabaseWizardPageDBDDSN) getPage(Messages.OpenDatabaseWizard_Page_DBDDSN);
			//@parra12: save the data for this page to a file.
			openDatabaseWizardPageDBDDSN.saveData();
		}
		
		return true;
	}
	
	public void showError(SendRequestToMainframe req) {
		shortText = new ArrayList<String>();
		messageID = new ArrayList<String>();
		messageTextFinal = "";
		messageIDFinal ="";
		messageText = new ArrayList<String>();
		//check for error condition upon clicking finish- navri01
		if(req.getGuiResponseType().getReturnCode()!=0|| req.getGuiResponseType().getFunctionRC()!=0){
			for(int i=0;i<req.getGuiResponseType().getMessages().getMessage().size();i++){
				shortText.add(req.getGuiResponseType().getMessages().getMessage().get(i).getShortText());
				messageID.add(req.getGuiResponseType().getMessages().getMessage().get(i).getMessageId());
				if(req.getGuiResponseType().getMessages().getMessage().get(i).getMessageText()!=null)
					messageText.add(req.getGuiResponseType().getMessages().getMessage().get(i).getMessageText()+ "\n");
				else 
					messageText.add("");
			}
			for(int i=0;i<messageID.size();i++){
				messageIDFinal+= messageID.get(i)+" : " + shortText.get(i) + "\n" ;
				if(messageIDFinal.contains("CAWL101E")){
					title = "Information";
				}
				else 
					title = "Error";
				messageTextFinal+= messageText.get(i).substring(1, messageText.get(i).length()-2) + "\n";

			}
			TT_ErrorDialog.openError(null, title, messageIDFinal, new Throwable(messageTextFinal));
		}	
	}
}
