/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.view.wizardpages.ImportSelCritWizardPage;


public class GenericImportWizard extends Wizard implements INewWizard {
	static String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	private ImportSelCritWizardPage page;
	private String pageName = "";
	private String[] SelConds;
	private FileMasterServer server;
	private boolean isImportSelCrit;

	public GenericImportWizard(String pageName,FileMasterServer server, String[] SelConds,
			boolean isImportSelCrit) {
		// TODO Auto-generated constructor stub
		this.pageName = pageName;
		setWindowTitle(pageName);
		this.server = server;
		this.SelConds = SelConds;
		this.isImportSelCrit = isImportSelCrit;
	}
	
	public GenericImportWizard(String pageName,FileMasterServer server,boolean isImportSelCrit) {
		// TODO Auto-generated constructor stub
		this.pageName = pageName;
		setWindowTitle(pageName);
		this.server = server;
		this.isImportSelCrit = isImportSelCrit;
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean performFinish() {
			return page.doFinish();

	}

	@Override
	public void addPages() {
		if (isImportSelCrit) {
			page = new ImportSelCritWizardPage(pageName, server, SelConds);
			addPage(page);
		} 
	}

}
