/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.wizards;
/**
 * @author navri01
 *
 */
import java.util.UUID;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.fmp.ims.view.wizardpages.DatasetWizardPage;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class FileMasterWizard extends WizardPage implements ModifyListener {
	static final String cacopyright = "Copyright  2016 CA";
	protected Composite container;
	protected Composite dataSetComposite;
	
	protected Label dataSetLabel;
	protected String dataSetName;
	
	public Combo dataSetCombo;
	
	protected Button dataSetSelectBtn;
	protected Button dataSetDSNListBtn;
	
	protected TestingToolsWizardDialog dialog = null;
	protected String error ="";
	protected GridData data;

	protected FileMasterServer server;
	public FileMasterDataset fmdataset;

	public FileMasterWizard(String pageName,String dataSetName, FileMasterServer server) {
		super(pageName);
		this.dataSetName=dataSetName;
		this.server = server;
	}

	public FileMasterWizard(String pageName) {
		super(pageName);
	}

	@Override
	public void createControl(Composite parent) {
		container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(1, false));

		dataSetComposite = new Composite(container, SWT.NULL);
		dataSetComposite.setLayout(new GridLayout(4, false));

		
		setControl(container);
	}
	
	public void createDataSet(){
		createDataSet("&Data set name:");
	}
	
public void createDataSet(String labelText){
	/* Label For Data set */
	dataSetLabel = new Label(dataSetComposite, SWT.NONE);
	dataSetLabel.setText(labelText);

	/* Data set combo box */
	dataSetCombo = new Combo(dataSetComposite, SWT.BORDER);
	dataSetCombo.addModifyListener(this);
	dataSetCombo.addVerifyListener(new verifytoUpperCase());

	data = new GridData();
	data.horizontalAlignment = SWT.FILL;
	data.verticalAlignment = SWT.NONE;

	data.grabExcessHorizontalSpace = true;
	data.grabExcessVerticalSpace = true;
	data.horizontalSpan = 1;
	data.verticalSpan = 1;

	dataSetCombo.setLayoutData(new GridData(SWT.FILL, SWT.NONE, true,
			true, 1, 1));
	TextUtil.setWidth(dataSetCombo, 37);
	 dataSetCombo.setTextLimit(44);

	/* Button for Data set Select */
	dataSetSelectBtn = new Button(dataSetComposite, SWT.NONE);
	dataSetSelectBtn.addSelectionListener(new SelectionListener() {
		
		@Override
		public void widgetSelected(SelectionEvent e) {
			// TODO Auto-generated method stub
			FMWWidgetSelected(e);
		}
		
		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
			// TODO Auto-generated method stub
			
		}
	});
	dataSetSelectBtn.setText("&Select...");

	/* Button for Data set DSN List */
	dataSetDSNListBtn = new Button(dataSetComposite, SWT.NONE);
	dataSetDSNListBtn.addSelectionListener(new SelectionListener() {
		
		@Override
		public void widgetSelected(SelectionEvent e) {
			// TODO Auto-generated method stub
			FMWWidgetSelected(e);
		}
		
		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
			// TODO Auto-generated method stub
			
		}
	});
	dataSetDSNListBtn.setText("DSN &List...");
	dataSetDSNListBtn.setVisible(false);
}

	public void FMWWidgetSelected(SelectionEvent e) {
		Widget source = e.widget;	
		if (source instanceof Button) {
			if (((Button) source).getText().equals("&Select...")) {
				DatasetWizard wizard = new DatasetWizard(dataSetCombo.getText(),"",server);
				dialog = new TestingToolsWizardDialog(getShell(), wizard);
				dialog.create();
				DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener() {
					
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						//dataSetCombo.setText(DatasetWizardPage.getSelectedDSN());
						fmdataset = DatasetWizardPage.getSelectedDSN();
						dataSetCombo.setText(fmdataset.getName());
					}
					
					@Override
					public void widgetDefaultSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						
					}
				});
				dialog.open();
			} 
			else {
				GenericImportWizard wizard = new GenericImportWizard("Select DSN List",server,false);
				dialog = new TestingToolsWizardDialog(getShell(), wizard);
				dialog.open();
			}
		}
	}
	
	@Override
	public void modifyText(ModifyEvent e) {
		setPageComplete(isPageComplete());
	}
	@Override
	public boolean isPageComplete() {
		return isPageComplete(true);
	}
	
	public boolean isPageComplete(boolean value) {
		
		//From Data set validation
				if (!(dataSetCombo == null || dataSetSelectBtn == null)) {
					switch (Validator.dataset(dataSetCombo.getText(), value)) {
					case Validator.DS_WILDCARD:
						//error = "Wildcard";
						error = error + Validator.errorMsg[Validator.DS_WILDCARD] + "\n";
						dataSetSelectBtn.setEnabled(true);
						dataSetDSNListBtn.setEnabled(true);
						
						break;
					case Validator.DS_INVALID:
					case Validator.DS_LONG:
					case Validator.DS_MISSING:
						error = error+ Validator.errorMsg[Validator.dataset(dataSetCombo.getText(), true)] + "\n ";
						dataSetSelectBtn.setEnabled(false);
						break;
					case Validator.NO_ERROR:
						dataSetSelectBtn.setEnabled(false);
						break;
					}
					
				}
				if(error.equalsIgnoreCase(Validator.errorMsg[Validator.DS_WILDCARD]))
					return false;

				if (error.length() > 0) {
					if(getErrorMessage()!=null){
						if(!getErrorMessage().equalsIgnoreCase(error)){
							setErrorMessage(error);
							error = new String();
							return false;
						}
						else{
							error = new String();
						}
					}else{
						setErrorMessage(error);
						error = new String(); 
						return false;
					}
				} else {
					setErrorMessage(null);
					return true;
				}
				return false;
}
	
	public IViewPart updateReportsView(String[] content){
		return null;
		/*final IWorkbenchWindow window = PlatformUI.getWorkbench()
		.getActiveWorkbenchWindow();
		final IWorkbenchPage page = window.getActivePage();
		IViewPart view;
		try {
			if(!content.toString().isEmpty()){
			view = page.showView(ReportView.ID,UUID.randomUUID().toString(),IWorkbenchPage.VIEW_ACTIVATE);
			if(view instanceof ReportView)
				((ReportView)view).updateReportViewer(content);
				return view;
			}
		} catch (PartInitException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;*/
		
	}
	
	public void serverChanged(FileMasterServer server){
		this.server = server;
	}
public Combo getDataSetCombo(){
	return dataSetCombo;
}
/**
 * @return the dataSetName
 */
public String getDataSetName() {
	return dataSetName;
}

/**
 * @param dataSetName the dataSetName to set
 */
public void setDataSetName(String dataSetName) {
	this.dataSetName = dataSetName;
}
}