/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;
/**
 * @author parra12
 *
 */
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MemberWizardPageSorter extends ViewerSorter {
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	/*
	 * These fields are used to set up logging
	 */
	private static final String sourceClass = MemberWizardPageSorter.class.getName();
	Logger log = Logger.getLogger(sourceClass);
	Level baseLevel = log.getLevel();
	/* end of logging setup */
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		// date descending
		// time descending
		// job ascending
		TableViewer tableViewer = (TableViewer) viewer;
		Table table = tableViewer.getTable();
		TableColumn column = table.getSortColumn();
		Integer index = null;

		if (column != null)
		{
			if(column.getText() == "Member name")
				index = 0;
			if(column.getText() == "Data set name")
				index = 1;
			if(column.getText() == "Access method")
				index = 2;
			if(column.getText() == "Created")
				index = 3;
			if(column.getText() == "Size")
				index = 4;
			if(column.getText() == "RMode")
				index = 5;
			if(column.getText() == "AMode")
				index = 6;
			if(column.getText() == "TTR")
				index = 7;
		}
			//index = (Integer) column.getData();
		if (index == null)
			index = 0;
		ColumnLabelProvider provider = (ColumnLabelProvider) tableViewer.getLabelProvider(index);
		String value1 = provider.getText(e1);
		String value2 = provider.getText(e2);
		int direction = table.getSortDirection();
		int rc;
		switch(index){
			case 5:
			case 6:
				Integer i1, i2;
				if(value1.equals("")){
					i1 = Integer.MIN_VALUE;
				} else {
					i1 = Integer.valueOf(value1);	
				}
				if(value2.equals("")){
					i2 = Integer.MIN_VALUE;
				} else {
					i2 = Integer.valueOf(value2);	
				}
				rc = i1.compareTo(i2);
				break;
			default:
				rc = value1.compareTo(value2);
				break;
		}
		if (rc != 0)
			return direction == SWT.DOWN?-rc:rc;
		
		return direction == SWT.DOWN?-rc:rc;
	}
}
