/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.model.GetSegmentsRequest;
import com.ca.fmp.ims.model.IMSSegment;
import com.ca.fmp.ims.model.generated.CKeyInfoType;
import com.ca.fmp.ims.model.generated.CursorType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.EditGetDirectionType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.SegmentFieldType;
import com.ca.fmp.ims.model.generated.SegmentInfoListType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Common;
import com.ca.fmp.ims.view.ckey.ConcatenatedKeyView;
import com.ca.fmp.ims.view.wizards.FindCommandWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;

public class SingleRecordFormatMode extends FormatMode {
	public List<IMSSegment> inputData = new ArrayList<IMSSegment>();
	protected IMSSegment currentSegment;
	private Composite sfContainer;
	private Composite topContainer;
	private Composite mainContainer;
	private Composite bottomContainer;
	private Button first;
	private Button previous;
	private Button next;
	private Button last;
	private String[] columnNames;
	private int[] columnWidths;
	private int[] columnAlignments;
	private Text segmentNameText;
	private Text recordLengthText;
	private Text recordLayoutText;	
	private Text errorMessageText;
	private String lastFieldEdited;
	private List<String> fieldsWithErrorFromTheStart;
	private boolean fieldWithErrorAfterEditing;
	private boolean disableBtns = false;
	private boolean setCusrsorFlag = true;
	private boolean putCusrsorFlag = true;
	private int xPosMouse = -1;
	private int dataColumnBegin;	
	private SRFValueEditingSupport sRFValueEditingSupport;


	/**
	 * carel06 - 2014/12/10
	 * Defect 3223
	 * Added this method so it can support both SingleRecordFormatMode and CharFormatMode
	 */
	public EditingSupportFileMasterIMS getEditingSupportFileMasterIMS(){
		return sRFValueEditingSupport;
	}

	public SingleRecordFormatMode(Composite parent, EditorView eView,
			SegmentInfoListType segmentInfo, int maxSegmentLength) {
		super(parent, eView, segmentInfo, maxSegmentLength);
	}

	public FormatMode createSingleRecordFormat() {
		sfContainer = new Composite(parent, SWT.NONE);		
		sfContainer.setLayout(new GridLayout(1, false));

		createSegmentInfoComposite();
		createTableComposite();
		createNavButtonsComposite();
				
		return this;
	}

	private void createSegmentInfoComposite() {
		topContainer = new Composite(sfContainer, SWT.NONE);
		topContainer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
				false, 1, 1));
		topContainer.setLayout(new GridLayout(6, false));

		Label segmentNameLabel = new Label(topContainer, SWT.NONE);
		segmentNameLabel.setText("Segment name:");		
		GridData textGridData = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		textGridData.widthHint = 60;
		segmentNameText = new Text(topContainer, SWT.NONE);		
		segmentNameText.setLayoutData(textGridData);
		segmentNameText.setEditable(false);

		Label recordLengthLabel = new Label(topContainer, SWT.NONE);
		recordLengthLabel.setText("Record length:");
		recordLengthText = new Text(topContainer, SWT.NONE);
		recordLengthText.setLayoutData(textGridData);
		recordLengthText.setEditable(false);

		Label recordLayoutLabel = new Label(topContainer, SWT.NONE);
		recordLayoutLabel.setText("Record layout:");		
		GridData data = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		data.widthHint = 100;
		recordLayoutText = new Text(topContainer, SWT.NONE);
		recordLayoutText.setLayoutData(data);
		recordLayoutText.setEditable(false);	
		
		errorMessageText = new Text(topContainer, SWT.ERROR);
		GridData errordata = new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1);
		errorMessageText.setLayoutData(errordata);
		errorMessageText.setEditable(false);
		errorMessageText.setForeground(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().getSystemColor(SWT.COLOR_RED));
	

		errorMessageText.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				first.setEnabled(!disableBtns);
				previous.setEnabled(!disableBtns);
				next.setEnabled(!disableBtns);
				last.setEnabled(!disableBtns);
				// TODO need to think about this
//					editorView.setDirty(false);
				editorView.getToolBarAction(EditorView.CHAR_BUTTON_ID).setEnabled(!disableBtns);
				//editorView.getToolBarAction(editorView.MULTI_TOOLBAR_BUTTON_ID).setEnabled(false);
				editorView.getToolBarAction(EditorView.HEX_BUTTON_ID).setEnabled(!disableBtns);
			}
		});
	}

	private void createTableComposite() {
		mainContainer = new Composite(sfContainer, SWT.NONE);
		mainContainer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
				true, 1, 1));
		GridLayout gl_editorComposite = new GridLayout(1, false);
		gl_editorComposite.marginWidth = 0;
		gl_editorComposite.marginHeight = 0;
		gl_editorComposite.verticalSpacing = 0;
		mainContainer.setLayout(gl_editorComposite);

		tableViewer = new TableViewer(mainContainer, SWT.BORDER
				| SWT.FULL_SELECTION);

		final Table table = tableViewer.getTable();
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setFont(JFaceResources.getTextFont());
		tableViewer.getTable().setFont(JFaceResources.getTextFont());
		
		columnNames = new String[] { "Field Name", "Position", "Format", "Value" };
		columnWidths = new int[] { 260, (10 * getPixelSizeOfCharacter()), (9 * getPixelSizeOfCharacter()), 0};
		columnAlignments = new int[] { SWT.LEFT, SWT.LEFT, SWT.LEFT, SWT.LEFT };

		createScrollBar();
		
		mainContainer.setFocus();
		
		Shell shell = new Shell();

		int displayWidth = mainContainer.getBounds().width;
		for (int i = 0; i < columnNames.length; i++) {
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, columnAlignments[i]);
			TableColumn tableColumn = tableViewerColumn.getColumn();

			tableColumn.setText(columnNames[i]);

			switch (i) {
			case 0:
				tableColumn.setWidth(columnWidths[i]);				
				TextLayout nameLayout = new TextLayout(shell.getDisplay());
				SRFNameLabelProvider srfNameLabelProvider = new SRFNameLabelProvider(nameLayout);
				tableViewerColumn.setLabelProvider(srfNameLabelProvider);				
				break;
			case 1:
				tableColumn.setWidth(columnWidths[i]);
				TextLayout positionLayout = new TextLayout(shell.getDisplay());    
				SRFPositionLabelProvider srfPositionLabelProvider = new SRFPositionLabelProvider(positionLayout, tableViewer, getPixelSizeOfCharacter());						
				tableViewerColumn.setLabelProvider(srfPositionLabelProvider);				
				break;
			case 2:
				tableColumn.setWidth(columnWidths[i]);
				TextLayout formatLayout = new TextLayout(shell.getDisplay());
				SRFFormatLabelProvider srfFormatabelProvider = new SRFFormatLabelProvider(formatLayout, tableViewer);						
				tableViewerColumn.setLabelProvider(srfFormatabelProvider);
				break;
			case 3:
				tableColumn.setText(columnNames[columnNames.length - 1]);
				tableColumn.setWidth(displayWidth - (columnWidths[0] + columnWidths[1] + columnWidths[2]));
				
				TextLayout valueLayout = new TextLayout(shell.getDisplay());
				SRFValueLabelProvider srfValueLabelProvider = new SRFValueLabelProvider(valueLayout, shell, slider);						
				tableViewerColumn.setLabelProvider(srfValueLabelProvider);
				// carel06 2014/10/15
				// Be able to edit this column in SF mode.
                // I don't understand the first parameter, I'm using 3 and it stands for 'colName' but what does 
				// it really represent
//				tableViewerColumn.setEditingSupport(new EditingSupportFileMasterIMS(editorView,tableViewer,3, tableViewerColumn, this));
				sRFValueEditingSupport = new SRFValueEditingSupport(editorView,tableViewer,3, tableViewerColumn, this);
				tableViewerColumn.setEditingSupport(sRFValueEditingSupport);
				break;
			}
		}		
				

		table.getHorizontalBar().dispose();
		
		tableViewer.getTable().addControlListener(new columnResizeListener());
		
		for(int i = 0; i < tableViewer.getTable().getColumnCount(); i++){
			tableViewer.getTable().getColumn(i).addControlListener(new columnResizeListener());
		}
		tableViewer.getTable().addMouseListener(new MouseListener() {
			
			@Override
			public void mouseUp(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void mouseDown(MouseEvent e) {
				// TODO Auto-generated method stub
				dataColumnBegin = tableViewer.getTable().getColumn(0).getWidth()+tableViewer.getTable().getColumn(1).getWidth()+tableViewer.getTable().getColumn(2).getWidth();
				xPosMouse = e.x;
				
				if (e.button != 1){
					putCusrsorFlag = false;
				} else {
					int caretPos = (int) Math.floor((xPosMouse - dataColumnBegin)/getPixelSizeOfCharacter());
					//Get absolute position of the carter(from beginning of the column)
					if (caretPos > -1){
						caretPos = caretPos + getSubstringBeginIndex();
					}
					CursorType fmiCursor = editorView.getCursor();
					fmiCursor.setCursorPosition(caretPos);
					editorView.setCursor(fmiCursor);
					putCusrsorFlag = true;
				}
			}
			
			@Override
			public void mouseDoubleClick(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		
		tableViewer.getTable().addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub			
				TableItem selection = (TableItem)e.item;
				
				if (selection != null) {
					Object data = selection.getData();
					if (data instanceof SegmentFieldType) {
						SegmentFieldType selectedSegmentField = (SegmentFieldType)selection.getData();                  
						//Segment was selected, get cursor
						if (setCusrsorFlag){
							CursorType fmiCursor = editorView.getCursor();
							fmiCursor.setFieldId(selectedSegmentField.getId());
							editorView.setCursor(fmiCursor);
						} else {
							setCusrsorFlag = true;
						}
					}
				}
				
				CursorType fmiCursor = editorView.getCursor();
				if(fmiCursor.getCursorPosition() > -1 & putCusrsorFlag) {
					tableViewer.editElement(tableViewer.getTable().getSelection()[0].getData(), 3);
					if (getSubstringBeginIndex() > fmiCursor.getCursorPosition()){
						fmiCursor.setCursorPosition(getSubstringBeginIndex());
					}				
					if (getSubstringEndIndex() < fmiCursor.getCursorPosition()){
						fmiCursor.setCursorPosition(getSubstringEndIndex());
					}
					if(selection.getParent().getChildren().length>0)
						((Text)selection.getParent().getChildren()[0]).setSelection(fmiCursor.getCursorPosition()-getSubstringBeginIndex());
				} else {
					putCusrsorFlag = true;
				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
	}

	private void createScrollBar() {
		slider = new Slider(mainContainer, SWT.NONE);
		slider.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1,
				1));
		slider.setMaximum(maxSegmentLength);
		
		slider.addSelectionListener(new SelectionListener(){

			@Override
			public void widgetSelected(SelectionEvent e) {
				Table table = tableViewer.getTable();
				int dataColumnWidth = table.getColumn(3).getWidth();
				int pixelSizeOfCharacter = getPixelSizeOfCharacter();
					
				int columnStart = slider.getSelection();
				int columnEnd = (dataColumnWidth / pixelSizeOfCharacter) + columnStart - 1;
				columnRangeString = "Columns " + (columnStart + 1) + " - " + columnEnd;
				
				if(dataColumnWidth < pixelSizeOfCharacter){
					columnEnd = columnStart;
					columnRangeString = "";
				}
				((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
						.getStatusLineManager().find("columnrange")).setText(columnRangeString);
				
				String valueData;
				int start, end;
				for(int i = 0; i < table.getItemCount(); i++){
					start = columnStart;
					end = columnEnd;
					
					valueData = inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCharData();
					
					if (valueData == null) {
						valueData = "";
					}
					
					if(start > valueData.length()){
						start = 0;
						end = 0;
					} else if(end > valueData.length()){
						end = valueData.length();
					}
					
					table.getItem(i).setText(3, valueData.substring(start, end));
				}
				table.redraw();
				slider.setFocus();			
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});
	}

	private void createNavButtonsComposite() {
		bottomContainer = new Composite(sfContainer, SWT.NONE);
		bottomContainer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
				false, 1, 1));
		GridLayout bottomContainerLayout = new GridLayout(4, false);
		bottomContainerLayout.marginTop = -5;
		bottomContainerLayout.marginRight = -5;
		bottomContainerLayout.marginLeft = -5;
		bottomContainer.setLayout(bottomContainerLayout);

		first = new Button(bottomContainer, SWT.NONE);
		GridData gridData = new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1,
				1);
		gridData.widthHint = 76;
		first.setLayoutData(gridData);
		first.setText("&First");
		first.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				doFirstSegment();
				putCursor();
			}	
		});

		previous = new Button(bottomContainer, SWT.NONE);
		gridData = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gridData.widthHint = 76;
		previous.setLayoutData(gridData);
		previous.setText("&Previous");
		previous.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				doPreviousSegment(inputData.get(0).segmentType.getSegid());			
				putCursor();
			}	
		});

		next = new Button(bottomContainer, SWT.NONE);
		gridData = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gridData.widthHint = 76;
		next.setLayoutData(gridData);
		next.setText("&Next");
		next.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				doNextSegment(inputData.get(0).segmentType.getSegid());	
				putCursor();
			}	
		});

		last = new Button(bottomContainer, SWT.NONE);
		gridData = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gridData.widthHint = 76;
		last.setLayoutData(gridData);
		last.setText("&Last");
		last.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {             
				doLastSegment();				
				putCursor();
			}	
		});
	}
	
	public Composite getComposite() {
		return this.sfContainer;
	}
	
	@Override
	public void loadCurrentSegmentsWithCKEYInfo (DisplayModeType ckeyDisplay, YorNType ckeyHex){		
		requestAndDisplaySegment(inputData.get(0).segmentType.getSegid(), 0, EditGetDirectionType.UP, ckeyDisplay, ckeyHex);  
	}	
	
	public void doFirstSegment(){
		requestAndDisplaySegment("TOP", 0, EditGetDirectionType. UP);		
		}
	
	public void doNextSegment(String reference){
		requestAndDisplaySegment(reference, 1, EditGetDirectionType.DOWN);			
		}

	public void doPreviousSegment(String reference){
		requestAndDisplaySegment(reference, 1, EditGetDirectionType.UP);			
		}
	
	public void doLastSegment(){
		requestAndDisplaySegment("BOT", 0, EditGetDirectionType. DOWN);		
		}
	
	public void requestAndDisplaySegment(String reference, int scrollCount, EditGetDirectionType direction){
		IViewPart cKeyView = editorView.getSite().getWorkbenchWindow().getActivePage().findView("com.ca.fmp.ims.view.ckey");
		CKeyInfoType ckeyInfo = CKeyInfoType.Y;
     	if(cKeyView == null){
     		ckeyInfo = CKeyInfoType.N;
     	}		
		YorNType hexMode =editorView.isHexToggled;
	    int loadBufferSize = 1;  							    																																														
	    XMLDocument xmlDocument = null;

		try {
			xmlDocument = new XMLDocument(new GetSegmentsRequest(editorView.server,((IViewSite) editorView.getSite()).getSecondaryId(), loadBufferSize, reference, 
					scrollCount, direction, ckeyInfo, ckeyDisplay,hexMode, ckeyHex, editorView.getDisplayMode()).createXml());	
		} catch (TTException e1) {
			e1.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(editorView.server, map, "opendb", true, xmlDocument);

		do{				
		}while(req.getResult() != Status.OK_STATUS && req.getResult()!= Status.CANCEL_STATUS);	
		if(req.getResult() == Status.CANCEL_STATUS){
			editorView.closeView();
			return;
		}
		
		GUIResponseType response = req.getGuiResponseType();					
		updateDisplay(response);							
	}
	
	public void requestAndDisplaySegment(String reference, int scrollCount, EditGetDirectionType direction, DisplayModeType ckeyDisplay, YorNType ckeyHex){
		this.ckeyDisplay = ckeyDisplay;
		this.ckeyHex = ckeyHex;
		
		requestAndDisplaySegment(reference, scrollCount, direction);
	}
	
	protected String getSegmentIDforReference(){
		return inputData.get(0).segmentType.getSegid();
    }
	
	protected void disposeContainer(){
		topContainer.dispose();
		mainContainer.dispose();
		bottomContainer.dispose();  
	}	
			
	public void updateDisplay(GUIResponseType response){
		
		//Check error messages and display
		Common.displayMessageforEditorView(response, editorView.getViewSite());
		if(response.getReturnCode()!=0){	
			editorView.closeView();
			return;
		}
		
		Table table = tableViewer.getTable();
		table.setRedraw(false);
		table.removeAll();	
		
		if(response != null){
			inputData = processInput(response.getEditResponse().getSegmentList().getSegment(),
					response.getEditResponse().getSegmentList().getDisplayMode());	
		}
				
		for (int i=0; i<this.segmentInfo.getSegmentInfo().size(); i++){
			if (this.segmentInfo.getSegmentInfo().get(i).getSegNum() == response.getEditResponse().getSegmentList().getSegment().get(0).getSegNum()){
				segmentNameText.setText(this.segmentInfo.getSegmentInfo().get(i).getSegName());
				continue;
			}				
		}
															
		recordLengthText.setText(Integer.toString(response.getEditResponse().getSegmentList().getSegment().get(0).getLength()));		
		recordLayoutText.setText(response.getEditResponse().getSegmentList().getLayout().getMemberName());
		
		slider.setMaximum((int)maxFieldLength);
				
		String formatData;
		String fieldData;
		int positionData;
		
		TableItem item;
		
		int count = inputData.get(0).segmentType.getSegmentFields().getSegmentField().size();
		String fieldLevelRepresentedAstwoDigitString;
		
		String fieldFomratForDisplay;
						
		for(int i = 0; i < count; i++){
			item = new TableItem (table, SWT.NONE);
						
			SegmentFieldType segmentFieldType = inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i);
			fieldLevelRepresentedAstwoDigitString = (segmentFieldType.getLevel() < 10 ? "0" : "") + String.valueOf(segmentFieldType.getLevel());
			fieldData = fieldLevelRepresentedAstwoDigitString + 
					    String.valueOf(segmentFieldType.getName());
//			fieldData = fieldData + "   " + inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getName();
			positionData = segmentFieldType.getPosition();
			
			formatData = segmentFieldType.getFormatChar();
			
			if (formatData == null) {
				formatData = "";
			}
			formatData = formatData + "   " + String.valueOf(segmentFieldType.getMaxLengthD());
			
			// TODO need to make sure all parameters are thought off.
//			if(!hasFieldWithErrorAfterEditing() && segmentFieldType.getColorData() == YorNType.Y && fieldEdited &&
//					!getFieldsWithErrorFromTheStart().contains(fieldName) && /*depil01-#2975*/lastFieldEdited.equals(fieldName)) {
//				setFieldWithErrorAfterEditing(true);
//			} else if(segmentFieldType.getColorData() == YorNType.Y && !fieldEdited) {
//				getFieldsWithErrorFromTheStart().add(fieldName);
//			}
			
			item.setText(0, fieldData);
			item.setText(1, String.valueOf(positionData));
			item.setText(2, formatData);
			item.setData(segmentFieldType);
			if(inputData.get(0).segmentType.getKeyInfo() != null){
				item.setData("KeyInfoType", inputData.get(0).segmentType.getKeyInfo());
			}
		}
						
		// Level and Field name indentation calculation 
		TreeSet<String> fieldLevelSet = new TreeSet<String>();
	
		for (int i = 0; i < count; i++){	
			fieldLevelRepresentedAstwoDigitString = (inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getLevel() < 10 ? "0" : "") + String.valueOf(inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getLevel()); 
			fieldLevelSet.add(fieldLevelRepresentedAstwoDigitString);
		}
		ArrayList<String> fieldLevels = new ArrayList<String>(fieldLevelSet);
		
		for (int i = 0; i < count; i++){	
			
			fieldLevelRepresentedAstwoDigitString = (inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getLevel() < 10 ? "0" : "") + String.valueOf(inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getLevel());			
			int indentation = fieldLevels.indexOf(fieldLevelRepresentedAstwoDigitString);
			char[] array = new char[indentation * 2];
			Arrays.fill(array, ' ');								
			inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).setName(new String(array) + fieldLevelRepresentedAstwoDigitString + " " +  String.valueOf(inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getName()));
		}
		
		// 	Format column alignment 
		for (int i = 0; i < count; i++){
			
			fieldFomratForDisplay = inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getFormatChar();
			if (fieldFomratForDisplay == null) {
				fieldFomratForDisplay = "";
			}
			
			// floating point type, response form the mainframe is 1 or 2
			if (fieldFomratForDisplay == "1" || fieldFomratForDisplay == "2") {
				fieldFomratForDisplay = "FP";
			}
			
			// unsigned or signed format type; if signed add 'S' to format 
			if (inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getSigned() == YorNType.Y) {
				fieldFomratForDisplay += "S";
			}
			
			// length of some format types can consist of two parts, integer and fraction
			String fieldFomratMaxLengthDisplay = "";

			if (inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getIntegerLength() == null) {
				fieldFomratMaxLengthDisplay = inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getMaxLengthP().toString();
			} else {
				fieldFomratMaxLengthDisplay = inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getIntegerLength().toString();
				if (inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getFractionLength() != null) {
					fieldFomratMaxLengthDisplay += "." + inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getFractionLength().toString();
				}
			}
			
			// Format column consists at last 7 characters 
			int charFormatLength = fieldFomratForDisplay.length() + fieldFomratMaxLengthDisplay.length();			
			if (charFormatLength <= 7) {
				char[] array = new char[7 - charFormatLength];
				Arrays.fill(array, ' ');
				inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).setFormatChar(fieldFomratForDisplay + new String(array) + fieldFomratMaxLengthDisplay);
			} else {
				inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).setFormatChar(fieldFomratForDisplay + " " + fieldFomratMaxLengthDisplay);
			}
			
		}
		updateValueColumn();
		table.setRedraw(true);

		// update CKey part
		IViewPart cKeyView = editorView.getSite().getWorkbenchWindow().getActivePage().findView("com.ca.fmp.ims.view.ckey");
		if (cKeyView != null){			
			if (inputData.get(0).segmentType!=null){	
				if (inputData.get(0).segmentType.getCKey()!=null){
					((ConcatenatedKeyView)cKeyView).updateCKey(inputData.get(0).segmentType.getCKey().getCKeyEntry());
					((ConcatenatedKeyView)cKeyView).setSegid(inputData.get(0).segmentType.getSegid());
				}
			}
		}  	      	
		
	}
	
	private void updateValueColumn(){
		if(inputData.isEmpty()){
			if (editorView.getCurrentSegment() != null){
				requestAndDisplaySegment((editorView.getCurrentSegment()).segmentType.getSegid(), 0, EditGetDirectionType. UP);
			} else 
				requestAndDisplaySegment("TOP", 0, EditGetDirectionType. UP);
		}
		
		editorView.currentSegment = inputData.get(0);
		
		Table table = tableViewer.getTable();
		
		int newDataColumnWidth = table.getClientArea().width -
				(table.getColumn(0).getWidth() + table.getColumn(1).getWidth() + table.getColumn(2).getWidth());
		
		table.getColumn(3).setWidth(newDataColumnWidth);
		
		int thumbSize = (newDataColumnWidth / getPixelSizeOfCharacter()) - 1;
		slider.setThumb(thumbSize);
		slider.setPageIncrement(thumbSize);
		
		int columnStart = slider.getSelection();
		int columnEnd = Math.max(((newDataColumnWidth / getPixelSizeOfCharacter()) + columnStart) - 1, 0);
//		int columnEnd = ((table.getColumn(3).getWidth() / getPixelSizeOfCharacter()) + columnStart) - 1;
		
		columnRangeString = "Columns " + (columnStart + 1) + " - " + columnEnd;
		
		if(newDataColumnWidth < getPixelSizeOfCharacter()){
			columnEnd = columnStart;
			columnRangeString = "";
		}
		((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
				.getStatusLineManager().find("columnrange")).setText(columnRangeString);
		
		int count = inputData.get(0).segmentType.getSegmentFields().getSegmentField().size();
		int start, end;
		int sliderPosition = -1;
		int verticalPosition = -1;
		int cursorOffset = 0;
		for(int i = 0; i < count; i++){
			String valueData = inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCharData();
			
			if (valueData == null) {
				valueData = "";
			}
			
			start = columnStart;
			end = columnEnd;
			
			if(start > valueData.length()){
				start = 0;
				end = 0;
			} else if(end > valueData.length()){
				end = valueData.length();
			}

			table.getItem(i).setText(3, valueData.substring(start, end));
			
			//Set cursor for Find
			if (inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCursor() != null) {
				CursorType fmiCursor = editorView.getCursor();			
				fmiCursor.setCursorPosition(inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCursor() -1);
				fmiCursor.setFieldId(inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getId());
				fmiCursor.setSegid(inputData.get(0).segmentType.getSegid());
				editorView.setCursor(fmiCursor);
				cursorOffset = inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCursor();
				if (cursorOffset + editorView.wizard.page.getfindValueLength() > columnEnd) {
					sliderPosition = inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCursor()-1;
				}
				
				if (cursorOffset < columnStart + 1) {
					sliderPosition = inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCursor()-1;
				}
				verticalPosition = i;		
			}
		}
		
		if (verticalPosition > -1 & verticalPosition < count) {	
			tableViewer.getTable().showItem(table.getItem(verticalPosition));
		}
		
		// If cursor is out of current display, set slider
		if ((sliderPosition > -1)){
			setSilderOffset(sliderPosition);	
			editorView.wizard.page.getShell().setActive();
		}
		
	}
	
	private class columnResizeListener implements ControlListener{

		@Override
		public void controlResized(ControlEvent e) {
			//navri01@carel06 - defect edit a field in SF mode and resize the window.
			getSubstringBeginIndex();
			getSubstringEndIndex();
			if (FindCommandWizard.getFindCommandWizardCount() == 0){					
				sfContainer.getShell().setFocus();
			}		
			updateValueColumn();
			if (FindCommandWizard.getFindCommandWizardCount() == 0){					
				putCursor();
			}
		}
		
		@Override
		public void controlMoved(ControlEvent e) {}
	}
	
	/**
	 * carel06 - 2014/10/15
	 * overloaded the getSubstringEndIndex method since we are 
	 * editing on the third column instead of the 2nd column.
	 */
	public int getSubstringEndIndex() {
		int substringEndIndex = getSubstringEndIndex(3);
		return substringEndIndex;
	}
	
	public boolean isDisableBtns() {
		return disableBtns;
	}

	public void setDisableBtns(boolean disableBtns) {
		this.disableBtns = disableBtns;
	}
	
	public String getLastFieldEdited() {
		return lastFieldEdited;
	}

	public void setLastFieldEdited(String lastFieldEdited) {
		this.lastFieldEdited = lastFieldEdited;
	}
	
	public List<String> getFieldsWithErrorFromTheStart() {
		if(fieldsWithErrorFromTheStart == null) {
			fieldsWithErrorFromTheStart = new ArrayList<String>();
		}
		return fieldsWithErrorFromTheStart;
	}
	
	public boolean hasFieldWithErrorAfterEditing() {
		return fieldWithErrorAfterEditing;
	}

	public void setFieldWithErrorAfterEditing(boolean fieldWithErrorAfterEditing) {
		this.fieldWithErrorAfterEditing = fieldWithErrorAfterEditing;
	}
	
	public void setErrorMessage(String errorMessage){
		if(!tableViewer.getTable().isDisposed()){
			this.errorMessageText.setText(errorMessage);
			this.errorMessageText.setToolTipText(errorMessage);
			
            // carel06 - 2014/11/19
			// Defect 3208
			// disabling the actions if there is an error in SF mode.
			if(errorMessage == null || errorMessage.length() ==0) {
				editorView.getCommitAction().setEnabled(true);
				editorView.getRollbackAction().setEnabled(true);
				editorView.getHexAction().setEnabled(true);
				editorView.getCharFormatAction().setEnabled(true);
                // when we are in SF mode, this is always disabled
				editorView.getSfFormatAction().setEnabled(false);
				editorView.getFindAction().setEnabled(true);
				editorView.getSegmentAction().setEnabled(true);
				editorView.getLocatekeyAction().setEnabled(true);
			} else {
				editorView.getCommitAction().setEnabled(false);
				editorView.getRollbackAction().setEnabled(false);
				editorView.getHexAction().setEnabled(false);
				editorView.getCharFormatAction().setEnabled(false);
				// when we are in SF mode, this is always disabled
				editorView.getSfFormatAction().setEnabled(false);
				editorView.getFindAction().setEnabled(false);
				editorView.getSegmentAction().setEnabled(false);
				editorView.getLocatekeyAction().setEnabled(false);
			}
		}
	}
	public Text getErrorMessageText() {
		return errorMessageText;
	}
	
	public void setSilderOffset(int offset) {
		slider.setSelection(offset);
		slider.notifyListeners(SWT.Selection, new Event());
	}
	
	public void putCursor(){
		final Table table = tableViewer.getTable();		
		
		if (!table.isDisposed()) {			
			Event e = new Event();			
			CursorType fmiCursor = editorView.getCursor();		
			boolean currentCursorVisible = false;
			int count = inputData.get(0).segmentType.getSegmentFields().getSegmentField().size();
			
			if (!inputData.get(0).segmentType.getSegid().equals(fmiCursor.getSegid())){
				setSilderOffset(0);
				fmiCursor.setCursorPosition(0);
				fmiCursor.setFieldId(inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(0).getId());
				fmiCursor.setSegid(inputData.get(0).segmentType.getSegid());
				editorView.setCursor(fmiCursor);
			}
			long keyStart = inputData.get(0).segmentType.getKeyInfo().getStart();
			
			for(int i = 0; i < count; i++){
				if (inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getId() == fmiCursor.getFieldId()) {
					if ((inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCharData() == null & i+1 < count &
						inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCursor() == null) |
						((keyStart - inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getPosition()) <= 0 & 
						inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getKeyPart() == YorNType.Y & 
						i+1 < count & inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i).getCursor() == null)){
							fmiCursor.setFieldId(inputData.get(0).segmentType.getSegmentFields().getSegmentField().get(i+1).getId());
						
					} else {
						setCusrsorFlag = false;
						table.setFocus();
						table.setSelection(i);
						if (table.getSelectionIndex() < 0){
							break;
						}
						e.item = tableViewer.getTable().getItem(i);
						table.notifyListeners(SWT.Selection, e);
						currentCursorVisible = true;
						setCusrsorFlag = true;
					}
				}
				e.doit = false;
			}				
			
			if (!currentCursorVisible) {
				int i = 0;
				setSilderOffset(0);
				fmiCursor.setCursorPosition(0);
				fmiCursor.setSegid(inputData.get(i).segmentType.getSegid());
				editorView.setCursor(fmiCursor);
				table.setFocus();
				table.setSelection(i);
				e.item = tableViewer.getTable().getItem(i);
				table.notifyListeners(SWT.Selection, e);
				currentCursorVisible = true;
			}
		}
	}
}