/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.databaselist;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.testingtools.core.TT_TreeItem;

public class WorkbenchPropertyTester extends PropertyTester {

	public WorkbenchPropertyTester() {}

	@Override
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		if("isServerSelected".equals(property)){
			if (((IWorkbenchWindow)receiver).getActivePage() == null){
				return false;
			}
			
			IViewPart dbList = ((IWorkbenchWindow)receiver).getActivePage().findView("com.ca.fmp.ims.view.databaselist");
				
			if(dbList != null){
				ISelection selection = dbList.getViewSite().getSelectionProvider().getSelection();
				
				if(((IStructuredSelection)selection).size() == 1){
					TT_TreeItem item = (TT_TreeItem)((IStructuredSelection)selection).getFirstElement(); 
					if(item.getValue() != null 
							&& item.getValue() instanceof FileMasterServer
							&& ((FileMasterServer)item.getValue()).isActive()){
						return true;	
					}
				}
			}
		}
		return false;
	}
}

