/*
 * Decompiled with CFR 0.152.
 */
package com.ca.fmp.ims.operation;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.FileMasterSession;
import com.ca.fmp.ims.model.UnmarshalGUIResponse;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Element;

public class SendRequestToMainframeJob
extends Job {
    private HashMap<String, Object> map;
    private String operation;
    private boolean doSignon;
    private FileMasterServer fileMasterServer;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SS");
    private static final String SERVICE = "filemaster/fmp";
    private static final int GUISESSIONLEN = 36;
    private XMLRequest response = null;
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private XMLDocument xmlDocument = null;
    private GUIResponseType guiResponseType;
    private String uuid;

    public SendRequestToMainframeJob(FileMasterServer fileMasterServer, HashMap<String, Object> map, String operation, boolean doSignon, XMLDocument xmlDocument) {
        super(operation);
        this.fileMasterServer = fileMasterServer != null ? fileMasterServer : new FileMasterServer("Dev Server", "CA11", "19487", "00000000-0000-0000-0000-000000000000");
        this.map = map;
        this.xmlDocument = xmlDocument;
        this.operation = operation;
        this.doSignon = false;
        Calendar now = Calendar.getInstance();
        this.log.log(Level.FINEST, "START JOB: " + this.dateFormat.format(now.getTime()));
        this.setPriority(20);
        this.schedule();
    }

    public GUIResponseType getGuiResponseType() {
        return this.guiResponseType;
    }

    protected IStatus run(IProgressMonitor monitor) {
        ServerConnect sc = new ServerConnect((TTServer)this.fileMasterServer, SERVICE);
        try {
            if (this.xmlDocument == null) {
                this.response = sc.connect(this.operation, this.map, this.doSignon);
            } else {
                int begOfGUISession = this.xmlDocument.toString().indexOf("GUIsession=\"") + 12;
                this.uuid = this.xmlDocument.toString().substring(begOfGUISession, begOfGUISession + 36);
                this.map.put("uuid", this.uuid);
                this.map.put("product", "IMS");
                this.response = sc.connect(this.operation, this.map, this.doSignon, this.xmlDocument);
            }
            Element reqElement = this.response.getRoot();
            if (reqElement != null) {
                if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                    FileMasterSession.removeSession((FileMasterServer)this.fileMasterServer, (String)this.uuid);
                }
                if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                    FileMasterSession.removeSession((FileMasterServer)this.fileMasterServer, (String)this.uuid);
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        this.log.log(Level.FINEST, "Running Job: " + this.operation);
        Calendar now = Calendar.getInstance();
        this.log.log(Level.FINEST, "END JOB: " + this.dateFormat.format(now.getTime()));
        UnmarshalGUIResponse u = new UnmarshalGUIResponse();
        File f = this.response.getAttachedFile();
        if (f == null) {
            return Status.CANCEL_STATUS;
        }
        if (f.exists()) {
            u.readAndUnmarshal(f);
            this.guiResponseType = u.getResponse();
        }
        return Status.OK_STATUS;
    }
}

