/*
 * Decompiled with CFR 0.152.
 */
package com.ca.fmp.ims.common.validator;

public class Validator {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    public static final int NO_ERROR = 0;
    public static final int DS_MISSING = 1;
    public static final int DS_INVALID = 2;
    public static final int DS_WILDCARD = 3;
    public static final int DS_LONG = 4;
    public static final int MEM_MISSING = 5;
    public static final int MEM_INVALID = 6;
    public static final int MEM_WILDCARD = 7;
    public static final int LENGTH_MISSING = 8;
    public static final int LENGTH_INVALID = 9;
    public static final int Hexadecimal_LENGTH_INVALID = 10;
    public static final int PackedDecimal_LENGTH_INVALID = 11;
    public static final int CL_NON_MATCHING_QUOTES = 12;
    public static final int CL_UNSUPPORTED_CHARS = 13;
    public static final int CL_TOO_LONG = 14;
    public static final int CL_INCOMPATIBILE_TYPE = 15;
    public static final int CL_INVALID = 16;
    public static final int CL_FORMAT_ERROR = 17;
    public static final int CL_FIELD_NAME = 18;
    public static final int CL_WHITE_SPACE = 19;
    public static final int CL_VALUE_NOT_IN_QUOTES = 20;
    public static final int CL_EMPTY_VALUE = 21;
    public static final int Character_LENGTH_INVALID = 22;
    public static final String[] errorMsg = new String[]{"", "Missing data set name", "Data set name has invalid format", "Unresolved data set name", "Data set name is too long", "Missing member name", "Member name has invalid format", "Unresolved member name", "Missing length", "Length has invalid format", "Hexadecimal has invalid format", "PackedDecimal has invalid format", "Missing quote", "Value contains characters not supported by specified data type", "Compare value is too long", "Compare value of incompatible type", "Invalid compare value", "Compare value has incorrect format", "", "White spaces are not allowed inside single quotes", "Character values must be within quotes", "Empty value is not allowed", "Input Too Long"};

    public static int dataset(String input, boolean mandatory) {
        input = input.trim();
        if (mandatory && input.length() == 0) {
            return 1;
        }
        if (input.length() > 44) {
            return 4;
        }
        if (!input.matches("(([a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\-\\*\\%]{0,7}))([.](([a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\-\\*\\%]{0,7})))*?") && input.length() != 0) {
            return 2;
        }
        if (input.contains("**")) {
            int pos = input.lastIndexOf("**");
            if (pos > 0 && input.charAt(pos - 1) == '.' && input.length() >= pos + 2) {
                if (input.length() == pos + 2) {
                    return 3;
                }
                if (input.charAt(pos + 2) == '.') {
                    return 3;
                }
            }
            return 2;
        }
        if (input.equals("\\*") || input.contains("*") || input.contains("%")) {
            return 3;
        }
        return 0;
    }

    public static int member(String input, boolean mandatory) {
        input = input.trim();
        if (mandatory && input.length() == 0) {
            return 5;
        }
        if (!input.matches("[a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\*\\%]{0,7}([;][a-zA-Z#@$\\*\\%][a-zA-Z0-9#@$\\*\\%]{0,7})*?") && !input.equals("\\*") && input.length() != 0) {
            return 6;
        }
        if (input.contains("*") || input.contains("%")) {
            return 7;
        }
        return 0;
    }

    public static int HexadecimalLength(String input, boolean mandatory) {
        if (!(input = input.trim()).matches("[a-fA-F0-9]{0,}")) {
            return 10;
        }
        if (mandatory && input.length() == 0) {
            return 8;
        }
        if (input.length() % 2 > 0) {
            return 10;
        }
        return 0;
    }

    public static int PackedDecimalLength(String input, boolean mandatory) {
        if ((input = input.trim()).matches("[-+]") ? !input.matches("[-+]{0,1}+[0-9]{0,32}") : !input.matches("[-+]{0,1}+[0-9]{0,31}")) {
            return 11;
        }
        if (mandatory && input.length() == 0) {
            return 8;
        }
        return 0;
    }

    public static int length(String input, boolean mandatory) {
        if (!(input = input.trim()).matches("[0-9]{0,6}")) {
            return 9;
        }
        if (mandatory && input.length() == 0) {
            return 8;
        }
        return 0;
    }

    public static int CLConditionField(String value, String formatType, int formatNum, int formatDec, int length, boolean mandatory) {
        String fieldType = formatType;
        int fieldLength = length;
        char singleQuote = '\'';
        char doubleQuote = '\"';
        char comma = ',';
        String input = value.trim();
        if (!fieldType.matches("C") && value.contains("\"")) {
            return 13;
        }
        boolean singleQuoteEncapsulation = false;
        boolean doubleQuoteEncapsulation = false;
        int i = 0;
        while (i < input.length()) {
            switch (input.charAt(i)) {
                case '\'': {
                    String tmp;
                    if (doubleQuoteEncapsulation) {
                        tmp = input;
                        input = String.valueOf(tmp.substring(0, i)) + "a";
                        if (i + 1 >= tmp.length()) break;
                        input = String.valueOf(input) + tmp.substring(i + 1);
                        break;
                    }
                    if (!singleQuoteEncapsulation) {
                        singleQuoteEncapsulation = true;
                        break;
                    }
                    if (singleQuoteEncapsulation) {
                        singleQuoteEncapsulation = false;
                        doubleQuoteEncapsulation = false;
                        break;
                    }
                }
                case '\"': {
                    String tmp;
                    if (singleQuoteEncapsulation) {
                        tmp = input;
                        input = String.valueOf(tmp.substring(0, i)) + "a";
                        if (i + 1 >= tmp.length()) break;
                        input = String.valueOf(input) + tmp.substring(i + 1);
                        break;
                    }
                    if (!doubleQuoteEncapsulation) {
                        doubleQuoteEncapsulation = true;
                        break;
                    }
                    if (doubleQuoteEncapsulation) {
                        singleQuoteEncapsulation = false;
                        doubleQuoteEncapsulation = false;
                        break;
                    }
                }
                case ',': {
                    String tmp;
                    if (!singleQuoteEncapsulation && !doubleQuoteEncapsulation && fieldType.matches("C")) {
                        tmp = input;
                        input = String.valueOf(tmp.substring(0, i)) + " ";
                        if (i + 1 >= tmp.length()) break;
                        input = String.valueOf(input) + tmp.substring(i + 1);
                        break;
                    }
                    if (!singleQuoteEncapsulation) break;
                    tmp = input;
                    input = String.valueOf(tmp.substring(0, i)) + ";";
                    if (i + 1 >= tmp.length()) break;
                    input = String.valueOf(input) + tmp.substring(i + 1);
                }
            }
            ++i;
        }
        boolean isNumericField = true;
        int inputLength = fieldLength;
        String inputType = fieldType;
        int fieldPrimaryLength = formatNum;
        int fieldSecondaryLength = formatDec;
        int valueLength = 0;
        String possibleCompareTypeChar = new String("a-zA-Z");
        String regEx = new String("(?<=(('.{0,155}'))|([" + possibleCompareTypeChar + "]('.{0,155}'))|([\\d]{0,15}[" + possibleCompareTypeChar + "][\\d]{0,15}('.{0,155}'))|" + "((\".{0,155}\"))|([" + possibleCompareTypeChar + "](\".{0,155}\"))|([\\d]{0,15}[" + possibleCompareTypeChar + "][\\d]{0,15}(\".{0,155}\"))|" + "([+-]?[0-9A-Za-z]{0,155}[.]?[0-9A-Za-z]{0,155}[,])" + ")");
        if (input.length() > 0 && input.matches("[a-zA-Z][a-zA-Z 0-9\\-\\(\\)]{0,31}") && !input.contains("'") && !input.contains("\"")) {
            return 18;
        }
        int singleQuoteCount = 0;
        int doubleQuoteCount = 0;
        int i2 = 0;
        while (i2 < input.length()) {
            if (input.charAt(i2) == singleQuote) {
                ++singleQuoteCount;
            }
            if (input.charAt(i2) == doubleQuote) {
                ++doubleQuoteCount;
            }
            ++i2;
        }
        if (singleQuoteCount % 2 != 0 || doubleQuoteCount % 2 != 0) {
            return 12;
        }
        String valType = new String("");
        String valLength = new String("");
        String val = new String("");
        int quoteType = 0;
        boolean valueParsed = false;
        int turn = 0;
        String[] result = input.split(regEx);
        while (result.length > 0 && result[0].length() > 0) {
            int res;
            input = input.substring(result[0].length(), input.length());
            quoteType = 0;
            valueParsed = false;
            boolean parseValue = false;
            String tmp = result[0];
            if ((tmp = tmp.trim()).length() > 0) {
                if (tmp.charAt(tmp.length() - 1) == singleQuote) {
                    quoteType = 1;
                    parseValue = true;
                }
                if (tmp.charAt(tmp.length() - 1) == doubleQuote) {
                    quoteType = 2;
                }
            }
            if (tmp.matches("([+-]?[0-9A-Za-z]{0,155}[.]?[0-9A-Za-z]{0,155}[,])|([+-]?[0-9A-Za-z]{0,155}[.]?[0-9A-Za-z]{0,155})")) {
                val = tmp;
                if (tmp.length() < 1) break;
                if (tmp.charAt(tmp.length() - 1) == comma) {
                    val = val.substring(0, val.length() - 1);
                }
                valueParsed = true;
            }
            if (tmp.matches("(('.{0,155}'))|((\".{0,155}\"))")) {
                valType = "";
                valLength = "";
                val = (String)tmp.trim().subSequence(1, tmp.length() - 1);
                valueParsed = true;
            }
            if (tmp.matches("([" + possibleCompareTypeChar + "]{1,155}('.{0,155}'))|([" + possibleCompareTypeChar + "]{1,155}(\".{0,155}\"))")) {
                valType = tmp.split("['\"]")[0];
                tmp = tmp.substring(valType.length(), tmp.length());
                valLength = "";
                val = (String)tmp.trim().subSequence(1, tmp.length() - 1);
                valueParsed = true;
            }
            if (tmp.matches("([\\d]{0,15}[" + possibleCompareTypeChar + "]{1,155}[\\d]{0,15}('.{0,155}'))|([\\d]{0,15}[" + possibleCompareTypeChar + "]{1,155}[\\d]{0,15}(\".{0,155}\"))")) {
                return 17;
            }
            if (!valueParsed) {
                val = tmp;
            }
            valueLength = valLength.matches("") ? length : Integer.valueOf(valLength);
            if (valLength.length() > 0) {
                inputLength = Math.min(Integer.parseInt(valLength), inputLength);
            }
            if (parseValue) {
                String[] subValues = val.split(";");
                int i3 = 0;
                while (i3 < subValues.length) {
                    res = Validator.validateValue(subValues[i3], valueLength, valType.toUpperCase(), inputType.toUpperCase(), fieldPrimaryLength, fieldSecondaryLength, fieldLength, quoteType);
                    if (res != 0) {
                        return res;
                    }
                    ++i3;
                }
            } else {
                res = Validator.validateValue(val, valueLength, valType.toUpperCase(), inputType.toUpperCase(), fieldPrimaryLength, fieldSecondaryLength, fieldLength, quoteType);
                if (res != 0) {
                    return res;
                }
            }
            quoteType = 0;
            result = input.split(regEx);
            ++turn;
        }
        return 0;
    }

    public static int validateValue(String value, int valueLength, String valueType, String fieldType, int fieldPrimaryLength, int fieldSecondaryLength, int length, int quoteType) {
        String sign = new String("");
        if (fieldType.matches("PS") || fieldType.matches("NS") || fieldType.matches("BS") || fieldType.matches("1") || fieldType.matches("2") || fieldType.matches("F")) {
            sign = "[-+]{0,1}";
        }
        if (value.length() == 0) {
            return 21;
        }
        fieldType = fieldType.toUpperCase();
        valueType = valueType.toUpperCase();
        if (fieldType.matches("C")) {
            if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 14;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*")) {
                    return 13;
                }
                if (value.length() % 2 > 0) {
                    return 10;
                }
            } else if (valueType.matches("C") || valueType.matches("T") || valueType.matches("")) {
                if (quoteType == 0) {
                    return 20;
                }
                if (value.length() > length) {
                    return 14;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches(".*")) {
                    return 13;
                }
            } else {
                return 15;
            }
            return 0;
        }
        if (fieldType.matches("B") || fieldType.matches("BS")) {
            if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 14;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*")) {
                    return 13;
                }
                if (value.length() % 2 > 0) {
                    return 10;
                }
            } else if (valueType.matches("N") || valueType.matches("")) {
                String[] decimalSplit;
                if (value.contains(".")) {
                    return 13;
                }
                if (value.startsWith("-") || value.startsWith("+")) {
                    ++fieldPrimaryLength;
                }
                if ((decimalSplit = value.split("[.]"))[0].length() > fieldPrimaryLength) {
                    return 14;
                }
                if (decimalSplit.length > 1 && decimalSplit[1].length() > fieldSecondaryLength) {
                    return 14;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches(String.valueOf(sign) + "[0-9]*[.]?[0-9]*")) {
                    return 13;
                }
            } else {
                return 15;
            }
            return 0;
        }
        if (fieldType.matches("N") || fieldType.matches("NS")) {
            if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 14;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*") || value.length() == 0) {
                    return 13;
                }
                if (value.length() % 2 > 0) {
                    return 10;
                }
            } else if (valueType.matches("N") || valueType.matches("NS") || valueType.matches("")) {
                String[] decimalSplit;
                if (value.contains(".") && fieldSecondaryLength == 0) {
                    return 13;
                }
                if (value.startsWith("-") || value.startsWith("+")) {
                    ++fieldPrimaryLength;
                }
                if ((decimalSplit = value.split("[.]"))[0].length() > fieldPrimaryLength) {
                    return 14;
                }
                if (decimalSplit.length > 1 && decimalSplit[1].length() > fieldSecondaryLength) {
                    return 14;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches(String.valueOf(sign) + "[0-9]*[.]?[0-9]*")) {
                    return 13;
                }
            } else {
                return 15;
            }
            return 0;
        }
        if (fieldType.matches("P") || fieldType.matches("PS")) {
            if (valueType.matches("") || valueType.matches("N") || valueType.matches("NS") || valueType.matches("P") || valueType.matches("PS")) {
                String[] decimalSplit;
                if (value.contains(".") && fieldSecondaryLength == 0) {
                    return 13;
                }
                if (value.startsWith("-") || value.startsWith("+")) {
                    ++fieldPrimaryLength;
                }
                if ((decimalSplit = value.split("[.]"))[0].length() > fieldPrimaryLength) {
                    return 14;
                }
                if (decimalSplit.length > 1 && decimalSplit[1].length() > fieldSecondaryLength) {
                    return 14;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches(String.valueOf(sign) + "[0-9]*[.]?[0-9]*")) {
                    return 13;
                }
            } else if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 14;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*")) {
                    return 13;
                }
                if (value.length() % 2 > 0) {
                    return 10;
                }
            } else {
                return 15;
            }
            return 0;
        }
        if (fieldType.matches("1") || fieldType.matches("2") || fieldType.matches("F")) {
            if (valueType.matches("X")) {
                if (value.length() > length * 2) {
                    return 14;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (!value.matches("[0-9A-Fa-f]*")) {
                    return 13;
                }
                if (value.length() % 2 > 0) {
                    return 10;
                }
                if (value.length() != length * 2) {
                    return 17;
                }
            } else if (valueType.matches("") || valueType.matches("C") || valueType.matches("T")) {
                if (quoteType == 0) {
                    return 20;
                }
                if (value.length() == 0) {
                    return 0;
                }
                if (value.length() > length) {
                    return 14;
                }
                if (value.length() != length) {
                    return 17;
                }
            } else if (valueType.matches("P") || valueType.matches("PS")) {
                if (value.length() == 0) {
                    return 0;
                }
                if (quoteType == 0) {
                    return 20;
                }
                if (value.length() > length) {
                    return 14;
                }
                if (value.length() != length) {
                    return 17;
                }
                if (!value.matches(String.valueOf(sign) + "[0-9]*")) {
                    return 13;
                }
                if (value.length() > length) {
                    return 14;
                }
            } else {
                return 15;
            }
            return 0;
        }
        return 0;
    }

    public static int CharacterLength(String input, Long long1) {
        if ((long)(input = input.trim()).length() > long1) {
            return 22;
        }
        return 0;
    }
}

