/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.copy;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.utility.copy.CopyPDSFromWizardPage;
import com.ca.filemaster.utility.copy.CopyPDSSummaryPage;
import com.ca.filemaster.utility.copy.CopyPDSToWizardPage;
import com.ca.filemaster.utility.copy.PDSSelectionCrtLayoutWizardPage;
import com.ca.filemaster.utility.copy.SelectionCrtLayoutWizardPage;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CopyPDSWizard
extends Wizard
implements INewWizard {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private CopyPDSFromWizardPage page1;
    private SelectionCrtLayoutWizardPage page3;
    private IStructuredSelection selection;
    private FileMasterDataset dataSet;
    private FileMasterServer server;
    private FileMasterMember member;
    private static final FMServerTreeModel model = FMServerTreeModel.getInstance();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        TT_TreeItem datasetItem;
        this.setWindowTitle("Copy PDS Utility");
        this.selection = selection;
        Object object = selection.getFirstElement();
        TT_TreeItem treeItem = model.findObject(object);
        if (treeItem != null && (datasetItem = treeItem.getParent(Profile.class)) != null) {
            treeItem = datasetItem;
        }
        if (treeItem != null) {
            FileMasterDataset value = (FileMasterDataset)((Object)treeItem.getAdapter(FileMasterDataset.class));
            if (value != null) {
                this.dataSet = value;
                this.server = (FileMasterServer)treeItem.getServer();
            } else if (treeItem.getAdapter(FileMasterServer.class) != null) {
                this.server = (FileMasterServer)treeItem.getValue();
            }
        }
        if (treeItem == null) {
            TT_TreeItem[] AllServerItem;
            TT_TreeItem[] tT_TreeItemArray = AllServerItem = model.getServers();
            int n = AllServerItem.length;
            int n2 = 0;
            while (n2 < n) {
                TT_TreeItem item = tT_TreeItemArray[n2];
                String serverStatus = item.getServer().getStatusText();
                if (serverStatus == "Active") {
                    this.server = (FileMasterServer)item.getServer();
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Copy PDS From")) {
            return false;
        }
        return ((CopyPDSToWizardPage)this.page1.getNextPage()).isPageComplete() && this.page3.isPageComplete();
    }

    public boolean performFinish() {
        return ((CopyPDSToWizardPage)this.page1.getNextPage()).doFinish();
    }

    public void addPages() {
        this.setForcePreviousAndNextButtons(true);
        TrayDialog.setDialogHelpAvailable((boolean)true);
        String datasetName = "";
        String memberName = "";
        String serverName = "";
        String layoutDS = "";
        String layoutMem = "";
        if (this.selection.getFirstElement() != null) {
            TT_TreeItem treeItem = (TT_TreeItem)this.selection.getFirstElement();
            if (treeItem.getParent() == null) {
                this.server = (FileMasterServer)treeItem.getValue();
            } else if (treeItem.getParent().getParent() != null) {
                this.server = (FileMasterServer)treeItem.getParent().getParent().getValue();
                this.dataSet = (FileMasterDataset)treeItem.getParent().getValue();
                this.member = (FileMasterMember)treeItem.getValue();
                if (this.member != null) {
                    memberName = this.member.getName();
                }
                layoutDS = treeItem.getElement().getAttribute("layoutDS");
                layoutMem = treeItem.getElement().getAttribute("layoutMem");
            } else {
                this.dataSet = (FileMasterDataset)treeItem.getValue();
                this.server = (FileMasterServer)treeItem.getParent().getValue();
            }
            this.dataSet = CommonMFCalls.getFQDSN(this.dataSet.getText(), "", this.server);
            CommonMFCalls.RETURN_CODE.equals("0");
        }
        this.page1 = new CopyPDSFromWizardPage("Copy PDS From", this.server, this.dataSet, this.member, true);
        this.addPage((IWizardPage)this.page1);
        this.page3 = new PDSSelectionCrtLayoutWizardPage("Options", this.server.getName(), this.dataSet.getName(), memberName, layoutDS, layoutMem);
        this.addPage((IWizardPage)this.page3);
        CopyPDSSummaryPage page4 = new CopyPDSSummaryPage("Copy PDS Summary");
        this.addPage((IWizardPage)page4);
    }
}

