/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.compare;

import com.ca.filemaster.utility.compare.CompareWizardPage5;
import com.ca.filemaster.utility.compare.InsertPositionWizard;
import com.ca.filemaster.utility.compare.InsertPositionWizardPage;
import com.ca.filemaster.utility.compare.Position;
import com.ca.filemaster.utility.compare.PositionContentProvider;
import com.ca.filemaster.utility.compare.PositionLabelProvider;
import com.ca.filemaster.utility.compare.PositionSorter;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CompareWizardPage4
extends WizardPage {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.compareWizardPage";
    private Composite container;
    private TableViewer tableViewer;
    private Listener sortListener;
    private Table positionTable;
    private Button deleteLineButton;
    private TableViewerColumn tableViewerColumn;
    private String error = "";
    private String value = "";
    private List<Position> positions = new ArrayList<Position>();

    public CompareWizardPage4() {
        super("wizardPage");
        this.setTitle("Position");
        this.setDescription("");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout container_layout = new GridLayout(2, false);
        this.container.setLayout((Layout)container_layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareWizardPage");
        this.createViewer(this.container);
        Composite composite = new Composite(this.container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        Button addButton = new Button(composite, 0);
        GridData gd_addButton = new GridData(4, 128, false, false, 1, 1);
        gd_addButton.widthHint = 90;
        addButton.setLayoutData((Object)gd_addButton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(CompareWizardPage4.this.getShell(), (IWizard)new InsertPositionWizard());
                dialog.create();
                dialog.open();
                Position position = ((InsertPositionWizardPage)dialog.getCurrentPage()).getPosition();
                if (position != null) {
                    CompareWizardPage4.this.positions.add(((InsertPositionWizardPage)dialog.getCurrentPage()).getPosition());
                    CompareWizardPage4.this.tableViewer.refresh();
                }
            }
        });
        addButton.setText("&Add");
        this.deleteLineButton = new Button(composite, 0);
        this.deleteLineButton.setEnabled(false);
        this.deleteLineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean answer = false;
                IStructuredSelection selection = (IStructuredSelection)CompareWizardPage4.this.tableViewer.getSelection();
                if (selection.isEmpty()) {
                    MessageDialog.openError(null, (String)"Delete", (String)"Select a line to delete");
                    return;
                }
                if (selection.size() == 1) {
                    answer = MessageDialog.openQuestion((Shell)CompareWizardPage4.this.getShell(), (String)"Delete", (String)("Are you sure you want to delete the position " + selection.getFirstElement().toString()));
                } else if (selection.size() > 1) {
                    answer = MessageDialog.openQuestion((Shell)CompareWizardPage4.this.getShell(), (String)"Delete", (String)("Are you sure you want to delete these " + selection.size() + " positions?"));
                }
                if (!answer) {
                    return;
                }
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    CompareWizardPage4.this.positions.remove(it.next());
                }
                if (CompareWizardPage4.this.positions.isEmpty()) {
                    CompareWizardPage4.this.deleteLineButton.setEnabled(false);
                }
                CompareWizardPage4.this.tableViewer.refresh();
                if (CompareWizardPage4.this.tableViewer.getSelection().isEmpty()) {
                    CompareWizardPage4.this.deleteLineButton.setEnabled(false);
                }
            }
        });
        this.deleteLineButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.deleteLineButton.setText("&Delete");
        this.positionTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CompareWizardPage4.this.value.isEmpty()) {
                    CompareWizardPage4.this.setErrorMessage(null);
                    CompareWizardPage4.this.setPageComplete(CompareWizardPage4.this.isPageComplete());
                }
                if (((IStructuredSelection)CompareWizardPage4.this.tableViewer.getSelection()).isEmpty()) {
                    CompareWizardPage4.this.deleteLineButton.setEnabled(false);
                    return;
                }
                CompareWizardPage4.this.deleteLineButton.setEnabled(true);
            }
        });
        this.setControl((Control)this.container);
    }

    private void createViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.positionTable = this.tableViewer.getTable();
        this.positionTable.setLinesVisible(true);
        this.positionTable.setHeaderVisible(true);
        GridData gd_table = new GridData(16384, 4, false, false, 1, 1);
        gd_table.heightHint = 293;
        gd_table.widthHint = 510;
        this.tableViewer.getTable().setLayoutData((Object)gd_table);
        this.columnSorterListener();
        this.createColumns(parent);
        Text text = new Text((Composite)this.positionTable, 2048);
        text.setMessage("0");
        this.tableViewer.setInput(this.positions);
    }

    private void createColumns(Composite parent) {
        String[] titles = new String[]{"Old Position", "Length", "New Position"};
        String[] properties = new String[]{"oldPosition", "length", "newPosition"};
        int[] bounds = new int[]{170, 170, 170};
        this.tableViewer.setSorter((ViewerSorter)new PositionSorter());
        int i = 0;
        while (i < titles.length) {
            this.tableViewerColumn = new TableViewerColumn(this.tableViewer, bounds[i]);
            TableColumn tableColumn = this.tableViewerColumn.getColumn();
            tableColumn.setResizable(false);
            tableColumn.addListener(13, this.sortListener);
            if (i == 0) {
                this.positionTable.setSortColumn(tableColumn);
                this.positionTable.setSortDirection(128);
                this.tableViewerColumn.getColumn().setToolTipText("Starts the compare of the first file at a position other than at the first record");
            } else if (i == 1) {
                this.tableViewerColumn.getColumn().setToolTipText("Specifies the length of the compare");
            } else if (i == 2) {
                this.tableViewerColumn.getColumn().setToolTipText("Starts the compare of the second file at a position other than the first record");
            }
            this.tableViewerColumn.getColumn().setText(titles[i]);
            this.tableViewerColumn.getColumn().setWidth(bounds[i]);
            ++i;
        }
        this.tableViewer.setColumnProperties(properties);
        this.tableViewer.setContentProvider((IContentProvider)new PositionContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PositionLabelProvider());
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    private void columnSorterListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = CompareWizardPage4.this.tableViewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                CompareWizardPage4.this.tableViewer.refresh();
            }
        };
    }

    public boolean isPageComplete() {
        return this.error == "" || this.error == null;
    }

    public IWizardPage getNextPage() {
        ((CompareWizardPage5)super.getNextPage()).presetText();
        return super.getNextPage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.container.setFocus();
    }

    public TableItem[] getPositions() {
        return this.positionTable.getItems();
    }
}

