/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.compare;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetCompareReport;
import com.ca.filemaster.ui.wizards.ChangedLabelProvider;
import com.ca.filemaster.ui.wizards.CreatedLabelProvider;
import com.ca.filemaster.ui.wizards.IDLabelProvider;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.filemaster.ui.wizards.MemberLabelProvider;
import com.ca.filemaster.ui.wizards.MemberWizard;
import com.ca.filemaster.ui.wizards.MemberWizardPage;
import com.ca.filemaster.ui.wizards.RecordCountLabelProvider;
import com.ca.filemaster.ui.wizards.TimeChangedLabelProvider;
import com.ca.filemaster.utilities.CompareGenericWizard;
import com.ca.filemaster.utility.compare.CompareProgramPage3;
import com.ca.filemaster.utility.compare.CompareWizard;
import com.ca.filemaster.utility.compare.CompareWizardPage1;
import com.ca.filemaster.utility.compare.CompareWizardPage3;
import com.ca.filemaster.utility.compare.CompareWizardPage4;
import com.ca.filemaster.utility.compare.CompareWizardPage5;
import com.ca.filemaster.utility.compare.Position;
import com.ca.filemaster.utility.compare.ProgramCompareSummaryPage;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.filemaster.views.report.ReportView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompareWizardPage2
extends FileMasterWizard {
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.compareWizardPage";
    private final String CONTEXT_HELP_ID_PGM = "com.ca.filemaster.help.compareProgramWizardPage";
    private Map<String, String> map;
    private Label memberLabel;
    private Combo memberNameCombo;
    private Button selectMemberButton;
    private TableViewer tableViewer;
    private boolean isComparePGM = false;
    private ProgramCompareSummaryPage programCompareSummaryPage;
    private CompareWizardPage5 standardCompareSummaryPage;
    private FileMasterServer server;
    private String sysDSNVal;
    protected FileMasterMember member;
    private boolean isGenericOpen;
    private Button DirListInsert;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();

    public CompareWizardPage2(String pageName, FileMasterServer server, FileMasterDataset dataSet, Map<String, String> map, boolean isComparePGM) {
        super(pageName, "", server);
        this.setTitle(pageName);
        this.server = server;
        this.map = map;
        this.isComparePGM = isComparePGM;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        GridData data = new GridData(4, 0, true, true, 1, 1);
        if (this.getWizard().getWindowTitle().contains("Program")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareProgramWizardPage");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareWizardPage");
        }
        super.createDataSet();
        FMHistory.intializeComboBoxes(this.dataSetCombo, "DataSetComboCompareWizardPage2");
        if (!this.dataSetName.isEmpty()) {
            this.dataSetCombo.setText(this.dataSetName);
        }
        this.memberLabel = new Label(this.dataSetComposite, 0);
        this.memberLabel.setText("&Member name:");
        this.memberNameCombo = new Combo(this.dataSetComposite, 0);
        this.memberNameCombo.setLayoutData((Object)data);
        this.memberNameCombo.setTextLimit(8);
        GridData gd_toMemberComboo = new GridData(4, 4, false, false, 1, 1);
        gd_toMemberComboo.widthHint = 107;
        this.memberNameCombo.addModifyListener((ModifyListener)this);
        this.memberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.memberNameCombo, "MemberNameComboCompareWizardPage2");
        this.selectMemberButton = new Button(this.dataSetComposite, 0);
        this.selectMemberButton.setText("S&elect...");
        this.selectMemberButton.setEnabled(false);
        this.selectMemberButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareWizardPage2.this.member = new FileMasterMember(null);
                CompareWizardPage2.this.member.setName(CompareWizardPage2.this.memberNameCombo.getText());
                CompareWizardPage2.this.fmdataset = CommonMFCalls.getFQDSN(CompareWizardPage2.this.dataSetCombo.getText(), "", CompareWizardPage2.this.server);
                if (!CompareWizardPage2.this.fmdataset.getName().isEmpty()) {
                    WizardDialog dialog = new WizardDialog(CompareWizardPage2.this.getShell(), (IWizard)new MemberWizard(CompareWizardPage2.this.member, CompareWizardPage2.this.fmdataset, CompareWizardPage2.this.server, true));
                    dialog.create();
                    dialog.open();
                    CompareWizardPage2.this.memberNameCombo.setText(((MemberWizardPage)dialog.getCurrentPage()).getMemberName());
                }
            }
        });
        new Label(this.dataSetComposite, 0);
        this.createMembersTable();
        this.setControl((Control)this.container);
        if (this.getWizard().getPageCount() == 8) {
            this.isGenericOpen = true;
            if (this.isGenericOpen) {
                this.DirListInsert = new Button(this.container, 32);
                this.DirListInsert.setText("Add to Director&y List view");
            }
        }
    }

    private void createMembersTable() {
        Composite tableComp = new Composite(this.container, 0);
        GridLayout table_Layout = new GridLayout(1, false);
        tableComp.setLayout((Layout)table_Layout);
        Group memberGroup = new Group(this.container, 0);
        memberGroup.setSize(memberGroup.computeSize(-1, -1));
        memberGroup.setText("Members");
        memberGroup.setLayout((Layout)new GridLayout(1, false));
        memberGroup.setRedraw(true);
        this.tableViewer = new TableViewer((Composite)memberGroup, 68354);
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            this.tableViewer.getTable().setLinesVisible(true);
            ++i;
        }
        this.tableViewer.getTable().setHeaderVisible(true);
        GridData gd_table = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_table.heightHint = 160;
        gd_table.widthHint = 620;
        this.tableViewer.getTable().setLayoutData((Object)gd_table);
        String[] titles = new String[]{"Member", "Record Count", "Created", "Changed", "Time Changed", "ID"};
        int[] bounds = new int[]{100, 100, 100, 100, 100, 100};
        int i2 = 0;
        while (i2 < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i2]);
            tableColumn.setWidth(bounds[i2]);
            switch (i2) {
                case 0: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    break;
                }
                case 1: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new RecordCountLabelProvider());
                    break;
                }
                case 2: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CreatedLabelProvider());
                    break;
                }
                case 3: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ChangedLabelProvider());
                    break;
                }
                case 4: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new TimeChangedLabelProvider());
                    break;
                }
                case 5: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new IDLabelProvider());
                }
            }
            ++i2;
        }
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(null);
    }

    @Override
    public boolean isPageComplete() {
        if (this.tableViewer == null) {
            return false;
        }
        if (((CompareWizardPage1)this.getPreviousPage()).getSelectedMembers().length > 1) {
            this.tableViewer.setInput((Object)((CompareWizardPage1)this.getPreviousPage()).getSelectedMembers());
        } else {
            this.tableViewer.setInput(null);
        }
        if (this.tableViewer.getTable().getItems().length > 1 || ((CompareWizardPage1)this.getPreviousPage()).getMemberNameCombo().getText().equalsIgnoreCase("*")) {
            if (((CompareWizardPage1)this.getPreviousPage()).getSelectedMembers().length != 1) {
                this.selectMemberButton.setEnabled(false);
                this.memberNameCombo.setEnabled(false);
            } else {
                this.selectMemberButton.setEnabled(true);
                this.memberNameCombo.setEnabled(true);
            }
        } else {
            this.memberNameCombo.setEnabled(true);
            this.selectMemberButton.setEnabled(true);
        }
        if (!super.isPageComplete()) {
            this.selectMemberButton.setEnabled(false);
        }
        if (super.isPageComplete()) {
            this.error = Validator.validateMember(this.memberNameCombo, this.selectMemberButton, this.error, false);
            if (this.error.isEmpty()) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.error);
            }
            if (this.memberNameCombo.getText().isEmpty() && this.memberNameCombo.isEnabled()) {
                this.selectMemberButton.setEnabled(true);
            }
        }
        if (!this.memberNameCombo.isEnabled()) {
            this.selectMemberButton.setEnabled(false);
        }
        this.programCompareSummaryPage = (ProgramCompareSummaryPage)this.getWizard().getPage("Compare Program Summary");
        this.standardCompareSummaryPage = (CompareWizardPage5)this.getWizard().getPage("Compare Summary");
        if (this.getErrorMessage() == null && this.dataSetCombo.getText() != "") {
            if (FMPreferences.disabledPreview()) {
                return true;
            }
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (CompareWizardPage2.this.map.get("Action") == null) {
                        CompareWizardPage2.this.map.put("Action", "Preview");
                    }
                    CompareWizardPage2.this.displaySummaryPage();
                }
            });
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(15).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    CompareWizardPage2.this.changePreviewToFinish();
                }
            });
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(14).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    CompareWizardPage2.this.changeFinishToPreview();
                }
            });
            this.getWizard().getContainer().getShell().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent event) {
                    if (CompareWizardPage2.this.getErrorMessage() != null) {
                        return;
                    }
                    if (event.stateMask == 65536) {
                        if (event.character == 'p' || event.character == 'P') {
                            CompareWizardPage2.this.displaySummaryPage();
                        }
                        if (event.character == 'b' || event.character == 'B') {
                            CompareWizardPage2.this.changeFinishToPreview();
                        }
                        if (event.character == 'n' || event.character == 'N') {
                            CompareWizardPage2.this.changePreviewToFinish();
                        }
                    }
                    if (event.character == '\r' && !(Display.getCurrent().getFocusControl() instanceof Text)) {
                        if (((Shell)event.widget).getDefaultButton().getText() == "&Preview") {
                            if (CompareWizardPage2.this.map.get("Action") == null) {
                                CompareWizardPage2.this.map.put("Action", "Preview");
                            }
                            CompareWizardPage2.this.displaySummaryPage();
                        }
                        if (((Shell)event.widget).getDefaultButton().getText().equals("< &Back")) {
                            CompareWizardPage2.this.changeFinishToPreview();
                        }
                        if (((Shell)event.widget).getDefaultButton().getText().equals("&Next >")) {
                            CompareWizardPage2.this.changePreviewToFinish();
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.dataSetCombo.setFocus();
        if (this.getWizard().getWindowTitle().contains("Program")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareProgramWizardPage");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareWizardPage");
        }
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public IWizardPage getNextPage() {
        if (this.isComparePGM) {
            if (this.getWizard() instanceof CompareGenericWizard) {
                CompareProgramPage3 cpp3 = (CompareProgramPage3)((CompareGenericWizard)this.getWizard()).getPage("Compare Program Options");
                return cpp3;
            }
            CompareProgramPage3 cpp3 = (CompareProgramPage3)((CompareWizard)this.getWizard()).getPage("Compare Program Options");
            return cpp3;
        }
        if (this.getWizard() instanceof CompareGenericWizard) {
            CompareWizardPage3 cp3 = (CompareWizardPage3)((CompareGenericWizard)this.getWizard()).getPage("Options");
            return cp3;
        }
        CompareWizardPage3 cp3 = (CompareWizardPage3)((CompareWizard)this.getWizard()).getPage("Options");
        return cp3;
    }

    public boolean doFinish() {
        ImportSelCritWizardPage.conditions = "";
        if (this.map.get("Action") == "Preview") {
            this.map.put("Action", "Finish");
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Finish");
            return false;
        }
        ArrayList<FileMasterDataset> datasets = new ArrayList<FileMasterDataset>();
        ArrayList<FileMasterMember> members = new ArrayList<FileMasterMember>();
        ArrayList<FileMasterMember> layoutMembers = new ArrayList<FileMasterMember>();
        ArrayList<String> selCrit = new ArrayList<String>();
        ArrayList<Position> positions = new ArrayList<Position>();
        ArrayList<String> outputOptions = new ArrayList<String>();
        FileMasterMember fmMember = new FileMasterMember(null);
        datasets.add(0, ((CompareWizardPage1)this.getPreviousPage()).getOldDataset());
        Object[] memTblItems = ((CompareWizardPage1)this.getPreviousPage()).getSelectedMembers();
        if (memTblItems.length == 0) {
            fmMember = new FileMasterMember(null);
            fmMember.setName(((CompareWizardPage1)this.getPreviousPage()).getMemberNameCombo().getText());
            if (!fmMember.getName().trim().isEmpty()) {
                members.add(fmMember);
            }
        } else {
            int count = 0;
            while (count < memTblItems.length) {
                members.add((FileMasterMember)((Object)memTblItems[count]));
                ++count;
            }
        }
        fmMember = new FileMasterMember(null);
        fmMember.setName(this.getMemberNameCombo().getText());
        if (!fmMember.getName().trim().isEmpty()) {
            members.add(fmMember);
        }
        FileMasterDataset fmDataset = new FileMasterDataset(null);
        fmDataset.setName(this.dataSetCombo.getText());
        datasets.add(1, fmDataset);
        if (!this.isComparePGM) {
            int right;
            int left;
            String layout;
            if (CompareWizardPage3.genericOldLay.isLayoutViewSelected()) {
                fmDataset = new FileMasterDataset(null);
                fmMember = new FileMasterMember(null);
                layout = CompareWizardPage3.genericOldLay.getLayoutViewComboString();
                String string = layout = layout.equals("(none)") ? "" : layout;
                if (!layout.trim().isEmpty()) {
                    left = layout.indexOf("(");
                    right = layout.indexOf(")");
                    fmDataset.setName(layout.substring(0, left));
                    fmMember.setName(layout.substring(left + 1, right));
                }
                datasets.add(2, fmDataset);
                layoutMembers.add(0, fmMember);
            } else {
                fmDataset = new FileMasterDataset(null);
                fmMember = new FileMasterMember(null);
                fmDataset.setName(((CompareWizardPage3)this.getNextPage()).getOldDataSetCombo().getText());
                fmMember.setName(((CompareWizardPage3)this.getNextPage()).getOldMemberNameCombo().getText());
                datasets.add(2, fmDataset);
                layoutMembers.add(0, fmMember);
            }
            fmDataset = new FileMasterDataset(null);
            fmMember = new FileMasterMember(null);
            if (CompareWizardPage3.genericNewLay.isLayoutViewSelected()) {
                fmDataset = new FileMasterDataset(null);
                fmMember = new FileMasterMember(null);
                layout = CompareWizardPage3.genericNewLay.getLayoutViewComboString();
                String string = layout = layout.equals("(none)") ? "" : layout;
                if (!layout.trim().isEmpty()) {
                    left = layout.indexOf("(");
                    right = layout.indexOf(")");
                    fmDataset.setName(layout.substring(0, left));
                    fmMember.setName(layout.substring(left + 1, right));
                }
                datasets.add(3, fmDataset);
                layoutMembers.add(1, fmMember);
            } else {
                fmDataset.setName(((CompareWizardPage3)this.getNextPage()).getNewDataSetCombo().getText());
                fmMember.setName(((CompareWizardPage3)this.getNextPage()).getNewMemberNameCombo().getText());
                datasets.add(3, fmDataset);
                layoutMembers.add(1, fmMember);
            }
            selCrit.add(0, ((CompareWizardPage3)this.getNextPage()).getSelCriteriaBoxText().trim());
            TableItem[] posTblItems = ((CompareWizardPage4)this.getNextPage().getNextPage()).getPositions();
            int count = 0;
            while (count < posTblItems.length) {
                positions.add((Position)posTblItems[count].getData());
                ++count;
            }
            outputOptions.add(0, CompareWizardPage3.getPrintCombo().getText().substring(0, 1));
            outputOptions.add(1, CompareWizardPage3.getRecordDisplayCombo().getText().substring(0, 1));
            outputOptions.add(2, CompareWizardPage3.getFieldDisplayCombo().getText().substring(0, 1));
            RunGetCompareReport runner = new RunGetCompareReport(this.server, datasets, members, outputOptions, layoutMembers, selCrit, positions, false, !this.memberNameCombo.getText().isEmpty());
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xml = runner.getXml();
            this.handleResponse(xml);
        } else {
            CompareProgramPage3 cpp3 = (CompareProgramPage3)this.getWizard().getPage("Compare Program Options");
            outputOptions.add(0, cpp3.getPrintCombo().getText().substring(0, 1));
            outputOptions.add(1, cpp3.getRecordDisplayCombo().getText().substring(0, 1));
            outputOptions.add(2, cpp3.getFieldDisplayCombo().getText().substring(0, 1));
            outputOptions.add(3, cpp3.getMaxMismatchesSpinner().getText());
            outputOptions.add(4, cpp3.getOutputPageSizeSpinner().getText());
            outputOptions.add(5, cpp3.getProperties().getText().substring(0, 1));
            outputOptions.add(cpp3.getCsectComp().getText().substring(3, 4).toUpperCase());
            String CSECTInclude = cpp3.getIncludeText().trim();
            String CSECTExclude = cpp3.getExcludeText().trim();
            HashMap<String, Object> mapCSECTOptions = cpp3.OptionValues();
            RunGetCompareReport runner = new RunGetCompareReport(this.server, datasets, members, outputOptions, mapCSECTOptions, CSECTInclude, CSECTExclude, true, !this.memberNameCombo.getText().isEmpty());
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xml = runner.getXml();
            this.handleResponse(xml);
        }
        FMHistory.insertHistory(((CompareWizardPage1)this.getPreviousPage()).getMemberNameCombo(), "MemberNameComboCompareWizardPage1");
        FMHistory.insertHistory(this.dataSetCombo, "DataSetComboCompareWizardPage2");
        FMHistory.insertHistory(this.memberNameCombo, "MemberNameComboCompareWizardPage2");
        if (!(this.getWizard().getPages()[3] instanceof ProgramCompareSummaryPage) && this.getWizard().getPages()[4] instanceof CompareWizardPage5) {
            FMHistory.insertHistory(((CompareWizardPage3)this.getNextPage()).getOldDataSetCombo(), "OldDataSetComboCompareWizardPage3");
            FMHistory.insertHistory(((CompareWizardPage3)this.getNextPage()).getOldMemberNameCombo(), "OldMemberNameComboCompareWizardPage3");
            FMHistory.insertHistory(((CompareWizardPage3)this.getNextPage()).getNewDataSetCombo(), "NewDataSetComboCompareWizardPage3");
            FMHistory.insertHistory(((CompareWizardPage3)this.getNextPage()).getNewMemberNameCombo(), "NewMemberNameComboCompareWizardPage3");
        }
        return true;
    }

    private void handleResponse(XMLRequest xml) {
        IViewPart reportView = null;
        ArrayList<String> contentAL = new ArrayList<String>();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList nodes = element.getElementsByTagName("Line");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + CompareWizardPage2.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = CompareWizardPage2.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                } else {
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element lineElement = (Element)nodes.item(i);
                        String line = new String();
                        line = CompareWizardPage2.getTagValue("Line", lineElement);
                        contentAL.add(line);
                        ++i;
                    }
                    reportView = super.updateReportsView(contentAL.toArray(new String[contentAL.size()]));
                }
            }
            if (element.getElementsByTagName("SYSLISTDSN").getLength() > 0) {
                this.handleSyslist(element, reportView);
            }
        }
    }

    public void handleSyslist(Element element, IViewPart reportView) {
        NodeList sysDsn = element.getElementsByTagName("SYSLISTDSN");
        Node sysDsnNode = sysDsn.item(0);
        Element sysDsnElement = (Element)sysDsnNode;
        this.sysDSNVal = CompareWizardPage2.getTagValue("SYSLISTDSN", sysDsnElement);
        if (reportView instanceof ReportView) {
            ((ReportView)reportView).setDataset(CommonMFCalls.getFQDSN(this.sysDSNVal, "", this.server));
            ((ReportView)reportView).setServer(this.server);
            ((ReportView)reportView).setSysDSN(this.sysDSNVal);
            ((ReportView)reportView).setFocus();
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    @Override
    public Combo getDataSetCombo() {
        return this.dataSetCombo;
    }

    public Combo getMemberNameCombo() {
        return this.memberNameCombo;
    }

    public String getMembersName() {
        String members = "";
        TableItem[] obj = this.tableViewer.getTable().getItems();
        if (obj.length > 0) {
            int i = 0;
            while (i < obj.length) {
                members = String.valueOf(members) + ((FileMasterMember)((Object)obj[i].getData())).getName() + " ";
                ++i;
            }
            return members;
        }
        return this.memberNameCombo.getText();
    }

    public void setIsComparePgm(boolean isComparePGM) {
        this.isComparePGM = isComparePGM;
    }

    private void displaySummaryPage() {
        if (this.isComparePGM) {
            this.programCompareSummaryPage.presetText();
            this.getWizard().getContainer().showPage((IWizardPage)this.programCompareSummaryPage);
        } else {
            this.standardCompareSummaryPage.presetText();
            this.getWizard().getContainer().showPage((IWizardPage)this.standardCompareSummaryPage);
        }
    }

    private void changePreviewToFinish() {
        IWizardPage page = this.getWizard().getContainer().getCurrentPage();
        if (page instanceof CompareWizardPage4 || page instanceof CompareProgramPage3) {
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Finish");
            this.map.put("Action", "Finish");
        }
    }

    private void changeFinishToPreview() {
        if (this.map.get("Action") == "Finish") {
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Preview");
            this.map.put("Action", "Preview");
        }
    }

    public void insertDSNToField(String value) {
        this.dataSetCombo.setText(value);
    }

    public void insertIntoDirecotryList() {
        String typeOfDSN = "";
        if (this.DirListInsert.getSelection()) {
            int numCheckedMembers;
            FileMasterDataset fmdataset = new FileMasterDataset(null);
            fmdataset.setName(this.dataSetCombo.getText());
            if (fmdataset != null && fmdataset.getName().equalsIgnoreCase(this.dataSetCombo.getText().trim())) {
                typeOfDSN = fmdataset.getDsOrg();
                FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN(this.dataSetCombo.getText(), "", this.server);
                if (CommonMFCalls.RETURN_CODE.equals("0")) {
                    typeOfDSN = FMDataSet.getDsOrg();
                    if (typeOfDSN.trim().isEmpty()) {
                        typeOfDSN = fmdataset.getFileType();
                    }
                } else {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + CommonMFCalls.RETURN_CODE), (Throwable)new Throwable(CommonMFCalls.MESSAGE));
                }
            }
            if (typeOfDSN.isEmpty()) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)"Archived data set");
            }
            fmdataset.setDsOrg(typeOfDSN);
            TT_TreeItem dsItem = null;
            int index = 0;
            int i = 0;
            while (i < this.model.getServers().length) {
                if (this.model.getServers()[i].getName().equals(this.server.getName())) {
                    index = i;
                    break;
                }
                ++i;
            }
            dsItem = this.model.findObjectInTree((Object)fmdataset, this.model.getServers()[index]);
            if (dsItem == null) {
                Element dsElement = this.model.addDataset(this.server.getElement(), fmdataset);
                dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
            }
            if ((numCheckedMembers = this.tableViewer.getTable().getItemCount()) > 0) {
                int i2 = 0;
                while (i2 < numCheckedMembers) {
                    this.insertMemberToTree(dsItem, this.tableViewer.getTable().getItems()[i2].getText(0));
                    ++i2;
                }
            } else {
                this.insertMemberToTree(dsItem, this.memberNameCombo.getText().trim());
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Shell shell = window.getShell();
            shell.setMinimized(false);
            shell.forceActive();
            shell.forceFocus();
            try {
                TreeViewer viewer;
                IWorkbenchPage page = window.getActivePage();
                IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
                if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                    viewer.refresh(true);
                    view = page.showView("com.ca.filemaster.views.directorylist");
                    page.activate((IWorkbenchPart)view);
                    page.bringToTop((IWorkbenchPart)view);
                    view.setFocus();
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
            this.model.save();
        }
    }

    private void insertMemberToTree(TT_TreeItem dsItem, String name) {
        boolean isDuplicatedMember = false;
        FileMasterMember fmmember = new FileMasterMember(null);
        if (name.length() != 0) {
            fmmember.setName(name.trim());
            fmmember.setType("MEMBER");
            if (this.model.findObjectInTree((Object)fmmember, dsItem) != null) {
                isDuplicatedMember = true;
            }
            if (!isDuplicatedMember) {
                Element memItem = this.model.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
                this.model.insertMember(dsItem, memItem);
            }
        }
    }

    public void insertMemberToField(String value) {
        this.memberNameCombo.setText(value);
    }
}

