/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.compare;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.utility.compare.CompareProgramPage3;
import com.ca.filemaster.utility.compare.CompareWizardPage1;
import com.ca.filemaster.utility.compare.CompareWizardPage2;
import com.ca.filemaster.utility.compare.CompareWizardPage3;
import com.ca.filemaster.utility.compare.CompareWizardPage4;
import com.ca.filemaster.utility.compare.CompareWizardPage5;
import com.ca.filemaster.utility.compare.FMTreeItemHelper;
import com.ca.filemaster.utility.compare.ProgramCompareSummaryPage;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CompareWizard
extends Wizard
implements INewWizard {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private IStructuredSelection selection;
    private CompareWizardPage1 page1;
    private CompareWizardPage2 page2;
    private CompareWizardPage4 page4;
    private CompareWizardPage5 page5;
    private CompareProgramPage3 page3Pgm;
    private ProgramCompareSummaryPage summaryPage;
    private TT_TreeItem[] treeItems;
    private Map<String, String> map;
    private String dataSetType;
    private boolean isPgm;
    private FileMasterServer server;
    private FileMasterDataset dataSet;
    private FileMasterMember member;

    public CompareWizard() {
        this.setWindowTitle("New Wizard");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Compare Data Set Utility");
        this.selection = selection;
        TrayDialog.setDialogHelpAvailable((boolean)true);
        this.isPgm = false;
    }

    public void addPages() {
        this.treeItems = new TT_TreeItem[2];
        if (this.selection != null && !this.selection.isEmpty()) {
            Iterator it = this.selection.iterator();
            int i = 0;
            while (it.hasNext()) {
                this.treeItems[i] = (TT_TreeItem)it.next();
                ++i;
            }
        }
        this.dataSetType = FMTreeItemHelper.checkDataSetType(this.treeItems[0]);
        TrayDialog.setDialogHelpAvailable((boolean)true);
        String layoutDS = "";
        String layoutMem = "";
        if (this.selection.getFirstElement() != null) {
            TT_TreeItem treeItem = (TT_TreeItem)this.selection.getFirstElement();
            if (treeItem.getParent() == null) {
                this.server = (FileMasterServer)treeItem.getValue();
            } else if (treeItem.getParent().getParent() == null) {
                this.dataSet = (FileMasterDataset)treeItem.getValue();
                this.server = (FileMasterServer)treeItem.getParent().getValue();
                layoutDS = treeItem.getElement().getAttribute("layoutDS");
                layoutMem = treeItem.getElement().getAttribute("layoutMem");
                this.dataSet = CommonMFCalls.getFQDSN(this.dataSet.getName(), "", this.server);
                if ((this.dataSet.getDsOrg().equalsIgnoreCase("PDS") || this.dataSet.getDsOrg().equalsIgnoreCase("PDSE")) && this.dataSet.getRecfm().equalsIgnoreCase("U")) {
                    this.setWindowTitle("Compare Program Utility");
                    this.isPgm = true;
                }
                if (this.dataSet.getDsOrg().equalsIgnoreCase("VSAM")) {
                    this.dataSet.setName(((FMPVSAMDataset)this.dataSet).getCluster());
                }
            } else if (treeItem.getParent().getParent().getParent() == null) {
                this.server = (FileMasterServer)treeItem.getParent().getParent().getValue();
                this.dataSet = (FileMasterDataset)treeItem.getParent().getValue();
                this.member = (FileMasterMember)treeItem.getValue();
                layoutDS = treeItem.getElement().getAttribute("layoutDS");
                layoutMem = treeItem.getElement().getAttribute("layoutMem");
                this.dataSet = CommonMFCalls.getFQDSN(this.dataSet.getName(), "", this.server);
                if ((this.dataSet.getDsOrg().equalsIgnoreCase("PDS") || this.dataSet.getDsOrg().equalsIgnoreCase("PDSE")) && this.dataSet.getRecfm().equalsIgnoreCase("U")) {
                    this.setWindowTitle("Compare Program Utility");
                    this.isPgm = true;
                }
            }
        }
        this.page1 = new CompareWizardPage1("Old Data Set", this.server, this.dataSet, this.member, this.dataSetType);
        this.map = new HashMap<String, String>();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new CompareWizardPage2("New Data Set", this.server, this.dataSet, this.map, this.isPgm);
        this.addPage((IWizardPage)this.page2);
        if (this.isPgm) {
            this.page3Pgm = new CompareProgramPage3("Compare Program Options");
            this.summaryPage = new ProgramCompareSummaryPage();
            this.addPage((IWizardPage)this.page3Pgm);
            this.addPage((IWizardPage)this.summaryPage);
        } else {
            this.addPage((IWizardPage)new CompareWizardPage3("Options", this.server, layoutDS, layoutMem));
            this.page4 = new CompareWizardPage4();
            this.addPage((IWizardPage)this.page4);
            this.page5 = new CompareWizardPage5();
            this.addPage((IWizardPage)this.page5);
        }
    }

    public boolean performFinish() {
        return this.page2.doFinish();
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() instanceof CompareWizardPage1) {
            return false;
        }
        if (this.isPgm) {
            return this.page2.isPageComplete() && this.page2.getNextPage().isPageComplete() && this.page3Pgm.isPageComplete();
        }
        return this.page2.isPageComplete() && this.page2.getNextPage().isPageComplete() && this.page4.isPageComplete();
    }
}

