/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utilities;

import com.ca.filemaster.ConfigureSettingsWizardPageOne;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.runners.RunGetCreateFile;
import com.ca.filemaster.ui.wizards.AllocateDatasetWizardPage1;
import com.ca.filemaster.utilities.AllocateNewDataSetWizardPage1;
import com.ca.filemaster.utilities.MultipleVolumeSeqWizard;
import com.ca.filemaster.utility.copy.CopyPDSFromWizardPage;
import com.ca.filemaster.utility.copy.CopyPDSToWizardPage;
import com.ca.filemaster.utility.copy.CopySeqFromWizardPage;
import com.ca.filemaster.utility.copy.CopySeqToWizardPage;
import com.ca.filemaster.utility.copy.CopyVSAMToWizardPage;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageThree;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AllocateNewDataSetWizardPage2
extends WizardPage
implements ModifyListener,
SelectionListener {
    static final String cacopyright = "Copyright \ufffd 2011 CA";
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.allocateNewDataSetWizardPageOne";
    private final String CONTEXT_HELP_IDSEQ = "com.ca.filemaster.help.allocateNewDataSetSEQPageOne";
    private Composite container;
    private String error;
    private String newDatasetName;
    private boolean showError = false;
    private Spinner primaryAllocationSpinner;
    private Spinner secondaryAllocationSpinner;
    private Spinner blockSizeSpinner;
    private Spinner recordLengthSpinner;
    private Spinner directoryBlocksSpinner;
    private Label directoryBlocksLabel;
    private Label placeHolder;
    private Combo recordFormatCombo;
    private Button pdsRadio;
    private Button pdseRadio;
    private Button seqRadio;
    private Button largeRadio;
    private Button tracksRadio;
    private Button cylindersRadio;
    private Button blocksRadio;
    private Button noneRadio;
    private Button permRadio;
    private Button expirationRadio;
    private Button multipleVolumeCheck;
    private Button editMultipleVolumeButton;
    private Button useOptimalBlockSize;
    private DateTime dateTime;
    private boolean isPDS = true;
    FileMasterDataset fmDSN = new FileMasterDataset(null);

    public AllocateNewDataSetWizardPage2(boolean isPDS, String newDatasetName) {
        super(isPDS ? "allocateNewPDSDataSetWizardPage2" : "allocateNewSeqDataSetWizardPage2");
        this.isPDS = isPDS;
        this.newDatasetName = newDatasetName;
        if (isPDS) {
            this.setTitle("Allocate New Partitioned Data Set (Page 2 of 2)");
        } else {
            this.setTitle("Allocate New Sequential Data Set (Page 2 of 2)");
        }
        this.setDescription("New data set allocation parameters");
    }

    protected AllocateNewDataSetWizardPage2() {
        super("allocateNewPDSDataSetWizardPage2");
        this.setTitle("Allocate New Sequential Or Partitioned Data Set (Page 2 of 2)");
        this.setDescription("New data set allocation parameters");
    }

    public AllocateNewDataSetWizardPage2(boolean isPDS, Combo modelDataSetNameCombo, String newDatasetName) {
        super(isPDS ? "allocateNewPDSDataSetWizardPage2" : "allocateNewSeqDataSetWizardPage2");
        this.isPDS = isPDS;
        this.newDatasetName = newDatasetName;
        if (isPDS) {
            this.setTitle("Allocate New Partitioned Data Set (Page 2 of 2)");
        } else {
            this.setTitle("Allocate New Sequential Data Set (Page 2 of 2)");
        }
        this.setDescription("New data set allocation parameters");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0x1000000);
        this.container.setSize(this.container.computeSize(-1, -1));
        this.container.setLayout((Layout)new GridLayout(1, false));
        Group dataSetTypeGroup = new Group(this.container, 0);
        dataSetTypeGroup.setSize(dataSetTypeGroup.computeSize(-1, -1));
        dataSetTypeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        dataSetTypeGroup.setText("Data set type");
        dataSetTypeGroup.setLayout((Layout)new GridLayout(4, false));
        if (this.isPDS) {
            this.pdsRadio = new Button((Composite)dataSetTypeGroup, 16);
            this.pdsRadio.setText("&PDS");
            this.pdsRadio.setSelection(true);
            this.pdsRadio.addSelectionListener((SelectionListener)this);
            this.pdseRadio = new Button((Composite)dataSetTypeGroup, 16);
            this.pdseRadio.setText("PD&SE");
            this.pdseRadio.addSelectionListener((SelectionListener)this);
        } else {
            this.seqRadio = new Button((Composite)dataSetTypeGroup, 16);
            this.seqRadio.setText("SE&Q");
            this.seqRadio.setSelection(true);
            this.seqRadio.addSelectionListener((SelectionListener)this);
            this.largeRadio = new Button((Composite)dataSetTypeGroup, 16);
            this.largeRadio.setText("LAR&GE");
            this.largeRadio.addSelectionListener((SelectionListener)this);
        }
        Group spaceAllocationUnitGroup = new Group(this.container, 0);
        spaceAllocationUnitGroup.setSize(spaceAllocationUnitGroup.computeSize(-1, -1));
        spaceAllocationUnitGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        spaceAllocationUnitGroup.setText("Space allocation units");
        spaceAllocationUnitGroup.setLayout((Layout)new GridLayout(3, false));
        this.tracksRadio = new Button((Composite)spaceAllocationUnitGroup, 16);
        this.tracksRadio.setToolTipText("");
        this.tracksRadio.setSelection(true);
        this.tracksRadio.setText("&Tracks");
        this.cylindersRadio = new Button((Composite)spaceAllocationUnitGroup, 16);
        this.cylindersRadio.setText("&Cylinders");
        this.blocksRadio = new Button((Composite)spaceAllocationUnitGroup, 16);
        this.blocksRadio.setText("B&locks");
        Group allocationParametersGroup = new Group(this.container, 0);
        allocationParametersGroup.setSize(allocationParametersGroup.computeSize(-1, -1));
        allocationParametersGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        allocationParametersGroup.setText("Allocation parameters");
        allocationParametersGroup.setLayout((Layout)new GridLayout(3, false));
        Label primaryAllocationLabel = new Label((Composite)allocationParametersGroup, 0);
        primaryAllocationLabel.setText("Primary &allocation:");
        this.primaryAllocationSpinner = new Spinner((Composite)allocationParametersGroup, 2048);
        this.primaryAllocationSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.primaryAllocationSpinner.setMinimum(0);
        this.primaryAllocationSpinner.setMaximum(Integer.MAX_VALUE);
        this.primaryAllocationSpinner.setTextLimit(9);
        this.primaryAllocationSpinner.setSelection(1);
        this.primaryAllocationSpinner.addModifyListener((ModifyListener)this);
        this.placeHolder = new Label((Composite)allocationParametersGroup, 0);
        this.placeHolder.setText("");
        Label secondaryAllocationLabel = new Label((Composite)allocationParametersGroup, 0);
        secondaryAllocationLabel.setText("Secondar&y allocation:");
        this.secondaryAllocationSpinner = new Spinner((Composite)allocationParametersGroup, 2048);
        this.secondaryAllocationSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.secondaryAllocationSpinner.setMinimum(0);
        this.secondaryAllocationSpinner.setMaximum(Integer.MAX_VALUE);
        this.secondaryAllocationSpinner.setTextLimit(9);
        this.secondaryAllocationSpinner.addModifyListener((ModifyListener)this);
        this.placeHolder = new Label((Composite)allocationParametersGroup, 0);
        this.placeHolder.setText("");
        if (this.isPDS) {
            this.directoryBlocksLabel = new Label((Composite)allocationParametersGroup, 0);
            this.directoryBlocksLabel.setText("Directory bloc&ks:");
            this.directoryBlocksSpinner = new Spinner((Composite)allocationParametersGroup, 2048);
            this.directoryBlocksSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.directoryBlocksSpinner.setMinimum(0);
            this.directoryBlocksSpinner.setMaximum(Integer.MAX_VALUE);
            this.directoryBlocksSpinner.setSelection(1);
            this.directoryBlocksSpinner.setTextLimit(8);
            this.directoryBlocksSpinner.addModifyListener((ModifyListener)this);
            this.directoryBlocksSpinner.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            this.placeHolder = new Label((Composite)allocationParametersGroup, 0);
            this.placeHolder.setText("");
        }
        Label recordFormatLabel = new Label((Composite)allocationParametersGroup, 0);
        recordFormatLabel.setText("&Record format:");
        this.recordFormatCombo = new Combo((Composite)allocationParametersGroup, 8);
        this.recordFormatCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.recordFormatCombo.setItems(new String[]{"F", "FB", "FBA", "FBM", "FBS", "U", "V", "VB", "VBA", "VBM", "VBS"});
        TextUtil.setWidth((Combo)this.recordFormatCombo, (int)8);
        this.recordFormatCombo.select(1);
        this.placeHolder = new Label((Composite)allocationParametersGroup, 0);
        this.placeHolder.setText("");
        Label recordLengthLabel = new Label((Composite)allocationParametersGroup, 0);
        recordLengthLabel.setText("Record lengt&h:");
        this.recordLengthSpinner = new Spinner((Composite)allocationParametersGroup, 2048);
        this.recordLengthSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.recordLengthSpinner.setMinimum(0);
        this.recordLengthSpinner.setMaximum(Integer.MAX_VALUE);
        this.recordLengthSpinner.setSelection(80);
        this.recordLengthSpinner.setTextLimit(9);
        this.recordLengthSpinner.addModifyListener((ModifyListener)this);
        this.placeHolder = new Label((Composite)allocationParametersGroup, 0);
        this.placeHolder.setText("");
        Label blockSizeLabel = new Label((Composite)allocationParametersGroup, 0);
        blockSizeLabel.setText("Block si&ze:");
        this.blockSizeSpinner = new Spinner((Composite)allocationParametersGroup, 2048);
        this.blockSizeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.blockSizeSpinner.setMinimum(1);
        this.blockSizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.blockSizeSpinner.setSelection(32720);
        this.blockSizeSpinner.addModifyListener((ModifyListener)this);
        this.blockSizeSpinner.setTextLimit(9);
        this.useOptimalBlockSize = new Button((Composite)allocationParametersGroup, 32);
        this.useOptimalBlockSize.setText("&Use optimal value");
        this.useOptimalBlockSize.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AllocateNewDataSetWizardPage2.this.setPageComplete(AllocateNewDataSetWizardPage2.this.isPageComplete());
                if (AllocateNewDataSetWizardPage2.this.useOptimalBlockSize.getSelection()) {
                    AllocateNewDataSetWizardPage2.this.blockSizeSpinner.setEnabled(false);
                } else {
                    AllocateNewDataSetWizardPage2.this.blockSizeSpinner.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (!this.isPDS) {
            this.multipleVolumeCheck = new Button((Composite)allocationParametersGroup, 32);
            this.multipleVolumeCheck.setText("&Multiple volumes");
            this.multipleVolumeCheck.addSelectionListener((SelectionListener)this);
            this.editMultipleVolumeButton = new Button((Composite)allocationParametersGroup, 0);
            this.editMultipleVolumeButton.setEnabled(false);
            this.editMultipleVolumeButton.setText("&Edit...        ");
            this.editMultipleVolumeButton.addSelectionListener((SelectionListener)this);
        }
        this.tracksRadio.addSelectionListener((SelectionListener)this);
        this.cylindersRadio.addSelectionListener((SelectionListener)this);
        this.blocksRadio.addSelectionListener((SelectionListener)this);
        this.recordFormatCombo.addModifyListener((ModifyListener)this);
        this.setPageComplete(this.isPageComplete());
        if (this.isPDS) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.allocateNewDataSetWizardPageOne");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.allocateNewDataSetSEQPageOne");
        }
        this.setControl((Control)this.container);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
        if (this.getShell().getParent().getData() instanceof TestingToolsWizardDialog) {
            IWizardPage page = ((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage().getPreviousPage();
            if (page instanceof CopySeqFromWizardPage && !this.isPDS) {
                ((AllocateNewDataSetWizardPage1)this.getPreviousPage()).setModelParameters(((CopySeqFromWizardPage)page).getFromDataSet());
            } else if (page instanceof CopyPDSFromWizardPage && this.isPDS) {
                ((AllocateNewDataSetWizardPage1)this.getPreviousPage()).setModelParameters(((CopyPDSFromWizardPage)page).getFromDataSet());
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isPDS && (e.getSource() == this.pdsRadio || e.getSource() == this.pdseRadio)) {
            this.setPageComplete(this.isPageComplete());
            if (e.getSource() == this.pdsRadio) {
                this.directoryBlocksSpinner.setEnabled(true);
            }
            if (e.getSource() == this.pdseRadio) {
                this.directoryBlocksSpinner.setSelection(0);
                this.directoryBlocksSpinner.setEnabled(false);
            }
        } else if (e.getSource() == this.tracksRadio || e.getSource() == this.cylindersRadio || e.getSource() == this.blocksRadio) {
            this.setPageComplete(this.isPageComplete());
        } else if (e.getSource() == this.noneRadio || e.getSource() == this.permRadio) {
            this.dateTime.setEnabled(false);
        } else if (e.getSource() == this.expirationRadio) {
            this.dateTime.setEnabled(true);
        } else if (!this.isPDS) {
            if (e.getSource() == this.seqRadio || e.getSource() == this.largeRadio) {
                this.setPageComplete(this.isPageComplete());
            }
            if (e.getSource() == this.multipleVolumeCheck) {
                if (this.editMultipleVolumeButton.isEnabled()) {
                    this.editMultipleVolumeButton.setEnabled(false);
                } else {
                    this.editMultipleVolumeButton.setEnabled(true);
                }
                if (!this.editMultipleVolumeButton.getSelection()) {
                    ArrayList<String> serials = new ArrayList<String>();
                    serials.add(((AllocateNewDataSetWizardPage1)this.getPreviousPage()).getVolumeSerial());
                    this.fmDSN.setVolSerials(serials);
                    this.fmDSN.setNumVolumes("1");
                }
            }
            if (e.getSource() == this.editMultipleVolumeButton) {
                AllocateNewDataSetWizardPage1 page1 = (AllocateNewDataSetWizardPage1)this.getPreviousPage();
                MultipleVolumeSeqWizard wizard = new MultipleVolumeSeqWizard(page1.useNumberOfVolumes(), this);
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean isPageComplete() {
        this.error = "";
        this.showError = false;
        if (this.primaryAllocationSpinner != null && this.secondaryAllocationSpinner != null && this.recordLengthSpinner != null && this.blockSizeSpinner != null && this.cylindersRadio != null && this.blocksRadio != null && this.tracksRadio != null) {
            int primaryAllocation = this.primaryAllocationSpinner.getSelection();
            int secondaryAllocation = this.secondaryAllocationSpinner.getSelection();
            int recordLength = this.recordLengthSpinner.getSelection();
            int blockSize = this.blockSizeSpinner.getSelection();
            if ((this.cylindersRadio.getSelection() || this.blocksRadio.getSelection()) && primaryAllocation > 0xFFFFFF) {
                this.error = String.valueOf(this.error) + "Primary allocation value is too high\n ";
                this.showError = true;
            }
            boolean isPDSEOrLARGE = false;
            if (this.isPDS) {
                if (this.pdseRadio == null) {
                    return true;
                }
                if (this.pdseRadio.getSelection()) {
                    isPDSEOrLARGE = true;
                } else if (!this.directoryBlocksSpinner.getText().isEmpty() && this.directoryBlocksSpinner.getText().trim().substring(0, 1).equalsIgnoreCase("0")) {
                    this.setErrorMessage("Minimum directory block size for PDS is 1");
                    return false;
                }
            } else {
                if (this.largeRadio == null) {
                    return true;
                }
                if (this.largeRadio.getSelection()) {
                    isPDSEOrLARGE = true;
                }
            }
            if (this.tracksRadio.getSelection() && primaryAllocation > 65535 && !isPDSEOrLARGE) {
                this.error = String.valueOf(this.error) + "Primary allocation value is too high\n ";
                this.showError = true;
            }
            if (this.tracksRadio.getSelection() && primaryAllocation > 0xFFFFFF && isPDSEOrLARGE) {
                this.error = String.valueOf(this.error) + "Primary allocation value is too high\n ";
                this.showError = true;
            }
            if (secondaryAllocation > 0xFFFFFF) {
                this.error = String.valueOf(this.error) + "Secondary allocation value is too high\n ";
                this.showError = true;
            }
            if (!(recordLength != 0 || this.isPDS && this.pdseRadio.getSelection() && this.recordFormatCombo.getText().startsWith("U"))) {
                AllocateNewDataSetWizardPage1 page1 = (AllocateNewDataSetWizardPage1)this.getPreviousPage();
                if (!page1.modelDataset.getDsType().equalsIgnoreCase("L")) {
                    this.error = String.valueOf(this.error) + "Record length value must be greater than zero\n ";
                    this.showError = true;
                }
            }
            if (recordLength > 32760) {
                this.error = String.valueOf(this.error) + "Record length value is too high\n ";
                this.showError = true;
            }
            if (!this.useOptimalBlockSize.getSelection()) {
                if (blockSize < recordLength && !this.recordFormatCombo.getText().startsWith("F") && !this.recordFormatCombo.getText().startsWith("V")) {
                    this.error = String.valueOf(this.error) + "Block size must be equal or greater then record length\n ";
                    this.showError = true;
                }
                if (recordLength != 0 && this.recordFormatCombo.getText().startsWith("F") && blockSize % recordLength > 0 && !this.useOptimalBlockSize.getSelection()) {
                    this.error = String.valueOf(this.error) + "Block size must be multiple of record length\n ";
                    this.showError = true;
                }
                if (this.recordFormatCombo.getText().startsWith("V") && blockSize < recordLength + 4) {
                    this.error = String.valueOf(this.error) + "Minimal block size value is record length + 4\n ";
                    this.showError = true;
                }
            }
            if (this.showError) {
                this.setErrorMessage(this.error);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean doFinish() {
        FMHistory.insertHistory(((AllocateNewDataSetWizardPage1)this.getPreviousPage()).getModelDataSetNameText(), "modelDataSetNameList");
        if ((AllocateDatasetWizardPage1)this.getWizard().getPage("Allocate Data Set") != null) {
            ((AllocateDatasetWizardPage1)this.getWizard().getPage("Allocate Data Set")).doFinish();
        }
        if (this.getShell().getParent().getData() instanceof TestingToolsWizardDialog) {
            if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof CopyPDSToWizardPage) {
                ((CopyPDSToWizardPage)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setDisp("SHR");
            } else if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof CopySeqToWizardPage) {
                ((CopySeqToWizardPage)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setDisp("SHR");
            } else if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof CopyVSAMToWizardPage) {
                ((CopyVSAMToWizardPage)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setDisp("SHR");
            } else if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof ConfigureSettingsWizardPageOne) {
                if (((ConfigureSettingsWizardPageOne)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).getActiveTabIndex() == 3) {
                    ((ConfigureSettingsWizardPageOne)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setPrintTabDisp("SHR");
                }
            } else if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof PrintUtilityWizardPageThree) {
                ((PrintUtilityWizardPageThree)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setDisp("SHR");
            }
        }
        AllocateNewDataSetWizardPage1 allocateNewDataSetWizardPage1 = (AllocateNewDataSetWizardPage1)this.getPreviousPage();
        FileMasterServer server = allocateNewDataSetWizardPage1.getServer();
        this.fmDSN.setName(allocateNewDataSetWizardPage1.getNewDataSetName());
        if (!this.isPDS && !this.multipleVolumeCheck.getSelection()) {
            this.fmDSN.setNumVolumes("1");
        }
        if (this.isPDS) {
            if (this.pdseRadio == null) {
                this.fmDSN.setFileType("PDS");
            } else if (this.pdsRadio.getSelection()) {
                this.fmDSN.setFileType("PDS");
            } else if (this.pdseRadio.getSelection()) {
                this.fmDSN.setFileType("PDSE");
            }
        } else if (this.seqRadio.getSelection()) {
            this.fmDSN.setFileType("SEQ");
        } else if (this.largeRadio.getSelection()) {
            this.fmDSN.setFileType("LARGE");
        }
        if (this.tracksRadio == null) {
            this.fmDSN.setUnits("trk");
        } else if (this.tracksRadio.getSelection()) {
            this.fmDSN.setUnits("trk");
        } else if (this.cylindersRadio.getSelection()) {
            this.fmDSN.setUnits("cyl");
        } else if (this.blocksRadio.getSelection()) {
            this.fmDSN.setUnits("blk");
        }
        if (this.primaryAllocationSpinner == null) {
            this.fmDSN.setPrimaryAlloc("1");
        } else {
            this.fmDSN.setPrimaryAlloc(Integer.valueOf(this.primaryAllocationSpinner.getText()).toString());
        }
        if (this.secondaryAllocationSpinner == null) {
            this.fmDSN.setSecondaryAlloc("0");
        } else {
            this.fmDSN.setSecondaryAlloc(Integer.valueOf(this.secondaryAllocationSpinner.getText()).toString());
        }
        if (this.isPDS) {
            if (this.directoryBlocksSpinner == null) {
                this.fmDSN.setDirBlocks("1");
            } else {
                this.fmDSN.setDirBlocks(this.directoryBlocksSpinner.getText());
            }
        }
        if (this.recordFormatCombo == null) {
            this.fmDSN.setRecfm("FB");
        } else {
            this.fmDSN.setRecfm(this.recordFormatCombo.getText());
        }
        if (this.recordLengthSpinner == null) {
            this.fmDSN.setLrecl("80");
        } else {
            this.fmDSN.setLrecl(this.recordLengthSpinner.getText());
        }
        if (this.useOptimalBlockSize == null) {
            this.fmDSN.setBlksize("32720");
        } else if (this.useOptimalBlockSize.getSelection()) {
            this.fmDSN.setBlksize("");
        } else {
            this.fmDSN.setBlksize(this.blockSizeSpinner.getText());
        }
        this.fmDSN.setIsSMSdataset(!allocateNewDataSetWizardPage1.getUseNonSMS());
        this.fmDSN.setUsesVolumeSerial(allocateNewDataSetWizardPage1.getUseVolumeSerial());
        this.fmDSN.setHasMultipleVolumes(false);
        if (!this.isPDS) {
            this.fmDSN.setHasMultipleVolumes(this.multipleVolumeCheck.getSelection());
        }
        if (!this.fmDSN.isSMSdataset()) {
            if (!this.fmDSN.usesVolumeSerial()) {
                this.fmDSN.setGenericUnitName(allocateNewDataSetWizardPage1.getGenericUnitName());
            } else if (this.fmDSN.getVolSerials().size() > 0) {
                this.fmDSN.getVolSerials().set(0, allocateNewDataSetWizardPage1.getVolumeSerial());
            } else {
                this.fmDSN.getVolSerials().add(allocateNewDataSetWizardPage1.getVolumeSerial());
            }
        } else {
            this.fmDSN.setSmsManagement(allocateNewDataSetWizardPage1.getManagementClass());
            this.fmDSN.setSmsData(allocateNewDataSetWizardPage1.getDataClass());
            this.fmDSN.setSmsStorage(allocateNewDataSetWizardPage1.getStorageClass());
        }
        if (this.fmDSN.getFileType() == "PDS" || this.fmDSN.getFileType() == "PDSE") {
            if (this.directoryBlocksSpinner == null) {
                this.fmDSN.setDirBlocks("1");
            } else {
                this.fmDSN.setDirBlocks(this.directoryBlocksSpinner.getText());
            }
        }
        RunGetCreateFile runner = new RunGetCreateFile(server, this.fmDSN);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            NodeList retCode = element.getElementsByTagName("ReturnCode");
            Node rcNode = retCode.item(0);
            Element rcElement = (Element)rcNode;
            NodeList rcList = rcElement.getChildNodes();
            Node rcValue = rcList.item(0);
            String returnCode = rcValue.getNodeValue();
            if (returnCode.equals("0")) {
                MessageDialog.openInformation(null, (String)"Allocate Data Set", (String)("Data set named '" + this.newDatasetName + "' has been allocated"));
                return true;
            }
            String message = "";
            NodeList messages = element.getElementsByTagName("Message");
            int i = 0;
            while (i < messages.getLength()) {
                Node msgNode = messages.item(i);
                Element msgElement = (Element)msgNode;
                NodeList msgList = msgElement.getChildNodes();
                Node msgValue = msgList.item(0);
                message = String.valueOf(message) + msgValue.getNodeValue() + "\n";
                ++i;
            }
            TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
            return false;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.container.setFocus();
    }

    public void setCount(Integer count) {
        this.fmDSN.setNumVolumes(Integer.toString(count));
    }

    public void setSer(ArrayList<String> ser) {
        this.fmDSN.setVolSerials(ser);
    }

    public Integer getCount() {
        return Integer.valueOf(this.fmDSN.getNumVolumes());
    }

    public ArrayList<String> getSer() {
        return this.fmDSN.getVolSerials();
    }

    public void setModelParameters(FileMasterDataset model) {
        this.blocksRadio.setSelection(false);
        this.cylindersRadio.setSelection(false);
        this.tracksRadio.setSelection(false);
        if (model.getAllocatedallocUnit().equalsIgnoreCase("blk")) {
            this.blocksRadio.setSelection(true);
        } else if (model.getAllocatedallocUnit().equalsIgnoreCase("cyls")) {
            this.cylindersRadio.setSelection(true);
        } else if (model.getAllocatedallocUnit().equalsIgnoreCase("trk")) {
            this.tracksRadio.setSelection(true);
        }
        this.primaryAllocationSpinner.setSelection(Integer.valueOf(model.getPrimaryAlloc()).intValue());
        this.secondaryAllocationSpinner.setSelection(Integer.valueOf(model.getSecondaryAlloc()).intValue());
        this.recordFormatCombo.setText(model.getRecfm());
        this.recordLengthSpinner.setSelection(Integer.valueOf(model.getLrecl()).intValue());
        this.blockSizeSpinner.setSelection(Integer.valueOf(model.getBlksize()).intValue());
        if (this.isPDS) {
            if (model.getDsType().equalsIgnoreCase("P") || model.getDsType().equalsIgnoreCase("L")) {
                this.pdsRadio.setSelection(true);
                this.pdseRadio.setSelection(false);
                this.directoryBlocksSpinner.setEnabled(true);
            } else if (model.getDsType().equalsIgnoreCase("X")) {
                this.pdsRadio.setSelection(false);
                this.pdseRadio.setSelection(true);
                this.directoryBlocksSpinner.setSelection(0);
                this.directoryBlocksSpinner.setEnabled(false);
            }
            this.directoryBlocksSpinner.setSelection(model.getDsType().equalsIgnoreCase("X") ? 0 : Integer.valueOf(model.getDircMax()));
        } else {
            if (model.getSmsDsorg().equalsIgnoreCase("LARGE")) {
                this.largeRadio.setSelection(true);
                this.seqRadio.setSelection(false);
            } else if (model.getSmsDsorg().equalsIgnoreCase("SEQ")) {
                this.largeRadio.setSelection(false);
                this.seqRadio.setSelection(true);
            }
            this.multipleVolumeCheck.setSelection(false);
            this.editMultipleVolumeButton.setEnabled(false);
            if (model.usesVolumeSerial()) {
                this.fmDSN.setNumVolumes(String.valueOf(model.getVolumes().size()));
                this.fmDSN.setVolSerials(model.getVolumes());
                if (model.getVolumes().size() > 1) {
                    this.multipleVolumeCheck.setSelection(true);
                    this.editMultipleVolumeButton.setEnabled(true);
                }
            }
        }
    }

    public void updateDataSet(String dataSet) {
        this.newDatasetName = dataSet;
    }
}

