/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FMXMLProfile;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.runners.RunRenameFile;
import com.ca.filemaster.ui.wizards.RenameFileVariable;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenameWizardPage
extends WizardPage
implements ModifyListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.renameWizard";
    private Text memberText;
    private TT_TreeItem memberName;
    private TT_TreeItem serverName;
    private String datasetName;
    private String oldMemberName;
    private TT_TreeItem[] members;
    private String errorRename = "";
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private RenameFileVariable renameFileVariable = new RenameFileVariable();

    protected RenameWizardPage(TT_TreeItem memberName, TT_TreeItem datasetName, TT_TreeItem serverName, TT_TreeItem[] members) {
        super("wizardPage");
        this.setTitle("Rename " + memberName);
        this.setDescription("");
        if (memberName != null) {
            this.memberName = memberName;
            this.members = members;
        }
        this.serverName = serverName;
        this.datasetName = datasetName.getName();
        this.renameFileVariable.setOldDataset(datasetName.getName());
        this.renameFileVariable.setOldMember(memberName.getName());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setSize(container.computeSize(-1, -1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite memberComposite = new Composite(container, 0);
        memberComposite.setLayout((Layout)new GridLayout(2, false));
        memberComposite.setSize(memberComposite.computeSize(4, 4));
        memberComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.renameWizard");
        Label memberLabel = new Label(memberComposite, 0);
        memberLabel.setText("&New name:");
        this.memberText = new Text(memberComposite, 2048);
        TextUtil.setWidth((Text)this.memberText, (int)30);
        this.memberText.setText(this.memberName.getName());
        this.memberText.addModifyListener((ModifyListener)this);
        this.memberText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.memberText.getCursor();
        this.memberText.setFocus();
        this.memberText.setSelection(30);
        this.memberText.setTextLimit(8);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                Text t = (Text)e.widget;
                t.selectAll();
            }

            public void focusLost(FocusEvent e) {
                Text t = (Text)e.widget;
                if (t.getSelectionCount() > 0) {
                    t.clearSelection();
                }
            }
        };
        this.memberText.addFocusListener(focusListener);
        this.oldMemberName = String.valueOf(this.oldMemberName) + this.memberName.getName();
        this.getShell().getDefaultButton().setText("OK");
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    public boolean isPageComplete() {
        this.errorRename = new String();
        String input = this.memberText.getText();
        if (!(input = input.trim()).equalsIgnoreCase(this.memberName.getName())) {
            if (input.length() == 0) {
                this.errorRename = " Enter new member name \n";
                this.setErrorMessage(this.errorRename);
                return false;
            }
            if (!input.matches("[a-zA-Z#@$][a-zA-Z0-9#@$]{0,7}([;][a-zA-Z#@$][a-zA-Z0-9#@$]{0,7})*?") && !input.equals("\\*")) {
                this.errorRename = " The Rename has invalid format \n";
                this.setErrorMessage(this.errorRename);
                return false;
            }
            int i = 0;
            while (i < this.members.length) {
                if (input.equalsIgnoreCase(this.members[i].getName().trim())) {
                    this.errorRename = "A member with this name already exists \n";
                    this.setErrorMessage(this.errorRename);
                    return false;
                }
                ++i;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public void widgetSelected(SelectionEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean doFinish() {
        String newMemberName = this.memberText.getText().trim().toUpperCase();
        this.renameFileVariable.setNewMember(newMemberName);
        if (newMemberName == "") {
            newMemberName = this.memberName.getName();
            this.renameFileVariable.setNewMember(newMemberName);
        }
        FileMasterServer server = (FileMasterServer)this.serverName.getValue();
        RunRenameFile runner = new RunRenameFile(server, this.renameFileVariable);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element RenameFileResponse = xml.getRoot();
            String errorMessage = "";
            NodeList programReturnCode = RenameFileResponse.getElementsByTagName("MemberUtilityResponse");
            int returnCodeError = Integer.parseInt(((Element)programReturnCode.item(0)).getAttribute("programReturnCode"));
            NodeList messages = RenameFileResponse.getElementsByTagName("Message");
            int i = 0;
            while (i < messages.getLength()) {
                Node msgNode = messages.item(i);
                Element msgElement = (Element)msgNode;
                NodeList msgList = msgElement.getChildNodes();
                Node msgValue = msgList.item(0);
                errorMessage = msgValue.getNodeValue();
                ++i;
            }
            if (errorMessage.length() > 0 && returnCodeError > 0) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCodeError), (Throwable)new Throwable(errorMessage));
                errorMessage = new String();
                return false;
            }
            TT_TreeItem itemFound = this.model.dlistMap.remove((String.valueOf(server.getUUIDString()) + this.datasetName + this.memberName).hashCode());
            ((FileMasterMember)((Object)itemFound.getAdapter(FileMasterMember.class))).setName(newMemberName);
            this.model.getProfiles();
            FMXMLProfile.setName((Element)itemFound.getElement(), (String)this.renameFileVariable.getNewMember());
            this.model.dlistMap.put((String.valueOf(server.getUUIDString()) + this.datasetName + newMemberName).hashCode(), itemFound);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Shell shell = window.getShell();
            shell.setMinimized(false);
            shell.forceActive();
            shell.forceFocus();
            try {
                TreeViewer viewer;
                IWorkbenchPage page = window.getActivePage();
                IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
                if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                    TT_TreeItem selection = this.model.dlistMap.get((String.valueOf(server.getUUIDString()) + this.datasetName + newMemberName).hashCode());
                    TT_TreeItem parent = selection.getParent();
                    viewer.refresh((Object)parent, true);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                    view.setFocus();
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
            this.model.save();
            return true;
        }
        return false;
    }
}

