/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunPutSelectionMem
implements Runnable {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private FileMasterServer server;
    private String dataset;
    private String member;
    private static final String service = "filemaster/fmp";
    private XMLRequest xml = null;
    private boolean canRetry = true;
    Logger log = Logger.getLogger(this.getClass().getName());
    private String command;
    private String uuid;
    private String description;
    private ArrayList<String> processingParmMbrRecord = new ArrayList();
    private String writeExistingSelMbr = "N";

    public RunPutSelectionMem(FileMasterServer server, String dataset, String member, ArrayList<String> arrayList, String description, String writeExistingSelMbr) {
        this.server = server;
        this.member = member;
        this.dataset = dataset;
        this.processingParmMbrRecord = arrayList;
        this.description = description;
        this.writeExistingSelMbr = writeExistingSelMbr;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, service);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String uuid = FileMasterSession.getUUID(this.server, true);
            if (uuid != null) {
                long t1;
                map.put("uuid", uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                this.xml = connection.connect("putsel", map, false, this.createXMLPutSelMem());
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private XMLDocument createXMLPutSelMem() {
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<PutSelectionMbr";
        this.command = String.valueOf(this.command) + " writeExistingSelMbr=\"" + this.writeExistingSelMbr + "\"";
        this.command = String.valueOf(this.command) + "><SelectionMember dsname=\"" + this.dataset + "\" member=\"" + this.member + "\" />";
        this.command = String.valueOf(this.command) + "<SelectionMbrRecords>";
        int i = 0;
        while (i < this.processingParmMbrRecord.size()) {
            if (i == 1) {
                String descr = new String(this.description);
                descr = descr.replace("&", "&amp;");
                descr = descr.replace(">", "&gt;");
                descr = descr.replace("<", "&lt;");
                descr = descr.replace("\"", "&quot;");
                descr = descr.replace("'", "&apos;");
                this.command = String.valueOf(this.command) + "<FMProcessingParmMbrRecord >\"" + descr + "\"" + "</FMProcessingParmMbrRecord >";
            } else {
                String procParmMbrRec = new String(this.processingParmMbrRecord.get(i));
                procParmMbrRec = procParmMbrRec.replace("&", "&amp;");
                procParmMbrRec = procParmMbrRec.replace(">", "&gt;");
                procParmMbrRec = procParmMbrRec.replace("<", "&lt;");
                procParmMbrRec = procParmMbrRec.replace("\"", "&quot;");
                procParmMbrRec = procParmMbrRec.replace("'", "&apos;");
                this.command = String.valueOf(this.command) + "<FMProcessingParmMbrRecord >" + procParmMbrRec + "</FMProcessingParmMbrRecord >";
            }
            ++i;
        }
        this.command = String.valueOf(this.command) + "</SelectionMbrRecords></PutSelectionMbr></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }

    public XMLRequest getXml() {
        return this.xml;
    }
}

