/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunPutCrlMem
implements Runnable {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private FileMasterServer server;
    private CRLClass crl;
    private boolean updateExisting;
    private static final String service = "filemaster/fmp";
    private XMLRequest xml = null;
    private boolean canRetry = true;
    Logger log = Logger.getLogger(this.getClass().getName());
    private String command;
    private String uuid;
    private String description;

    public RunPutCrlMem(FileMasterServer server, CRLClass crl, boolean updateExisting) {
        this.server = server;
        this.crl = crl;
        this.updateExisting = updateExisting;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, service);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String uuid = FileMasterSession.getUUID(this.server, true);
            if (uuid != null) {
                long t1;
                map.put("uuid", uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                this.xml = connection.connect("putsel", map, false, this.createXMLPutCrlMem());
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private XMLDocument createXMLPutCrlMem() {
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<PutCrlMbr writeExistingCrlMbr=\"" + (this.updateExisting ? "Y" : "N") + "\" recordOffset=\"" + this.crl.getOffset() + "\">";
        this.command = String.valueOf(this.command) + "<CrlMember dsname=\"" + this.crl.getDatasetName() + "\" member=\"" + this.crl.getMemberName() + "\" />";
        this.description = this.crl.getDescription();
        this.description = this.description.replace("&", "&amp;");
        this.description = this.description.replace(">", "&gt;");
        this.description = this.description.replace("<", "&lt;");
        this.description = this.description.replace("\"", "&quot;");
        this.description = this.description.replace("'", "&apos;");
        this.command = String.valueOf(this.command) + "<CrlHdrInfo FMProcessingParmDescription=\"" + this.description + "\" />";
        this.command = String.valueOf(this.command) + "<CrlListEntries><CrlEntryList>";
        int entryCount = 0;
        while (entryCount < this.crl.getLayouts().size()) {
            CRLClass.Layout layout = this.crl.getLayout(entryCount);
            this.command = String.valueOf(this.command) + "<CrlEntry";
            this.command = layout.isDefault() ? String.valueOf(this.command) + " default=\"Y\">" : String.valueOf(this.command) + " default=\"N\">";
            this.command = String.valueOf(this.command) + "<CrlEntryVersion>" + layout.getEntryVersion() + "</CrlEntryVersion>";
            this.command = String.valueOf(this.command) + "<CopyBook><DataSetName>" + layout.getLayoutDataset() + "</DataSetName><MemberName>" + layout.getLayoutMember() + "</MemberName></CopyBook>";
            this.command = String.valueOf(this.command) + "<TopName>" + layout.getTopLayoutField() + "</TopName>";
            this.command = String.valueOf(this.command) + "<CrlFieldList>";
            int fieldCount = 0;
            while (fieldCount < layout.getLayoutFields().size()) {
                this.command = String.valueOf(this.command) + "<CrlField";
                this.command = layout.getLayoutField(fieldCount).isSelected() ? String.valueOf(this.command) + " excluded=\"N\">" : String.valueOf(this.command) + " excluded=\"Y\">";
                this.command = String.valueOf(this.command) + "<Name>" + layout.getLayoutField(fieldCount).getField() + "</Name>" + "<Position>" + layout.getLayoutField(fieldCount).getPosition() + "</Position>";
                if (layout.getLayoutField(fieldCount).getLogOperator() != 0) {
                    switch (layout.getLayoutField(fieldCount).getLogOperator()) {
                        case 2: {
                            this.command = String.valueOf(this.command) + "<ORorAND>A</ORorAND>";
                            break;
                        }
                        case 1: {
                            this.command = String.valueOf(this.command) + "<ORorAND>O</ORorAND>";
                        }
                    }
                }
                if (layout.getLayoutField(fieldCount).getOperator() != 0) {
                    switch (layout.getLayoutField(fieldCount).getOperator()) {
                        case 1: {
                            this.command = String.valueOf(this.command) + "<Operand>EQ</Operand>";
                            break;
                        }
                        case 2: {
                            this.command = String.valueOf(this.command) + "<Operand>NE</Operand>";
                            break;
                        }
                        case 3: {
                            this.command = String.valueOf(this.command) + "<Operand>GT</Operand>";
                            break;
                        }
                        case 4: {
                            this.command = String.valueOf(this.command) + "<Operand>LT</Operand>";
                            break;
                        }
                        case 5: {
                            this.command = String.valueOf(this.command) + "<Operand>GE</Operand>";
                            break;
                        }
                        case 6: {
                            this.command = String.valueOf(this.command) + "<Operand>LE</Operand>";
                            break;
                        }
                        case 7: {
                            this.command = String.valueOf(this.command) + "<Operand>CO</Operand>";
                        }
                    }
                }
                if (!layout.getLayoutField(fieldCount).getValue().isEmpty()) {
                    this.command = String.valueOf(this.command) + "<Condition>" + layout.getLayoutField(fieldCount).getValue().replace("'", "&apos;") + "</Condition>";
                }
                this.command = String.valueOf(this.command) + "</CrlField>";
                ++fieldCount;
            }
            this.command = String.valueOf(this.command) + "</CrlFieldList></CrlEntry>";
            ++entryCount;
        }
        this.command = String.valueOf(this.command) + "</CrlEntryList></CrlListEntries></PutCrlMbr></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }

    public XMLRequest getXml() {
        return this.xml;
    }
}

