/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.runners.RunValidateSelCriteria;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RunPrint
implements Runnable {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private boolean canRetry = true;
    private String command;
    private String uuid;
    File file;
    private String dataSet;
    private ArrayList<String> membersAsArray;
    private String volume;
    private String startingKey;
    private String limit;
    private String mode;
    private String layoutDataSet;
    private String layoutMember;
    private String selectionCriteria;
    private String sysoutClass;
    private String numberOfCopies;
    private int printDestination;
    private String printDestination1;
    private String printDestination2;
    private String printDestination3;
    private String[] jobCard;
    private static final String SERVICE = "filemaster/fmp";

    public RunPrint() {
    }

    public RunPrint(FileMasterServer server, String dataSet, ArrayList<String> membersAsArray, String volume, String startingKey, String limit, String mode, String layoutDataSet, String layoutMember, String selectionCriteria, String sysoutClass, String numberOfCopies, int printDestination, String printDestination1, String printDestination2, String printDestination3, String[] jobCard) {
        this.server = server;
        this.dataSet = dataSet;
        this.membersAsArray = membersAsArray;
        this.volume = volume;
        this.startingKey = startingKey;
        this.limit = limit;
        this.mode = mode;
        this.layoutDataSet = layoutDataSet;
        this.layoutMember = layoutMember;
        this.selectionCriteria = selectionCriteria;
        this.sysoutClass = sysoutClass;
        this.numberOfCopies = numberOfCopies;
        this.printDestination = printDestination;
        this.printDestination1 = printDestination1.replace("&", "&amp;");
        this.printDestination2 = printDestination2.replace("&", "&amp;");
        this.printDestination3 = printDestination3.replace("&", "&amp;");
        this.jobCard = jobCard;
        int i = 0;
        while (i < this.jobCard.length) {
            this.jobCard[i] = this.jobCard[i].replace("&", "&amp;");
            ++i;
        }
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.uuid = FileMasterSession.getUUID(this.server, true);
            if (this.uuid != null) {
                long t1;
                map.put("uuid", this.uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                this.xml = connection.connect("print", map, false, this.createXMLPrint());
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, this.uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, this.uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, this.uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXMLPrint() {
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">";
        this.command = String.valueOf(this.command) + "<Print>";
        this.command = String.valueOf(this.command) + "<DefaultOptionsData ";
        if (this.jobCard.length > 0) {
            this.command = String.valueOf(this.command) + "JobInformationLine1=\"" + this.jobCard[0] + "\" ";
        }
        if (this.jobCard.length > 1) {
            this.command = String.valueOf(this.command) + "JobInformationLine2=\"" + this.jobCard[1] + "\" ";
        }
        if (this.jobCard.length > 2) {
            this.command = String.valueOf(this.command) + "JobInformationLine3=\"" + this.jobCard[2] + "\" ";
        }
        if (this.jobCard.length > 3) {
            this.command = String.valueOf(this.command) + "JobInformationLine4=\"" + this.jobCard[3] + "\" ";
        }
        this.command = String.valueOf(this.command) + " />";
        this.command = String.valueOf(this.command) + "<PrintDatasetOptionsData>";
        this.command = String.valueOf(this.command) + "<DataSetName dsname=\"" + this.dataSet + "\"" + (this.volume.isEmpty() ? "" : " volumeSerial=\"" + this.volume + "\"") + " />";
        if (!(this.membersAsArray.size() <= 0 || this.membersAsArray.size() == 1 && this.membersAsArray.get(0).isEmpty())) {
            this.command = String.valueOf(this.command) + "<MemberList>";
            int i = 0;
            while (i < this.membersAsArray.size()) {
                this.command = String.valueOf(this.command) + "<Member name=\"" + this.membersAsArray.get(i) + "\" />";
                ++i;
            }
            this.command = String.valueOf(this.command) + "</MemberList>";
        }
        if (!this.mode.isEmpty()) {
            this.command = String.valueOf(this.command) + "<PrintMode>" + this.mode.substring(0, 1) + "</PrintMode>";
        }
        if (!this.startingKey.isEmpty()) {
            this.command = String.valueOf(this.command) + "<StartRec>" + this.startingKey + "</StartRec>";
        }
        if (!this.limit.isEmpty()) {
            this.command = String.valueOf(this.command) + "<PrintLimit>" + this.limit + "</PrintLimit>";
        }
        this.command = String.valueOf(this.command) + "<ExMode>S</ExMode>";
        if (!this.layoutDataSet.isEmpty()) {
            this.command = String.valueOf(this.command) + "<Layout>";
            this.command = String.valueOf(this.command) + "<DataSetName>" + this.layoutDataSet + "</DataSetName>";
            this.command = String.valueOf(this.command) + "<MemberName>" + this.layoutMember + "</MemberName>";
            this.command = String.valueOf(this.command) + "</Layout>";
        }
        this.command = String.valueOf(this.command) + "</PrintDatasetOptionsData>";
        this.command = String.valueOf(this.command) + "<PrintOptionsData SysoutClass=\"" + this.sysoutClass + "\" NumberOfCopies=\"" + this.numberOfCopies + "\">";
        if (this.printDestination != 0) {
            switch (this.printDestination) {
                case 1: {
                    this.command = String.valueOf(this.command) + "<PrintDest>" + this.printDestination1;
                    this.command = String.valueOf(this.command) + "</PrintDest>";
                    break;
                }
                case 2: {
                    this.command = String.valueOf(this.command) + "<PrintJESNode JESNode=\"" + this.printDestination1 + "\" JESUserid=\"" + this.printDestination2 + "\"></PrintJESNode>";
                    break;
                }
                case 3: {
                    this.command = String.valueOf(this.command) + "<SYSOUTWriterName>" + this.printDestination1;
                    this.command = String.valueOf(this.command) + "</SYSOUTWriterName>";
                    break;
                }
                case 4: {
                    this.command = String.valueOf(this.command) + "<PrintDSN dsname=\"" + this.printDestination1 + "\"";
                    if (!this.printDestination2.isEmpty()) {
                        this.command = String.valueOf(this.command) + " member=\"" + this.printDestination2 + "\"";
                    }
                    if (!this.printDestination3.equalsIgnoreCase("SHR")) {
                        this.command = String.valueOf(this.command) + " disp=\"" + this.printDestination3 + "\"";
                    }
                    this.command = String.valueOf(this.command) + "/>";
                }
            }
        }
        this.command = String.valueOf(this.command) + "</PrintOptionsData>";
        if (this.selectionCriteria.trim().length() > 0) {
            this.command = String.valueOf(this.command) + "<SelectionCriteria>";
            this.command = String.valueOf(this.command) + "<DynamicSelCrit>";
            RunValidateSelCriteria runner = new RunValidateSelCriteria(this.server, this.layoutDataSet, this.layoutMember, this.selectionCriteria);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xml = runner.getXml();
            if (xml != null) {
                Element rootElement = xml.getRoot();
                NodeList nodeListSelValidation = rootElement.getElementsByTagName("SelectionValidationRecord");
                int i = 0;
                while (i < nodeListSelValidation.getLength()) {
                    Node nValue;
                    Element selValiRcElement = (Element)nodeListSelValidation.item(i);
                    NodeList nlList = selValiRcElement.getChildNodes();
                    if (nlList.getLength() > 0 && (nValue = nlList.item(0)) != null) {
                        String value = nValue.getNodeValue();
                        value = String.format("%-74s", value);
                        this.command = String.valueOf(this.command) + "<DynamicSelCritLine>" + value + "</DynamicSelCritLine>";
                    }
                    ++i;
                }
            }
            this.command = String.valueOf(this.command) + "</DynamicSelCrit>";
            this.command = String.valueOf(this.command) + "</SelectionCriteria>";
        }
        this.command = String.valueOf(this.command) + "</Print></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }
}

