/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunGetLocateRecords
implements Runnable {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final String SERVICE = "filemaster/fmp";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private boolean canRetry = true;
    private String uuid;
    private String type;
    private String keyword;
    private String option;
    private String displayMode;
    private String hexMode;
    private String value;

    public RunGetLocateRecords(FileMasterServer server, String uuid, String type, String value, String keyword, String option, String displayMode, String hexMode) {
        this.displayMode = displayMode;
        this.hexMode = hexMode;
        this.type = type;
        this.value = value;
        this.keyword = keyword;
        this.option = option;
        this.server = server;
        this.uuid = uuid;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            long t1;
            map.put("uuid", this.uuid);
            long t0 = System.currentTimeMillis();
            while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
            }
            this.xml = connection.connect("locate", map, false, this.createXml());
            if (this.xml.getAttachedFile() != null) {
                File file = this.xml.getAttachedFile();
                FileInputStream is = new FileInputStream(file);
                this.xml = new XMLRequest((InputStream)is);
            } else {
                Element file = this.xml.getRoot();
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXml() {
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Edit displayMode=\"" + this.displayMode + "\" hex=\"" + this.hexMode + "\">";
        command = this.type.endsWith("Keyword") ? String.valueOf(command) + "<Locate><" + this.type + " keyword=\"" + this.keyword + "\" option=\"" + this.option + "\">" + this.value + "</" + this.type + ">" : String.valueOf(command) + "<Locate><" + this.type + ">" + this.value + "</" + this.type + ">";
        command = String.valueOf(command) + "</Locate></Edit></GUIRequest>";
        return CommonMFCalls.createXMLDoc(command);
    }
}

