/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.GenericFieldNameWizard;
import com.ca.filemaster.common.Validator;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class GenericUpdate2Page
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.modifyCLRules";
    protected static final String CHARACTER = "C - Character";
    protected static final String NUMERIC = "N - Numeric";
    protected static final String PACKED = "P - Packed";
    protected static final String HEXADECIMAL = "X - Hex";
    protected static final String BINARY = "B - Binary";
    protected static final String TEXT = "T - Text";
    protected static final String FIELD_NAME = "Field Name...";
    protected Text txtRecLayout;
    private Button selectAllClearButton;
    protected Tree topLevelTree;
    protected CheckboxTreeViewer checkboxTreeViewer;
    protected String error;
    protected CRLClass crl;
    protected CRLClass.Layout tempLayout;
    protected int selectedIndex;
    private CRLClass.LayoutField layoutField;
    protected ArrayList<CRLClass.LayoutField> fields;
    public int lineNumber;
    protected boolean[] checkedStatus;
    protected boolean selectable;
    protected TreeViewer treeViewer;
    private TextCellEditor textEditor;

    public GenericUpdate2Page(String pageName, String title, CRLClass crl, int selectedIndex, FileMasterServer server, boolean selectable) {
        super(pageName, crl.getDatasetName(), server);
        this.crl = crl;
        this.tempLayout = crl.getLayout(selectedIndex).getCopy();
        this.selectedIndex = selectedIndex;
        this.selectable = selectable;
        if (selectable) {
            this.checkedStatus = new boolean[this.tempLayout.getLayoutFields().size()];
            int i = 0;
            while (i < this.checkedStatus.length) {
                this.checkedStatus[i] = this.tempLayout.getLayoutFields().get(i).isSelected();
                ++i;
            }
        }
        this.setTitle(title);
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.modifyCLRules");
        Composite compositeTop = new Composite(container, 0);
        GridData gd_compositeTop = new GridData(4, 4, false, false, 1, 1);
        gd_compositeTop.widthHint = 267;
        compositeTop.setLayoutData((Object)gd_compositeTop);
        compositeTop.setLayout((Layout)new GridLayout(2, false));
        Label lblDataSet = new Label(compositeTop, 0);
        lblDataSet.setText("&Record layout:");
        this.txtRecLayout = new Text(compositeTop, 8);
        this.txtRecLayout.setEditable(false);
        GridData gd_txtRecLayout = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtRecLayout.widthHint = 280;
        this.txtRecLayout.setLayoutData((Object)gd_txtRecLayout);
        this.txtRecLayout.setText(String.valueOf(this.crl.getLayout(this.selectedIndex).getLayoutDataset()) + "(" + this.crl.getLayout(this.selectedIndex).getLayoutMember() + ")");
        this.txtRecLayout.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    if (GenericUpdate2Page.this.topLevelTree.getSelection().length == 0) {
                        GenericUpdate2Page.this.topLevelTree.setSelection((TreeItem)GenericUpdate2Page.this.getTreeItems(GenericUpdate2Page.this.topLevelTree.getItems())[0]);
                    }
                    GenericUpdate2Page.this.topLevelTree.setFocus();
                }
            }
        });
        Composite compositeTable = new Composite(container, 0);
        GridData gd_compositeTable = new GridData(4, 4, true, true, 1, 1);
        gd_compositeTable.heightHint = 249;
        compositeTable.setLayoutData((Object)gd_compositeTable);
        compositeTable.setLayout((Layout)new GridLayout(1, false));
        this.createViewer(compositeTable);
        if (this.selectable) {
            this.checkboxTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public Object[] getElements(Object inputElement) {
                    ArrayList<CRLClass.LayoutField> elements = new ArrayList<CRLClass.LayoutField>();
                    int i = 0;
                    while (i < GenericUpdate2Page.this.fields.size()) {
                        if (GenericUpdate2Page.this.fields.get(i).getLevel() == 1) {
                            elements.add(GenericUpdate2Page.this.fields.get(i));
                        }
                        ++i;
                    }
                    return elements.toArray();
                }

                public Object[] getChildren(Object parentElement) {
                    CRLClass.LayoutField e = (CRLClass.LayoutField)parentElement;
                    int index = GenericUpdate2Page.this.getIndex(e);
                    int childrenLevel = GenericUpdate2Page.this.fields.get(index + 1).getLevel();
                    ArrayList<CRLClass.LayoutField> children = new ArrayList<CRLClass.LayoutField>();
                    int i = index + 1;
                    while (i < GenericUpdate2Page.this.fields.size()) {
                        if (GenericUpdate2Page.this.fields.get(i).getLevel() == childrenLevel) {
                            children.add(GenericUpdate2Page.this.fields.get(i));
                        } else if (GenericUpdate2Page.this.fields.get(i).getLevel() < childrenLevel && GenericUpdate2Page.this.fields.get(i).getLevel() > e.getLevel()) {
                            children.add(GenericUpdate2Page.this.fields.get(i));
                            childrenLevel = GenericUpdate2Page.this.fields.get(i).getLevel();
                        } else if (GenericUpdate2Page.this.fields.get(i).getLevel() == e.getLevel()) break;
                        ++i;
                    }
                    return children.toArray();
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    CRLClass.LayoutField e = (CRLClass.LayoutField)element;
                    int index = GenericUpdate2Page.this.getIndex(e);
                    if (index + 1 < GenericUpdate2Page.this.fields.size()) {
                        return GenericUpdate2Page.this.fields.get(index + 1).getLevel() > e.getLevel();
                    }
                    return false;
                }
            });
            this.checkboxTreeViewer.setInput(null);
            this.checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    int i = 0;
                    while (i < GenericUpdate2Page.this.fields.size()) {
                        if (GenericUpdate2Page.this.fields.get(i).equals(event.getElement())) {
                            GenericUpdate2Page.this.checkedStatus[i] = !GenericUpdate2Page.this.checkedStatus[i];
                            break;
                        }
                        ++i;
                    }
                }
            });
            this.selectAllClearButton = new Button(compositeTable, 0);
            GridData gd_selectAllClearButton = new GridData(16384, 0x1000000, false, false, 1, 1);
            gd_selectAllClearButton.widthHint = 120;
            this.selectAllClearButton.setLayoutData((Object)gd_selectAllClearButton);
            this.selectAllClearButton.setText("Select &All");
            this.selectAllClearButton.addSelectionListener((SelectionListener)this);
            this.selectAllClearButton.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 8) {
                        int selectedElement;
                        if (GenericUpdate2Page.this.topLevelTree.getSelection().length == 0) {
                            selectedElement = GenericUpdate2Page.this.getTreeItemCount(GenericUpdate2Page.this.topLevelTree.getItems()) - 1;
                            GenericUpdate2Page.this.topLevelTree.setSelection((TreeItem)GenericUpdate2Page.this.getTreeItems(GenericUpdate2Page.this.topLevelTree.getItems())[selectedElement]);
                        } else {
                            selectedElement = GenericUpdate2Page.this.getIndex(GenericUpdate2Page.this.topLevelTree.getItems(), GenericUpdate2Page.this.topLevelTree.getSelection()[GenericUpdate2Page.this.topLevelTree.getSelection().length - 1]);
                        }
                        GenericUpdate2Page.this.checkboxTreeViewer.editElement((Object)GenericUpdate2Page.this.fields.get(selectedElement), 6);
                        GenericUpdate2Page.this.topLevelTree.setFocus();
                    }
                }
            });
        } else {
            this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public Object[] getElements(Object inputElement) {
                    ArrayList<CRLClass.LayoutField> elements = new ArrayList<CRLClass.LayoutField>();
                    int i = 0;
                    while (i < GenericUpdate2Page.this.fields.size()) {
                        if (GenericUpdate2Page.this.fields.get(i).getLevel() == 1) {
                            elements.add(GenericUpdate2Page.this.fields.get(i));
                        }
                        ++i;
                    }
                    return elements.toArray();
                }

                public Object[] getChildren(Object parentElement) {
                    CRLClass.LayoutField e = (CRLClass.LayoutField)parentElement;
                    int index = GenericUpdate2Page.this.getIndex(e);
                    int childrenLevel = GenericUpdate2Page.this.fields.get(index + 1).getLevel();
                    ArrayList<CRLClass.LayoutField> children = new ArrayList<CRLClass.LayoutField>();
                    int i = index + 1;
                    while (i < GenericUpdate2Page.this.fields.size()) {
                        if (GenericUpdate2Page.this.fields.get(i).getLevel() == childrenLevel) {
                            children.add(GenericUpdate2Page.this.fields.get(i));
                        } else if (GenericUpdate2Page.this.fields.get(i).getLevel() < childrenLevel && GenericUpdate2Page.this.fields.get(i).getLevel() > e.getLevel()) {
                            children.add(GenericUpdate2Page.this.fields.get(i));
                            childrenLevel = GenericUpdate2Page.this.fields.get(i).getLevel();
                        } else if (GenericUpdate2Page.this.fields.get(i).getLevel() == e.getLevel()) break;
                        ++i;
                    }
                    return children.toArray();
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    CRLClass.LayoutField e = (CRLClass.LayoutField)element;
                    int index = GenericUpdate2Page.this.getIndex(e);
                    if (index + 1 < GenericUpdate2Page.this.fields.size()) {
                        return GenericUpdate2Page.this.fields.get(index + 1).getLevel() > e.getLevel();
                    }
                    return false;
                }
            });
            this.treeViewer.setInput(null);
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 8) {
                        int selectedElement;
                        if (GenericUpdate2Page.this.topLevelTree.getSelection().length == 0) {
                            selectedElement = GenericUpdate2Page.this.getTreeItemCount(GenericUpdate2Page.this.topLevelTree.getItems()) - 1;
                            GenericUpdate2Page.this.topLevelTree.setSelection((TreeItem)GenericUpdate2Page.this.getTreeItems(GenericUpdate2Page.this.topLevelTree.getItems())[selectedElement]);
                        } else {
                            selectedElement = GenericUpdate2Page.this.getIndex(GenericUpdate2Page.this.topLevelTree.getItems(), GenericUpdate2Page.this.topLevelTree.getSelection()[GenericUpdate2Page.this.topLevelTree.getSelection().length - 1]);
                        }
                        GenericUpdate2Page.this.treeViewer.editElement((Object)GenericUpdate2Page.this.fields.get(selectedElement), 6);
                        GenericUpdate2Page.this.topLevelTree.setFocus();
                    }
                }
            });
        }
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("OK");
        this.treeUpdate();
        this.txtRecLayout.setFocus();
    }

    protected void createViewer(Composite parent) {
        if (this.selectable) {
            this.checkboxTreeViewer = new CheckboxTreeViewer(parent, 68354);
            this.checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (GenericUpdate2Page.this.checkboxTreeViewer.getCheckedElements().length == GenericUpdate2Page.this.getTreeItemCount(GenericUpdate2Page.this.checkboxTreeViewer.getTree().getItems())) {
                        GenericUpdate2Page.this.selectAllClearButton.setText("&Clear Selections");
                    } else {
                        GenericUpdate2Page.this.selectAllClearButton.setText("Select &All");
                    }
                }
            });
            this.topLevelTree = this.checkboxTreeViewer.getTree();
        } else {
            this.treeViewer = new TreeViewer(parent, 68354);
            this.setTreeViewer(this.treeViewer);
            this.topLevelTree = this.treeViewer.getTree();
        }
        this.topLevelTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.topLevelTree.setLinesVisible(true);
        this.topLevelTree.setHeaderVisible(true);
        this.topLevelTree.setFocus();
        this.topLevelTree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point pt = new Point(event.x, event.y);
                TreeItem item = GenericUpdate2Page.this.topLevelTree.getItem(pt);
                if (item == null) {
                    GenericUpdate2Page.this.topLevelTree.setMenu(null);
                    return;
                }
                int i = 0;
                while (i < GenericUpdate2Page.this.topLevelTree.getColumnCount()) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        if (i == GenericUpdate2Page.this.topLevelTree.getColumnCount() - 1) {
                            GenericUpdate2Page.this.lineNumber = GenericUpdate2Page.this.getIndex(GenericUpdate2Page.this.topLevelTree.getItems(), item);
                            Object[] obj = GenericUpdate2Page.this.selectable ? (Object[])GenericUpdate2Page.this.checkboxTreeViewer.getInput() : (Object[])GenericUpdate2Page.this.treeViewer.getInput();
                            GenericUpdate2Page.this.layoutField = (CRLClass.LayoutField)obj[GenericUpdate2Page.this.lineNumber];
                            String formatType = GenericUpdate2Page.this.layoutField.getFormatType();
                            GenericUpdate2Page.this.topLevelTree.setMenu(GenericUpdate2Page.this.buildTableMenu(formatType));
                        } else {
                            GenericUpdate2Page.this.topLevelTree.setMenu(null);
                        }
                    }
                    ++i;
                }
            }
        });
        this.topLevelTree.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    if (GenericUpdate2Page.this.topLevelTree.getSelection().length == 0) {
                        GenericUpdate2Page.this.topLevelTree.setSelection((TreeItem)GenericUpdate2Page.this.getTreeItems(GenericUpdate2Page.this.topLevelTree.getItems())[0]);
                        e.doit = false;
                    } else {
                        int selectedElement = GenericUpdate2Page.this.getIndex(GenericUpdate2Page.this.topLevelTree.getItems(), GenericUpdate2Page.this.topLevelTree.getSelection()[0]);
                        if (GenericUpdate2Page.this.selectable) {
                            GenericUpdate2Page.this.checkboxTreeViewer.editElement((Object)GenericUpdate2Page.this.fields.get(selectedElement), 4);
                        } else {
                            GenericUpdate2Page.this.treeViewer.editElement((Object)GenericUpdate2Page.this.fields.get(selectedElement), 4);
                        }
                    }
                } else if (e.detail == 8) {
                    if (GenericUpdate2Page.this.topLevelTree.getSelection().length == 0) {
                        if (GenericUpdate2Page.this.selectable) {
                            GenericUpdate2Page.this.checkboxTreeViewer.editElement((Object)GenericUpdate2Page.this.fields.get(GenericUpdate2Page.this.getTreeItems(GenericUpdate2Page.this.topLevelTree.getItems()).length - 1), 6);
                        } else {
                            GenericUpdate2Page.this.treeViewer.editElement((Object)GenericUpdate2Page.this.fields.get(GenericUpdate2Page.this.getTreeItems(GenericUpdate2Page.this.topLevelTree.getItems()).length - 1), 6);
                        }
                        e.doit = false;
                    } else {
                        int selectedElement = GenericUpdate2Page.this.getIndex(GenericUpdate2Page.this.topLevelTree.getItems(), GenericUpdate2Page.this.topLevelTree.getSelection()[GenericUpdate2Page.this.topLevelTree.getSelection().length - 1]);
                        if (selectedElement > 0) {
                            if (GenericUpdate2Page.this.selectable) {
                                GenericUpdate2Page.this.checkboxTreeViewer.editElement((Object)GenericUpdate2Page.this.fields.get(selectedElement - 1), 6);
                            } else {
                                GenericUpdate2Page.this.treeViewer.editElement((Object)GenericUpdate2Page.this.fields.get(selectedElement - 1), 6);
                            }
                            e.doit = false;
                        } else {
                            GenericUpdate2Page.this.topLevelTree.setSelection(new TreeItem[0]);
                            GenericUpdate2Page.this.txtRecLayout.setFocus();
                        }
                    }
                }
            }
        });
        this.createColumns();
    }

    public void createMenuItem(Menu menu, String text) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(text);
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String value = GenericUpdate2Page.this.fields.get(GenericUpdate2Page.this.lineNumber).getValue();
                if (((MenuItem)event.widget).getText().equals(GenericUpdate2Page.FIELD_NAME)) {
                    GenericUpdate2Page.this.dialog = new TestingToolsWizardDialog(GenericUpdate2Page.this.getShell(), (IWizard)new GenericFieldNameWizard(GenericUpdate2Page.this.crl.getLayout(GenericUpdate2Page.this.selectedIndex).getLayoutDataset(), GenericUpdate2Page.this.crl.getLayout(GenericUpdate2Page.this.selectedIndex).getLayoutMember()));
                    GenericUpdate2Page.this.dialog.create();
                    GenericUpdate2Page.this.dialog.open();
                } else if (!value.matches("([CTXPBN]*\\d*['\"]?[0-9A-Za-z]*['\"]?\\s*)*")) {
                    value = "";
                }
                if (((MenuItem)event.widget).getText().equals(GenericUpdate2Page.CHARACTER)) {
                    GenericUpdate2Page.this.fields.get(GenericUpdate2Page.this.lineNumber).setValue(String.valueOf(value) + " C'' ");
                } else if (((MenuItem)event.widget).getText().equals(GenericUpdate2Page.TEXT)) {
                    GenericUpdate2Page.this.fields.get(GenericUpdate2Page.this.lineNumber).setValue(String.valueOf(value) + " T'' ");
                } else if (((MenuItem)event.widget).getText().equals(GenericUpdate2Page.HEXADECIMAL)) {
                    GenericUpdate2Page.this.fields.get(GenericUpdate2Page.this.lineNumber).setValue(String.valueOf(value) + " X'' ");
                } else if (((MenuItem)event.widget).getText().equals(GenericUpdate2Page.PACKED)) {
                    GenericUpdate2Page.this.fields.get(GenericUpdate2Page.this.lineNumber).setValue(String.valueOf(value) + " P'' ");
                } else if (((MenuItem)event.widget).getText().equals(GenericUpdate2Page.BINARY)) {
                    GenericUpdate2Page.this.fields.get(GenericUpdate2Page.this.lineNumber).setValue(String.valueOf(value) + " B'' ");
                } else if (((MenuItem)event.widget).getText().equals(GenericUpdate2Page.NUMERIC)) {
                    GenericUpdate2Page.this.fields.get(GenericUpdate2Page.this.lineNumber).setValue(String.valueOf(value) + " N'' ");
                }
                GenericUpdate2Page.this.checkboxTreeViewer.refresh();
            }
        });
    }

    private Menu buildTableMenu(String type) {
        Menu tableMenu = new Menu((Decorations)this.getShell(), 8);
        if (type.equals("C")) {
            this.createMenuItem(tableMenu, CHARACTER);
            this.createMenuItem(tableMenu, TEXT);
        } else if (type.equals("PS") || type.equals("P")) {
            this.createMenuItem(tableMenu, NUMERIC);
            this.createMenuItem(tableMenu, PACKED);
        } else if (type.equals("NS") || type.equals("N") || type.equals("BS") || type.equals("B")) {
            this.createMenuItem(tableMenu, NUMERIC);
        }
        this.createMenuItem(tableMenu, HEXADECIMAL);
        new MenuItem(tableMenu, 2);
        this.createMenuItem(tableMenu, FIELD_NAME);
        return tableMenu;
    }

    public void getSelectedfields(String fieldsName) {
        this.fields.get(this.lineNumber).setValue(fieldsName);
        this.setPageComplete(this.isPageComplete());
    }

    protected void createColumns() {
        String[] titles = new String[]{"Field Name", "Position", "Type", "Format", "And/Or", "Operator", "Compare Value or Field Name"};
        int[] bounds = new int[]{210, 55, 95, 50, 80, 130, 210};
        int i = 0;
        while (i < titles.length) {
            Tree tree;
            TreeViewerColumn treeViewerColumn;
            if (this.selectable) {
                treeViewerColumn = new TreeViewerColumn((TreeViewer)this.checkboxTreeViewer, 0);
                tree = this.checkboxTreeViewer.getTree();
            } else {
                treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
                tree = this.treeViewer.getTree();
            }
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            treeColumn.setText(titles[i]);
            treeColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            return crlLayoutField.getLevelField();
                        }
                    });
                    break;
                }
                case 1: {
                    treeViewerColumn.getColumn().setAlignment(131072);
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            return Integer.toString(crlLayoutField.getPosition());
                        }
                    });
                    break;
                }
                case 2: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            return crlLayoutField.getFormatString();
                        }
                    });
                    break;
                }
                case 3: {
                    treeViewerColumn.getColumn().setAlignment(131072);
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            return crlLayoutField.getFormatLength();
                        }
                    });
                    break;
                }
                case 4: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            if (crlLayoutField.getLogOperator() == 0) {
                                return "";
                            }
                            return CRLClass.logOperators[crlLayoutField.getLogOperator()];
                        }
                    });
                    treeViewerColumn.setEditingSupport(new EditingSupport(treeViewerColumn.getViewer()){

                        protected void setValue(Object element, Object value) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            crlLayoutField.setLogOperator((Integer)value);
                            if (GenericUpdate2Page.this.selectable) {
                                GenericUpdate2Page.this.checkboxTreeViewer.refresh();
                            } else {
                                GenericUpdate2Page.this.treeViewer.refresh();
                            }
                        }

                        protected Object getValue(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            return crlLayoutField.getLogOperator();
                        }

                        protected CellEditor getCellEditor(Object element) {
                            ComboBoxCellEditor comboEditor = new ComboBoxCellEditor((Composite)tree, CRLClass.logOperators, 8);
                            comboEditor.getControl().addTraverseListener(new TraverseListener(){

                                public void keyTraversed(TraverseEvent e) {
                                    int selectedElement = GenericUpdate2Page.this.getIndex((this).GenericUpdate2Page.this.topLevelTree.getItems(), (this).GenericUpdate2Page.this.topLevelTree.getSelection()[0]);
                                    if (e.detail == 16) {
                                        if ((this).GenericUpdate2Page.this.selectable) {
                                            (this).GenericUpdate2Page.this.checkboxTreeViewer.editElement((Object)(this).GenericUpdate2Page.this.fields.get(selectedElement), 5);
                                        } else {
                                            (this).GenericUpdate2Page.this.treeViewer.editElement((Object)(this).GenericUpdate2Page.this.fields.get(selectedElement), 5);
                                        }
                                    } else if (e.detail == 8) {
                                        (this).GenericUpdate2Page.this.topLevelTree.setSelection((TreeItem)GenericUpdate2Page.this.getTreeItems((this).GenericUpdate2Page.this.topLevelTree.getItems())[selectedElement]);
                                        e.doit = false;
                                    }
                                }
                            });
                            return comboEditor;
                        }

                        protected boolean canEdit(Object element) {
                            return true;
                        }
                    });
                    break;
                }
                case 5: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            if (crlLayoutField.getOperator() == 0) {
                                return "";
                            }
                            return CRLClass.operators[crlLayoutField.getOperator()];
                        }
                    });
                    treeViewerColumn.setEditingSupport(new EditingSupport(treeViewerColumn.getViewer()){

                        protected void setValue(Object element, Object value) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            if ((Integer)value < 0 || (Integer)value > 7) {
                                crlLayoutField.setOperator(0);
                            } else {
                                crlLayoutField.setOperator((Integer)value);
                            }
                            if (crlLayoutField.getOperator() == 0) {
                                crlLayoutField.setLogOperator(0);
                                crlLayoutField.setValue("");
                            }
                            if (GenericUpdate2Page.this.selectable) {
                                GenericUpdate2Page.this.checkboxTreeViewer.refresh();
                            } else {
                                GenericUpdate2Page.this.treeViewer.refresh();
                            }
                            GenericUpdate2Page.this.setPageComplete(GenericUpdate2Page.this.isPageComplete());
                        }

                        protected Object getValue(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            return crlLayoutField.getOperator();
                        }

                        protected CellEditor getCellEditor(Object element) {
                            final Object cellElement = element;
                            final ComboBoxCellEditor comboEditor = new ComboBoxCellEditor((Composite)tree, CRLClass.operators, 8);
                            ((CCombo)comboEditor.getControl()).setVisibleItemCount(8);
                            ((CCombo)comboEditor.getControl()).addSelectionListener(new SelectionListener(){

                                public void widgetSelected(SelectionEvent e) {
                                    int i = 0;
                                    while (i < GenericUpdate2Page.this.getTreeItemCount(tree.getItems())) {
                                        CRLClass.LayoutField field = (CRLClass.LayoutField)((TreeItem)GenericUpdate2Page.this.getTreeItems(tree.getItems())[i]).getData();
                                        if (((CRLClass.LayoutField)cellElement).equals(field)) {
                                            (this).GenericUpdate2Page.this.fields.get(i).setOperator(((CCombo)comboEditor.getControl()).getSelectionIndex());
                                            GenericUpdate2Page.this.setPageComplete(GenericUpdate2Page.this.isPageComplete());
                                            break;
                                        }
                                        ++i;
                                    }
                                }

                                public void widgetDefaultSelected(SelectionEvent e) {
                                }
                            });
                            comboEditor.getControl().addTraverseListener(new TraverseListener(){

                                public void keyTraversed(TraverseEvent e) {
                                    int selectedElement = GenericUpdate2Page.this.getIndex((this).GenericUpdate2Page.this.topLevelTree.getItems(), (this).GenericUpdate2Page.this.topLevelTree.getSelection()[0]);
                                    if (e.detail == 16) {
                                        if ((this).GenericUpdate2Page.this.selectable) {
                                            (this).GenericUpdate2Page.this.checkboxTreeViewer.editElement((Object)(this).GenericUpdate2Page.this.fields.get(selectedElement), 6);
                                        } else {
                                            (this).GenericUpdate2Page.this.treeViewer.editElement((Object)(this).GenericUpdate2Page.this.fields.get(selectedElement), 6);
                                        }
                                    } else if (e.detail == 8) {
                                        if ((this).GenericUpdate2Page.this.selectable) {
                                            (this).GenericUpdate2Page.this.checkboxTreeViewer.editElement((Object)(this).GenericUpdate2Page.this.fields.get(selectedElement), 4);
                                        } else {
                                            (this).GenericUpdate2Page.this.treeViewer.editElement((Object)(this).GenericUpdate2Page.this.fields.get(selectedElement), 4);
                                        }
                                    }
                                }
                            });
                            return comboEditor;
                        }

                        protected boolean canEdit(Object element) {
                            return true;
                        }
                    });
                    break;
                }
                case 6: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            return crlLayoutField.getValue();
                        }
                    });
                    treeViewerColumn.setEditingSupport(new EditingSupport(treeViewerColumn.getViewer()){

                        protected void setValue(Object element, Object value) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            crlLayoutField.setValue((String)value);
                            if (GenericUpdate2Page.this.selectable) {
                                GenericUpdate2Page.this.checkboxTreeViewer.refresh();
                            } else {
                                GenericUpdate2Page.this.treeViewer.refresh();
                            }
                        }

                        protected Object getValue(Object element) {
                            CRLClass.LayoutField crlLayoutField = (CRLClass.LayoutField)element;
                            return crlLayoutField.getValue();
                        }

                        protected CellEditor getCellEditor(Object element) {
                            GenericUpdate2Page.this.textEditor = new TextCellEditor((Composite)tree);
                            if (GenericUpdate2Page.this.selectable) {
                                ((Text)GenericUpdate2Page.this.textEditor.getControl()).setTextLimit(32);
                            }
                            ((Text)GenericUpdate2Page.this.textEditor.getControl()).addModifyListener(new ModifyListener(){

                                public void modifyText(ModifyEvent e) {
                                    Widget source = e.widget;
                                    if (tree.getSelectionCount() == 1) {
                                        int index = GenericUpdate2Page.this.getIndex(tree.getItems(), tree.getSelection()[0]);
                                        (this).GenericUpdate2Page.this.fields.get(index).setValue(((Text)GenericUpdate2Page.this.textEditor.getControl()).getText());
                                        if (source instanceof Text) {
                                            GenericUpdate2Page.this.setPageComplete(GenericUpdate2Page.this.isPageComplete());
                                        }
                                    }
                                }
                            });
                            ((Text)GenericUpdate2Page.this.textEditor.getControl()).addFocusListener(new FocusListener(){

                                public void focusGained(FocusEvent e) {
                                }

                                public void focusLost(FocusEvent e) {
                                    GenericUpdate2Page.this.setPageComplete(GenericUpdate2Page.this.isPageComplete());
                                }
                            });
                            Object obj = GenericUpdate2Page.this.selectable ? ((StructuredSelection)GenericUpdate2Page.this.checkboxTreeViewer.getSelection()).getFirstElement() : ((StructuredSelection)GenericUpdate2Page.this.treeViewer.getSelection()).getFirstElement();
                            GenericUpdate2Page.this.layoutField = (CRLClass.LayoutField)obj;
                            String type = GenericUpdate2Page.this.layoutField.getFormatType();
                            GenericUpdate2Page.this.textEditor.getControl().setMenu(GenericUpdate2Page.this.buildTableMenu(type));
                            GenericUpdate2Page.this.textEditor.getControl().addTraverseListener(new TraverseListener(){

                                public void keyTraversed(TraverseEvent e) {
                                    int selectedElement = GenericUpdate2Page.this.getIndex((this).GenericUpdate2Page.this.topLevelTree.getItems(), (this).GenericUpdate2Page.this.topLevelTree.getSelection()[0]);
                                    if (e.detail == 16) {
                                        if (GenericUpdate2Page.this.getTreeItemCount((this).GenericUpdate2Page.this.topLevelTree.getItems()) == selectedElement + 1) {
                                            (this).GenericUpdate2Page.this.topLevelTree.setSelection(new TreeItem[0]);
                                            e.doit = true;
                                        } else {
                                            if ((this).GenericUpdate2Page.this.selectable) {
                                                (this).GenericUpdate2Page.this.checkboxTreeViewer.cancelEditing();
                                                (this).GenericUpdate2Page.this.checkboxTreeViewer.refresh();
                                            } else {
                                                (this).GenericUpdate2Page.this.treeViewer.cancelEditing();
                                                (this).GenericUpdate2Page.this.treeViewer.refresh();
                                            }
                                            (this).GenericUpdate2Page.this.topLevelTree.setSelection((TreeItem)GenericUpdate2Page.this.getTreeItems((this).GenericUpdate2Page.this.topLevelTree.getItems())[selectedElement + 1]);
                                            e.doit = false;
                                        }
                                    } else if (e.detail == 8) {
                                        if ((this).GenericUpdate2Page.this.selectable) {
                                            (this).GenericUpdate2Page.this.checkboxTreeViewer.editElement((Object)(this).GenericUpdate2Page.this.fields.get(selectedElement), 5);
                                        } else {
                                            (this).GenericUpdate2Page.this.treeViewer.editElement((Object)(this).GenericUpdate2Page.this.fields.get(selectedElement), 5);
                                        }
                                    }
                                }
                            });
                            return GenericUpdate2Page.this.textEditor;
                        }

                        protected boolean canEdit(Object element) {
                            return true;
                        }
                    });
                }
            }
            ++i;
        }
        if (this.selectable) {
            this.checkboxTreeViewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (GenericUpdate2Page.this.textEditor != null) {
                        GenericUpdate2Page.this.textEditor.deactivate();
                    }
                }
            });
        } else {
            this.treeViewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (GenericUpdate2Page.this.textEditor != null) {
                        GenericUpdate2Page.this.textEditor.deactivate();
                    }
                }
            });
        }
    }

    public void treeUpdate() {
        this.fields = this.tempLayout.getLayoutFields();
        if (this.selectable) {
            this.checkboxTreeViewer.getTree().setRedraw(false);
            this.checkboxTreeViewer.setUseHashlookup(true);
            this.checkboxTreeViewer.setInput((Object)this.fields.toArray(new Object[this.fields.size()]));
            this.checkboxTreeViewer.refresh();
            this.checkboxTreeViewer.expandToLevel(-1);
            int i = 0;
            while (i < this.fields.size()) {
                CRLClass.LayoutField lf = this.fields.get(i);
                if (lf.isSelected()) {
                    this.checkboxTreeViewer.setChecked((Object)lf, true);
                }
                ++i;
            }
            this.checkboxTreeViewer.getTree().setRedraw(true);
        } else {
            this.treeViewer.setUseHashlookup(true);
            this.treeViewer.setInput((Object)this.fields.toArray(new Object[this.fields.size()]));
            this.treeViewer.refresh();
            this.treeViewer.expandToLevel(-1);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    @Override
    public boolean isPageComplete() {
        Tree tree;
        this.error = "";
        boolean atLeastOneCondition = false;
        boolean returnVal = false;
        returnVal = super.isPageComplete();
        if (!returnVal) {
            return false;
        }
        int itemCount = this.fields.size();
        if (this.selectable) {
            if (itemCount == 0) {
                this.error = String.valueOf(this.error) + "Insert at least one layout\n ";
                returnVal = false;
                this.selectAllClearButton.setEnabled(false);
            } else {
                if (this.checkboxTreeViewer.getCheckedElements().length == itemCount) {
                    this.selectAllClearButton.setText("&Clear Selections");
                } else {
                    this.selectAllClearButton.setText("Select &All");
                }
                this.selectAllClearButton.setEnabled(true);
            }
            tree = this.checkboxTreeViewer.getTree();
        } else {
            tree = this.treeViewer.getTree();
        }
        int i = 0;
        while (i < itemCount) {
            CRLClass.LayoutField lf = this.fields.get(i);
            String value = lf.getValue();
            int operator = lf.getOperator();
            int logOperator = lf.getLogOperator();
            if (value.length() != 0 || operator != 0 || logOperator != 0) {
                String fieldName = lf.getField();
                String formatType = lf.getFormatType();
                int length = lf.getLength();
                int formatNum = lf.getFormatNum();
                int formatDec = lf.getFormatDec();
                if (!atLeastOneCondition && value.trim().length() > 0) {
                    atLeastOneCondition = true;
                }
                switch (Validator.CLConditionField(value, formatType, formatNum, formatDec, length, true)) {
                    case 0: {
                        break;
                    }
                    case 21: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[21] + " in field name " + fieldName + "\n ";
                        break;
                    }
                    case 22: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[22] + " in field name " + fieldName + "\n ";
                        break;
                    }
                    case 23: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[23] + " in field name " + fieldName + "\n ";
                        break;
                    }
                    case 24: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[24] + " in field name " + fieldName + "\n ";
                        break;
                    }
                    case 25: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[25] + " in field name " + fieldName + "\n ";
                        break;
                    }
                    case 26: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[26] + " in field name " + fieldName + "\n ";
                        break;
                    }
                    case 27: {
                        boolean fieldFound = false;
                        Object[] treeItems = this.getTreeItems(tree.getItems());
                        int j = 0;
                        while (j < treeItems.length) {
                            CRLClass.LayoutField compareToField = (CRLClass.LayoutField)((TreeItem)treeItems[j]).getData();
                            if (value.trim().toUpperCase().equals(compareToField.getField())) {
                                fieldFound = true;
                                compareToField = (CRLClass.LayoutField)((TreeItem)treeItems[j]).getData();
                                if (length != compareToField.getLength() || formatNum != compareToField.getFormatNum() || formatDec != compareToField.getFormatDec()) {
                                    this.error = String.valueOf(this.error) + "Length of " + compareToField.getField() + " field name does not match length of " + fieldName + " field name\n ";
                                }
                                if (formatType.equalsIgnoreCase(compareToField.getFormatType())) break;
                                this.error = String.valueOf(this.error) + "Type of " + compareToField.getField() + "  field name does not match type of " + fieldName + " field name\n";
                                break;
                            }
                            ++j;
                        }
                        if (fieldFound) break;
                        this.error = String.valueOf(this.error) + "Field name " + value.trim() + " was not found in the layout. Error in field name " + fieldName + "\n ";
                        break;
                    }
                    case 28: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[25] + " in field name " + fieldName + "\n ";
                        break;
                    }
                    case 29: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[29] + " in field name " + fieldName + "\n ";
                        break;
                    }
                    case 30: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[30] + " in field name " + fieldName + "\n ";
                        break;
                    }
                    case 51: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[51] + " in field name " + fieldName + "\n ";
                    }
                }
                if ((CRLClass.LayoutField)((TreeItem)this.getTreeItems(tree.getItems())[i]).getData() != null) {
                    if (((CRLClass.LayoutField)((TreeItem)this.getTreeItems(tree.getItems())[i]).getData()).getOperator() == 0 && value.length() > 0) {
                        this.error = String.valueOf(this.error) + "Missing operator in field name " + fieldName + "\n ";
                    }
                    if (((CRLClass.LayoutField)((TreeItem)this.getTreeItems(tree.getItems())[i]).getData()).getOperator() != 0 && value.length() == 0) {
                        this.error = String.valueOf(this.error) + "Missing compare value in field name " + fieldName + "\n ";
                    }
                }
            }
            ++i;
        }
        if (this.error.length() > 0) {
            this.setErrorMessage(this.error);
            return false;
        }
        if (!this.selectable && !atLeastOneCondition) {
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean doFinish() {
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.selectAllClearButton) {
            if (this.selectAllClearButton.getText() == "Select &All") {
                int i = 0;
                while (i < this.checkedStatus.length) {
                    this.checkedStatus[i] = true;
                    this.checkboxTreeViewer.setChecked((Object)this.fields.get(i), true);
                    ++i;
                }
                this.selectAllClearButton.setText("&Clear Selections");
            } else {
                this.selectAllClearButton.setText("Select &All");
                int i = 0;
                while (i < this.checkedStatus.length) {
                    this.checkedStatus[i] = false;
                    this.checkboxTreeViewer.setChecked((Object)this.fields.get(i), false);
                    ++i;
                }
            }
        }
    }

    private int getIndex(CRLClass.LayoutField element) {
        int i = 0;
        while (i < this.fields.size()) {
            if (this.fields.get(i).equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getIndex(TreeItem[] rootItems, TreeItem item) {
        int index = -1;
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        int i = 0;
        while (i < rootItems.length) {
            if (rootItems[i].getItemCount() > 0) {
                items.add(rootItems[i]);
                items.addAll(this.getSubTree(rootItems[i]));
            } else {
                items.add(rootItems[i]);
            }
            ++i;
        }
        i = 0;
        while (i < items.size()) {
            if (((TreeItem)items.get(i)).equals(item)) {
                return i;
            }
            ++i;
        }
        return index;
    }

    private ArrayList<TreeItem> getSubTree(TreeItem treeItem) {
        ArrayList<TreeItem> temp = new ArrayList<TreeItem>();
        TreeItem[] t = treeItem.getItems();
        int i = 0;
        while (i < t.length) {
            if (t[i].getItemCount() > 0) {
                temp.add(t[i]);
                temp.addAll(this.getSubTree(t[i]));
            } else {
                temp.add(t[i]);
            }
            ++i;
        }
        return temp;
    }

    protected int getTreeItemCount(TreeItem[] rootItems) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        int i = 0;
        while (i < rootItems.length) {
            if (rootItems[i].getItemCount() > 0) {
                items.add(rootItems[i]);
                items.addAll(this.getSubTree(rootItems[i]));
            } else {
                items.add(rootItems[i]);
            }
            ++i;
        }
        return items.size();
    }

    protected Object[] getTreeItems(TreeItem[] rootItems) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        int i = 0;
        while (i < rootItems.length) {
            if (rootItems[i].getItemCount() > 0) {
                items.add(rootItems[i]);
                items.addAll(this.getSubTree(rootItems[i]));
            } else {
                items.add(rootItems[i]);
            }
            ++i;
        }
        return items.toArray();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

