/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.views.report.ReportView;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DirectoryListPropertyTester
extends PropertyTester {
    static String cacopyright = "Copyright \ufffd 2016 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IWorkbench wb = null;
        IWorkbenchWindow win = null;
        IWorkbenchPage page = null;
        IViewReference[] viewRef = null;
        if (receiver instanceof TT_TreeItem) {
            TT_TreeItem treeitem = null;
            boolean isdataset = false;
            boolean isserver = false;
            if (!(receiver instanceof TT_TreeItem)) {
                return false;
            }
            treeitem = (TT_TreeItem)receiver;
            boolean getParent = false;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj.toString().equalsIgnoreCase("getparent")) {
                    getParent = true;
                    break;
                }
                ++n2;
            }
            TT_TreeItem result = null;
            if ("isServer".equals(property)) {
                result = treeitem.getParent(FileMasterServer.class);
                return getParent ? result != null : result == treeitem;
            }
            if ("isEditonServer".equals(property)) {
                FMServerTreeModel model = FMServerTreeModel.getInstance();
                if (treeitem.getValue() instanceof FileMasterServer) {
                    FileMasterServer server = (FileMasterServer)treeitem.getValue();
                    int count = 0;
                    while (count < model.getSessions(server).size()) {
                        if (model.getSessions(server).get(count).getType().equalsIgnoreCase("conversational")) {
                            return false;
                        }
                        ++count;
                    }
                    return true;
                }
            } else {
                if ("hasSys".equals(property)) {
                    wb = PlatformUI.getWorkbench();
                    win = wb.getActiveWorkbenchWindow();
                    if (win != null) {
                        page = win.getActivePage();
                        viewRef = page.getViewReferences();
                        int count = 0;
                        while (count < viewRef.length) {
                            ReportView reportView;
                            if (viewRef[count].getTitle().equalsIgnoreCase("Report") && (reportView = (ReportView)viewRef[count].getView(false)) != null && reportView.syslist()) {
                                return false;
                            }
                            ++count;
                        }
                    }
                    return true;
                }
                if ("isDSN".equals(property)) {
                    result = treeitem.getParent(FileMasterDataset.class);
                    return getParent ? result != null : result == treeitem;
                }
                if ("isMember".equals(property)) {
                    result = treeitem.getParent(FileMasterMember.class);
                    return getParent ? result != null : result == treeitem;
                }
                if ("isTop".equals(property)) {
                    result = treeitem.getParent();
                    return result != null && treeitem.getParent().getChildren().length > 0 && treeitem.getParent().getChildren()[0] == treeitem;
                }
                if ("isBottom".equals(property)) {
                    result = treeitem.getParent();
                    return result != null && treeitem.getParent().getChildren().length > 0 && treeitem.getParent().getChildren()[treeitem.getParent().getChildren().length - 1] == treeitem;
                }
                if ("isdsndser".equals(property)) {
                    wb = PlatformUI.getWorkbench();
                    win = wb.getActiveWorkbenchWindow();
                    if (win != null) {
                        page = win.getActivePage();
                        ISelection selection = page.getSelection();
                        result = treeitem.getParent();
                        if (result != null && selection instanceof TreeSelection) {
                            TreeSelection sel = (TreeSelection)selection;
                            for (Object obj : sel) {
                                if (!(obj instanceof TT_TreeItem)) continue;
                                TT_TreeItem next = (TT_TreeItem)obj;
                                if (next.getParent() != null) {
                                    isdataset = true;
                                    continue;
                                }
                                isserver = true;
                            }
                            if (isdataset && isserver) {
                                return true;
                            }
                        }
                    }
                    return false;
                }
                if ("isPDS".equals(property)) {
                    result = treeitem.getParent();
                    return result != null && (FileMasterServer)((Object)result.getAdapter(FileMasterServer.class)) != null && (((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("PDS") || ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("PDSE"));
                }
                if ("isVSAM".equals(property)) {
                    result = treeitem.getParent();
                    return result != null && (FileMasterServer)((Object)result.getAdapter(FileMasterServer.class)) != null && (((FileMasterDataset)treeitem.getValue()).getFileType().equalsIgnoreCase("CLUSTER") || ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("VSAM"));
                }
                if ("isSEQ".equals(property)) {
                    result = treeitem.getParent();
                    return result != null && (FileMasterServer)((Object)result.getAdapter(FileMasterServer.class)) != null && (((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("PS") || ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("PSL") || ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("Sequential") || ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("SEQ") || ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("DA") || ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("Direct Access"));
                }
                if ("isArchive".equals(property)) {
                    result = treeitem.getParent();
                    return result != null && (FileMasterServer)((Object)result.getAdapter(FileMasterServer.class)) != null && ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("") && !((FileMasterDataset)treeitem.getValue()).getFileType().equalsIgnoreCase("CLUSTER");
                }
                if ("isNoneUtility".equals(property)) {
                    result = treeitem.getParent();
                    if (result != null && (FileMasterServer)((Object)result.getAdapter(FileMasterServer.class)) != null) {
                        if (((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("HFS")) {
                            return true;
                        }
                        if (((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("VSAM") && ((FileMasterDataset)treeitem.getValue()).getDsType().equalsIgnoreCase("N")) {
                            return true;
                        }
                        if (((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("GDG")) {
                            return true;
                        }
                    }
                    return false;
                }
                if ("isHFS".equals(property)) {
                    result = treeitem.getParent();
                    return result != null && (FileMasterServer)((Object)result.getAdapter(FileMasterServer.class)) != null && ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("HFS");
                }
                if ("isPGM".equals(property)) {
                    result = treeitem.getParent();
                    return (((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("PDS") || ((FileMasterDataset)treeitem.getValue()).getDsOrg().equalsIgnoreCase("PDSE")) && ((FileMasterDataset)treeitem.getValue()).getRecfm().equalsIgnoreCase("U");
                }
            }
        } else if (receiver instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)receiver;
            if (!(selection instanceof TreeSelection) || selection.size() == 0) {
                return false;
            }
            if ("isMember".equals(property)) {
                for (Object item : selection) {
                    if (item instanceof TT_TreeItem) {
                        boolean result;
                        boolean bl = result = item == ((TT_TreeItem)item).getParent(FileMasterMember.class);
                        if (result) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            if ("isOneDSNSelected".equals(property)) {
                selection = (IStructuredSelection)receiver;
                return selection instanceof TreeSelection;
            }
            if ("hasSameParent".equals(property)) {
                TreeSelection sel = (TreeSelection)selection;
                if (sel.size() == 1) {
                    return true;
                }
                if (sel.getFirstElement() instanceof TT_TreeItem) {
                    TT_TreeItem itemToTest = ((TT_TreeItem)sel.getFirstElement()).getParent();
                    for (TT_TreeItem obj : sel) {
                        if (obj == null) {
                            return false;
                        }
                        if (obj.getParent() == null || itemToTest == null) {
                            return false;
                        }
                        if (obj.getParent().equals((Object)itemToTest)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

