/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.copy;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.DatasetWizardPage;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.ui.wizards.MemberLabelProvider;
import com.ca.filemaster.ui.wizards.MemberWizard;
import com.ca.filemaster.utilities.CopyGenericWizard;
import com.ca.filemaster.utility.copy.CopyPDSMemberSorter;
import com.ca.filemaster.utility.copy.CopyPDSRenameMemLabelProvider;
import com.ca.filemaster.utility.copy.CopyPDSToWizardPage;
import com.ca.filemaster.utility.copy.CopyPDSWizard;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CopyPDSFromWizardPage
extends WizardPage
implements ModifyListener,
SelectionListener,
FocusListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    Logger log = Logger.getLogger(CopyPDSFromWizardPage.class.getName());
    Level baseLevel = this.log.getLevel();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.copyPDSWizardPage";
    private Label serverNameLabel;
    private Label dataSetLabel;
    private Label fromMemberLabel;
    private Label fromVolSerialLabel;
    private String serverName;
    private String newDatasetName;
    private String oldDatasetName;
    private FileMasterMember memberName;
    private Text serverNameCombo;
    private Text fromDataSetCombo;
    private Combo fromMemberNameCombo;
    private Combo fromVolumeCombo;
    private FileMasterDataset fmdataset;
    private Button btnMemberSelect;
    private Button clearSelBtn;
    private Button deleteListBtn;
    private Button dirListInsert;
    private IPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
    private Boolean ShowDialog = false;
    private boolean pendingMessage = false;
    private boolean pendingNext = false;
    private boolean isCopyPDSWizard;
    private boolean msgDisplayed;
    private int returnDDCM;
    Group selectMemberGroup;
    private CheckboxTableViewer viewer;
    private static final int Member = 0;
    private static final int Rename = 1;
    private Listener sortListener;
    private String volumeSerial;
    protected FileMasterDataset dataSet;
    protected FileMasterServer server;
    protected FileMasterMember member;
    protected FileMasterDataset dataSetFrom;

    public CopyPDSFromWizardPage(String pageName, FileMasterServer server, FileMasterDataset dataSet, FileMasterMember memberName, String volumeSerial, boolean isCopyPDSWizard) {
        this(pageName, server, dataSet, memberName, isCopyPDSWizard);
        this.volumeSerial = volumeSerial;
    }

    public CopyPDSFromWizardPage(String pageName, FileMasterServer server, FileMasterDataset dataSet, FileMasterMember memberName, boolean isCopyPDSWizard) {
        super(pageName);
        this.setTitle("Copy PDS From");
        this.serverName = server.getName();
        this.oldDatasetName = dataSet.getName();
        this.memberName = memberName;
        this.isCopyPDSWizard = isCopyPDSWizard;
        this.server = server;
        this.dataSet = dataSet;
        this.msgDisplayed = false;
        if (this.fromDataSetCombo != null) {
            this.fromDataSetCombo.setText(this.oldDatasetName);
        }
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.copyPDSWizardPage");
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite dataSetFromComposite = new Composite(container, 0);
        dataSetFromComposite.setLayout((Layout)new GridLayout(4, false));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 0;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 1;
        data.verticalSpan = 1;
        this.serverNameLabel = new Label(dataSetFromComposite, 0);
        this.serverNameLabel.setText("Se&rver:");
        this.serverNameCombo = new Text(dataSetFromComposite, 2056);
        this.serverNameCombo.setLayoutData((Object)data);
        this.serverNameCombo.setText(this.server.getText());
        new Label(dataSetFromComposite, 0);
        new Label(dataSetFromComposite, 0);
        this.dataSetLabel = new Label(dataSetFromComposite, 0);
        this.dataSetLabel.setText("&Data set name:");
        this.fromDataSetCombo = new Text(dataSetFromComposite, 2056);
        this.fromDataSetCombo.setTextLimit(44);
        this.fromDataSetCombo.addModifyListener((ModifyListener)this);
        this.fromDataSetCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.fromDataSetCombo.setText(this.oldDatasetName);
        this.fromDataSetCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Text)this.fromDataSetCombo, (int)37);
        this.fromDataSetCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!CopyPDSFromWizardPage.this.msgDisplayed) {
                    CopyPDSFromWizardPage.this.oldDatasetName = CopyPDSFromWizardPage.this.fromDataSetCombo.getText();
                    CopyPDSFromWizardPage.this.dataSet.setName(CopyPDSFromWizardPage.this.fromDataSetCombo.getText());
                }
                CopyPDSFromWizardPage.this.msgDisplayed = false;
            }
        });
        this.fromDataSetCombo.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                CopyPDSFromWizardPage.this.validateDataSet();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fromDataSetCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CopyPDSFromWizardPage.this.validateDataSet();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fromDataSetCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CopyPDSFromWizardPage.this.validateDataSet();
            }
        });
        new Label(dataSetFromComposite, 0);
        new Label(dataSetFromComposite, 0);
        this.fromMemberLabel = new Label(dataSetFromComposite, 0);
        this.fromMemberLabel.setText("&Member name:");
        this.fromMemberNameCombo = new Combo(dataSetFromComposite, 0);
        this.fromMemberNameCombo.setLayoutData((Object)data);
        this.fromMemberNameCombo.setTextLimit(8);
        TextUtil.setWidth((Combo)this.fromMemberNameCombo, (int)37);
        this.fromMemberNameCombo.addModifyListener((ModifyListener)this);
        this.fromMemberNameCombo.addFocusListener((FocusListener)this);
        this.fromMemberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.fromMemberNameCombo, "FromMemberListCopyPDS");
        if (this.memberName != null) {
            this.fromMemberNameCombo.setText(this.memberName.getName());
        }
        this.btnMemberSelect = new Button(dataSetFromComposite, 0);
        this.btnMemberSelect.setText("S&elect...");
        this.btnMemberSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopyPDSFromWizardPage.this.returnDDCM = CopyPDSFromWizardPage.this.displayDatasetChangedMsg();
                if (CopyPDSFromWizardPage.this.returnDDCM == 2 || CopyPDSFromWizardPage.this.returnDDCM == -1) {
                    CopyPDSFromWizardPage.this.member = new FileMasterMember(null);
                    CopyPDSFromWizardPage.this.member.setName(CopyPDSFromWizardPage.this.fromMemberNameCombo.getText());
                    CopyPDSFromWizardPage.this.fmdataset = CommonMFCalls.getFQDSN(CopyPDSFromWizardPage.this.fromDataSetCombo.getText(), CopyPDSFromWizardPage.this.fromVolumeCombo.getText(), CopyPDSFromWizardPage.this.server);
                    if (!CopyPDSFromWizardPage.this.fmdataset.getName().isEmpty()) {
                        WizardDialog dialog = new WizardDialog(CopyPDSFromWizardPage.this.getShell(), (IWizard)new MemberWizard(CopyPDSFromWizardPage.this.member, CopyPDSFromWizardPage.this.fmdataset, CopyPDSFromWizardPage.this.server, false));
                        dialog.create();
                        dialog.open();
                    }
                } else if (CopyPDSFromWizardPage.this.returnDDCM == 3) {
                    CopyPDSFromWizardPage.this.fromDataSetCombo.setFocus();
                }
            }
        });
        new Label(dataSetFromComposite, 0);
        this.fromVolSerialLabel = new Label(dataSetFromComposite, 0);
        this.fromVolSerialLabel.setText("&Volume serial:");
        this.fromVolumeCombo = new Combo(dataSetFromComposite, 2048);
        TextUtil.setWidth((Combo)this.fromVolumeCombo, (int)37);
        this.fromVolumeCombo.setTextLimit(6);
        this.fromVolumeCombo.addModifyListener((ModifyListener)this);
        this.fromVolumeCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.fromVolumeCombo.addFocusListener((FocusListener)this);
        this.fromVolumeCombo.setLayoutData((Object)data);
        FMHistory.intializeComboBoxes(this.fromVolumeCombo, "FromVolumeListCopyPDS");
        this.fromVolumeCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    if (CopyPDSFromWizardPage.this.viewer.getTable().getSelectionIndex() == -1) {
                        CopyPDSFromWizardPage.this.viewer.getTable().setSelection(0);
                        CopyPDSFromWizardPage.this.viewer.getTable().setFocus();
                    } else {
                        CopyPDSFromWizardPage.this.viewer.getTable().setFocus();
                    }
                }
            }
        });
        new Label(dataSetFromComposite, 0);
        new Label(dataSetFromComposite, 0);
        new Label(container, 0);
        this.selectMemberGroup = new Group(container, 0);
        this.selectMemberGroup.setSize(this.selectMemberGroup.computeSize(-1, -1));
        this.selectMemberGroup.setText("Members");
        this.selectMemberGroup.setLayout((Layout)new GridLayout(1, false));
        this.selectMemberGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createViewer((Composite)this.selectMemberGroup);
        new Label(container, 0);
        Composite btncomposite = new Composite((Composite)this.selectMemberGroup, 0);
        btncomposite.setLayout((Layout)new GridLayout(2, false));
        btncomposite.setSize(btncomposite.computeSize(-1, -1));
        this.clearSelBtn = new Button(btncomposite, 0x1000000);
        GridData gd_btnClear = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnClear.widthHint = 120;
        this.clearSelBtn.setLayoutData((Object)gd_btnClear);
        this.clearSelBtn.setText("&Clear Selections");
        this.clearSelBtn.setEnabled(false);
        this.clearSelBtn.addSelectionListener((SelectionListener)this);
        this.clearSelBtn.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8) {
                    int selectedElement = CopyPDSFromWizardPage.this.viewer.getTable().getSelectionIndex();
                    if (selectedElement == -1) {
                        CopyPDSFromWizardPage.this.viewer.editElement(CopyPDSFromWizardPage.this.viewer.getElementAt(CopyPDSFromWizardPage.this.viewer.getTable().getItemCount() - 1), 1);
                    } else {
                        CopyPDSFromWizardPage.this.viewer.editElement(CopyPDSFromWizardPage.this.viewer.getElementAt(selectedElement), 1);
                    }
                }
            }
        });
        this.deleteListBtn = new Button(btncomposite, 0x1000000);
        this.deleteListBtn.setText("Dele&te List");
        this.deleteListBtn.setEnabled(false);
        this.deleteListBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopyPDSFromWizardPage.this.returnDDCM = CopyPDSFromWizardPage.this.displayDatasetChangedMsg();
                if (CopyPDSFromWizardPage.this.returnDDCM == -1) {
                    String message = "Are you sure you want to delete the existing member list? Clicking Yes will delete the existing member list";
                    boolean result = MessageDialog.openQuestion(null, (String)"Warning", (String)message);
                    if (result) {
                        CopyPDSFromWizardPage.this.viewer.getTable().removeAll();
                        CopyPDSFromWizardPage.this.clearSelBtn.setEnabled(false);
                        CopyPDSFromWizardPage.this.deleteListBtn.setEnabled(false);
                        CopyPDSFromWizardPage.this.setPageComplete(CopyPDSFromWizardPage.this.isPageComplete());
                    }
                } else if (CopyPDSFromWizardPage.this.returnDDCM == 3) {
                    CopyPDSFromWizardPage.this.fromDataSetCombo.setFocus();
                }
            }
        });
        if (!this.isCopyPDSWizard) {
            this.dirListInsert = new Button(container, 32);
            this.dirListInsert.setText("Add to Director&y List view");
        }
        if (!FMPreferences.disabledPreview()) {
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Preview");
        }
        this.setControl((Control)container);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    private void createViewer(Composite parent) {
        ArrayList<FileMasterMember> prefilMember = new ArrayList<FileMasterMember>();
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        int i = 0;
        while (i < this.viewer.getTable().getItemCount()) {
            this.viewer.getTable().setLinesVisible(true);
            ++i;
        }
        this.viewer.getTable().setHeaderVisible(true);
        GridData gd_table = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_table.heightHint = 130;
        gd_table.widthHint = 497;
        this.viewer.getTable().setLayoutData((Object)gd_table);
        this.columnSorterListener();
        this.createColumns(parent, (TableViewer)this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (this.memberName != null) {
            prefilMember.add(this.memberName);
            this.viewer.setInput(prefilMember);
            this.viewer.setChecked(this.viewer.getElementAt(0), true);
        } else {
            this.viewer.setInput(null);
        }
        this.viewer.getTable().addFocusListener((FocusListener)this);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (CopyPDSFromWizardPage.this.viewer.getCheckedElements().length >= 1) {
                    CopyPDSFromWizardPage.this.clearSelBtn.setText("&Clear Selections");
                } else {
                    CopyPDSFromWizardPage.this.clearSelBtn.setText("Select &All");
                }
                if (CopyPDSFromWizardPage.this.viewer.getCheckedElements().length == 0) {
                    CopyPDSFromWizardPage.this.clearSelBtn.setText("Select &All");
                }
                CopyPDSFromWizardPage.this.setPageComplete(CopyPDSFromWizardPage.this.canFlipToNextPage());
            }
        });
        this.viewer.getTable().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    int selectedElement = CopyPDSFromWizardPage.this.viewer.getTable().getSelectionIndex();
                    if (selectedElement > -1 && CopyPDSFromWizardPage.this.viewer.getChecked(CopyPDSFromWizardPage.this.viewer.getElementAt(selectedElement))) {
                        CopyPDSFromWizardPage.this.viewer.editElement(CopyPDSFromWizardPage.this.viewer.getElementAt(selectedElement), 1);
                        return;
                    }
                    if (selectedElement > -1 && selectedElement + 1 < CopyPDSFromWizardPage.this.viewer.getTable().getItemCount()) {
                        CopyPDSFromWizardPage.this.viewer.getTable().setSelection(selectedElement + 1);
                        e.doit = false;
                        return;
                    }
                    CopyPDSFromWizardPage.this.viewer.getTable().setSelection(-1);
                    CopyPDSFromWizardPage.this.clearSelBtn.setFocus();
                } else if (e.detail == 8) {
                    int selectedElement = CopyPDSFromWizardPage.this.viewer.getTable().getSelectionIndex();
                    if (selectedElement > 0 && CopyPDSFromWizardPage.this.viewer.getChecked(CopyPDSFromWizardPage.this.viewer.getElementAt(selectedElement - 1))) {
                        CopyPDSFromWizardPage.this.viewer.editElement(CopyPDSFromWizardPage.this.viewer.getElementAt(selectedElement - 1), 1);
                        e.doit = false;
                        return;
                    }
                    if (selectedElement > 0) {
                        CopyPDSFromWizardPage.this.viewer.getTable().setSelection(selectedElement - 1);
                        e.doit = false;
                        return;
                    }
                    CopyPDSFromWizardPage.this.viewer.getTable().setSelection(-1);
                    CopyPDSFromWizardPage.this.fromVolumeCombo.setFocus();
                }
            }
        });
    }

    private void columnSorterListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = CopyPDSFromWizardPage.this.viewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                CopyPDSFromWizardPage.this.viewer.refresh();
            }
        };
    }

    private void createColumns(Composite parent, final TableViewer viewer) {
        String[] titles = new String[]{"Member", "Rename"};
        int[] bounds = new int[]{245, 245};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableViewerColumn.getColumn().setText(titles[i]);
            tableViewerColumn.getColumn().setWidth(bounds[i]);
            viewer.setSorter((ViewerSorter)new CopyPDSMemberSorter());
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(0));
            viewer.getTable().setSortDirection(128);
            switch (i) {
                case 0: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    tableColumn.addListener(13, this.sortListener);
                    break;
                }
                case 1: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CopyPDSRenameMemLabelProvider());
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setEditingSupport(new EditingSupport(tableViewerColumn.getViewer()){

                        protected void setValue(Object element, Object newName) {
                            FileMasterMember m = (FileMasterMember)((Object)element);
                            m.setNewName((String)newName);
                            viewer.refresh();
                            CopyPDSFromWizardPage.this.setPageComplete(CopyPDSFromWizardPage.this.canFlipToNextPage());
                        }

                        protected Object getValue(Object element) {
                            FileMasterMember m = (FileMasterMember)((Object)element);
                            return m.getNewName().toUpperCase();
                        }

                        protected CellEditor getCellEditor(Object element) {
                            final TextCellEditor textEditor = new TextCellEditor((Composite)viewer.getTable());
                            ((Text)textEditor.getControl()).setTextLimit(8);
                            ((Text)textEditor.getControl()).addVerifyListener((VerifyListener)new verifytoUpperCase());
                            ((Text)textEditor.getControl()).addModifyListener(new ModifyListener(){

                                public void modifyText(ModifyEvent e) {
                                    Widget source = e.widget;
                                    if (source instanceof Text) {
                                        CopyPDSFromWizardPage.this.setPageComplete(CopyPDSFromWizardPage.this.canFlipToNextPage());
                                    }
                                }
                            });
                            textEditor.getControl().addTraverseListener(new TraverseListener(){

                                public void keyTraversed(TraverseEvent e) {
                                    if (e.detail == 16) {
                                        textEditor.getControl().traverse(8);
                                        int selectedElement = viewer.getTable().getSelectionIndex();
                                        if (selectedElement + 1 < viewer.getTable().getItemCount()) {
                                            viewer.getTable().setSelection(selectedElement + 1);
                                            e.doit = false;
                                            return;
                                        }
                                        viewer.getTable().setSelection(-1);
                                        CopyPDSFromWizardPage.this.clearSelBtn.setFocus();
                                    } else if (e.detail == 8) {
                                        textEditor.getControl().traverse(4);
                                    }
                                }
                            });
                            return textEditor;
                        }

                        protected boolean canEdit(Object element) {
                            int i = 0;
                            while (i < viewer.getTable().getItems().length) {
                                if (viewer.getTable().getItems()[i].getText().equalsIgnoreCase(((FileMasterMember)((Object)element)).getName()) && viewer.getTable().getItems()[i].getChecked()) {
                                    return true;
                                }
                                ++i;
                            }
                            return false;
                        }
                    });
                }
            }
            ++i;
        }
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    public boolean canFlipToNextPage() {
        String errorFrom = new String();
        String inputRenames = new String();
        if (this.fromDataSetCombo != null && this.fromMemberNameCombo != null && this.fromVolumeCombo != null) {
            switch (Validator.dataset(this.fromDataSetCombo.getText(), true)) {
                case 3: {
                    errorFrom = String.valueOf(errorFrom) + Validator.errorMsg[3] + "\n";
                    this.btnMemberSelect.setEnabled(false);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    errorFrom = String.valueOf(errorFrom) + Validator.errorMsg[Validator.dataset(this.fromDataSetCombo.getText(), true)] + "\n ";
                    this.btnMemberSelect.setEnabled(false);
                    break;
                }
            }
            if (errorFrom.isEmpty()) {
                switch (Validator.member(this.fromMemberNameCombo.getText(), true)) {
                    case 7: {
                        if (Validator.dataset(this.fromDataSetCombo.getText(), true) == 0) {
                            this.btnMemberSelect.setEnabled(true);
                        }
                        String fromMemberText = this.fromMemberNameCombo.getText().trim();
                        if (this.viewer.getCheckedElements().length != 0 || fromMemberText.contains("*") && fromMemberText.length() == 1) break;
                        errorFrom = String.valueOf(errorFrom) + Validator.errorMsg[Validator.member(this.fromMemberNameCombo.getText(), true)] + "\n ";
                        break;
                    }
                    case 6: {
                        errorFrom = String.valueOf(errorFrom) + Validator.errorMsg[Validator.member(this.fromMemberNameCombo.getText(), true)] + "\n ";
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                    case 0: {
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                    case 5: {
                        if (Validator.dataset(this.fromDataSetCombo.getText(), true) == 0) {
                            this.btnMemberSelect.setEnabled(true);
                        }
                        if (this.viewer.getCheckedElements().length != 0) break;
                        errorFrom = String.valueOf(errorFrom) + Validator.errorMsg[Validator.member(this.fromMemberNameCombo.getText(), true)] + "\n ";
                    }
                }
                switch (Validator.volume(this.fromVolumeCombo.getText(), false)) {
                    case 9: {
                        errorFrom = String.valueOf(errorFrom) + Validator.errorMsg[Validator.volume(this.fromVolumeCombo.getText(), false)] + "\n ";
                    }
                }
            }
            int i = 0;
            while (i < this.viewer.getTable().getItemCount()) {
                inputRenames = ((FileMasterMember)((Object)this.viewer.getTable().getItems()[i].getData())).getNewName();
                if (inputRenames != null && this.viewer.getTable().getItems()[i].getChecked()) {
                    switch (Validator.renameMember(inputRenames, true)) {
                        case 10: {
                            errorFrom = String.valueOf(Validator.errorMsg[Validator.renameMember(inputRenames, true)]) + "\n ";
                            break;
                        }
                    }
                }
                ++i;
            }
            if (errorFrom.length() > 0) {
                this.setErrorMessage(errorFrom);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public IWizardPage getNextPage() {
        this.returnDDCM = this.displayDatasetChangedMsg();
        if (this.pendingNext && this.returnDDCM == 2) {
            this.returnDDCM = 3;
            this.pendingNext = false;
        } else if (this.pendingNext && this.returnDDCM == 3) {
            this.returnDDCM = 2;
            this.pendingNext = false;
        }
        CopyPDSToWizardPage page1 = new CopyPDSToWizardPage("Copy PDS To", this.server, this.dataSet, this.fromMemberNameCombo.getText(), this.isCopyPDSWizard);
        if (this.returnDDCM == 2 || this.returnDDCM == -1) {
            if (this.isCopyPDSWizard) {
                ((CopyPDSWizard)this.getWizard()).addPage((IWizardPage)page1);
                return ((CopyPDSWizard)this.getWizard()).getPage("Copy PDS To");
            }
            ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)page1);
            return ((CopyGenericWizard)this.getWizard()).getPage("Copy PDS To");
        }
        if (this.returnDDCM == 3) {
            this.fromDataSetCombo.setFocus();
        }
        return null;
    }

    public boolean isPageComplete() {
        return false;
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        TestingToolsWizardDialog dialog = null;
        this.returnDDCM = this.displayDatasetChangedMsg();
        if (this.returnDDCM == 2 || this.returnDDCM == -1) {
            if (source instanceof Button) {
                if (((Button)source).getText().equals("&Clear Selections")) {
                    int elements = 0;
                    while (elements < this.getViewer().getTable().getItemCount()) {
                        this.getViewer().setChecked(this.getViewer().getElementAt(elements), false);
                        ++elements;
                    }
                    ((Button)source).setText("Select &All");
                    this.setPageComplete(this.canFlipToNextPage());
                } else if (((Button)source).getText().equals("Select &All")) {
                    int elements = 0;
                    while (elements < this.getViewer().getTable().getItemCount()) {
                        this.getViewer().setChecked(this.getViewer().getElementAt(elements), true);
                        ++elements;
                    }
                    ((Button)source).setText("&Clear Selections");
                    this.setPageComplete(this.canFlipToNextPage());
                } else if (((Button)source).getText().equals("D&elete list")) {
                    String message = "Are you sure you want to delete the existing member list? Clicking Yes will delete the existing member list";
                    boolean result = MessageDialog.openQuestion(null, (String)"Warning", (String)message);
                    if (result) {
                        this.getViewer().getTable().removeAll();
                    }
                } else if (((Button)source).getText().equals("&Select...")) {
                    DatasetWizard wizard = new DatasetWizard(true, this.fromDataSetCombo.getText(), this.fromVolumeCombo.getText(), this.serverName);
                    dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
                    dialog.create();
                    DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            CopyPDSFromWizardPage.this.fmdataset = DatasetWizardPage.getSelectedDSN();
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    dialog.open();
                } else if (FMServerTreeModel.getInstance().getServer(this.serverName).getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)Validator.errorMsg[20]);
                } else if (this.fromDataSetCombo.getText().isEmpty() || Validator.dataset(this.fromDataSetCombo.getText(), true) == 3) {
                    GenericImportWizard wizard = new GenericImportWizard("Select DSN List", FMServerTreeModel.getInstance().getServer(this.serverName), false);
                    dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
                    dialog.open();
                } else {
                    GenericImportWizard wizard = new GenericImportWizard("Select DSN List", this.server, false);
                    dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
                    dialog.open();
                }
            }
        } else if (this.returnDDCM == 3) {
            this.fromDataSetCombo.setFocus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public void insertMembersToTable(List<FileMasterMember> members) {
        ArrayList<FileMasterMember> oldMembers = new ArrayList<FileMasterMember>();
        int i = 0;
        while (i < this.viewer.getTable().getItemCount()) {
            oldMembers.add((FileMasterMember)((Object)this.viewer.getElementAt(i)));
            ++i;
        }
        i = 0;
        while (i < members.size()) {
            oldMembers.add(members.get(i));
            ++i;
        }
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)oldMembers.toArray());
        this.viewer.setAllChecked(true);
        if (this.viewer.getTable().getItemCount() == 0) {
            this.clearSelBtn.setEnabled(false);
        }
        if (this.viewer.getCheckedElements().length == this.viewer.getTable().getItemCount()) {
            this.clearSelBtn.setText("&Clear Selections");
        } else {
            this.clearSelBtn.setText("Select &All");
        }
        if (members.size() > 0) {
            i = 0;
            while (i < this.viewer.getTable().getItemCount()) {
                ((FileMasterMember)((Object)this.viewer.getTable().getItems()[i].getData())).setChecked(true);
                ++i;
            }
            this.setPageComplete(this.isPageComplete());
            this.clearSelBtn.setEnabled(true);
            this.deleteListBtn.setEnabled(true);
        }
    }

    private void validateDataSet() {
        boolean datasetError;
        this.newDatasetName = this.fromDataSetCombo.getText().trim();
        this.ShowDialog = !this.store.getBoolean("CLOSE_VALUE");
        boolean bl = datasetError = Validator.dataset(this.fromDataSetCombo.getText(), true) != 0 && Validator.dataset(this.fromDataSetCombo.getText(), true) != 3 && Validator.dataset(this.fromDataSetCombo.getText(), true) != 1;
        if (!(!this.ShowDialog.booleanValue() || datasetError || this.viewer.getTable().getItemCount() <= 1 && this.fromMemberNameCombo.getText().isEmpty() || this.oldDatasetName.equalsIgnoreCase(this.newDatasetName))) {
            this.pendingMessage = true;
        } else {
            this.pendingMessage = false;
            if (!this.oldDatasetName.equalsIgnoreCase(this.newDatasetName)) {
                this.oldDatasetName = this.newDatasetName;
                this.viewer.getTable().removeAll();
                this.viewer.setInput(null);
                this.fromMemberNameCombo.setText("");
            }
        }
        this.displayDatasetChangedMsg();
    }

    private int displayDatasetChangedMsg() {
        this.msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (this.pendingMessage) {
            this.pendingMessage = false;
            if (!(this.viewer.getTable().getItemCount() <= 0 && this.fromMemberNameCombo.getText().isEmpty() || this.newDatasetName.equals(this.oldDatasetName))) {
                String title = "Confirm Change Data Set";
                String toggleMessage = "Do not ask me again";
                String question = "Are you sure you want to change the data set? Clicking Yes will reset all fields on this dialog. ";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Change Data Set", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)this.store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                this.pendingNext = true;
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    this.oldDatasetName = this.newDatasetName;
                    this.store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.viewer.getTable().removeAll();
                    this.viewer.setInput(null);
                    this.fromMemberNameCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.fromDataSetCombo.setText(this.oldDatasetName);
                    this.newDatasetName = this.oldDatasetName;
                }
            }
        }
        return returncode;
    }

    public void focusGained(FocusEvent e) {
        this.returnDDCM = this.displayDatasetChangedMsg();
        if (this.returnDDCM == 3) {
            this.fromDataSetCombo.setFocus();
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fromDataSetCombo.setFocus();
        if (this.volumeSerial != null) {
            this.fromVolumeCombo.setText(this.volumeSerial);
        }
    }

    public String getFromDataSetName() {
        return this.fromDataSetCombo.getText().trim();
    }

    public void setFromDataSetCombo(FileMasterDataset fromDataset) {
        this.dataSet = fromDataset;
        if (this.fromDataSetCombo != null) {
            this.fromDataSetCombo.setText(fromDataset.getName());
        }
    }

    public String getFromMemberName() {
        String members = "";
        int numCheckedMembers = this.viewer.getCheckedElements().length;
        if (numCheckedMembers > 0) {
            int i = 0;
            while (i < numCheckedMembers) {
                members = ((FileMasterMember)((Object)this.viewer.getCheckedElements()[i])).getNewName().isEmpty() ? String.valueOf(members) + ((FileMasterMember)((Object)this.viewer.getCheckedElements()[i])).getName() + "     " : String.valueOf(members) + "[" + ((FileMasterMember)((Object)this.viewer.getCheckedElements()[i])).getName() + "," + ((FileMasterMember)((Object)this.viewer.getCheckedElements()[i])).getNewName() + "]     ";
                ++i;
            }
            return members;
        }
        return this.fromMemberNameCombo.getText();
    }

    public String[] getFromMemberList() {
        String[] memberList;
        int numCheckedMembers = this.viewer.getCheckedElements().length;
        if (numCheckedMembers > 0) {
            memberList = new String[numCheckedMembers];
            int i = 0;
            while (i < numCheckedMembers) {
                memberList[i] = ((FileMasterMember)((Object)this.viewer.getCheckedElements()[i])).getName();
                ++i;
            }
        } else {
            memberList = new String[]{this.fromMemberNameCombo.getText().trim()};
        }
        return memberList;
    }

    public String[] getToMemberList() {
        String[] memberList;
        int numCheckedMembers = this.viewer.getCheckedElements().length;
        if (numCheckedMembers > 0) {
            memberList = new String[numCheckedMembers];
            int i = 0;
            while (i < numCheckedMembers) {
                memberList[i] = ((FileMasterMember)((Object)this.viewer.getCheckedElements()[i])).getNewName().isEmpty() ? ((FileMasterMember)((Object)this.viewer.getCheckedElements()[i])).getName() : ((FileMasterMember)((Object)this.viewer.getCheckedElements()[i])).getNewName();
                ++i;
            }
        } else {
            memberList = new String[]{this.fromMemberNameCombo.getText().trim()};
        }
        return memberList;
    }

    public void setFromMemberNameCombo(Combo fromMemberNameCombo) {
        this.fromMemberNameCombo = fromMemberNameCombo;
    }

    public Combo getFromVolumeCombo() {
        return this.fromVolumeCombo;
    }

    public void insertDSNToField(String value) {
        this.fromDataSetCombo.setText(value);
    }

    public boolean dirListInsertFrom() {
        if (this.dirListInsert == null) {
            return false;
        }
        return this.dirListInsert.getSelection();
    }

    public Combo getFromMemberNameCombo() {
        return this.fromMemberNameCombo;
    }

    public FileMasterDataset getFromDataSet() {
        return this.dataSet;
    }
}

