/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.AllocateNewParmPDS;
import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetWCMEM;
import com.ca.filemaster.ui.wizards.ACLabelProvider;
import com.ca.filemaster.ui.wizards.AModeLabelProvider;
import com.ca.filemaster.ui.wizards.ChangedLabelProvider;
import com.ca.filemaster.ui.wizards.CreatedLabelProvider;
import com.ca.filemaster.ui.wizards.IDLabelProvider;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.filemaster.ui.wizards.LinkDateLabelProvider;
import com.ca.filemaster.ui.wizards.LinkTimeLabelProvider;
import com.ca.filemaster.ui.wizards.MemberLabelProvider;
import com.ca.filemaster.ui.wizards.MemberSorter;
import com.ca.filemaster.ui.wizards.MemberWizardOptions;
import com.ca.filemaster.ui.wizards.RModeChangedLabelProvider;
import com.ca.filemaster.ui.wizards.RecordCountLabelProvider;
import com.ca.filemaster.ui.wizards.ReentrantLabelProvider;
import com.ca.filemaster.ui.wizards.RefreshableLabelProvider;
import com.ca.filemaster.ui.wizards.ReusableLabelProvider;
import com.ca.filemaster.ui.wizards.SizeLabelProvider;
import com.ca.filemaster.ui.wizards.TimeChangedLabelProvider;
import com.ca.filemaster.utilities.AllocateNewDataSetWizardPage1;
import com.ca.filemaster.utilities.AllocateNewDataSetWizardPage2;
import com.ca.filemaster.utility.compare.CompareWizardPage1;
import com.ca.filemaster.utility.compare.CompareWizardPage2;
import com.ca.filemaster.utility.compare.CompareWizardPage3;
import com.ca.filemaster.utility.copy.CopyPDSFromWizardPage;
import com.ca.filemaster.utility.copy.CopySeqToWizardPage;
import com.ca.filemaster.utility.copy.CopyVSAMToWizardPage;
import com.ca.filemaster.utility.copy.SelectionCrtLayoutWizardPage;
import com.ca.filemaster.utility.print.PrintPageOneTable;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageOne;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MemberWizardPage
extends WizardPage
implements ModifyListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final String sourceClass = MemberWizardPage.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.memberWizard";
    private Text dataSetText;
    private Table membersTable;
    private Combo filterPattern;
    private Button filterBtn;
    private Button optionsBtn;
    private static Button selectAllClearButton;
    public static CheckboxTableViewer checkboxTableViewer;
    private Listener sortListener;
    private String memberName = "";
    private String dataSetName;
    private String membersName;
    private ArrayList<String> memberList;
    private FileMasterMember[] members;
    private boolean isSingleMember;
    private boolean filterIsMember;
    private boolean patternFocus = false;
    private static FileMasterServer server;
    private static FileMasterDataset dataSet;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private String serverName;
    private CopyPDSFromWizardPage copyPDSFromWizardPage;
    private CopyVSAMToWizardPage copyVSAMToWizardPage;
    private CopySeqToWizardPage copySeqToWizardPage;
    private CompareWizardPage1 compareWizardPage1;
    private CompareWizardPage2 compareWizardPage2;
    private CompareWizardPage3 compareWizardPage3;
    private AllocateNewDataSetWizardPage1 allocateNewDataSetWizardPage1;
    private AllocateNewDataSetWizardPage2 allocateNewDataSetWizardPage2;
    private SelectionCrtLayoutWizardPage selectionCrtLayoutWizardPage;
    private ImportSelCritWizardPage importSelCritWizardPage;
    private PrintUtilityWizardPageOne printPageOneTable;
    private FileMasterMember member;
    private static List<FileMasterMember> fmMemberList;
    private static Text numberOfMem;
    public static Button memValue;
    private static int oldCheckedElements;
    private int pixelSizeOfCharacter = -1;

    static {
        fmMemberList = new ArrayList<FileMasterMember>();
    }

    public MemberWizardPage() {
        super("wizardPage");
    }

    public MemberWizardPage(String pageName, FileMasterMember member, FileMasterDataset dataSet, FileMasterServer server, boolean isSingleMember) {
        super(pageName);
        this.setTitle("Select Member");
        this.setDescription("");
        MemberWizardPage.server = server;
        MemberWizardPage.dataSet = dataSet;
        this.member = member;
        if (member != null) {
            this.memberName = member.getName();
        }
        this.dataSetName = dataSet.getName();
        this.isSingleMember = isSingleMember;
        this.serverName = server.getName();
        this.membersName = new String();
    }

    public MemberWizardPage(String pageName, FileMasterMember member, FileMasterDataset dataSet, FileMasterServer server, boolean isSingleMember, ArrayList<String> memberList) {
        super(pageName);
        this.setTitle("Select Member");
        this.setDescription("");
        MemberWizardPage.server = server;
        MemberWizardPage.dataSet = dataSet;
        this.member = member;
        if (member != null) {
            this.memberName = member.getName();
        }
        this.dataSetName = dataSet.getName();
        this.isSingleMember = isSingleMember;
        this.serverName = server.getName();
        this.memberList = memberList;
        this.membersName = new String();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        Preferences.userRoot().node(((Object)((Object)this)).getClass().getName());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.memberWizard");
        this.filterIsMember = false;
        if (this.getShell().getParent().getData() instanceof TestingToolsWizardDialog) {
            IWizardPage page = ((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage();
            if (page instanceof CopyPDSFromWizardPage) {
                this.copyPDSFromWizardPage = (CopyPDSFromWizardPage)page;
            } else if (page instanceof CopySeqToWizardPage) {
                this.copySeqToWizardPage = (CopySeqToWizardPage)page;
            } else if (page instanceof CopyVSAMToWizardPage) {
                this.copyVSAMToWizardPage = (CopyVSAMToWizardPage)page;
            } else if (page instanceof CompareWizardPage1) {
                this.compareWizardPage1 = (CompareWizardPage1)page;
            } else if (page instanceof CompareWizardPage2) {
                this.compareWizardPage2 = (CompareWizardPage2)page;
            } else if (page instanceof CompareWizardPage3) {
                this.compareWizardPage3 = (CompareWizardPage3)page;
            } else if (page instanceof AllocateNewDataSetWizardPage1) {
                this.allocateNewDataSetWizardPage1 = (AllocateNewDataSetWizardPage1)page;
            } else if (page instanceof AllocateNewDataSetWizardPage2) {
                this.allocateNewDataSetWizardPage2 = (AllocateNewDataSetWizardPage2)page;
            } else if (page instanceof SelectionCrtLayoutWizardPage) {
                this.selectionCrtLayoutWizardPage = (SelectionCrtLayoutWizardPage)page;
            } else if (page instanceof ImportSelCritWizardPage) {
                this.importSelCritWizardPage = (ImportSelCritWizardPage)page;
            } else if (page instanceof PrintUtilityWizardPageOne) {
                this.printPageOneTable = (PrintUtilityWizardPageOne)page;
            }
        }
        this.setControl((Control)container);
        container.setSize(container.computeSize(-1, -1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite dataSetComposite = new Composite(container, 0);
        dataSetComposite.setLayout((Layout)new GridLayout(4, false));
        dataSetComposite.setSize(dataSetComposite.computeSize(-1, -1));
        dataSetComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label dataSetLabel = new Label(dataSetComposite, 0);
        dataSetLabel.setText("Data set name:");
        this.dataSetText = new Text(dataSetComposite, 8);
        this.dataSetText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.dataSetName != null) {
            this.dataSetText.setText(this.dataSetName);
        }
        new Label(dataSetComposite, 0);
        new Label(dataSetComposite, 0);
        Label memberLabel = new Label(dataSetComposite, 0);
        memberLabel.setText("&Member name:");
        this.filterPattern = new Combo(dataSetComposite, 2048);
        GridData gd_oldMemberNameCombo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_oldMemberNameCombo.horizontalIndent = 2;
        this.filterPattern.setLayoutData((Object)gd_oldMemberNameCombo);
        TextUtil.setWidth((Combo)this.filterPattern, (int)37);
        this.filterPattern.setTextLimit(8);
        this.filterPattern.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.filterPattern.addModifyListener((ModifyListener)this);
        FMHistory.intializeComboBoxes(this.filterPattern, "FilterPatternListMemberSelect");
        this.filterPattern.setText(this.memberName);
        this.filterBtn = new Button(dataSetComposite, 0);
        this.filterBtn.setText("&Select");
        this.filterBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemberWizardPage.this.doSelect();
                MemberWizardPage.this.setPageComplete(MemberWizardPage.this.isPageComplete());
            }
        });
        this.filterPattern.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!MemberWizardPage.this.patternFocus && !MemberWizardPage.this.getShell().getParent().getData().getClass().getName().endsWith("org.eclipse.ui.internal.WorkbenchWindow")) {
                    MemberWizardPage.this.patternFocus = true;
                    MemberWizardPage.this.doSelect();
                    MemberWizardPage.this.setPageComplete(MemberWizardPage.this.isPageComplete());
                }
            }
        });
        this.optionsBtn = new Button(dataSetComposite, 0);
        this.optionsBtn.setText("&Filter...");
        this.optionsBtn.setEnabled(false);
        this.optionsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemberWizardPage.this.member = new FileMasterMember(null);
                MemberWizardPage.this.member.setName(MemberWizardPage.this.filterPattern.getText().trim());
                MemberWizardOptions wizard = new MemberWizardOptions(server, dataSet, MemberWizardPage.this.member);
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(MemberWizardPage.this.getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
        });
        Group selectMembersGroup = new Group(container, 0);
        selectMembersGroup.setLayout((Layout)new GridLayout(2, false));
        selectMembersGroup.setSize(selectMembersGroup.computeSize(-1, -1));
        selectMembersGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        selectMembersGroup.setText("Se&lect member");
        selectMembersGroup.setRedraw(true);
        checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)selectMembersGroup, (int)68354);
        checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (MemberWizardPage.this.isSingleMember) {
                    checkboxTableViewer.setCheckedElements(new Object[]{event.getElement()});
                }
                if (!MemberWizardPage.this.isSingleMember) {
                    if (checkboxTableViewer.getCheckedElements().length == checkboxTableViewer.getTable().getItemCount()) {
                        selectAllClearButton.setText("&Clear Selections");
                    } else {
                        selectAllClearButton.setText("Select &All");
                    }
                    if (checkboxTableViewer.getCheckedElements().length == 0) {
                        selectAllClearButton.setText("Select &All");
                    }
                } else if (checkboxTableViewer.getCheckedElements().length == 1) {
                    selectAllClearButton.setEnabled(true);
                } else {
                    selectAllClearButton.setEnabled(false);
                }
                MemberWizardPage.this.setPageComplete(MemberWizardPage.this.isPageComplete());
            }
        });
        this.membersTable = checkboxTableViewer.getTable();
        GridData gd_membersTtable = new GridData(4, 4, true, true, 2, 1);
        gd_membersTtable.heightHint = 149;
        this.membersTable.setLayoutData((Object)gd_membersTtable);
        this.membersTable.setHeaderVisible(true);
        this.membersTable.setLinesVisible(true);
        this.columnSorterListener();
        if (MemberWizardPage.isLoadLib()) {
            this.createLoadLibColumns(parent, checkboxTableViewer);
        } else {
            this.createColumns(parent, checkboxTableViewer);
        }
        checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.filterPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MemberWizardPage.this.setPageComplete(MemberWizardPage.this.isPageComplete());
            }
        });
        selectAllClearButton = new Button((Composite)selectMembersGroup, 0);
        GridData gd_selectAllClearButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectAllClearButton.widthHint = 120;
        selectAllClearButton.setLayoutData((Object)gd_selectAllClearButton);
        selectAllClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MemberWizardPage.this.isSingleMember) {
                    if (selectAllClearButton.getText() == "Select &All") {
                        checkboxTableViewer.setAllChecked(true);
                        selectAllClearButton.setText("&Clear Selections");
                    } else {
                        selectAllClearButton.setText("Select &All");
                        checkboxTableViewer.setAllChecked(false);
                    }
                } else {
                    selectAllClearButton.setEnabled(false);
                    checkboxTableViewer.setAllChecked(false);
                }
                MemberWizardPage.this.setPageComplete(MemberWizardPage.this.isPageComplete());
            }
        });
        if (!this.isSingleMember) {
            selectAllClearButton.setText("Select &All");
        } else {
            selectAllClearButton.setText("&Clear Selections");
        }
        selectAllClearButton.setEnabled(false);
        numberOfMem = new Text((Composite)selectMembersGroup, 8);
        numberOfMem.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)numberOfMem, (int)12);
        numberOfMem.setEnabled(false);
        this.getShell().getDefaultButton().setText("OK");
        this.filterPattern.setFocus();
        memValue = new Button(parent, 0);
        memValue.setEnabled(false);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    private static boolean isLoadLib() {
        return (dataSet.getDsOrg().equalsIgnoreCase("PDS") || dataSet.getDsOrg().equalsIgnoreCase("PDSE")) && dataSet.getRecfm().equalsIgnoreCase("U");
    }

    private void doSelect() {
        FileMasterMember member = new FileMasterMember(null);
        member.setName(this.filterPattern.getText());
        if (this.filterPattern.getText().equalsIgnoreCase("")) {
            member.setName("*");
        }
        RunGetWCMEM runner = new RunGetWCMEM(dataSet, server, member, true, "S");
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        this.xmlRun(xml);
    }

    public boolean xmlRun(XMLRequest xml) {
        fmMemberList.clear();
        oldCheckedElements = checkboxTableViewer.getCheckedElements().length;
        int count = 0;
        while (count < oldCheckedElements) {
            fmMemberList.add((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[count]));
            ++count;
        }
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
                numberOfMem.setText("No members returned.");
                numberOfMem.setEnabled(true);
            } else {
                NodeList nodes = element.getElementsByTagName("MemberInfo");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                ArrayList<String> contentErrorMsg = new ArrayList<String>();
                if (nodes.getLength() == 0) {
                    int count2 = 0;
                    while (count2 < messages.getLength()) {
                        message = String.valueOf(message) + ((Element)messages.item(count2)).getTextContent().replaceAll("CAWA[0-9A-Z]{0,5}", "") + "\n";
                        contentErrorMsg.add(String.valueOf(((Element)messages.item(count2)).getTextContent().replaceAll("CAWA[0-9A-Z]{0,5}", "")) + "\n");
                        ++count2;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = MemberWizardPage.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message), contentErrorMsg);
                    numberOfMem.setText("No members returned.");
                    numberOfMem.setEnabled(true);
                } else {
                    if (MemberWizardPage.isLoadLib()) {
                        int i = 0;
                        while (i < nodes.getLength()) {
                            Element dsElement = (Element)nodes.item(i);
                            FileMasterMember wcMember = new FileMasterMember(null);
                            wcMember.setName(dsElement.getAttribute("name"));
                            wcMember.setSize(dsElement.getAttribute("programSize"));
                            wcMember.setAmode(dsElement.getAttribute("aMode"));
                            wcMember.setRmode(dsElement.getAttribute("rMode"));
                            wcMember.setLinkDate(dsElement.getAttribute("linkDate"));
                            wcMember.setLinkTime(dsElement.getAttribute("linkTime"));
                            wcMember.setReentrant(dsElement.getAttribute("reentrant"));
                            wcMember.setReusable(dsElement.getAttribute("reusable"));
                            wcMember.setRefreshable(dsElement.getAttribute("refreshable"));
                            wcMember.setAuthCode(dsElement.getAttribute("authCode"));
                            if (!fmMemberList.contains((Object)wcMember)) {
                                fmMemberList.add(wcMember);
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < nodes.getLength()) {
                            Element dsElement = (Element)nodes.item(i);
                            FileMasterMember wcMember = new FileMasterMember(null);
                            wcMember.setName(dsElement.getAttribute("name"));
                            wcMember.setRecordCount(dsElement.getAttribute("recordCount"));
                            wcMember.setDateCreated(dsElement.getAttribute("dateCreated"));
                            wcMember.setDateChanged(dsElement.getAttribute("dateChanged"));
                            wcMember.setTimeChanged(dsElement.getAttribute("timeChanged"));
                            wcMember.setID(dsElement.getAttribute("userID"));
                            if (!fmMemberList.contains((Object)wcMember)) {
                                fmMemberList.add(wcMember);
                            }
                            ++i;
                        }
                    }
                    checkboxTableViewer.setInput((Object)fmMemberList.toArray(new FileMasterMember[fmMemberList.size()]));
                    checkboxTableViewer.refresh();
                    if (nodes.getLength() == 1) {
                        numberOfMem.setText(String.valueOf(nodes.getLength()) + " member returned.");
                    } else {
                        numberOfMem.setText(String.valueOf(nodes.getLength()) + " members returned.");
                    }
                    numberOfMem.setEnabled(true);
                }
                if (fmMemberList.size() > 0) {
                    selectAllClearButton.setEnabled(true);
                } else {
                    selectAllClearButton.setEnabled(false);
                }
                return true;
            }
        }
        return false;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    public boolean isPageComplete() {
        if (Validator.member(this.filterPattern.getText(), true) == 0 && this.filterBtn != null) {
            this.filterBtn.setEnabled(false);
            this.optionsBtn.setEnabled(false);
            this.filterIsMember = true;
            this.setErrorMessage(null);
            return true;
        }
        this.filterIsMember = false;
        String error = new String();
        if (this.filterBtn != null && checkboxTableViewer != null) {
            switch (Validator.member(this.filterPattern.getText(), true)) {
                case 7: {
                    this.filterBtn.setEnabled(true);
                    this.optionsBtn.setEnabled(true);
                    if (checkboxTableViewer.getCheckedElements().length != 0) break;
                    error = String.valueOf(error) + Validator.errorMsg[Validator.member(this.filterPattern.getText(), true)] + "\n";
                    break;
                }
                case 6: {
                    error = String.valueOf(error) + "Member name has invalid format.\n ";
                    this.filterBtn.setEnabled(false);
                    this.optionsBtn.setEnabled(false);
                    break;
                }
                case 5: {
                    if (checkboxTableViewer.getCheckedElements().length == 0) {
                        error = String.valueOf(error) + Validator.errorMsg[Validator.member(this.filterPattern.getText(), true)] + "\n";
                    }
                    this.filterBtn.setEnabled(true);
                    this.optionsBtn.setEnabled(true);
                    break;
                }
                case 0: {
                    this.optionsBtn.setEnabled(false);
                }
            }
            if (error.length() > 0) {
                this.setErrorMessage(error);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    public boolean doFinish() {
        ArrayList<FileMasterMember> checkedAL = new ArrayList<FileMasterMember>();
        FileMasterMember member = new FileMasterMember(null);
        FMHistory.insertHistory(this.filterPattern, "FilterPatternListMemberSelect");
        if (this.filterIsMember) {
            this.membersName = this.filterPattern.getText().trim();
            this.members = new FileMasterMember[1];
            this.members[0] = CommonMFCalls.getFQMEM(this.dataSetName, this.membersName, server, "S");
            if (!CommonMFCalls.RETURN_CODE.equals("0")) {
                return false;
            }
        } else {
            int i;
            this.membersName = "";
            if (MemberWizardPage.isLoadLib()) {
                i = 0;
                while (i < checkboxTableViewer.getCheckedElements().length) {
                    if (checkboxTableViewer.getChecked(checkboxTableViewer.getCheckedElements()[i]) && !checkboxTableViewer.getGrayed(checkboxTableViewer.getCheckedElements()[i])) {
                        member = new FileMasterMember(null);
                        member.setName(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getName());
                        member.setSize(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getSize());
                        member.setAmode(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getAmode());
                        member.setRmode(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getRmode());
                        member.setLinkDate(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getLinkDate());
                        member.setLinkTime(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getLinkTime());
                        member.setReentrant(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getReentrant());
                        member.setReusable(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getReusable());
                        member.setRefreshable(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getRefreshable());
                        member.setAuthCode(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getAuthCode());
                        checkedAL.add(member);
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < checkboxTableViewer.getCheckedElements().length) {
                    if (checkboxTableViewer.getChecked(checkboxTableViewer.getCheckedElements()[i]) && !checkboxTableViewer.getGrayed(checkboxTableViewer.getCheckedElements()[i])) {
                        member = new FileMasterMember(null);
                        member.setName(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getName());
                        member.setRecordCount(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getRecordCount());
                        member.setDateCreated(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getDateCreated());
                        member.setDateChanged(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getDateChanged());
                        member.setTimeChanged(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getTimeChanged());
                        member.setID(((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[i])).getID());
                        checkedAL.add(member);
                    }
                    ++i;
                }
            }
            Object[] checked = checkedAL.toArray(new Object[checkedAL.size()]);
            this.members = new FileMasterMember[checked.length];
            if (checked != null && checked.length > 0) {
                int count = 0;
                while (count < checked.length) {
                    this.members[count] = (FileMasterMember)((Object)checked[count]);
                    this.membersName = String.valueOf(this.membersName) + this.members[count].getName();
                    if (count < checked.length - 1) {
                        this.membersName = String.valueOf(this.membersName) + ";";
                    }
                    ++count;
                }
            }
        }
        if (this.copyPDSFromWizardPage != null) {
            this.copyPDSFromWizardPage.insertMembersToTable(Arrays.asList(this.members));
        } else if (this.copySeqToWizardPage != null && this.isSingleMember) {
            this.copySeqToWizardPage.insertMemberToField(this.membersName);
        } else if (this.copyVSAMToWizardPage != null && this.isSingleMember) {
            this.copyVSAMToWizardPage.insertMemberToField(this.membersName);
        } else if (this.compareWizardPage1 != null) {
            if (checkboxTableViewer.getCheckedElements().length == 1) {
                this.compareWizardPage1.insertMemberToField(this.membersName);
            }
        } else if (this.compareWizardPage2 != null) {
            if (checkboxTableViewer.getCheckedElements().length == 1) {
                this.compareWizardPage2.insertMemberToField(this.membersName);
            }
        } else if (this.compareWizardPage3 == null && this.selectionCrtLayoutWizardPage == null) {
            if (this.allocateNewDataSetWizardPage1 != null) {
                ((AllocateNewParmPDS)this.allocateNewDataSetWizardPage1.getPreviousPage()).insertMembers(this.members);
            } else if (this.allocateNewDataSetWizardPage2 != null) {
                ((AllocateNewParmPDS)this.allocateNewDataSetWizardPage2.getPreviousPage().getPreviousPage()).insertMembers(this.members);
            } else if (this.importSelCritWizardPage != null) {
                this.importSelCritWizardPage.insertMembersToTable(Arrays.asList(this.members));
            } else if (this.printPageOneTable != null) {
                PrintPageOneTable.insertMembersToTable(Arrays.asList(this.members));
            } else if (this.getShell().getParent().toString().contains("CA File Master Plus") || this.getShell().getParent().toString().contains("Eclipse")) {
                Element memberElement;
                TT_TreeItem memberItem;
                server = this.model.getServer(this.serverName);
                TT_TreeItem serverItem = this.model.findObject((Object)this.model.getServer(this.serverName));
                Element serverElement = server.getElement();
                Element datasetElement = null;
                TT_TreeItem datasetItem = null;
                datasetItem = this.model.dlistMap.get((String.valueOf(server.getUUIDString()) + this.dataSetName).hashCode());
                datasetElement = datasetItem.getElement();
                String memberNotAdded = "";
                if (this.filterIsMember) {
                    memberItem = this.model.dlistMap.get((String.valueOf(server.getUUIDString()) + this.dataSetName + this.members[0].getName()).hashCode());
                    if (memberItem != null) {
                        memberNotAdded = String.valueOf(memberNotAdded) + "\n" + this.members[0].getName();
                    } else {
                        memberElement = this.model.addMember(datasetElement, this.members[0]);
                        memberItem = this.model.insertMember(datasetItem, memberElement);
                        member = (FileMasterMember)memberItem.getValue();
                    }
                }
                int count = 0;
                while (count < checkedAL.size()) {
                    memberItem = this.model.dlistMap.get((String.valueOf(server.getUUIDString()) + this.dataSetName + ((FileMasterMember)((Object)checkedAL.get(count))).getName()).hashCode());
                    if (memberItem != null) {
                        memberNotAdded = String.valueOf(memberNotAdded) + "\n" + ((FileMasterMember)((Object)checkedAL.get(count))).getName();
                    } else {
                        memberElement = this.model.addMember(datasetElement, (FileMasterMember)((Object)checkedAL.get(count)));
                        memberItem = this.model.insertMember(datasetItem, memberElement);
                        member = (FileMasterMember)memberItem.getValue();
                    }
                    ++count;
                }
                this.model.save();
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Shell shell = window.getShell();
                shell.setMinimized(false);
                shell.forceActive();
                shell.forceFocus();
                try {
                    TreeViewer viewer;
                    IWorkbenchPage page = window.getActivePage();
                    IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
                    if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                        TT_TreeItem selection = this.model.dlistMap.get((String.valueOf(server.getUUIDString()) + this.dataSetName + member.getName()).hashCode());
                        TT_TreeItem parent = selection.getParent();
                        viewer.refresh((Object)parent, true);
                        viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                        view.setFocus();
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }
        memValue.notifyListeners(13, new Event());
        return true;
    }

    public String getMemberName() {
        return this.membersName;
    }

    public List<FileMasterMember> getMembersList() {
        if (this.members != null) {
            return Arrays.asList(this.members);
        }
        return null;
    }

    private void createColumns(Composite parent, CheckboxTableViewer viewer) {
        String[] titles = new String[]{"Member", "Record Count", "Created", "Changed", "Time Changed", "ID"};
        viewer.setSorter((ViewerSorter)new MemberSorter());
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(13 * Constants.getPixelSizeOfCharacter());
            switch (i) {
                case 0: {
                    this.membersTable.setSortColumn(tableColumn);
                    this.membersTable.setSortDirection(128);
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.addListener(13, this.sortListener);
                    tableColumn.setAlignment(131072);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new RecordCountLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.addListener(13, this.sortListener);
                    tableColumn.setAlignment(131072);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CreatedLabelProvider());
                    break;
                }
                case 3: {
                    tableColumn.addListener(13, this.sortListener);
                    tableColumn.setAlignment(131072);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ChangedLabelProvider());
                    break;
                }
                case 4: {
                    tableColumn.addListener(13, this.sortListener);
                    tableColumn.setAlignment(131072);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new TimeChangedLabelProvider());
                    break;
                }
                case 5: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new IDLabelProvider());
                }
            }
            ++i;
        }
    }

    private void createLoadLibColumns(Composite parent, CheckboxTableViewer viewer) {
        String[] titles = new String[]{"Member", "Size", "AMode", "RMode", "Link-Date", "Link Time", "Reentrant", "Reuseable", "Refreshable", "AC"};
        viewer.setSorter((ViewerSorter)new MemberSorter());
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(13 * Constants.getPixelSizeOfCharacter());
            switch (i) {
                case 0: {
                    this.membersTable.setSortColumn(tableColumn);
                    this.membersTable.setSortDirection(128);
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.addListener(13, this.sortListener);
                    tableColumn.setAlignment(131072);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new SizeLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new AModeLabelProvider());
                    break;
                }
                case 3: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new RModeChangedLabelProvider());
                    break;
                }
                case 4: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new LinkDateLabelProvider());
                    break;
                }
                case 5: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new LinkTimeLabelProvider());
                    break;
                }
                case 6: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ReentrantLabelProvider());
                    break;
                }
                case 7: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ReusableLabelProvider());
                    break;
                }
                case 8: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new RefreshableLabelProvider());
                    break;
                }
                case 9: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ACLabelProvider());
                }
            }
            ++i;
        }
    }

    private void columnSorterListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = checkboxTableViewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                checkboxTableViewer.refresh();
            }
        };
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public static String getSelectedMember() {
        return ((FileMasterMember)((Object)checkboxTableViewer.getCheckedElements()[0])).getName();
    }
}

