/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.ConfigureMFsettingVariableList;
import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunSetConfigureSetting
implements Runnable {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private static final String SERVICE = "filemaster/fmp";
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String command;
    private String uuid;
    File file;
    private boolean canRetry = true;
    private ConfigureMFsettingVariableList configureVariableList;
    private String[] jobCard;

    public RunSetConfigureSetting(FileMasterServer server, ConfigureMFsettingVariableList configureVariableList) {
        this.server = server;
        this.configureVariableList = configureVariableList;
        if (configureVariableList.getJobCard() != null) {
            this.jobCard = configureVariableList.getJobCard();
            int i = 0;
            while (i < this.jobCard.length) {
                if (this.jobCard[i] != null) {
                    this.jobCard[i] = this.jobCard[i].replace("&", "&amp;");
                }
                ++i;
            }
        }
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.uuid = FileMasterSession.getUUID(this.server, true);
            if (this.uuid != null) {
                long t1;
                map.put("uuid", this.uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                if (this.uuid != null && !this.uuid.isEmpty()) {
                    this.xml = connection.connect("Find", map, false, this.createXml());
                    if (this.xml.getAttachedFile() != null) {
                        File file = this.xml.getAttachedFile();
                        FileInputStream is = new FileInputStream(file);
                        this.xml = new XMLRequest((InputStream)is);
                    } else {
                        Element reqElement = this.xml.getRoot();
                        if (reqElement != null && (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("16"))) {
                            String message = "";
                            FileMasterSession.removeSession(this.server, this.uuid);
                            if (this.canRetry) {
                                this.canRetry = false;
                                this.run();
                                return;
                            }
                            ArrayList<String> extraText = new ArrayList<String>();
                            extraText.add("Session information: " + this.uuid);
                            message = "Return Code: " + reqElement.getAttribute("errorlevel");
                            String message2 = "The connection with the server has been interrupted.";
                            TT_ErrorDialog.openError(null, (String)"Communications Error", (String)message, (Throwable)new Throwable(message2), extraText);
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXml() {
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">";
        if (this.configureVariableList.getPreferencescalltype().equalsIgnoreCase("I")) {
            this.command = String.valueOf(this.command) + "<SetPreferences setpreferencescalltype=\"" + this.configureVariableList.getPreferencescalltype() + "\">";
        } else {
            this.command = String.valueOf(this.command) + "<SetPreferences setpreferencescalltype=\"" + this.configureVariableList.getPreferencescalltype() + "\">";
            this.command = String.valueOf(this.command) + "<SetPreferencesData>";
            String deleteDataset = this.configureVariableList.isDeleteDataset() ? "Y" : "N";
            String deletMember = this.configureVariableList.isDeleteMember() ? "Y" : "N";
            this.command = String.valueOf(this.command) + "<DefaultOptionsData ";
            this.command = String.valueOf(this.command) + " confirmDataSetDeletes=\"" + deleteDataset + "\" ";
            this.command = String.valueOf(this.command) + " confirmMemberDeletes=\"" + deletMember + "\" ";
            this.command = String.valueOf(this.command) + " maxSize=\"" + this.configureVariableList.getSizeCylinders() + "\" ";
            if (this.jobCard != null && this.jobCard.length > 0) {
                if (this.jobCard[0] != null && this.jobCard[0].trim().length() > 0) {
                    this.command = String.valueOf(this.command) + "JobInformationLine1=\"" + this.jobCard[0] + "\" ";
                }
                if (this.configureVariableList.getJobCard() != null && this.jobCard.length > 1 && this.configureVariableList.getJobCard().length > 1) {
                    this.command = String.valueOf(this.command) + "JobInformationLine2=\"" + this.jobCard[1] + "\" ";
                }
                if (this.configureVariableList.getJobCard() != null && this.jobCard.length > 2 && this.configureVariableList.getJobCard().length > 2) {
                    this.command = String.valueOf(this.command) + "JobInformationLine3=\"" + this.jobCard[2] + "\" ";
                }
                if (this.configureVariableList.getJobCard() != null && this.jobCard.length > 3 && this.configureVariableList.getJobCard().length > 3) {
                    this.command = String.valueOf(this.command) + "JobInformationLine4=\"" + this.jobCard[3] + "\" ";
                }
            }
            this.command = String.valueOf(this.command) + " >";
            if (this.configureVariableList.getWorkSpaceallocationName() != null) {
                this.command = this.configureVariableList.getWorkSpaceallocationName().equalsIgnoreCase("DASDUnitName") ? String.valueOf(this.command) + "<DASDUnitName>" + this.configureVariableList.getWorkSpaceallocationvalue() + "</DASDUnitName>" : String.valueOf(this.command) + "<SMSStorageClass>" + this.configureVariableList.getWorkSpaceallocationvalue() + "</SMSStorageClass>";
            }
            this.command = String.valueOf(this.command) + "</DefaultOptionsData>";
            this.command = String.valueOf(this.command) + "<PrintOptionsData ";
            if (!this.configureVariableList.getSysoutClass().isEmpty()) {
                this.command = String.valueOf(this.command) + " SysoutClass=\"" + this.configureVariableList.getSysoutClass() + "\" ";
            }
            this.command = String.valueOf(this.command) + " NumberOfCopies=\"" + this.configureVariableList.getNumberOfCopies() + "\" ";
            this.command = String.valueOf(this.command) + " >";
            if (this.configureVariableList.getPrintDesSelection() != 0) {
                if (this.configureVariableList.getPrintDesSelection() == 1) {
                    this.command = String.valueOf(this.command) + "<PrintDest>" + this.configureVariableList.getPrintDestination1();
                    this.command = String.valueOf(this.command) + "</PrintDest>";
                } else if (this.configureVariableList.getPrintDesSelection() == 2) {
                    this.command = String.valueOf(this.command) + "<PrintJESNode JESNode=\"" + this.configureVariableList.getPrintDestination1() + "\" JESUserid=\"" + this.configureVariableList.getPrintDestination2() + "\"></PrintJESNode>";
                } else if (this.configureVariableList.getPrintDesSelection() == 3) {
                    this.command = String.valueOf(this.command) + "<SYSOUTWriterName>" + this.configureVariableList.getPrintDestination1();
                    this.command = String.valueOf(this.command) + "</SYSOUTWriterName>";
                } else if (this.configureVariableList.getPrintDesSelection() == 4) {
                    this.command = String.valueOf(this.command) + "<PrintDSN ";
                    this.command = String.valueOf(this.command) + " dsname=\"" + this.configureVariableList.getPrintDestination1() + "\"";
                    if (!this.configureVariableList.getPrintDestination2().isEmpty()) {
                        this.command = String.valueOf(this.command) + " member=\"" + this.configureVariableList.getPrintDestination2() + "\"";
                    }
                    this.command = !this.configureVariableList.getDisPosition().isEmpty() ? String.valueOf(this.command) + " disp=\"" + this.configureVariableList.getDisPosition() + "\"" : String.valueOf(this.command) + " disp=\"SHR\"";
                    this.command = String.valueOf(this.command) + "/>";
                }
            }
            this.command = String.valueOf(this.command) + "</PrintOptionsData>";
            this.command = String.valueOf(this.command) + "<ParmFilesData ";
            if (!this.configureVariableList.getDsnList().isEmpty()) {
                this.command = String.valueOf(this.command) + " DSNListsDSN=\"" + this.configureVariableList.getDsnList() + "\"";
            }
            if (!this.configureVariableList.getSelCriteriaField().isEmpty()) {
                this.command = String.valueOf(this.command) + " SelectionCriteriaDSN=\"" + this.configureVariableList.getSelCriteriaField() + "\"";
            }
            if (!this.configureVariableList.getCusRecordLayout().isEmpty()) {
                this.command = String.valueOf(this.command) + " CustomRecordLayoutsDSN=\"" + this.configureVariableList.getCusRecordLayout() + "\"";
            }
            this.command = String.valueOf(this.command) + "/>";
            this.command = String.valueOf(this.command) + "<ChangeLogData ";
            this.command = String.valueOf(this.command) + " ChangeLogSpacePrim=\"" + this.configureVariableList.getPrimaryAllocation() + "\" ChangeLogSpaceSec=\"" + this.configureVariableList.getSecondaryAllocation() + "\">";
            if (this.configureVariableList.getStorageName().equalsIgnoreCase("ChangeLogVolser")) {
                this.command = String.valueOf(this.command) + "<ChangeLogVolser>" + this.configureVariableList.getStorageValue();
                this.command = String.valueOf(this.command) + "</ChangeLogVolser>";
            } else if (this.configureVariableList.getStorageName().equalsIgnoreCase("ChangeLogUnit")) {
                this.command = String.valueOf(this.command) + "<ChangeLogUnit>" + this.configureVariableList.getStorageValue();
                this.command = String.valueOf(this.command) + "</ChangeLogUnit>";
            }
            this.command = String.valueOf(this.command) + "</ChangeLogData></SetPreferencesData>";
        }
        this.command = String.valueOf(this.command) + "</SetPreferences></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }
}

