/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.selection.wizards;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMSelectionTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterSelection;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.GenericAddPage;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetSelectionMem;
import com.ca.filemaster.selection.views.SelectionView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddSelCritWizardPage
extends GenericAddPage
implements ModifyListener,
ICheckStateListener {
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.addSelCritMemPage";
    public FMSelectionTreeModel fmselectionModel = FMSelectionTreeModel.getInstance();
    private String initDSName;
    private String memberName;
    private FileMasterDataset FmLayoutDataset = new FileMasterDataset(null);
    private FileMasterMember FmLayoutMember = new FileMasterMember(null);
    private String layoutDS = "";
    private String layoutMem = "";
    private static ArrayList<FileMasterSelection> contentSelRec = new ArrayList();

    public AddSelCritWizardPage(String pageName, FileMasterServer server, String datasetName, String memberName, boolean isDirectoryListCaller) {
        super(pageName, server, datasetName, memberName, isDirectoryListCaller);
        this.initDSName = datasetName;
        this.memberName = memberName;
        this.setTitle("Add Selection Criteria");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        FMHistory.intializeComboBoxes((Combo)this.dataSetCombo, (String)"DatasetListAddSelection");
        FMHistory.intializeComboBoxes((Combo)this.memberNameCombo, (String)"MemberListAddSelection");
        if (this.serverNameCombo.getItemCount() > 0) {
            boolean lastServerExists = false;
            String lastServerUsed = FMHistory.getServer((String)"ServerAddSelcritWizardPage");
            int count = 0;
            while (count < this.serverNameCombo.getItemCount()) {
                if (this.serverNameCombo.getItem(count).toString().equalsIgnoreCase(lastServerUsed)) {
                    lastServerExists = true;
                    this.serverNameCombo.setText(this.serverNameCombo.getItem(count).toString());
                    break;
                }
                ++count;
            }
            if (!lastServerExists) {
                this.serverNameCombo.setText(this.serverNameCombo.getItem(0));
            }
            this.changeServer();
        }
        this.dataSetCombo.setText(this.initDSName);
        this.checkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    private void changeServer() {
        String TestServer = "";
        int servers = 0;
        while (servers < this.fmstModel.getServers().length) {
            TestServer = this.fmstModel.getServers()[servers].getText();
            if (TestServer.equalsIgnoreCase(this.serverNameCombo.getText())) {
                this.server = (FileMasterServer)this.fmstModel.getServers()[servers].getAdapter(FileMasterServer.class);
                this.serverChanged(this.server);
                break;
            }
            ++servers;
        }
    }

    public void modifyText(ModifyEvent e) {
        this.newServer = this.serverNameCombo.getText().trim();
        this.pendingMessage = true;
        this.changeServer();
        this.setPageComplete(this.canFinish());
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this.checkboxTableViewer.getCheckedElements().length >= 1) {
            this.selectAllClearButton.setText("&Clear Selections");
        } else {
            this.selectAllClearButton.setText("Select &All");
        }
        if (this.checkboxTableViewer.getCheckedElements().length == 0) {
            this.selectAllClearButton.setText("Select &All");
        }
        this.setPageComplete(this.canFinish());
    }

    private XMLRequest getSelectionMem() {
        RunGetSelectionMem runner = new RunGetSelectionMem(this.server, this.dataSetCombo.getText().trim(), this.memberName);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        return runner.getXml();
    }

    public Object[] process(String selectParm) {
        XMLRequest xml = null;
        this.memberName = selectParm;
        contentSelRec.clear();
        xml = this.getSelectionMem();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList nodes = element.getElementsByTagName("FMProcessingParmMbrRecord");
                NodeList nodeDatasetLay = element.getElementsByTagName("DataSetName");
                NodeList nodeMemberLay = element.getElementsByTagName("MemberName");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodeDatasetLay.getLength() > 0) {
                    Element DSLayElement = (Element)nodeDatasetLay.item(0);
                    this.layoutDS = this.getTagValue("DataSetName", DSLayElement);
                    Element MemLayElement = (Element)nodeMemberLay.item(0);
                    this.layoutMem = this.getTagValue("MemberName", MemLayElement);
                }
                if (messages.getLength() > 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + this.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = this.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                } else {
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element selectionElement = (Element)nodes.item(i);
                        String line = new String();
                        line = this.getTagValue("FMProcessingParmMbrRecord", selectionElement);
                        FileMasterSelection selection = new FileMasterSelection(null);
                        if (line != null) {
                            selection.setName(line);
                            contentSelRec.add(selection);
                        }
                        ++i;
                    }
                    return contentSelRec.toArray(new Object[contentSelRec.size()]);
                }
            }
        }
        return null;
    }

    private String getTagValue(String sTag, Element msgElement) {
        NodeList nlList = msgElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return null;
    }

    public boolean nextOrFinish() {
        this.error = "";
        boolean returnVal = false;
        returnVal = super.isPageComplete();
        if (this.dataSetCombo != null && this.memberSelectBtn != null) {
            switch (Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true)) {
                case 0: {
                    this.memberSelectBtn.setEnabled(true);
                    break;
                }
                default: {
                    this.memberSelectBtn.setEnabled(false);
                }
            }
        }
        if (returnVal) {
            returnVal = this.ValidateMember();
        }
        if (this.dataSetCombo != null && this.memberNameCombo != null && this.checkboxTableViewer != null) {
            this.dataSetName = this.dataSetCombo.getText().trim();
            if (returnVal && this.dataSetName.startsWith("\"")) {
                this.dataSetName = this.dataSetName.substring(1, this.dataSetName.length() - 1);
            }
            if (this.getName().equalsIgnoreCase("Add Selection")) {
                if (this.checkboxTableViewer.getCheckedElements().length == 0) {
                    this.memberName = this.memberNameCombo.getText().trim();
                    FileMasterDataset fmdataset = new FileMasterDataset(null);
                    fmdataset.setName(this.dataSetName);
                    fmdataset.setDsOrg("PDS");
                    TT_TreeItem dsItem = null;
                    dsItem = this.fmselectionModel.findObject((Object)fmdataset);
                    if (dsItem != null) {
                        FileMasterMember fmmember = new FileMasterMember(dsItem);
                        fmmember.setName(this.memberName);
                    }
                } else {
                    int count = 0;
                    while (count < this.checkboxTableViewer.getCheckedElements().length) {
                        this.memberName = ((FileMasterMember)this.checkboxTableViewer.getCheckedElements()[count]).getName();
                        FileMasterDataset fmdataset = new FileMasterDataset(null);
                        fmdataset.setName(this.dataSetName);
                        fmdataset.setDsOrg("PDS");
                        TT_TreeItem dsItem = null;
                        dsItem = this.fmselectionModel.findObject((Object)fmdataset);
                        if (dsItem != null) {
                            FileMasterMember fmmember = new FileMasterMember(dsItem);
                            fmmember.setName(this.memberName);
                        }
                        ++count;
                    }
                }
            }
        }
        return returnVal;
    }

    private void AddMemberToSelView(TT_TreeItem dsItem, FileMasterMember fmmember, int count, Object[] checkedLayouts, Object[] checkedLayoutMembers) {
        Element memElement = this.fmselectionModel.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType(), fmmember.getCLDescription(), this.layoutDS, this.layoutMem);
        TT_TreeItem memItem = this.fmselectionModel.insertMember(dsItem, memElement);
        checkedLayouts = this.process(((FileMasterMember)checkedLayoutMembers[count]).getName());
        memItem.getElement().setAttribute("layoutDS", this.layoutDS);
        memItem.getElement().setAttribute("layoutMem", this.layoutMem);
        FileMasterSelection fmSelect = null;
        Element fmSelectElement = null;
        if (checkedLayouts != null) {
            int countLay = 0;
            while (countLay < checkedLayouts.length) {
                if (checkedLayouts[countLay] instanceof FileMasterSelection) {
                    fmSelect = new FileMasterSelection(null);
                    fmSelect.setName(((FileMasterSelection)checkedLayouts[countLay]).getName());
                    fmSelectElement = this.fmselectionModel.addSelection(memElement, fmSelect.getName());
                    this.fmselectionModel.insertSelection(memItem, fmSelectElement);
                }
                ++countLay;
            }
        } else {
            this.fmselectionModel.removeItem((Object)fmmember);
        }
    }

    public boolean doFinish() {
        FMHistory.clearList((String)"ServerAddSelcritWizardPage");
        FMHistory.insertHistory((Combo)this.serverNameCombo, (String)"ServerAddSelcritWizardPage");
        FMHistory.insertHistory((Combo)this.dataSetCombo, (String)"DatasetListAddSelection");
        FMHistory.insertHistory((Combo)this.memberNameCombo, (String)"MemberListAddSelection");
        this.changeServer();
        Object[] checkedMembersViewer = this.checkboxTableViewer.getCheckedElements();
        Object[] checkedLayouts = null;
        boolean isDuplicatedMember = false;
        boolean yesToAll = false;
        boolean noToAll = false;
        boolean singelYes = false;
        String title = "Replace Members";
        String question = "Do you want to replace ";
        FileMasterDataset fmdataset = new FileMasterDataset(null);
        fmdataset.setName(this.dataSetCombo.getText());
        this.FmLayoutDataset.setName(this.layoutDS);
        this.FmLayoutMember.setName(this.layoutMem);
        TT_TreeItem dsItem = null;
        dsItem = this.fmselectionModel.findObject((Object)fmdataset);
        if (dsItem == null) {
            Element dsElement = this.fmselectionModel.addDataset(null, fmdataset);
            dsItem = this.fmselectionModel.insertDataset(dsElement);
        }
        FileMasterMember fmmember = new FileMasterMember(null);
        if (checkedMembersViewer.length == 0) {
            fmmember.setName(this.memberNameCombo.getText().trim());
            fmmember.setType("Selection");
            checkedMembersViewer = new Object[]{new FileMasterMember(null)};
            checkedMembersViewer[0] = CommonMFCalls.getFQMEM((String)this.dataSetName, (String)this.memberNameCombo.getText(), (FileMasterServer)this.server, (String)"L");
            if (CommonMFCalls.RETURN_CODE.equals("0")) {
                if (!((FileMasterMember)checkedMembersViewer[0]).getType().equalsIgnoreCase("S")) {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)"Return Code: 4", (Throwable)new Throwable("The specified member is not a valid selection member."));
                    return false;
                }
            } else {
                return false;
            }
        }
        int count = 0;
        while (count < checkedMembersViewer.length) {
            if (checkedMembersViewer[count] instanceof FileMasterMember) {
                fmmember.setName(((FileMasterMember)checkedMembersViewer[count]).getName());
                fmmember.setType("Selection");
                fmmember.setCLDescription(((FileMasterMember)checkedMembersViewer[count]).getCLDescription());
                if (this.fmselectionModel.findObjectInTree((Object)fmmember, dsItem) != null) {
                    isDuplicatedMember = true;
                }
                if (isDuplicatedMember) {
                    if (!yesToAll && !noToAll) {
                        MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), "Replace Members", null, String.valueOf(question) + fmmember.getName() + " ?", 3, new String[]{IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL}, 0);
                        dialog.open();
                        if (dialog.getReturnCode() != 0) {
                            if (dialog.getReturnCode() == 1) {
                                noToAll = true;
                                yesToAll = false;
                            } else if (dialog.getReturnCode() == 2) {
                                this.fmselectionModel.removeItem((Object)fmmember);
                                this.AddMemberToSelView(dsItem, fmmember, count, checkedLayouts, checkedMembersViewer);
                            } else if (dialog.getReturnCode() == 3) {
                                this.fmselectionModel.removeItem((Object)fmmember);
                                this.AddMemberToSelView(dsItem, fmmember, count, checkedLayouts, checkedMembersViewer);
                                yesToAll = true;
                            }
                        }
                    }
                    if (yesToAll || singelYes) {
                        this.fmselectionModel.removeItem((Object)fmmember);
                        this.AddMemberToSelView(dsItem, fmmember, count, checkedLayouts, checkedMembersViewer);
                        singelYes = false;
                    }
                    isDuplicatedMember = false;
                } else if (!isDuplicatedMember) {
                    this.AddMemberToSelView(dsItem, fmmember, count, checkedLayouts, checkedMembersViewer);
                }
            }
            ++count;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView("com.ca.filemaster.selection.views.selectionview");
            if (view instanceof SelectionView) {
                TreeViewer viewer = ((SelectionView)view).getViewer();
                if (viewer != null) {
                    TT_TreeItem selection = this.fmselectionModel.findObjectInTree((Object)fmmember, this.fmselectionModel.findObject((Object)fmdataset));
                    Object[] expandedElements = viewer.getExpandedElements();
                    viewer.setInput((Object)this.fmselectionModel.getDatasets());
                    viewer.refresh(true);
                    viewer.setExpandedElements(expandedElements);
                    if (selection != null) {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                    }
                    view = page.showView("com.ca.filemaster.selection.views.selectionview");
                    page.activate((IWorkbenchPart)view);
                    page.bringToTop((IWorkbenchPart)view);
                }
                view.setFocus();
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        this.fmselectionModel.save();
        return true;
    }
}

