/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.customlayout.wizards;

import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.customlayout.wizards.CRLWizard;
import com.ca.filemaster.customlayout.wizards.UpdateCRLPage;
import com.ca.filemaster.ui.wizards.CRLMemberSorter;
import com.ca.filemaster.ui.wizards.CRLMessageLabelProvider;
import com.ca.filemaster.ui.wizards.ChangedLabelProvider;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.ui.wizards.IDLabelProvider;
import com.ca.filemaster.ui.wizards.MemberLabelProvider;
import com.ca.filemaster.ui.wizards.SizeLabelProvider;
import com.ca.filemaster.views.layout.LayoutView;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;

public class AddCRLPage
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.addCustomLayoutPage";
    private String dataSetName = "";
    private String memberName = "";
    private String newDatasetName;
    private String oldDatasetName;
    private boolean pendingMessage = false;
    private boolean isSingleMember;
    public static boolean chkForDSChanged = true;
    private Label serverNameLabel;
    private Label memberNameLabel;
    private Combo serverNameCombo;
    private Combo memberNameCombo;
    private Button memberSelectBtn;
    private Button selectAllClearButton;
    private Button deleteButton;
    private Button newCRL;
    private Group selectMembersGroup;
    private CheckboxTableViewer checkboxTableViewer;
    private Table membersTable;
    private Listener sortListener;
    private FileMasterServer server;
    private boolean msgDisplayed;
    private boolean createNewCRL;
    private FMServerTreeModel fmstModel = FMServerTreeModel.getInstance();
    private FMLayoutTreeModel fmltModel = FMLayoutTreeModel.getInstance();
    private boolean isDirectoryListCaller = false;
    private IPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
    private Boolean ShowDialog = false;

    public AddCRLPage(String pageName, FileMasterServer server, String datasetName, String memberName, boolean isDirectoryListCaller) {
        super(pageName, datasetName, server);
        this.setTitle("Add Custom Layout");
        this.server = server;
        this.dataSetName = datasetName;
        this.memberName = memberName;
        this.isDirectoryListCaller = isDirectoryListCaller;
        this.oldDatasetName = "";
        this.msgDisplayed = false;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.addCustomLayoutPage");
        this.serverNameLabel = new Label(this.dataSetComposite, 0);
        this.serverNameLabel.setText("Ser&ver:");
        this.serverNameCombo = new Combo(this.dataSetComposite, 2056);
        GridData gd_serverNameCombo = new GridData(4, 4, false, false, 1, 1);
        gd_serverNameCombo.widthHint = 170;
        this.serverNameCombo.setLayoutData((Object)gd_serverNameCombo);
        this.serverNameCombo.setItems(this.getServers());
        if (this.serverNameCombo.getItemCount() > 0) {
            this.serverNameCombo.setText(this.serverNameCombo.getItem(0));
        }
        this.serverNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddCRLPage.this.changeServer();
                AddCRLPage.this.setPageComplete(AddCRLPage.this.canFlipToNextPage());
            }
        });
        if (this.server != null) {
            this.serverNameCombo.setText(this.server.getText());
        }
        if (this.isDirectoryListCaller) {
            this.serverNameCombo.setEnabled(false);
        }
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        super.createDataSet();
        this.dataSetCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!AddCRLPage.this.msgDisplayed) {
                    AddCRLPage.this.oldDatasetName = AddCRLPage.this.dataSetCombo.getText();
                }
                AddCRLPage.this.msgDisplayed = false;
            }
        });
        this.dataSetCombo.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                AddCRLPage.this.datasetChanged();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.dataSetCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddCRLPage.this.datasetChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FMHistory.intializeComboBoxes((Combo)this.dataSetCombo, (String)"DatasetListAddCustomLayoutPage1");
        if (!this.isDirectoryListCaller) {
            this.dataSetCombo.setText(this.dataSetName);
        }
        new Label(this.dataSetComposite, 0);
        this.selectMembersGroup = new Group(this.container, 0);
        this.selectMembersGroup.setLayout((Layout)new GridLayout(3, false));
        this.selectMembersGroup.setSize(this.selectMembersGroup.computeSize(-1, -1));
        this.selectMembersGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.selectMembersGroup.setText("Layout member");
        this.selectMembersGroup.setRedraw(true);
        this.createViewer((Composite)this.selectMembersGroup);
        new Label((Composite)this.selectMembersGroup, 0);
        this.selectAllClearButton = new Button((Composite)this.selectMembersGroup, 0);
        GridData gd_selectAllClearButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectAllClearButton.widthHint = 120;
        this.selectAllClearButton.setLayoutData((Object)gd_selectAllClearButton);
        this.selectAllClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AddCRLPage.this.isSingleMember) {
                    if (AddCRLPage.this.selectAllClearButton.getText() == "Select &All") {
                        AddCRLPage.this.checkboxTableViewer.setAllChecked(true);
                        ModelProvider.INSTANCE.setStateOfAll(true);
                        AddCRLPage.this.selectAllClearButton.setText("&Clear Selections");
                        AddCRLPage.this.deleteButton.setEnabled(true);
                    } else {
                        AddCRLPage.this.selectAllClearButton.setText("Select &All");
                        AddCRLPage.this.checkboxTableViewer.setAllChecked(false);
                        ModelProvider.INSTANCE.setStateOfAll(false);
                        AddCRLPage.this.deleteButton.setEnabled(false);
                    }
                } else {
                    AddCRLPage.this.selectAllClearButton.setEnabled(false);
                    AddCRLPage.this.checkboxTableViewer.setAllChecked(false);
                }
                AddCRLPage.this.setPageComplete(AddCRLPage.this.isPageComplete());
            }
        });
        if (!this.isSingleMember) {
            this.selectAllClearButton.setText("Select &All");
        } else {
            this.selectAllClearButton.setText("&Clear Selections");
        }
        this.selectAllClearButton.setEnabled(false);
        this.deleteButton = new Button((Composite)this.selectMembersGroup, 0);
        gd_selectAllClearButton.widthHint = 120;
        this.deleteButton.setText("Dele&te");
        this.deleteButton.setLayoutData((Object)gd_selectAllClearButton);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
                String key = "CLOSING_VALUE";
                boolean showDiag = !store.getBoolean(key);
                boolean remove = false;
                if (showDiag) {
                    String question = AddCRLPage.this.checkboxTableViewer.getCheckedElements().length > 1 ? "Do you want to remove these custom layout members?" : "Do you want to remove this custom layout member?";
                    String toggleMessage = "Always remove items without this prompt";
                    MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Remove", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)key);
                    int returncode = result.getReturnCode();
                    boolean bl = remove = returncode == 0 || returncode == 2;
                    if (remove) {
                        store.setValue(key, result.getToggleState());
                    }
                }
                if (showDiag && remove || !showDiag) {
                    AddCRLPage.this.deleteButton.setEnabled(false);
                    int i = 0;
                    while (i < AddCRLPage.this.checkboxTableViewer.getCheckedElements().length) {
                        ModelProvider.INSTANCE.removeMember(((FileMasterMember)AddCRLPage.this.checkboxTableViewer.getCheckedElements()[i]).getName());
                        ++i;
                    }
                    AddCRLPage.this.checkboxTableViewer.remove(AddCRLPage.this.checkboxTableViewer.getCheckedElements());
                    if (AddCRLPage.this.checkboxTableViewer.getTable().getItemCount() > 0) {
                        AddCRLPage.this.selectAllClearButton.setText("Select &All");
                        AddCRLPage.this.selectAllClearButton.setEnabled(true);
                    } else {
                        AddCRLPage.this.selectAllClearButton.setEnabled(false);
                    }
                }
            }
        });
        this.newCRL = new Button(this.container, 32);
        this.newCRL.setText("C&reate new custom layout");
        this.createNewCRL = false;
        this.newCRL.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AddCRLPage.this.createNewCRL) {
                    AddCRLPage.this.memberNameCombo.setEnabled(true);
                    AddCRLPage.this.checkboxTableViewer.getTable().setEnabled(true);
                    if (AddCRLPage.this.checkboxTableViewer.getCheckedElements().length > 0) {
                        AddCRLPage.this.deleteButton.setEnabled(true);
                        AddCRLPage.this.selectAllClearButton.setEnabled(true);
                    }
                    AddCRLPage.this.memberSelectBtn.setEnabled(true);
                    AddCRLPage.this.createNewCRL = false;
                    AddCRLPage.this.setPageComplete(AddCRLPage.this.isPageComplete());
                } else {
                    AddCRLPage.this.memberNameCombo.setEnabled(false);
                    AddCRLPage.this.checkboxTableViewer.getTable().setEnabled(false);
                    AddCRLPage.this.memberSelectBtn.setEnabled(false);
                    AddCRLPage.this.selectAllClearButton.setEnabled(false);
                    AddCRLPage.this.deleteButton.setEnabled(false);
                    AddCRLPage.this.createNewCRL = true;
                    AddCRLPage.this.setPageComplete(AddCRLPage.this.isPageComplete());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createViewer(Composite parent) {
        this.memberNameLabel = new Label((Composite)this.selectMembersGroup, 0);
        this.memberNameLabel.setText("&Member:");
        this.memberNameCombo = new Combo((Composite)this.selectMembersGroup, 2048);
        GridData gd_memberNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.memberNameCombo.setLayoutData((Object)gd_memberNameCombo);
        this.memberNameCombo.addModifyListener((ModifyListener)this);
        this.memberNameCombo.setTextLimit(8);
        this.memberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes((Combo)this.memberNameCombo, (String)"MemberListAddCustomLayoutPage1");
        this.memberNameCombo.setText(this.memberName);
        this.memberSelectBtn = new Button((Composite)this.selectMembersGroup, 0);
        this.memberSelectBtn.setText("S&elect");
        this.memberSelectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddCRLPage.this.process();
                AddCRLPage.this.selectAllClearButton.setText("Select &All");
                if (AddCRLPage.this.checkboxTableViewer.getTable().getItemCount() > 0) {
                    AddCRLPage.this.selectAllClearButton.setEnabled(true);
                } else {
                    AddCRLPage.this.selectAllClearButton.setEnabled(false);
                }
            }
        });
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)this.selectMembersGroup, (int)68354);
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (AddCRLPage.this.checkboxTableViewer.getCheckedElements().length == AddCRLPage.this.checkboxTableViewer.getTable().getItemCount()) {
                    AddCRLPage.this.selectAllClearButton.setText("&Clear Selections");
                } else {
                    AddCRLPage.this.selectAllClearButton.setText("Select &All");
                }
                if (AddCRLPage.this.checkboxTableViewer.getCheckedElements().length == 0) {
                    AddCRLPage.this.selectAllClearButton.setText("Select &All");
                }
                if (AddCRLPage.this.checkboxTableViewer.getCheckedElements().length > 0) {
                    AddCRLPage.this.deleteButton.setEnabled(true);
                } else {
                    AddCRLPage.this.deleteButton.setEnabled(false);
                }
                AddCRLPage.this.setPageComplete(AddCRLPage.this.canFlipToNextPage());
            }
        });
        this.membersTable = this.checkboxTableViewer.getTable();
        this.membersTable.setLinesVisible(true);
        this.membersTable.setHeaderVisible(true);
        GridData gd_table = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_table.heightHint = 200;
        gd_table.widthHint = 510;
        this.membersTable.setLayoutData((Object)gd_table);
        this.columnSorterListener();
        this.createColumns(parent, this.checkboxTableViewer);
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkboxTableViewer.setInput(null);
    }

    private void createColumns(Composite parent, CheckboxTableViewer viewer) {
        String[] titles = new String[]{"Name", "Description", "Changed", "Size", "ID"};
        int[] bounds = new int[]{125, 100, 100, 100, 100};
        viewer.setSorter((ViewerSorter)new CRLMemberSorter());
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    this.membersTable.setSortColumn(tableColumn);
                    this.membersTable.setSortDirection(128);
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CRLMessageLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ChangedLabelProvider());
                    break;
                }
                case 3: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new SizeLabelProvider());
                    break;
                }
                case 4: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new IDLabelProvider());
                }
            }
            ++i;
        }
    }

    private void columnSorterListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = AddCRLPage.this.checkboxTableViewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                AddCRLPage.this.checkboxTableViewer.refresh();
            }
        };
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (((Button)source).getText().equals("&Select...")) {
            DatasetWizard wizard = new DatasetWizard(true);
            this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
            this.dialog.open();
        } else if (this.server.getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"DSN lists PDS in preferences is undefined. No DSNLists found");
        } else if (this.dataSetCombo.getText().isEmpty() || Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true) == 3) {
            GenericImportWizard wizard = new GenericImportWizard("Select DSN List", this.server, false);
            this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
            this.dialog.open();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public IWizardPage getNextPage() {
        FMHistory.insertHistory((Combo)this.dataSetCombo, (String)"DatasetListAddCustomLayoutPage1");
        FMHistory.insertHistory((Combo)this.memberNameCombo, (String)"MemberListAddCustomLayoutPage1");
        String memberCRLToUpdate = new String();
        if (this.createNewCRL) {
            memberCRLToUpdate = "";
        } else {
            if (this.checkboxTableViewer.getCheckedElements().length > 0) {
                this.memberNameCombo.setText(((FileMasterMember)this.checkboxTableViewer.getCheckedElements()[0]).getName());
            }
            if (Validator.member((String)this.memberNameCombo.getText(), (boolean)true) == 0) {
                memberCRLToUpdate = this.memberNameCombo.getText();
            }
            switch (Validator.member((String)this.memberNameCombo.getText(), (boolean)true)) {
                case 0: {
                    memberCRLToUpdate = this.memberNameCombo.getText();
                    break;
                }
                case 7: {
                    memberCRLToUpdate = this.memberNameCombo.getText();
                    if (this.checkboxTableViewer.getCheckedElements().length != 1) break;
                    memberCRLToUpdate = ((FileMasterMember)this.checkboxTableViewer.getCheckedElements()[0]).getName();
                    break;
                }
                case 5: {
                    memberCRLToUpdate = this.memberNameCombo.getText();
                    if (this.checkboxTableViewer.getCheckedElements().length != 1) break;
                    memberCRLToUpdate = ((FileMasterMember)this.checkboxTableViewer.getCheckedElements()[0]).getName();
                    break;
                }
            }
        }
        if (((CRLWizard)this.getWizard()).getPage("Update Custom Record Layout") == null) {
            UpdateCRLPage page2 = new UpdateCRLPage("Update Custom Record Layout", this.dataSetCombo.getText(), memberCRLToUpdate, this.createNewCRL, this.server, this.isDirectoryListCaller);
            ((CRLWizard)this.getWizard()).addPage((IWizardPage)page2);
        }
        ((UpdateCRLPage)((CRLWizard)this.getWizard()).getPage("Update Custom Record Layout")).setMemberFieldEnabled(this.newCRL.getSelection());
        ((UpdateCRLPage)((CRLWizard)this.getWizard()).getPage("Update Custom Record Layout")).setDatasetName(this.dataSetCombo.getText().trim());
        if (!this.newCRL.getSelection()) {
            ((UpdateCRLPage)((CRLWizard)this.getWizard()).getPage("Update Custom Record Layout")).setMemberName(memberCRLToUpdate);
        }
        return ((CRLWizard)this.getWizard()).getPage("Update Custom Record Layout");
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.canFlipToNextPage());
    }

    public boolean canFlipToNextPage() {
        this.error = "";
        boolean returnVal = this.nextOrFinish();
        if (returnVal && this.checkboxTableViewer != null && this.memberNameCombo != null) {
            boolean bl = returnVal = this.checkboxTableViewer.getCheckedElements().length == 1 || Validator.member((String)this.memberNameCombo.getText(), (boolean)true) == 0;
        }
        if (this.createNewCRL && Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true) == 0) {
            return true;
        }
        return returnVal;
    }

    public boolean canFinish() {
        if (this.createNewCRL) {
            return false;
        }
        return this.nextOrFinish();
    }

    private boolean nextOrFinish() {
        this.error = "";
        boolean returnVal = false;
        returnVal = super.isPageComplete();
        if (returnVal) {
            returnVal = this.ValidateMember();
            if (this.memberSelectBtn != null && !this.createNewCRL) {
                this.memberSelectBtn.setEnabled(true);
            }
            if (this.selectAllClearButton != null && !this.createNewCRL && this.checkboxTableViewer.getCheckedElements().length != this.checkboxTableViewer.getTable().getItemCount()) {
                this.selectAllClearButton.setEnabled(true);
                this.selectAllClearButton.setText("Select &All");
            } else if (this.selectAllClearButton != null && !this.createNewCRL && this.checkboxTableViewer.getCheckedElements().length == this.checkboxTableViewer.getTable().getItemCount() && this.checkboxTableViewer.getTable().getItemCount() > 1) {
                this.selectAllClearButton.setEnabled(true);
                this.selectAllClearButton.setText("&Clear Selections");
            }
            if (this.createNewCRL) {
                return true;
            }
            if (this.memberNameCombo != null && this.memberSelectBtn != null) {
                switch (Validator.member((String)this.memberNameCombo.getText(), (boolean)true)) {
                    case 0: {
                        returnVal = true;
                        this.memberSelectBtn.setEnabled(false);
                        break;
                    }
                    case 7: {
                        if (this.checkboxTableViewer.getCheckedElements().length > 0) {
                            returnVal = true;
                            break;
                        }
                        return false;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (this.memberSelectBtn != null) {
            this.memberSelectBtn.setEnabled(false);
        }
        if (this.dataSetCombo != null && this.memberNameCombo != null && this.checkboxTableViewer != null) {
            this.dataSetName = this.dataSetCombo.getText().trim();
            if (returnVal && this.dataSetName.startsWith("\"")) {
                this.dataSetName = this.dataSetName.substring(1, this.dataSetName.length() - 1);
            }
            if (this.checkboxTableViewer.getCheckedElements().length == 0) {
                this.memberName = this.memberNameCombo.getText().trim();
                FileMasterDataset fmdataset = new FileMasterDataset(null);
                fmdataset.setName(this.dataSetName);
                fmdataset.setDsOrg("PDS");
                TT_TreeItem dsItem = null;
                dsItem = this.fmltModel.findObject((Object)fmdataset);
                if (dsItem != null) {
                    FileMasterMember fmmember = new FileMasterMember(dsItem);
                    fmmember.setName(this.memberName);
                    if (this.fmltModel.findObjectInTree((Object)fmmember, dsItem) != null) {
                        this.setErrorMessage("Duplicate member name");
                        return false;
                    }
                }
            } else {
                int count = 0;
                while (count < this.checkboxTableViewer.getCheckedElements().length) {
                    this.memberName = ((FileMasterMember)this.checkboxTableViewer.getCheckedElements()[count]).getName();
                    FileMasterDataset fmdataset = new FileMasterDataset(null);
                    fmdataset.setName(this.dataSetName);
                    fmdataset.setDsOrg("PDS");
                    TT_TreeItem dsItem = null;
                    dsItem = this.fmltModel.findObject((Object)fmdataset);
                    if (dsItem != null) {
                        FileMasterMember fmmember = new FileMasterMember(dsItem);
                        fmmember.setName(this.memberName);
                        if (this.fmltModel.findObjectInTree((Object)fmmember, dsItem) != null) {
                            this.setErrorMessage("Duplicate member name");
                            return false;
                        }
                    }
                    ++count;
                }
            }
        }
        return returnVal;
    }

    private String[] getServers() {
        String[] listOfServers = new String[this.fmstModel.getServers().length];
        int serverCount = 0;
        while (serverCount < this.fmstModel.getServers().length) {
            listOfServers[serverCount] = this.fmstModel.getServers()[serverCount].getServer().getText();
            ++serverCount;
        }
        if (!this.isDirectoryListCaller) {
            this.server = (FileMasterServer)this.fmstModel.getServers()[0].getServer();
        }
        this.serverChanged(this.server);
        return listOfServers;
    }

    private boolean ValidateMember() {
        if (this.createNewCRL) {
            return true;
        }
        if (this.memberNameCombo != null && this.memberSelectBtn != null) {
            if (Validator.member((String)this.memberNameCombo.getText(), (boolean)true) == 0) {
                this.memberSelectBtn.setEnabled(false);
                return true;
            }
            if (this.memberSelectBtn != null && this.checkboxTableViewer != null) {
                switch (Validator.member((String)this.memberNameCombo.getText(), (boolean)true)) {
                    case 0: 
                    case 7: {
                        this.memberSelectBtn.setEnabled(true);
                        break;
                    }
                    case 6: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameCombo.getText(), (boolean)true)] + "\n";
                        this.memberSelectBtn.setEnabled(false);
                        break;
                    }
                    case 5: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameCombo.getText(), (boolean)true)] + "\n";
                        if (this.checkboxTableViewer.getCheckedElements().length <= 0) break;
                        this.error = new String();
                    }
                }
                if (this.error.length() > 0) {
                    this.setErrorMessage(this.error);
                    return this.checkboxTableViewer.getCheckedElements().length > 0;
                }
                this.setErrorMessage(null);
                return this.checkboxTableViewer.getCheckedElements().length > 0;
            }
        }
        return false;
    }

    private void process() {
        String pattern = this.memberNameCombo.getText().replace("%", ".").replace("*", ".*");
        Object[] checkedMembers = (Object[])this.checkboxTableViewer.getCheckedElements().clone();
        this.checkboxTableViewer.setInput(ModelProvider.INSTANCE.getMem(this.checkboxTableViewer, pattern, true));
        if (this.checkboxTableViewer.getTable().getItemCount() > 0) {
            if (this.isSingleMember) {
                if (this.checkboxTableViewer.getTable().getItemCount() == 1) {
                    this.checkboxTableViewer.setAllChecked(true);
                } else {
                    this.checkboxTableViewer.setAllChecked(false);
                }
            } else {
                this.selectAllClearButton.setEnabled(true);
                this.checkboxTableViewer.setAllChecked(false);
                int i = 0;
                while (i < this.checkboxTableViewer.getTable().getItemCount()) {
                    int j = 0;
                    while (j < checkedMembers.length) {
                        if (((FileMasterMember)this.checkboxTableViewer.getElementAt(i)).getName().equals(((FileMasterMember)checkedMembers[j]).getName())) {
                            this.checkboxTableViewer.setChecked(this.checkboxTableViewer.getElementAt(i), true);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (this.checkboxTableViewer.getCheckedElements().length == this.checkboxTableViewer.getTable().getItemCount()) {
                    this.selectAllClearButton.setText("&Clear Selections");
                } else {
                    this.selectAllClearButton.setText("Select &All");
                }
            }
        }
    }

    private void changeServer() {
        String TestServer = "";
        int servers = 0;
        while (servers < this.fmstModel.getServers().length) {
            TestServer = this.fmstModel.getServers()[servers].getText();
            if (TestServer.equalsIgnoreCase(this.serverNameCombo.getText())) {
                this.server = (FileMasterServer)this.fmstModel.getServers()[servers].getAdapter(FileMasterServer.class);
                this.serverChanged(this.server);
                break;
            }
            ++servers;
        }
    }

    private int displayDatasetChangedMsg() {
        this.msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (this.pendingMessage) {
            this.pendingMessage = false;
            if (this.newDatasetName != null && !this.newDatasetName.equals(this.oldDatasetName)) {
                String title = "Confirm Change Data Set";
                String question = "Are you sure you want to change the data set? Clicking yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Change Data Set", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)this.store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    this.oldDatasetName = this.newDatasetName;
                    this.store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.checkboxTableViewer.getTable().removeAll();
                    this.checkboxTableViewer.setInput(null);
                    this.memberNameCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.dataSetCombo.setText(this.oldDatasetName);
                    this.newDatasetName = this.oldDatasetName;
                }
            }
        }
        return returncode;
    }

    public boolean doFinish() {
        FMHistory.insertHistory((Combo)this.dataSetCombo, (String)"DatasetListAddCustomLayoutPage1");
        FMHistory.insertHistory((Combo)this.memberNameCombo, (String)"MemberListAddCustomLayoutPage1");
        Object[] checkedLayoutMembers = this.checkboxTableViewer.getCheckedElements();
        TT_TreeItem dsItem = null;
        dsItem = this.fmltModel.findObject((Object)this.fmdataset);
        if (dsItem == null) {
            Element dsElement = this.fmltModel.addDataset(null, this.fmdataset);
            dsItem = this.fmltModel.insertDataset(dsElement);
        }
        FileMasterMember fmmember = new FileMasterMember(null);
        if (checkedLayoutMembers.length == 0) {
            fmmember.setName(this.memberNameCombo.getText().trim());
            fmmember.setType("CRL");
            checkedLayoutMembers = new Object[]{new FileMasterMember(null)};
            ((FileMasterMember)checkedLayoutMembers[0]).setName(fmmember.getName());
            ((FileMasterMember)checkedLayoutMembers[0]).setType(fmmember.getType());
        }
        int count = 0;
        while (count < checkedLayoutMembers.length) {
            if (checkedLayoutMembers[count] instanceof FileMasterMember) {
                fmmember.setName(((FileMasterMember)checkedLayoutMembers[count]).getName());
                fmmember.setType(((FileMasterMember)checkedLayoutMembers[count]).getType());
                Element memElement = this.fmltModel.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
                this.fmltModel.insertMember(dsItem, memElement);
            }
            ++count;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            TreeViewer viewer;
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView("com.ca.filemaster.layout.views.layoutview");
            if (view instanceof LayoutView && (viewer = ((LayoutView)view).getViewer()) != null) {
                TT_TreeItem selection = this.fmltModel.findObjectInTree((Object)fmmember, this.fmltModel.findObject((Object)this.fmdataset));
                Object[] expandedElements = viewer.getExpandedElements();
                viewer.setInput((Object)this.fmltModel.getDatasets());
                viewer.refresh(true);
                viewer.setExpandedElements(expandedElements);
                if (this.isDirectoryListCaller && selection == null) {
                    view = page.showView("com.ca.filemaster.views.directorylist");
                } else {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                    view = page.showView("com.ca.filemaster.layout.views.layoutview");
                    page.activate((IWorkbenchPart)view);
                    page.bringToTop((IWorkbenchPart)view);
                }
                view.setFocus();
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        this.fmltModel.save();
        return true;
    }

    public void setMemberName(String memberCRLToUpdate) {
        if (this.memberName != null) {
            this.memberNameCombo.add(memberCRLToUpdate);
            this.memberNameCombo.setText(memberCRLToUpdate);
            this.checkboxTableViewer.getTable().removeAll();
            this.selectAllClearButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    public void setDatasetName(String datasetCRLToUpdate) {
        if (this.dataSetName != null) {
            this.dataSetCombo.add(datasetCRLToUpdate);
            this.dataSetCombo.setText(datasetCRLToUpdate);
        }
    }

    public void datasetChanged() {
        if (chkForDSChanged && this.checkboxTableViewer != null && this.dataSetCombo != null && this.memberNameCombo != null) {
            boolean datasetError;
            this.newDatasetName = this.dataSetCombo.getText().trim();
            this.ShowDialog = !this.store.getBoolean("CLOSE_VALUE");
            boolean bl = datasetError = Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true) != 0 && Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true) != 3 && Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true) != 1;
            if (!(!this.ShowDialog.booleanValue() || datasetError || this.checkboxTableViewer.getTable().getItemCount() <= 1 && this.memberNameCombo.getText().isEmpty() || this.oldDatasetName.equalsIgnoreCase(this.newDatasetName))) {
                this.pendingMessage = true;
            } else {
                this.pendingMessage = false;
                if (!this.oldDatasetName.equalsIgnoreCase(this.newDatasetName)) {
                    this.oldDatasetName = this.newDatasetName;
                    this.checkboxTableViewer.getTable().removeAll();
                    this.checkboxTableViewer.setInput(null);
                    this.memberNameCombo.setText("");
                }
            }
            this.displayDatasetChangedMsg();
        }
    }

    static enum ModelProvider {
        INSTANCE;

        private List<FileMasterMember> members = new ArrayList<FileMasterMember>();
        private List<FileMasterMember> membersSubset;

        public List<FileMasterMember> getMem(CheckboxTableViewer checkboxTableViewer, String pattern, boolean keepSelectedMembers) {
            String execPattern = pattern.trim().length() == 0 ? ".*" : pattern;
            this.membersSubset = new ArrayList<FileMasterMember>();
            int i = 0;
            while (i < this.members.size()) {
                this.members.get(i).getName().matches(execPattern);
                ++i;
            }
            if (this.membersSubset.size() == 0) {
                MessageDialog.openError(null, (String)"Error", (String)"No matching members found.");
            }
            if (keepSelectedMembers && checkboxTableViewer.getCheckedElements().length > 0) {
                int count = 0;
                while (count < checkboxTableViewer.getCheckedElements().length) {
                    ++count;
                }
            }
            return this.membersSubset;
        }

        public boolean removeMember(String memberName) {
            int i = 0;
            while (i < this.members.size()) {
                if (this.members.get(i).getName().equals(memberName)) {
                    this.members.remove(i);
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void setStateOfAll(boolean state) {
            int i = 0;
            while (i < this.members.size()) {
                this.members.get(i).setChecked(state);
                ++i;
            }
        }

        public boolean doesMemberExist(String memberName) {
            int i = 0;
            while (i < this.members.size()) {
                if (this.members.get(i).getName().equals(memberName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

