/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.common.XMLResponseParser;
import com.ca.filemaster.editor.RunGetGetRecords;
import com.ca.filemaster.editor.ui.wizards.EditorWizardPageOne;
import com.ca.filemaster.editor.virtualtableviews.CharFormatMode;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.FormatMode;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TableFormatMode
extends FormatMode {
    protected TableViewer tableViewer;
    protected int TABLE_BORDER_WIDTH = 0;
    protected int TABLE_HEADER_HEIGHT = 0;
    protected int TABLE_ITEM_HEIGHT = 0;
    protected static final int COLUMN_MAX_WIDTH = Short.MAX_VALUE;
    protected static final int MAX_CHARACTERS_PER_COLUMN_FOR_EACH_LINE = 4000;
    protected int currentRecordLength = 0;
    protected int startOfData_inChar;
    protected int endOfData_inChar;
    protected ArrayList<FileMasterRecord> fileMasterRecords = new ArrayList();
    protected ArrayList<Object> fileMasterRecordsUsedAsInputByTableViewer = new ArrayList();
    private Logger logger = Logger.getLogger(TableFormatMode.class.getName());

    public TableFormatMode(Composite parent, EditorView editorView) {
        super(parent, editorView);
    }

    protected int getLastIndex() {
        if (!this.tableViewer.getTable().isDisposed()) {
            this.TABLE_HEADER_HEIGHT = this.tableViewer.getTable().getHeaderHeight();
            this.TABLE_BORDER_WIDTH = this.tableViewer.getTable().getBorderWidth();
            this.TABLE_ITEM_HEIGHT = this.tableViewer.getTable().getItemHeight();
            int tableHeight = this.tableViewer.getTable().getBounds().height;
            if (tableHeight == 0 && this.parent != null) {
                tableHeight = this.parent.getBounds().height - 30;
            }
            if (tableHeight <= 0) {
                return 0;
            }
            return (tableHeight - this.TABLE_BORDER_WIDTH * 2 - this.TABLE_HEADER_HEIGHT) / this.TABLE_ITEM_HEIGHT;
        }
        return 0;
    }

    protected ArrayList<FileMasterRecord> getFileMasterRecordsBasedOnXmlResponseFromMainframe(XMLRequest xmlResponse) {
        ArrayList<Object> fileMasterRecords = new ArrayList<FileMasterRecord>();
        int keyPosition = 0;
        int keyLength = 0;
        int exludedRecords = 0;
        if (xmlResponse == null) {
            this.logger.log(Level.WARNING, "xmlRespose is null");
            return null;
        }
        if (!xmlResponse.getRoot().getNodeName().equals(Constants.ELEMENT_GUI_RESPONSE)) {
            this.logger.log(Level.WARNING, "xmlResponse is not a GUI response");
            return null;
        }
        Element element = xmlResponse.getRoot();
        NodeList nodeListRecord = element.getElementsByTagName(Constants.ELEMENT_RECORD);
        element.getAttribute(Constants.ATTRIBUTE_HEX);
        if (nodeListRecord.getLength() > 0) {
            fileMasterRecords = new ArrayList();
            if (EditorWizardPageOne.dataSet instanceof FMPVSAMDataset && !((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength().isEmpty() && Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength()) > 0) {
                keyPosition = Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getOffset());
                keyLength = Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength());
            }
            int i = 0;
            while (i < nodeListRecord.getLength()) {
                FileMasterRecordField fileMasterRecordField;
                FileMasterRecord fileMasterRecord = new FileMasterRecord();
                exludedRecords = 0;
                int recordNumber = Integer.parseInt(((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_NUMBER));
                fileMasterRecord.setNumber(recordNumber);
                if (((Element)nodeListRecord.item(i)).hasAttribute(Constants.ATTRIBUTE_RRN)) {
                    fileMasterRecord.setRRN(Integer.parseInt(((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_RRN)));
                }
                if (((Element)nodeListRecord.item(i)).hasAttribute(Constants.ATTRIBUTE_STATUS)) {
                    String recordStatus = ((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_STATUS);
                    fileMasterRecord.setStatus(recordStatus);
                }
                fileMasterRecord.setLastRecord(false);
                String eof = ((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_EOF);
                if (eof.endsWith("Y")) {
                    fileMasterRecord.setLastRecord(true);
                }
                if (((Element)nodeListRecord.item(i)).hasAttribute(Constants.ATTRIBUTE_EXCLUDED)) {
                    fileMasterRecordField = new FileMasterRecordField();
                    fileMasterRecord.setExcluded(true);
                    exludedRecords = Integer.parseInt(((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_EXCLUDED));
                    fileMasterRecordField.setCharData(String.valueOf(exludedRecords) + " Line(s) not Displayed");
                    fileMasterRecord.getRecordFields().add(fileMasterRecordField);
                    fileMasterRecords.add(fileMasterRecord);
                } else {
                    fileMasterRecord.setExcluded(false);
                    fileMasterRecord.setLength(Integer.parseInt(((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_LENGTH)));
                    Element recordField = (Element)((Element)((Element)nodeListRecord.item(i)).getElementsByTagName(Constants.ELEMENT_RECORD_FIELDS).item(0)).getElementsByTagName(Constants.ELEMENT_RECORD_FIELD).item(0);
                    if (recordField != null) {
                        NodeList protectedList;
                        fileMasterRecordField = new FileMasterRecordField();
                        if (recordField.hasAttribute(Constants.ATTRIBUTE_POSITION)) {
                            fileMasterRecordField.setPosition(Integer.parseInt(recordField.getAttribute(Constants.ATTRIBUTE_POSITION)));
                        }
                        if (recordField.hasAttribute(Constants.ATTRIBUTE_MAX_LENGTH_P)) {
                            fileMasterRecordField.setMaxLengthP(recordField.getAttribute(Constants.ATTRIBUTE_MAX_LENGTH_P));
                            if (fileMasterRecordField.getMaxLengthP() > this.currentRecordLength) {
                                this.currentRecordLength = fileMasterRecordField.getMaxLengthP() + 3;
                            }
                        }
                        if (recordField.hasAttribute(Constants.ATTRIBUTE_MAX_LENGTH_D)) {
                            fileMasterRecordField.setMaxLengthD(recordField.getAttribute(Constants.ATTRIBUTE_MAX_LENGTH_D));
                        }
                        if (recordField.hasAttribute(Constants.ATTRIBUTE_ID)) {
                            fileMasterRecordField.setId(recordField.getAttribute(Constants.ATTRIBUTE_ID));
                        }
                        if (recordField.hasAttribute(Constants.ATTRIBUTE_CHARDATAHEX)) {
                            fileMasterRecordField.setCharDataHex(recordField.getAttribute(Constants.ATTRIBUTE_CHARDATAHEX));
                        }
                        if (recordField.hasAttribute(Constants.ATTRIBUTE_CURSOR)) {
                            this.logger.log(Level.INFO, "recordField has cursor");
                            fileMasterRecordField.setCursorEnabled(true);
                            fileMasterRecordField.setCursor(Integer.parseInt(recordField.getAttribute(Constants.ATTRIBUTE_CURSOR)));
                        }
                        if ((protectedList = recordField.getElementsByTagName(Constants.ELEMENT_PROTECTED_LIST)).getLength() > 0) {
                            NodeList protectedNodeList = ((Element)protectedList.item(0)).getElementsByTagName(Constants.ELEMENT_RANGE);
                            int countProtectedList = 0;
                            while (countProtectedList < protectedNodeList.getLength()) {
                                Element rangeElement = (Element)protectedNodeList.item(countProtectedList);
                                FMPRange range = null;
                                range = rangeElement.hasAttribute(Constants.ATTRIBUTE_HEX) ? new FMPRange(rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_START), rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_END), rangeElement.getAttribute(Constants.ATTRIBUTE_HEX)) : new FMPRange(rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_START), rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_END), "N");
                                fileMasterRecordField.addProtectedRange(range);
                                ++countProtectedList;
                            }
                        }
                        fileMasterRecordField.getLayoutField().setId(recordField.getAttribute(Constants.ATTRIBUTE_ID));
                        NodeList findList = recordField.getElementsByTagName(Constants.ELEMENT_FIND_LIST);
                        this.setUpFindListRange(fileMasterRecord, fileMasterRecordField, findList);
                        String charData = "";
                        if (recordField.getElementsByTagName(Constants.ELEMENT_CHAR_DATA).item(0).getFirstChild() != null) {
                            charData = recordField.getElementsByTagName(Constants.ELEMENT_CHAR_DATA).item(0).getFirstChild().getTextContent();
                        } else {
                            char[] array = new char[fileMasterRecord.getLength()];
                            Arrays.fill(array, ' ');
                            charData = new String(array);
                        }
                        if (EditorWizardPageOne.dataSet.getDsOrg().equalsIgnoreCase("VSAM") && (EditorWizardPageOne.dataSet.getDsType().equalsIgnoreCase("K") || EditorWizardPageOne.dataSet.getDsType().equalsIgnoreCase("T"))) {
                            if (keyPosition == 1) {
                                if (charData.length() == keyLength) {
                                    String vsamKey = charData.substring(keyPosition - 1, keyLength);
                                    this.logger.log(Level.INFO, "1 vsamKey: " + vsamKey);
                                    fileMasterRecordField.setVsamKey(vsamKey);
                                } else {
                                    fileMasterRecordField.setVsamKey(charData.substring(keyPosition - 1, keyLength));
                                }
                            } else {
                                fileMasterRecordField.setVsamKey(charData.substring(keyPosition - 1, keyPosition + keyLength - 1));
                            }
                            fileMasterRecordField.setKeyPosition(String.valueOf(keyPosition));
                        }
                        fileMasterRecordField.setCharData(charData);
                        if (recordField.getElementsByTagName(Constants.ELEMENT_HEX_DATA).getLength() > 0) {
                            String hexData1 = recordField.getElementsByTagName(Constants.ELEMENT_HEX_DATA).item(0).getFirstChild().getTextContent();
                            fileMasterRecordField.setHexData1(hexData1);
                            String hexData2 = recordField.getElementsByTagName(Constants.ELEMENT_HEX_DATA2).item(0).getFirstChild().getTextContent();
                            fileMasterRecordField.setHexData2(hexData2);
                        }
                        fileMasterRecord.getRecordFields().add(fileMasterRecordField);
                    }
                    fileMasterRecords.add(fileMasterRecord);
                }
                ++i;
            }
        }
        return fileMasterRecords;
    }

    protected void setUpFindListRange(FileMasterRecord fileMasterRecord, FileMasterRecordField fileMasterRecordField, NodeList findList) {
        if (findList != null && findList.getLength() > 0) {
            NodeList findNodeList = ((Element)findList.item(0)).getElementsByTagName(Constants.ELEMENT_RANGE);
            int countFindList = 0;
            while (countFindList < findNodeList.getLength()) {
                Element rangeElement = (Element)findNodeList.item(countFindList);
                FMPRange range = null;
                range = rangeElement.hasAttribute(Constants.ATTRIBUTE_HEX) ? new FMPRange(rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_START), rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_END), rangeElement.getAttribute(Constants.ATTRIBUTE_HEX)) : new FMPRange(rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_START), rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_END), "N");
                fileMasterRecordField.addFindRange(range);
                ++countFindList;
            }
        }
    }

    protected List<FileMasterRecord> getMoreRecordsFromMainFrameAndReturnFileMasterRecords(int offset) {
        String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
        this.logger.log(Level.INFO, "secondarId" + secondaryID);
        FileMasterSession fileMasterSession = this.editorView.getCurrentSession(secondaryID);
        if (fileMasterSession == null) {
            this.logger.log(Level.INFO, "fileMasterSession is null");
            return this.fileMasterRecords;
        }
        RunGetGetRecords runner = new RunGetGetRecords(fileMasterSession.getServer(), fileMasterSession.getUuid(), offset, CharFormatMode.COUNT, "C", fileMasterSession.getHexMode());
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xmlResponse = runner.getXml();
        XMLResponseParser xmlResponseParser = new XMLResponseParser(xmlResponse);
        return xmlResponseParser.getFileMasterRecords();
    }

    protected XMLRequest getMoreRecordsFromMainFrameAndReturnXMLRequest(int offset) {
        String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
        this.logger.log(Level.INFO, "secondarId" + secondaryID);
        FileMasterSession fileMasterSession = this.editorView.getCurrentSession(secondaryID);
        if (fileMasterSession == null) {
            this.logger.log(Level.INFO, "fileMasterSession is null");
            return null;
        }
        RunGetGetRecords runner = new RunGetGetRecords(fileMasterSession.getServer(), fileMasterSession.getUuid(), offset, CharFormatMode.COUNT, "M", fileMasterSession.getHexMode());
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xmlResponse = runner.getXml();
        return xmlResponse;
    }
}

