/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.editor.virtualtableviews.SRFField;
import com.ca.filemaster.editor.virtualtableviews.SingleRecordFormatMode;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class SRFValueLabelProvider
extends OwnerDrawLabelProvider {
    private Logger logger = Logger.getLogger(SRFValueLabelProvider.class.getName());
    private SRFField srfField;
    private TextLayout layout;
    private Shell shell;
    private TextStyle errorStyle;
    private TextStyle cursorStyle;
    private TextStyle findStyle;
    private SingleRecordFormatMode singleRecordFormatMode;
    private int startIndex = -1;
    private int endIndex = -1;
    private TextStyle protectedField;
    private Font font;

    public SRFValueLabelProvider(Font font, SingleRecordFormatMode singleRecordFormatMode, int startIndex, int endIndex) {
        this.singleRecordFormatMode = singleRecordFormatMode;
        this.shell = new Shell();
        this.layout = new TextLayout((Device)this.shell.getDisplay());
        this.font = font;
        this.findStyle = new TextStyle(font, this.shell.getDisplay().getSystemColor(24), this.shell.getDisplay().getSystemColor(5));
        this.errorStyle = new TextStyle(font, this.shell.getDisplay().getSystemColor(3), null);
        this.cursorStyle = new TextStyle(font, this.shell.getDisplay().getSystemColor(24), this.shell.getDisplay().getSystemColor(7));
        this.protectedField = new TextStyle(font, this.shell.getDisplay().getSystemColor(24), this.shell.getDisplay().getSystemColor(15));
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public String getText(Object element) {
        if (element instanceof SRFField) {
            return ((SRFField)element).getValue();
        }
        return "";
    }

    protected void measure(Event event, Object element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof SRFField)) {
            return;
        }
        if (event == null) {
            return;
        }
        event.gc.setFont(this.font);
        Point size = event.gc.textExtent("H");
        event.height = size.y;
    }

    protected void paint(Event event, Object element) {
        int yellowPosition;
        if (element == null) {
            this.logger.log(Level.WARNING, "element is null in paint method");
            return;
        }
        if (!(element instanceof SRFField)) {
            this.logger.log(Level.WARNING, "element not instance of SRFField");
            return;
        }
        this.srfField = (SRFField)element;
        TextStyle plain = new TextStyle(this.font, null, null);
        if (this.srfField.getFields().size() == 0) {
            this.layout.setText("");
            this.layout.setStyle(plain, 0, 2000000);
        }
        if (this.startIndex >= 0 && this.endIndex > 0 && this.startIndex < this.srfField.getValue().length() && this.startIndex <= this.endIndex) {
            this.layout.setText(this.srfField.getValue().substring(Math.min(this.startIndex, this.srfField.getValue().length()), Math.min(this.endIndex, this.srfField.getValue().length())));
        } else {
            this.layout.setText("");
        }
        if (this.startIndex < 0) {
            this.layout.setText(this.srfField.getValue());
        }
        this.layout.setStyle(plain, 0, this.layout.getText().length());
        FMPCursor fmpCursor = this.singleRecordFormatMode.getEditorView().getCursor();
        if (fmpCursor.getFieldName().equals(this.srfField.getName()) && fmpCursor.isFindChange() && !fmpCursor.isField()) {
            int start = fmpCursor.getCursorOffset();
            int end = fmpCursor.getSelectionEnd();
            this.layout.setStyle(this.findStyle, start, end);
        }
        if (this.srfField.isProtected()) {
            this.layout.setStyle(this.protectedField, 0, this.srfField.getValue().length());
        }
        if (this.srfField.isColorData()) {
            this.layout.setStyle(this.errorStyle, 0, this.srfField.getValue().length());
        }
        if (this.srfField.isCursorEnabled() && this.startIndex <= (yellowPosition = this.singleRecordFormatMode.getEditorView().getYellowPosition()) && this.endIndex > yellowPosition) {
            int cursorPositionToHighlight = yellowPosition - this.startIndex;
            this.layout.setStyle(this.cursorStyle, cursorPositionToHighlight, cursorPositionToHighlight);
        }
        this.layout.draw(event.gc, event.x, event.y);
    }
}

