/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class TraverseListenerBase
implements TraverseListener {
    Logger log = Logger.getLogger(TraverseListenerBase.class.getName());
    protected TextCellEditor textCellEditor;
    private FileMasterRecord fileMasterRecord;
    private FileMasterRecordField fileMasterRecordField;

    public TraverseListenerBase(TextCellEditor textCellEditor, FileMasterRecord fileMasterRecord, FileMasterRecordField fileMasterRecordField) {
        this.textCellEditor = textCellEditor;
        this.fileMasterRecord = fileMasterRecord;
        this.fileMasterRecordField = fileMasterRecordField;
    }

    public void keyTraversed(TraverseEvent traverseEvent) {
        this.log.log(Level.INFO, "traverse listener event: " + traverseEvent.detail + " doit: " + traverseEvent.doit);
        int caretLineNumber = -1;
        int caretLineCount = -1;
        Control textCellEditorControl = this.textCellEditor.getControl();
        if (textCellEditorControl instanceof Text && !this.textCellEditor.getControl().isDisposed()) {
            Text text = (Text)textCellEditorControl;
            caretLineNumber = text.getCaretLineNumber();
            String lineDelimeter = text.getLineDelimiter();
            String contentOfTextWidget = text.getText();
            Object[] contentsOfTextWidgetSplitIntoSeparateLines = contentOfTextWidget.split(lineDelimeter);
            caretLineCount = contentsOfTextWidgetSplitIntoSeparateLines.length;
            this.log.log(Level.INFO, "abc: " + Arrays.toString(contentsOfTextWidgetSplitIntoSeparateLines));
            this.log.log(Level.INFO, "text line delimeter: " + lineDelimeter);
            this.log.log(Level.INFO, "text caret line number: " + caretLineNumber);
            this.log.log(Level.INFO, "text line count: " + caretLineCount);
        }
        if (traverseEvent.detail == 4) {
            this.log.log(Level.INFO, "TRAVERSE_RETURN");
            this.moveToNext(traverseEvent);
            traverseEvent.detail = 0;
            traverseEvent.doit = true;
        } else if (traverseEvent.detail == 512) {
            this.log.log(Level.INFO, "TRAVERSE_PAGE_NEXT");
            this.moveToNext(traverseEvent);
            traverseEvent.detail = 0;
            traverseEvent.doit = true;
        } else if (traverseEvent.detail == 256) {
            this.log.log(Level.INFO, "TRAVERSE_PAGE_PREVIOUS");
            this.moveToPrevious(traverseEvent);
            traverseEvent.detail = 0;
            traverseEvent.doit = true;
        } else if (traverseEvent.detail == 16) {
            this.log.log(Level.INFO, "TRAVERSE_TAB_NEXT");
            this.moveToNext(traverseEvent);
            traverseEvent.detail = 0;
            traverseEvent.doit = true;
        } else if (traverseEvent.detail == 8) {
            this.log.log(Level.INFO, "TRAVERSE_TAB_PREVIOUS");
            this.moveToPrevious(traverseEvent);
            traverseEvent.detail = 0;
            traverseEvent.doit = true;
        } else if (traverseEvent.detail == 64) {
            this.log.log(Level.INFO, "TRAVERSE_ARROW_NEXT");
            if (traverseEvent.keyCode == 0x1000002) {
                if (caretLineNumber + 1 == caretLineCount) {
                    this.moveToNext(traverseEvent);
                    traverseEvent.detail = 0;
                    traverseEvent.doit = true;
                } else {
                    this.log.log(Level.INFO, "not at the end of the record field");
                }
            } else if (traverseEvent.keyCode == 0x1000004) {
                this.log.log(Level.INFO, "ARROW RIGHT");
            } else {
                this.log.log(Level.WARNING, "Unknown keyCode: " + traverseEvent.keyCode);
            }
        } else if (traverseEvent.detail == 32) {
            this.log.log(Level.INFO, "TRAVERSE_ARROW_PREVIOUS");
            if (traverseEvent.keyCode == 0x1000001) {
                if (caretLineNumber == 0) {
                    this.moveToPrevious(traverseEvent);
                    traverseEvent.detail = 0;
                    traverseEvent.doit = true;
                }
            } else if (traverseEvent.keyCode == 0x1000003) {
                this.log.log(Level.INFO, "ARROW LEFT");
            } else {
                this.log.log(Level.WARNING, "Unknown keyCode: " + traverseEvent.keyCode);
            }
        } else {
            this.log.log(Level.INFO, "unrecognized traverse event: " + traverseEvent.detail);
        }
    }

    protected abstract void moveToNext(TraverseEvent var1);

    protected abstract void moveToPrevious(TraverseEvent var1);

    public FileMasterRecord getFileMasterRecord() {
        return this.fileMasterRecord;
    }

    public FileMasterRecordField getFileMasterRecordField() {
        return this.fileMasterRecordField;
    }
}

