/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.FileMasterLabelProviderBase;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CharLineNumLabelProvider
extends FileMasterLabelProviderBase {
    Display display;
    Shell shell = null;
    boolean subString = false;
    int subStringIndex;
    private Font font;

    public CharLineNumLabelProvider(Font font, boolean subString, int subStringIndex) {
        this.subString = subString;
        this.subStringIndex = subStringIndex;
        this.font = font;
    }

    public CharLineNumLabelProvider() {
    }

    @Override
    protected void paint(Event event, Object element) {
        if (element != null && element instanceof FileMasterRecord) {
            FileMasterRecord m = (FileMasterRecord)element;
            if (this.shell == null) {
                this.shell = new Shell();
                this.display = this.shell.getDisplay();
            }
            TextLayout layout = new TextLayout((Device)this.display);
            TextStyle plain = new TextStyle(this.font, this.display.getSystemColor(2), this.display.getSystemColor(19));
            TextStyle msgStyle = new TextStyle(this.font, this.display.getSystemColor(24), this.display.getSystemColor(7));
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            EditorView view = null;
            if (page.getActivePart() instanceof EditorView) {
                view = (EditorView)page.getActivePart();
            }
            int cursorStart = 0;
            int cursorEnd = 8;
            if (event != null) {
                event.gc.setForeground(this.display.getSystemColor(19));
                TableItem item = (TableItem)event.item;
                Rectangle rect = item.getImageBounds(event.index);
                rect = item.getBounds(event.index);
                --rect.height;
                --rect.width;
                int[] borderPoints = new int[]{rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height};
                event.gc.drawPolyline(borderPoints);
                event.gc.setForeground(this.display.getSystemColor(2));
            }
            if (m.getStatus() != null && m.getStatus().equals("ERR")) {
                if (view != null) {
                    layout.setText("=====ERR>");
                    layout.setStyle(msgStyle, cursorStart, cursorEnd);
                    layout.draw(event.gc, event.x, event.y);
                }
            } else if (m.getStatus() != null && m.getStatus().equals("CHG")) {
                if (view != null) {
                    layout.setText("=====CHG>");
                    layout.setStyle(msgStyle, cursorStart, cursorEnd);
                    layout.draw(event.gc, event.x, event.y);
                }
            } else if (m.getStatus() != null && m.getStatus().equals("DUP")) {
                if (view != null) {
                    layout.setText("=====DUP>");
                    layout.setStyle(msgStyle, cursorStart, cursorEnd);
                    layout.draw(event.gc, event.x, event.y);
                }
            } else if (m.getStatus() != null && m.getStatus().equals("SEQ")) {
                if (view != null) {
                    layout.setText("=====SEQ>");
                    layout.setStyle(msgStyle, cursorStart, cursorEnd);
                    layout.draw(event.gc, event.x, event.y);
                }
            } else if (m.getStatus() != null && m.getStatus().equals("ODO")) {
                if (view != null) {
                    layout.setText("=====ODO>");
                    layout.setStyle(msgStyle, cursorStart, cursorEnd);
                    layout.draw(event.gc, event.x, event.y);
                }
            } else {
                if (m.getLabelForRecord() != null) {
                    layout.setText(m.getLabelForRecord());
                } else if (m.getNumber() == 0) {
                    layout.setText("");
                }
                if (m.getRRN() > -1) {
                    if (m.getRRN() == 0) {
                        layout.setText("");
                    } else {
                        layout.setText(String.format("%09d", m.getRRN()));
                    }
                } else if (m.getNumber() == 0) {
                    layout.setText("");
                } else {
                    layout.setText(this.subString ? String.format("%09d", m.getNumber()).substring(Math.min(this.subStringIndex, String.format("%09d", m.getNumber()).length() - 1)) : String.format("%09d", m.getNumber()));
                }
                layout.setStyle(plain, cursorStart, cursorEnd);
                layout.draw(event.gc, event.x, event.y);
            }
        }
    }

    public String getColumnText(Object obj, int index) {
        return this.getText(obj);
    }

    public Image getColumnImage(Object obj, int index) {
        return null;
    }

    public Image getImage(Object obj) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof FileMasterRecord) {
            FileMasterRecord m = (FileMasterRecord)element;
            if (m.getLabelForRecord() != null) {
                return m.getLabelForRecord();
            }
            if (m.getNumber() == 0) {
                return "";
            }
            if (m.getRRN() > -1) {
                return String.format("%09d", m.getRRN());
            }
            return String.format("%09d", m.getNumber());
        }
        return (String)element;
    }
}

