/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.FileMasterLabelProviderBase;
import com.ca.filemaster.editor.virtualtableviews.MultiRecordFormatMode;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class MFEditorLabelProvider
extends FileMasterLabelProviderBase {
    private Logger logger = Logger.getLogger(MFEditorLabelProvider.class.getName());
    private int count;
    private Display display;
    private Shell shell = null;
    private TextStyle protectedField;
    private TextLayout layout;
    private FileMasterRecord fmRecord;
    private TableViewer tableViewer;
    private MultiRecordFormatMode multiRecordFormatMode;
    private Logger log = Logger.getLogger(MFEditorLabelProvider.class.getName());
    private TextStyle errorStyle;
    private TextStyle plainStyle;
    private TextStyle findStyle;
    private TextStyle cursorStyle;
    private boolean subString = false;
    private int subStringIndex;
    private Font font;

    public MFEditorLabelProvider(Font font, MultiRecordFormatMode multiRecordFormatMode, int count) {
        this.count = count;
        this.font = font;
        this.createShell();
        this.createLayout();
        this.createProtectedField();
        this.multiRecordFormatMode = multiRecordFormatMode;
        this.plainStyle = new TextStyle(font, null, null);
        this.errorStyle = new TextStyle(font, this.shell.getDisplay().getSystemColor(3), this.shell.getDisplay().getSystemColor(25));
        this.findStyle = new TextStyle(font, this.display.getSystemColor(24), this.display.getSystemColor(5));
        this.cursorStyle = new TextStyle(font, this.display.getSystemColor(24), this.display.getSystemColor(7));
    }

    public MFEditorLabelProvider(Font font, MultiRecordFormatMode multiRecordFormatMode, int i, boolean isHexMode, TableViewer tableViewer, boolean subString, int subStringIndex) {
        this(font, multiRecordFormatMode, i);
        this.tableViewer = tableViewer;
        this.subString = subString;
        this.subStringIndex = subStringIndex;
    }

    public String getColumnText(Object obj, int index) {
        return this.getText(obj);
    }

    public Image getColumnImage(Object obj, int index) {
        return null;
    }

    public Image getImage(Object obj) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof FileMasterRecord) {
            FileMasterRecord m = (FileMasterRecord)element;
            if (this.count == 0) {
                if (m.getNumber() == 0) {
                    return "";
                }
                if (m.getRRN() > -1) {
                    return String.format("%06d", m.getRRN());
                }
                return String.format("%06d", m.getNumber());
            }
            if (m.getRecordFields().size() > this.count) {
                return ((FileMasterRecordField)m.getRecordFields().get(this.count)).getCharData();
            }
        }
        return "";
    }

    @Override
    protected void paint(Event event, Object element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof FileMasterRecord)) {
            return;
        }
        this.fmRecord = (FileMasterRecord)element;
        if (this.fmRecord.getRecordFields().size() == 0) {
            this.layout.setText("");
            this.layout.setStyle(this.plainStyle, 0, 20000);
        } else if (!this.fmRecord.isExcluded()) {
            this.layout.setStyle(this.plainStyle, 0, 20000);
            if (this.count == 0) {
                int cursorStart = 0;
                int cursorEnd = 6;
                TextStyle msgStyle = new TextStyle(this.font, this.display.getSystemColor(24), this.display.getSystemColor(7));
                if (this.fmRecord.getStatus() != null && this.fmRecord.getStatus().equals("CHG")) {
                    this.layout.setText("==CHG>");
                    this.layout.setStyle(msgStyle, cursorStart, cursorEnd);
                    this.layout.draw(event.gc, event.x, event.y);
                }
                if (this.fmRecord.getStatus() != null && this.fmRecord.getStatus().equals("DUP")) {
                    this.layout.setText("==DUP>");
                    this.layout.setStyle(msgStyle, cursorStart, cursorEnd);
                    this.layout.draw(event.gc, event.x, event.y);
                }
                if (this.fmRecord.getStatus() != null && this.fmRecord.getStatus().equals("SEQ")) {
                    this.layout.setText("==SEQ>");
                    this.layout.setStyle(msgStyle, cursorStart, cursorEnd);
                    this.layout.draw(event.gc, event.x, event.y);
                }
                if (this.fmRecord.getStatus() != null && this.fmRecord.getStatus().equals("ODO")) {
                    this.layout.setText("==ODO>");
                    this.layout.setStyle(msgStyle, cursorStart, cursorEnd);
                    this.layout.draw(event.gc, event.x, event.y);
                } else if (this.fmRecord.getRRN() > -1) {
                    if (this.fmRecord.getRRN() == 0) {
                        this.layout.setText("");
                    } else {
                        this.layout.setText(String.format("%06d", this.fmRecord.getRRN()));
                    }
                } else if (this.fmRecord.getNumber() == 0) {
                    this.layout.setText("");
                } else {
                    this.layout.setText(String.format("%06d", this.fmRecord.getNumber()));
                }
            } else {
                if (this.hasHexData()) {
                    this.displayHexData();
                } else {
                    this.displayCharData();
                }
                int recordFieldsSize = this.fmRecord.getRecordFields().size();
                int indexOfRecordField = this.count - 1;
                if (indexOfRecordField < recordFieldsSize) {
                    FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)this.fmRecord.getRecordFields().get(this.count - 1);
                    int length = fileMasterRecordField.getMaxLengthP();
                    if (fileMasterRecordField.isDataInputError() && fileMasterRecordField.isColorData()) {
                        this.log.log(Level.INFO, "charData: " + fileMasterRecordField.getCharData() + " isDataInputError and isColorData both true");
                        this.layout.setStyle(this.errorStyle, 0, length);
                        if (this.hasHexData()) {
                            this.layout.setStyle(this.plainStyle, length + 1, length * 2);
                        }
                    } else {
                        this.layout.setStyle(this.plainStyle, 0, length);
                        if (this.hasHexData()) {
                            this.layout.setStyle(this.plainStyle, length + 1, length * 3 + 1);
                        }
                    }
                }
                this.setFindResults();
                this.highlightCursorPosition();
            }
        } else {
            this.displayCharData();
        }
        this.setProtectedFields(this.fmRecord);
        EditorView view = this.multiRecordFormatMode.getEditorView();
        if (view.getHexModeToggled() && this.tableViewer.getTable().getTopIndex() != 0 && this.fmRecord.getNumber() != 0) {
            this.tableViewer.getTable().setTopIndex(this.fmRecord.getNumber() - 1);
            view.setHexModeToggled(false);
        }
        this.layout.draw(event.gc, event.x, event.y);
    }

    private void setProtectedFields(FileMasterRecord fileMasterRecord) {
        FileMasterRecordField fileMasterRecordField;
        ArrayList fmpRanges;
        List fileMasterRecordFields = fileMasterRecord.getRecordFields();
        if (fileMasterRecordFields.size() == 0) {
            return;
        }
        if (fileMasterRecordFields.size() > this.count - 1 && (fmpRanges = (fileMasterRecordField = (FileMasterRecordField)fileMasterRecordFields.get(this.count - 1)).getProtectedList()) != null && fmpRanges.size() > 0) {
            for (FMPRange fmpRange : fmpRanges) {
                int start = Integer.parseInt(fmpRange.getStart());
                int end = Integer.parseInt(fmpRange.getEnd());
                this.layout.setStyle(this.protectedField, start - 1, end - 1);
            }
        }
    }

    private void highlightCursorPosition() {
        if (this.multiRecordFormatMode.isFind()) {
            FileMasterRecordField recordField;
            FMPCursor cursor = this.multiRecordFormatMode.getEditorView().getCursor();
            if (this.count < this.fmRecord.getRecordFields().size() && (recordField = (FileMasterRecordField)this.fmRecord.getRecordFields().get(this.count - 1)).isCursorEnabled()) {
                int cursorOffset = cursor.getCursorOffset();
                int position = recordField.getPosition();
                int lenghtOfRecordField = recordField.getMaxLengthP();
                int cursorPositionToHighlight = cursorOffset - position;
                if (this.fmRecord.getNumber() == cursor.getRecordNumber()) {
                    if (this.subString) {
                        if (this.subStringIndex <= cursorOffset && this.subStringIndex >= cursorOffset) {
                            this.layout.setStyle(this.cursorStyle, cursorOffset, cursorOffset);
                        }
                    } else {
                        this.layout.setStyle(this.cursorStyle, cursorOffset, cursorOffset);
                    }
                }
            }
        }
    }

    private void setFindResults() {
        FileMasterRecordField recordField;
        FMPCursor cursor = this.multiRecordFormatMode.getEditorView().getCursor();
        if (cursor.isField()) {
            int i = 0;
            while (i < this.tableViewer.getTable().getColumnCount()) {
                if (this.tableViewer.getTable().getColumns()[i] == null) {
                    this.log.log(Level.WARNING, "column is null:" + i);
                    return;
                }
                if (cursor.getFieldName().isEmpty()) {
                    this.log.log(Level.WARNING, "cursor fieldName is empty");
                    return;
                }
                this.log.log(Level.INFO, "Where is null" + i + this.tableViewer.getTable().getColumns()[i]);
                String textFromColumn = this.tableViewer.getTable().getColumns()[i].getText();
                if (textFromColumn == null) {
                    this.log.log(Level.WARNING, "text is null at column:" + i);
                    return;
                }
                if (textFromColumn.equalsIgnoreCase(cursor.getFieldName())) {
                    this.tableViewer.getTable().showColumn(this.tableViewer.getTable().getColumns()[i]);
                    return;
                }
                ++i;
            }
            return;
        }
        if (this.count < this.fmRecord.getRecordFields().size() && (recordField = (FileMasterRecordField)this.fmRecord.getRecordFields().get(this.count - 1)).getFindList() != null) {
            int countFindFields = 0;
            while (countFindFields < recordField.getFindList().size()) {
                this.layout.setStyle(this.findStyle, Integer.parseInt(((FMPRange)recordField.getFindList().get(countFindFields)).getStart()) - 1, Integer.parseInt(((FMPRange)recordField.getFindList().get(countFindFields)).getEnd()) - 1);
                ++countFindFields;
            }
        }
    }

    private void displayCharData() {
        if (this.count <= this.fmRecord.getRecordFields().size()) {
            FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)this.fmRecord.getRecordFields().get(this.count - 1);
            if (fileMasterRecordField.getCharData() == null) {
                this.layout.setText("");
                return;
            }
            this.layout.setText(fileMasterRecordField.getCharData() == "" ? "" : (this.subString ? (this.subStringIndex > ((FileMasterRecordField)this.fmRecord.getRecordFields().get(this.count - 1)).getCharData().length() ? "" : ((FileMasterRecordField)this.fmRecord.getRecordFields().get(this.count - 1)).getCharData().substring(this.subStringIndex)) : ((FileMasterRecordField)this.fmRecord.getRecordFields().get(this.count - 1)).getCharData()));
        } else {
            this.layout.setText("");
        }
    }

    private void displayHexData() {
        String hexData1;
        String charData;
        FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)this.fmRecord.getRecordFields().get(this.count - 1);
        String string = fileMasterRecordField.getCharData() == null ? "" : (charData = this.subString ? fileMasterRecordField.getCharData().substring(this.subStringIndex) : fileMasterRecordField.getCharData());
        String string2 = fileMasterRecordField.getHexData1() == null ? "" : (hexData1 = this.subString ? fileMasterRecordField.getHexData1().substring(this.subStringIndex) : fileMasterRecordField.getHexData1());
        String hexData2 = fileMasterRecordField.getHexData2() == null ? "" : (this.subString ? fileMasterRecordField.getHexData2().substring(this.subStringIndex) : fileMasterRecordField.getHexData2());
        this.layout.setText(String.valueOf(charData) + "\n" + hexData1 + "\n" + hexData2);
    }

    private boolean hasHexData() {
        if (this.count - 1 < this.fmRecord.getRecordFields().size()) {
            return ((FileMasterRecordField)this.fmRecord.getRecordFields().get(this.count - 1)).getHexData1() != null;
        }
        return false;
    }

    private void createProtectedField() {
        this.protectedField = new TextStyle(this.font, this.display.getSystemColor(24), this.display.getSystemColor(15));
    }

    private void createLayout() {
        this.layout = new TextLayout((Device)this.display);
    }

    private void createShell() {
        if (this.shell == null) {
            this.shell = new Shell();
            this.display = this.shell.getDisplay();
        }
    }
}

