/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.ui.wizards;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.editor.ui.wizards.EditorGenericWizard;
import com.ca.filemaster.editor.ui.wizards.EditorWizardPageOne;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class EditorGenericWizardPage
extends FileMasterWizard {
    private Combo dsNameText;
    private Combo volumeText;
    private FileMasterServer server;
    private FileMasterDataset dataSet;
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.OpenFile";

    protected EditorGenericWizardPage(FileMasterServer server, FileMasterDataset dataSet) {
        super("Select Data set", "", server);
        this.setTitle("Open File");
        this.server = server;
        this.dataSet = dataSet;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.OpenFile");
        super.createControl(parent);
        super.createDataSet();
        FMHistory.intializeComboBoxes((Combo)this.dataSetCombo, (String)"DatasetListGenericOpen");
        Label lblvolumeSerial = new Label(this.dataSetComposite, 0);
        lblvolumeSerial.setText("&Volume serial:");
        this.volumeText = new Combo(this.dataSetComposite, 2048);
        this.volumeText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Combo)this.volumeText, (int)37);
        this.volumeText.setTextLimit(6);
        this.volumeText.addModifyListener((ModifyListener)this);
        this.volumeText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes((Combo)this.volumeText, (String)"VolumeListGenericOpen");
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.canFlipToNextPage());
    }

    public boolean canFlipToNextPage() {
        this.error = "";
        if (this.volumeText != null) {
            switch (Validator.volume((String)this.volumeText.getText(), (boolean)false)) {
                case 9: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume((String)this.volumeText.getText(), (boolean)false)] + "\n ";
                }
            }
        }
        return super.isPageComplete();
    }

    public IWizardPage getNextPage() {
        FMHistory.insertHistory((Combo)this.dataSetCombo, (String)"DatasetListGenericOpen");
        FMHistory.insertHistory((Combo)this.volumeText, (String)"VolumeListGenericOpen");
        String typeOfDSN = "";
        this.dataSet = new FileMasterDataset(null);
        this.dsNameText = this.dataSetCombo;
        this.dataSet.setName(this.dsNameText.getText());
        this.dataSet.setVolume(this.volumeText.getText());
        FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN((String)this.dsNameText.getText(), (String)this.volumeText.getText(), (FileMasterServer)this.server);
        if (CommonMFCalls.RETURN_CODE.equals("0")) {
            typeOfDSN = FMDataSet.getDsOrg();
        }
        if (FMDataSet.getDsOrg().equalsIgnoreCase("HFS") || FMDataSet.getDsOrg().equalsIgnoreCase("VSAM") && FMDataSet.getDsType().equalsIgnoreCase("N") || FMDataSet.getDsOrg().equalsIgnoreCase("GDG")) {
            MessageDialog.openError(null, (String)"Data Set Not Supported", (String)(String.valueOf(FMDataSet.getName()) + " not supported."));
            return null;
        }
        if (FMDataSet.getDsOrg().equalsIgnoreCase("VSAM")) {
            FMDataSet.setName(((FMPVSAMDataset)FMDataSet).getCluster());
        }
        if (typeOfDSN.isEmpty()) {
            if (CommonMFCalls.RETURN_CODE.equals("0")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)"Archived data set", (Throwable)new Throwable("Archived data set"));
            }
            return null;
        }
        if (((EditorGenericWizard)this.getWizard()).getPage("Open File") == null) {
            ((EditorGenericWizard)this.getWizard()).setValues(this.server, FMDataSet, typeOfDSN);
            ((EditorGenericWizard)this.getWizard()).addRemainingPages();
            ((EditorWizardPageOne)((EditorGenericWizard)this.getWizard()).getPage("Open File")).setOpenVolume(this.volumeText.getText().trim());
        } else {
            ((EditorWizardPageOne)((EditorGenericWizard)this.getWizard()).getPage("Open File")).updateDataSet(FMDataSet);
            ((EditorWizardPageOne)((EditorGenericWizard)this.getWizard()).getPage("Open File")).setDataSet(FMDataSet);
            ((EditorWizardPageOne)((EditorGenericWizard)this.getWizard()).getPage("Open File")).setFileType(typeOfDSN);
            ((EditorWizardPageOne)((EditorGenericWizard)this.getWizard()).getPage("Open File")).setOpenVolume(this.volumeText.getText().trim());
        }
        return ((EditorGenericWizard)this.getWizard()).getPage("Open File");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.dataSetCombo.setFocus();
    }
}

