/**
 * Copyright (c) 2017 CA, All rights reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.filemaster.dsnlists.wizards;

/**
 * @author polra04
 *
 */
import java.util.ArrayList;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.ui.wizards.FilesDatasetWizardPage;

public class InsertDataSetWizard extends Wizard implements INewWizard {
	static final String cacopyright = "Copyright (c) 2017 CA";
	private FileMasterServer server;
	private FilesDatasetWizardPage page;
	private String pageName;
	private ArrayList<String> dsnList;
	private int index;

	public InsertDataSetWizard(FileMasterServer server, String windowTitle,
			String pageName, ArrayList<String> dsnList, int index){
		this.server = server;
		setWindowTitle(windowTitle); //$NON-NLS-1$	
		this.pageName = pageName;
		this.dsnList = dsnList;
		this.index = index;
	}

	public void addPages() {
		page = new InsertDataSetWizardPage(null, server, true, pageName, dsnList, index);
		addPage(page);
	}

	@Override
	public boolean canFinish() {
		return page.isPageComplete();
	}

	@Override
	public boolean performFinish() {
		return page.doFinish();
	}
	
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
	}
}
