/**
 * Copyright (c) 2017 CA, All rights reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.filemaster.dsnlists.wizards;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMDSNListTreeModel;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterDSName;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.dsnlists.view.DSNListView;
import com.ca.filemaster.ui.wizards.ImportDSNListWizardPage;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

/**
 * @author galpe02
 * 
 */

public class CreateUpdateDSNListWizardPage extends FileMasterWizard
implements ModifyListener, SelectionListener {

	protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.createdsnlist"; //$NON-NLS-1$
	protected final String CONTEXT_Update_HELP_ID = "com.ca.filemaster.help.updatedsnlist";
	private FMServerTreeModel fmstModel = FMServerTreeModel.getInstance();
	private FMDSNListTreeModel fmDSNListModel = FMDSNListTreeModel
	.getInstance();
	protected TestingToolsWizardDialog dialog = null;
	private String initDSName;
	private FileMasterServer server;
	private String memberName;
	private String description;

	private boolean isDirectoryListCaller = false;

	private Label serverNameLabel;
	private Label memberNameLabel;
	private Label descriptionLabel;

	private Combo serverNameCombo;
	public Text memberNameText;
	private Text descriptionText;

	private boolean isNewDSNList;
	private String error = "";

	private Button btnInsert;
	private Button btnMoveUp;
	private Button btnMoveDown;
	private Button btnRepeat;
	private Button btnRemove;
	private Button btnImport;

	private TableViewer tableViewer;
	private Table table;
	private TextCellEditor textEditor;
	
	ArrayList<String> dsnList = new ArrayList<String>();
	

	public CreateUpdateDSNListWizardPage(String pageName,
			FileMasterServer server, String datasetName, String memberName,
			String description, boolean isNewDSNList, ArrayList<String> dsnList) {
		super(pageName, datasetName, server);
		this.initDSName = datasetName;
		this.memberName = memberName;
		this.description = description;
		this.server = server;
		this.isNewDSNList = isNewDSNList;
		this.dsnList = dsnList;
		if(!isNewDSNList)
		setTitle(datasetName+"("+memberName+")"+" "+"Update");
		else
		setTitle(pageName);
	}

	@Override
	public void createControl(Composite parent) {

		super.createControl(parent);
		setControl(container);
		if (isNewDSNList) {
			PlatformUI.getWorkbench().getHelpSystem()
			.setHelp(parent, CONTEXT_HELP_ID);
		} else {
			PlatformUI.getWorkbench().getHelpSystem()
			.setHelp(parent, CONTEXT_Update_HELP_ID);
		}
		serverNameLabel = new Label(dataSetComposite, SWT.NONE);
		serverNameLabel.setText("Se&rver:");
		serverNameCombo = new Combo(dataSetComposite, SWT.BORDER
				| SWT.READ_ONLY);

		GridData gd_serverNameCombo = new GridData(SWT.FILL, SWT.FILL, false,
				false, 1, 1);
		serverNameCombo.setLayoutData(gd_serverNameCombo);
		serverNameCombo.setItems(getServers());
		if (serverNameCombo.getItemCount() > 0) {
			boolean lastServerExists = false;
			String lastServerUsed = FMHistory
			.getServer("CreateUpdateDSNListWizardPage");
			for (int count = 0; count < serverNameCombo.getItemCount(); count++) {
				if (serverNameCombo.getItem(count).toString()
						.equalsIgnoreCase(lastServerUsed)) {
					lastServerExists = true;
					serverNameCombo.setText(serverNameCombo.getItem(count)
							.toString());

					break;
				}
			}
			if (!lastServerExists)
				serverNameCombo.setText(serverNameCombo.getItem(0));
		}
		serverNameCombo.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				changeServer();
				setPageComplete(canFlipToNextPage());
			}

		});
		if (isDirectoryListCaller)
			serverNameCombo.setEnabled(false);
		new Label(dataSetComposite, SWT.NONE);
		new Label(dataSetComposite, SWT.NONE);
		super.createDataSet();
		FMHistory.intializeComboBoxes(dataSetCombo, "UpdateDSNListDSN");
		dataSetCombo.setText(initDSName);

		/* DSN List Member */
		memberNameLabel = new Label(dataSetComposite, SWT.NONE);
		memberNameLabel.setText("&Member name:");
		memberNameText = new Text(dataSetComposite, SWT.BORDER);
		GridData gd_memberNameCombo = new GridData(SWT.FILL, SWT.FILL, false,
				false, 1, 1);
		memberNameText.setLayoutData(gd_memberNameCombo);
		memberNameText.setText(memberName);
		memberNameText.addModifyListener(this);
		memberNameText.setTextLimit(8);
		memberNameText.addVerifyListener(new verifytoUpperCase());

		new Label(dataSetComposite, SWT.NONE);
		new Label(dataSetComposite, SWT.NONE);

		/* DSN List description */
		descriptionLabel = new Label(dataSetComposite, SWT.NONE);
		descriptionLabel.setText("Descri&ption:");
		descriptionText = new Text(dataSetComposite, SWT.BORDER);
		GridData gd_descriptionText = new GridData(SWT.FILL, SWT.FILL, false,
				false, 1, 1);
		descriptionText.setLayoutData(gd_descriptionText);
		descriptionText.setText(description);
		descriptionText.addModifyListener(this);
		descriptionText.setTextLimit(40);
		descriptionText.addTraverseListener(new TraverseListener() {
        	public void keyTraversed(TraverseEvent e) {
        		if (e.detail == SWT.TRAVERSE_TAB_NEXT) {
        			if(table.getSelectionIndex() == -1){
        				tableViewer.editElement(tableViewer.getElementAt(0), 0);
        				table.setSelection(0);
        			} else {
        				tableViewer.editElement(tableViewer.getElementAt(table.getSelectionIndex()), 0);
        			}
        			e.doit = false;
        		}
        	}
        });

		new Label(dataSetComposite, SWT.NONE);
		new Label(dataSetComposite, SWT.NONE);

		Composite compositeTable = new Composite(container, SWT.NONE);
		GridData gd_compositeTable = new GridData(SWT.FILL, SWT.FILL, true,
				true, 1, 1);
		gd_compositeTable.heightHint = 249;
		compositeTable.setLayoutData(gd_compositeTable);
		GridLayout gl_compositeTable = new GridLayout(2, false);
		gl_compositeTable.marginWidth = 0;
		compositeTable.setLayout(gl_compositeTable);

		Composite composite_left = new Composite(compositeTable, SWT.NONE);
		composite_left.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
				true, 1, 1));
		composite_left.setLayout(new GridLayout(1, false));

		createViewer(composite_left);

		Composite composite_right = new Composite(compositeTable, SWT.NONE);
		composite_right.setLayoutData(new GridData(SWT.RIGHT, SWT.FILL, false,
				true, 1, 1));
		composite_right.setLayout(new GridLayout(1, false));

		btnInsert = new Button(composite_right, SWT.NONE);
		btnInsert.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		btnInsert.setText("I&nsert...");
		btnInsert.addSelectionListener(this);
		btnInsert.addTraverseListener(new TraverseListener(){
			@Override
			public void keyTraversed(TraverseEvent e) {
				if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS) {
					if(table.getSelectionIndex() == -1){
						tableViewer.editElement(tableViewer.getElementAt(table.getItemCount() - 1), 0);
						table.setSelection(table.getItemCount() - 1);
					} else {
						tableViewer.editElement(tableViewer.getElementAt(table.getSelectionIndex()), 0);
					}
					e.doit = false;
				}
			}
		});

		btnMoveUp = new Button(composite_right, SWT.NONE);
		btnMoveUp.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		btnMoveUp.setText("M&ove up");
		btnMoveUp.setEnabled(false);
		btnMoveUp.addSelectionListener(this);


		btnMoveDown = new Button(composite_right, SWT.NONE);
		btnMoveDown.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		btnMoveDown.setText("Move do&wn");
		btnMoveDown.setEnabled(false);
		btnMoveDown.addSelectionListener(this);


		btnRepeat = new Button(composite_right, SWT.NONE);
		btnRepeat.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		btnRepeat.setText("R&epeat");
		btnRepeat.setEnabled(false);
		btnRepeat.addSelectionListener(this);


		btnRemove = new Button(composite_right, SWT.NONE);
		btnRemove.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		btnRemove.setText("Remo&ve");
		btnRemove.setEnabled(false);
		btnRemove.addSelectionListener(this);
		
		btnImport = new Button(composite_right, SWT.NONE);
		btnImport.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		btnImport.setText("&Import...");
		btnImport.addSelectionListener(this);

		if(initDSName.equals("")){
			dataSetCombo.setFocus();
		} else {
			memberNameText.setFocus();
		}
		
		tableUpdate();
		getShell().getDefaultButton().setText("OK");
	}

	private void createViewer(Composite parent) {
		tableViewer = new TableViewer (parent,
				SWT.BORDER | SWT.FULL_SELECTION | SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.MULTI);		

		Composite composite_default = new Composite(parent, SWT.NONE);
		composite_default.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		composite_default.setLayout(new GridLayout(3, false));

		tableViewer.setContentProvider(new ArrayContentProvider());
		tableViewer.setInput(null);
		tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				setButtonState();
			}
		});

		table = tableViewer.getTable();
		table.addFocusListener(new FocusListener(){
			@Override
			public void focusGained(FocusEvent e) {
				setButtonState();
			}
			@Override
			public void focusLost(FocusEvent e) {
				setButtonState();
			}
		});
		
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
				true, 1, 1));
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setFocus();
		createColumns(parent, tableViewer);		
	}

	private void createColumns(Composite parent, TableViewer viewer) {
		String[] titles = { "Data set name"};
		int[] bounds = { 515 };

		for (int i = 0; i < titles.length; i++) {
			TableViewerColumn tableViewerColumn = new TableViewerColumn(viewer,
					SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();

			tableColumn.setText(titles[i]);
			tableColumn.setWidth(bounds[i]);

			switch(i){	
			case 0:
				tableViewerColumn.setLabelProvider(new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						String s = (String) element;
						return s;
					}
				});

				tableViewerColumn.setEditingSupport(new EditingSupport(
						tableViewerColumn.getViewer()) {

					@Override
					protected boolean canEdit(Object element) {
						return true;
					}

					@Override
					protected CellEditor getCellEditor(Object element) {
						textEditor = new TextCellEditor(table);
						((Text) textEditor.getControl()).setTextLimit(44);
						
						((Text) textEditor.getControl())
								.addModifyListener(new ModifyListener() {
									@Override
									public void modifyText(ModifyEvent e) {
										setPageComplete(isPageComplete());
									}
								});
						
						((Text) textEditor.getControl())
								.addVerifyListener(new verifytoUpperCase());
						
						textEditor.getControl().addTraverseListener(new TraverseListener() {
				        	public void keyTraversed(TraverseEvent e) {
				        		if (e.detail == SWT.TRAVERSE_TAB_NEXT) {
				        			int selectedElement = table.getSelectionIndex();
				        			tableViewer.cancelEditing();

				        			if(selectedElement + 1 < table.getItemCount()){
				        				tableViewer.editElement(tableViewer.getElementAt(selectedElement + 1), 0);	
				        			} else {
				        				table.setSelection(-1);
				        				btnInsert.setFocus();
				        			}
				        			
				        			e.doit = false;
				        			
				        		} else if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS) {
				        			int selectedElement = table.getSelectionIndex();
				        			tableViewer.cancelEditing();
				        			
				        			if(selectedElement - 1 >= 0){
				        				tableViewer.editElement(tableViewer.getElementAt(selectedElement - 1), 0);	
				        			} else {
				        				table.setSelection(-1);
				        				descriptionText.setFocus();
				        			}
				        			
				        			e.doit = false;
				        		}
				        	}
				        });
						
						return textEditor;
					}

					@Override
					protected Object getValue(Object element) {
						String s = (String) element;
						return s;
					}

					@Override
					protected void setValue(Object element, Object value) {
						int selectedIndex = tableViewer.getTable().getSelectionIndex();
						String dsname = ((String) value).trim();
						dsnList.set(selectedIndex, dsname);
							
						if(selectedIndex == dsnList.size() - 1 && dsname.length() > 0){
							dsnList.add("");	
						}
						
						tableUpdate();
						tableViewer.getTable().setSelection(selectedIndex);
						setButtonState();
						textEditor = null;
					}
				});

				break;
			}
		}
	}
	
	private void tableUpdate() {
		tableViewer.setInput(dsnList.toArray(new Object[dsnList.size()]));
		tableViewer.refresh();

		setPageComplete(isPageComplete());
	}
	
	private void tableUpdate(int selection) {
		tableViewer.setInput(dsnList.toArray(new Object[dsnList.size()]));
		tableViewer.refresh();
		
		table.setSelection(selection);

		setPageComplete(isPageComplete());
	}

	private void setButtonState(){
		int selIndex = tableViewer.getTable().getSelectionIndex();
		
		if(tableViewer.getTable().getSelectionCount() == 1){
			//Repeat button
			if(((String)tableViewer.getElementAt(selIndex)).trim().length() > 0){
				btnRepeat.setEnabled(true);
			} else {
				btnRepeat.setEnabled(false);
			}
			
			//Move up button
			if(selIndex == 0 || selIndex == dsnList.size() - 1){
				btnMoveUp.setEnabled(false);
			} else {
				btnMoveUp.setEnabled(true);
			}
			
			//Move down button
			if(selIndex >= dsnList.size() - 2){
				btnMoveDown.setEnabled(false);
			} else {
				btnMoveDown.setEnabled(true);
			}
		} else {
			btnMoveUp.setEnabled(false);
			btnMoveDown.setEnabled(false);
			btnRepeat.setEnabled(false);
		}
		
		//Remove button
		if(tableViewer.getTable().getSelectionCount() == 0 || 
				(tableViewer.getTable().getSelectionCount() == 1 &&
				((String)tableViewer.getElementAt(selIndex)).trim().length() == 0)){
			btnRemove.setEnabled(false);
		} else {
			btnRemove.setEnabled(true);
		}
	}

	private String[] getServers() {
		String[] listOfServers = new String[fmstModel.getServers().length];
		for (int serverCount = 0; serverCount < fmstModel.getServers().length; serverCount++) {
			listOfServers[serverCount] = fmstModel.getServers()[serverCount]
			                                                    .getServer().getText();
		}
		if (!isDirectoryListCaller)
			server = (FileMasterServer) fmstModel.getServers()[0].getServer();
		serverChanged(server);
		return listOfServers;
	}

	public void serverChanged(FileMasterServer server) {
		super.serverChanged(server);

	}

	private void changeServer() {
		String TestServer = "";
		for (int servers = 0; servers < fmstModel.getServers().length; servers++) {
			TestServer = fmstModel.getServers()[servers].getText();
			if (TestServer.equalsIgnoreCase(serverNameCombo.getText())) {
				this.server = (FileMasterServer) fmstModel.getServers()[servers]
				                                                        .getAdapter(FileMasterServer.class);
				serverChanged(server);
				break;
			}
		}
	}

	@Override
	public void modifyText(ModifyEvent e) {
		setPageComplete(isPageComplete());
	}

	public boolean doFinish() {
		FMHistory.clearList("CreateUpdateDSNListWizardPage");
		FMHistory.insertHistory(serverNameCombo, "CreateUpdateDSNListWizardPage");	
		FMHistory.insertHistory(dataSetCombo, "UpdateDSNListDSN");
		
		changeServer();
		
		// Create The Data set object
		//FileMasterDataset fmdataset = new FileMasterDataset(null);
		//fmdataset.setName(dataSetCombo.getText().trim());
		//fmdataset.setDsOrg("PDS");

		// Create The Member object
		FileMasterMember fmmember = new FileMasterMember(null);
		fmmember.setName(memberNameText.getText().trim());
		fmmember.setType("DSNLIST");

		// Create The DSN list object
		FileMasterDSName fmdsname = null;
		Element fmdsnameElement = null;

		TT_TreeItem dsItem = null;
		TT_TreeItem memItem = null;

		// Create DSN list member
		if (isNewDSNList
				|| (!isNewDSNList && !initDSName.equalsIgnoreCase(dataSetCombo
						.getText().trim()))
				|| (!isNewDSNList && !memberName
						.equalsIgnoreCase(memberNameText.getText().trim()))) {

			if ((dsItem = fmDSNListModel.findObject(fmdataset)) == null) {
				//data set is not in the layout view, check if it is allocated on MF
				FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN(fmdataset.getName(), "", server);

				if(!CommonMFCalls.RETURN_CODE.equals("0")){
					TT_ErrorDialog.openError(null,
							"Error",
							"Return Code: " + CommonMFCalls.RETURN_CODE,
							new Throwable(CommonMFCalls.MESSAGE));
					return false;
				}
				
				if(FMDataSet.getDsOrg().equalsIgnoreCase("PDS") || FMDataSet.getDsOrg().equalsIgnoreCase("PDSE")){
					Element dsElement = fmDSNListModel.addDataset(null,fmdataset);
					dsItem = fmDSNListModel.insertDataset(dsElement);	
				} else {
					TT_ErrorDialog.openError(null, "Error",	"FILE NOT A PDS",
							new Throwable("THE SPECIFIED DATASET '" + FMDataSet.getName() + "' IS NOT A PARTITIONED DATASET"));
					return false;
				}
			}

			Element memElement = fmDSNListModel.addMember(dsItem.getElement(),
					fmmember.getName(), fmmember.getType(), descriptionText
							.getText().trim());
			memItem = fmDSNListModel.insertMember(dsItem, memElement);

		} else { // Update DSN list member

			dsItem = fmDSNListModel.findObject(fmdataset);

			for (int i = 0; i < dsItem.getChildren().length; i++) {
				if (((TT_TreeItem) dsItem.getChildren()[i]).getName()
						.equalsIgnoreCase(memberNameText.getText().trim())) {
					memItem = (TT_TreeItem) dsItem.getChildren()[i];
					break;
				}
			}

			memItem.getElement().setAttribute("description",
					descriptionText.getText().trim());

			int numChildren = ((TT_TreeItem) memItem).getChildren().length;
			for (int i = numChildren - 1; i >= 0; i--) {
				fmDSNListModel.removeItem((TT_TreeItem) memItem.getChildren()[i],
						(TT_TreeItem) memItem);
			}
		}

		for (int i = 0; i < dsnList.size() - 1; i++) {
			if (!dsnList.get(i).trim().isEmpty()) {
				fmdsname = new FileMasterDSName(null);
				fmdsname.setName(dsnList.get(i));

				fmdsnameElement = fmDSNListModel.addDSName(memItem.getElement(),
						fmdsname.getName());
				fmDSNListModel.insertDSName(memItem, fmdsnameElement);
			}
		}

		final IWorkbenchWindow window = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		Shell shell = window.getShell();
		shell.setMinimized(false);
		shell.forceActive();
		shell.forceFocus();

		try {
			final IWorkbenchPage page = window.getActivePage();
			IViewPart view = page.showView(DSNListView.ID);

			if (view instanceof DSNListView) {
				TreeViewer viewer = ((DSNListView) view).getViewer();
				if (viewer != null) {
					TT_TreeItem selection = fmDSNListModel.findObjectInTree(
							fmmember, fmDSNListModel.findObject(fmdataset));
					Object[] expandedElements = viewer.getExpandedElements();
					viewer.setInput(fmDSNListModel.getDatasets());
					viewer.refresh(true);
					viewer.setExpandedElements(expandedElements);
					viewer.setSelection(new StructuredSelection(selection),
							true);
					view = page.showView(DSNListView.ID);
					page.activate(view);
					page.bringToTop(view);

				}

				view.setFocus();

			}

		} catch (final PartInitException e) {
		}
		fmDSNListModel.save();
		return true;
	}

	@Override
	public boolean isPageComplete() {
		boolean prevError = !super.isPageComplete();
		// DSN List Data set validation
		if (memberNameText != null && dataSetSelectBtn != null) {
			if (!prevError && error.length() == 0) {
				// DSN List member validation
				switch (Validator.member(memberNameText.getText(), true)) {
				case Validator.MEM_INVALID:
					error = error
					+ Validator.errorMsg[Validator.member(
							memberNameText.getText(), true)] + "\n ";
					break;
				case Validator.MEM_WILDCARD:
					error = error
					+ Validator.errorMsg[Validator.member(
							memberNameText.getText(), true)] + "\n ";
					break;
				case Validator.NO_ERROR:
					if(!getName().contains("Properties"))
						error = error + CheckForDuplicate();
					break;

				case Validator.MEM_MISSING:
					error = error
					+ Validator.errorMsg[Validator.member(
							memberNameText.getText(), true)] + "\n ";

					break;
				}
				if (error.length() == 0) {
					if (descriptionText.getText().trim().equalsIgnoreCase("")) {
						error = error + "Missing description\n ";
					}
				}
			}
		}
		
		//cell editor validation
		if(textEditor != null && !prevError && error.length() == 0){
			switch (Validator.dataset(((String)textEditor.getValue()).trim(), false)) {
			case Validator.DS_INVALID:
			case Validator.DS_LONG:
				error = error + Validator.errorMsg[Validator.dataset(
						((String)textEditor.getValue()).trim(), false)] + "\n ";
				btnRepeat.setEnabled(false);
				break;
			case Validator.NO_ERROR:
				btnRepeat.setEnabled(true);
				break;
			}
		}

		//table items validation
		if(tableViewer != null && !prevError && error.length() == 0){
			for(int i = 0; i < table.getItemCount() - 1; i++){
				switch (Validator.dataset(((String)tableViewer.getElementAt(i)).trim(), false)) {
				case Validator.DS_INVALID:
				case Validator.DS_LONG:
					error = error + Validator.errorMsg[Validator.dataset(
							((String)tableViewer.getElementAt(i)).trim(), false)] + "\n ";
					break;
				}
			}
		}

		if (error.length() > 0) {
			if (getErrorMessage() != null) {
				if (!getErrorMessage().equalsIgnoreCase(error)) {
					setErrorMessage(error);
					error = new String();
					return false;
				} else {
					error = new String();
				}
			} else {
				setErrorMessage(error);
				error = new String();
				return false;
			}
		} else {
			if (!prevError) {
				setErrorMessage(null);
				return true;
			} else {
				return false;
			}
		}
		return false;
	}

	private String CheckForDuplicate() {
		// Create The Data set object
		FileMasterDataset fmdataset = new FileMasterDataset(null);
		fmdataset.setName(dataSetCombo.getText().trim());
		fmdataset.setDsOrg("PDS");

		// Create The Member object
		FileMasterMember fmmember = new FileMasterMember(null);
		fmmember.setName(memberNameText.getText().trim());
		fmmember.setType("DSNLIST");

		TT_TreeItem dsItem = fmDSNListModel.findObject(fmdataset);

		if(dsItem != null){

			if(fmDSNListModel.findObjectInTree(fmmember, dsItem)!=null)
				return "Duplicate member name \n";
		}
		return "";
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		int selectedIndex = table.getSelectionIndex(); 
		
		if(e.getSource().equals(btnInsert)){
			
			//INSERT

			TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(
					getShell(),	new InsertDataSetWizard(
							server, "Insert Data Set", "Select Data Set", dsnList, selectedIndex));
			dialog.create();
			dialog.open();
			tableUpdate();
			setButtonState();
		} else if(e.getSource().equals(btnMoveUp)){
			
			//MOVE UP

			String temp = dsnList.get(selectedIndex);
			dsnList.set(selectedIndex, dsnList.get(selectedIndex - 1));
			dsnList.set(selectedIndex - 1, temp);
			tableUpdate(selectedIndex - 1);
			setButtonState();
		} else if(e.getSource().equals(btnMoveDown)){
			
			//MOVE DOWN

			String temp = dsnList.get(selectedIndex);
			dsnList.set(selectedIndex, dsnList.get(selectedIndex + 1));
			dsnList.set(selectedIndex + 1, temp);
			tableUpdate(selectedIndex + 1);
			setButtonState();
		} else if(e.getSource().equals(btnRepeat)){
			
			//REPEAT

			dsnList.add(selectedIndex, dsnList.get(selectedIndex));
			tableUpdate();
			tableViewer.editElement(tableViewer.getElementAt(selectedIndex), 0);
			setButtonState();
		} else if(e.getSource().equals(btnRemove)){
			
			//REMOVE
			
			int[] selectedIndices = table.getSelectionIndices();
			for(int i = selectedIndices.length - 1; i >= 0; i--){
				dsnList.remove(selectedIndices[i]);	
			}
			
			if(dsnList.size() == 0 || 
					dsnList.get(dsnList.size() - 1).trim().length() > 0){
				dsnList.add("");
			}
			
			tableUpdate();
			setButtonState();
		} else if(e.getSource().equals(btnImport)){
			
			//IMPORT

			TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(
					getShell(),
					new GenericImportWizard("Import DSN List",server,false));
			dialog.create();
			ImportDSNListWizardPage.saveSelCrit.addSelectionListener(new SelectionListener() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					String[] DSNames = ImportDSNListWizardPage.getImportedDSNames();
					
					int index = table.getSelectionIndex(); 

					if(index == -1){
						index = 0;
					}
					
					for (int i = DSNames.length - 1 ; i >= 0; i--) {
						dsnList.add(index, DSNames[i]);
					}
				}
				
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
				}
			});
			dialog.open();

			tableUpdate();
			setButtonState();
		}
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
	}
}
